/* C code produced by gperf version 2.5 (GNU C++ version) */
/* Command-line: gperf -p -j1 -i 1 -g -o -t -G -N is_reserved_word -k1,3,$ ./c-parse.gperf  */
/* Command-line: gperf -p -j1 -i 1 -g -o -t -N is_reserved_word -k1,3,$ c-parse.gperf  */ 
struct resword { char *name; short token; enum rid rid; };

#define TOTAL_KEYWORDS 79
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 20
#define MIN_HASH_VALUE 10
#define MAX_HASH_VALUE 144
/* maximum key range = 135, duplicates = 0 */

#ifdef __GNUC__
inline
#endif
static unsigned int
hash (str, len)
     register char *str;
     register int unsigned len;
{
  static unsigned char asso_values[] =
    {
#ifdef HOST_EBCDIC
/*00  NU   SH   SX   EX   PF   HT   LC   DL */
     145, 145, 145, 145, 145, 145, 145, 145,
/*08            SM   VT   FF   CR   SO   SI */
     145, 145, 145, 145, 145, 145, 145, 145,
/*10  DE   D1   D2   TM   RS   NL   BS   IL */
     145, 145, 145, 145, 145, 145, 145, 145,
/*18  CN   EM   CC   C1   FS   GS   RS   US */
     145, 145, 145, 145, 145, 145, 145, 145,
/*20  DS   SS   FS        BP   LF   EB   EC */
     145, 145, 145, 145, 145, 145, 145, 145,
/*28            SM   C2   EQ   AK   BL      */
     145, 145, 145, 145, 145, 145, 145, 145,
/*30            SY        PN   RS   UC   ET */
     145, 145, 145, 145, 145, 145, 145, 145,
/*38                 C3   D4   NK        SU */
     145, 145, 145, 145, 145, 145, 145, 145,
/*40  SP                                    */
     145, 145, 145, 145, 145, 145, 145, 145,
/*48           CENT   .    <    (    +    | */
     145, 145, 145, 145, 145, 145, 145, 145,
/*50   &                                    */
     145, 145, 145, 145, 145, 145, 145, 145,
/*58             !    $    *    )    ;    ^ */
     145, 145, 145, 145, 145, 145, 145, 145,
/*60   -    /                               */
     145, 145, 145, 145, 145, 145, 145, 145,
/*68             |    ,    %    _    >    ? */
     145, 145, 145, 145, 145,   1, 145, 145,
/*70                                        */
     145, 145, 145, 145, 145, 145, 145, 145,
/*78        `    :    #    @    '    =    " */
     145, 145, 145, 145,  25, 145, 145, 145,
/*80        a    b    c    d    e    f    g */
     145,  46,   8,  15,  61,   6,  36,  48,
/*88   h    i         {                     */
       3,   5, 145, 145, 145, 145, 145, 145,
/*90        j    k    l    m    n    o    p */
     145, 145,  18,  63,  25,  29,  76,   1,
/*98   q    r         }                     */
     145,  13, 145, 145, 145, 145, 145, 145,
/*A0        ~    s    t    u    v    w    x */
     145, 145,   2,   1,  51,  37,   9,   9,
/*A8   y    z                   [           */
       1,   3, 145, 145, 145, 145, 145, 145,
/*B0                                        */
     145, 145, 145, 145, 145, 145, 145, 145,
/*B8                            ]           */
     145, 145, 145, 145, 145, 145, 145, 145,
/*C0   {    A    B    C    D    E    F    G */
     145, 145, 145, 145, 145, 145, 145, 145,
/*C8   H    I                               */
     145, 145, 145, 145, 145, 145, 145, 145,
/*D0   }    J    K    L    M    N    O    P */
     145, 145, 145, 145, 145, 145, 145, 145,
/*D8   Q    R                               */
     145, 145, 145, 145, 145, 145, 145, 145,
/*E0   \         S    T    U    V    W    X */
     145, 145, 145, 145, 145, 145, 145, 145,
/*E8   Y    Z                               */
     145, 145, 145, 145, 145, 145, 145, 145,
/*F0   0    1    2    3    4    5    6    7 */
     145, 145, 145, 145, 145, 145, 145, 145,
/*F8   8    9                               */
     145, 145, 145, 145, 145, 145, 145, 145,
#else
/*00  NL   SH   SX   EX   ET   NQ   AK   BL */
     145, 145, 145, 145, 145, 145, 145, 145,
/*08  BS   HT   LF   VT   FF   CR   SO   SI */
     145, 145, 145, 145, 145, 145, 145, 145,
/*10  DL   D1   D2   D3   D4   NK   SN   EB */
     145, 145, 145, 145, 145, 145, 145, 145,
/*18  CN   EM   SB   EC   FS   GS   RS   US */
     145, 145, 145, 145, 145, 145, 145, 145,
/*20  SP    !    "    #    $    %    &    ' */
     145, 145, 145, 145, 145, 145, 145, 145,
/*28   (    )    *    +    ,    -    .    / */
     145, 145, 145, 145, 145, 145, 145, 145,
/*30   0    1    2    3    4    5    6    7 */
     145, 145, 145, 145, 145, 145, 145, 145,
/*38   8    9    :    ;    <    =    >    ? */
     145, 145, 145, 145, 145, 145, 145, 145,
/*40   @    A    B    C    D    E    F    G */
      25, 145, 145, 145, 145, 145, 145, 145,
/*48   H    I    J    K    L    M    N     O */
     145, 145, 145, 145, 145, 145, 145, 145,
/*50   P    Q    R    S    T    U    V     W */
     145, 145, 145, 145, 145, 145, 145, 145,
/*58   X    Y    Z    [    \    ]    ^    _ */
     145, 145, 145, 145, 145, 145, 145,   1,
/*60   `    a    b    c    d    e    f    g */
     145,  46,   8,  15,  61,   6,  36,  48,
/*68   h    i    j    k    l    m    n    o */
       3,   5, 145,  18,  63,  25,  29,  76,
/*70   p    q    r    s    t    u    v    w */
       1, 145,  13,   2,   1,  51,  37,   9,
/*78   x    y    z    {    |    }    ~   DL */
       9,   1,   3, 145, 145, 145, 145, 145,
#endif
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 3:
        hval += asso_values[str[2]];
      case 2:
      case 1:
        hval += asso_values[str[0]];
        break;
    }
  return hval + asso_values[str[len - 1]];
}

static struct resword wordlist[] =
{
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"",}, 
      {"int",  TYPESPEC, RID_INT},
      {"",}, {"",}, 
      {"__typeof__",  TYPEOF, NORID},
      {"__signed__",  TYPESPEC, RID_SIGNED},
      {"__imag__",  IMAGPART, NORID},
      {"switch",  SWITCH, NORID},
      {"__inline__",  SCSPEC, RID_INLINE},
      {"else",  ELSE, NORID},
      {"__iterator__",  SCSPEC, RID_ITERATOR},
      {"__inline",  SCSPEC, RID_INLINE},
      {"__extension__",  EXTENSION, NORID},
      {"struct",  STRUCT, NORID},
      {"__real__",  REALPART, NORID},
      {"__const",  TYPE_QUAL, RID_CONST},
      {"while",  WHILE, NORID},
      {"__const__",  TYPE_QUAL, RID_CONST},
      {"case",  CASE, NORID},
      {"__complex__",  TYPESPEC, RID_COMPLEX},
      {"__iterator",  SCSPEC, RID_ITERATOR},
      {"bycopy",  TYPE_QUAL, RID_BYCOPY},
      {"",}, {"",}, {"",}, 
      {"__complex",  TYPESPEC, RID_COMPLEX},
      {"",}, 
      {"in",  TYPE_QUAL, RID_IN},
      {"break",  BREAK, NORID},
      {"@defs",  DEFS, NORID},
      {"",}, {"",}, {"",}, 
      {"extern",  SCSPEC, RID_EXTERN},
      {"if",  IF, NORID},
      {"typeof",  TYPEOF, NORID},
      {"typedef",  SCSPEC, RID_TYPEDEF},
      {"__typeof",  TYPEOF, NORID},
      {"sizeof",  SIZEOF, NORID},
      {"",}, 
      {"return",  RETURN, NORID},
      {"const",  TYPE_QUAL, RID_CONST},
      {"__volatile__",  TYPE_QUAL, RID_VOLATILE},
      {"@private",  PRIVATE, NORID},
      {"@selector",  SELECTOR, NORID},
      {"__volatile",  TYPE_QUAL, RID_VOLATILE},
      {"__asm__",  ASM_KEYWORD, NORID},
      {"",}, {"",}, 
      {"continue",  CONTINUE, NORID},
      {"__alignof__",  ALIGNOF, NORID},
      {"__imag",  IMAGPART, NORID},
      {"__attribute__",  ATTRIBUTE, NORID},
      {"",}, {"",}, 
      {"__attribute",  ATTRIBUTE, NORID},
      {"for",  FOR, NORID},
      {"",}, 
      {"@encode",  ENCODE, NORID},
      {"id",  OBJECTNAME, RID_ID},
      {"static",  SCSPEC, RID_STATIC},
      {"@interface",  INTERFACE, NORID},
      {"",}, 
      {"__signed",  TYPESPEC, RID_SIGNED},
      {"",}, 
      {"__label__",  LABEL, NORID},
      {"",}, {"",}, 
      {"__asm",  ASM_KEYWORD, NORID},
      {"char",  TYPESPEC, RID_CHAR},
      {"",}, 
      {"inline",  SCSPEC, RID_INLINE},
      {"out",  TYPE_QUAL, RID_OUT},
      {"register",  SCSPEC, RID_REGISTER},
      {"__real",  REALPART, NORID},
      {"short",  TYPESPEC, RID_SHORT},
      {"",}, 
      {"enum",  ENUM, NORID},
      {"inout",  TYPE_QUAL, RID_INOUT},
      {"",}, 
      {"oneway",  TYPE_QUAL, RID_ONEWAY},
      {"union",  UNION, NORID},
      {"",}, 
      {"__alignof",  ALIGNOF, NORID},
      {"",}, 
      {"@implementation",  IMPLEMENTATION, NORID},
      {"",}, 
      {"@class",  CLASS, NORID},
      {"",}, 
      {"@public",  PUBLIC, NORID},
      {"asm",  ASM_KEYWORD, NORID},
      {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"default",  DEFAULT, NORID},
      {"",}, 
      {"void",  TYPESPEC, RID_VOID},
      {"",}, 
      {"@protected",  PROTECTED, NORID},
      {"@protocol",  PROTOCOL, NORID},
      {"",}, {"",}, {"",}, 
      {"volatile",  TYPE_QUAL, RID_VOLATILE},
      {"",}, {"",}, 
      {"signed",  TYPESPEC, RID_SIGNED},
      {"float",  TYPESPEC, RID_FLOAT},
      {"@end",  END, NORID},
      {"",}, {"",}, 
      {"unsigned",  TYPESPEC, RID_UNSIGNED},
      {"@compatibility_alias",  ALIAS, NORID},
      {"double",  TYPESPEC, RID_DOUBLE},
      {"",}, {"",}, 
      {"auto",  SCSPEC, RID_AUTO},
      {"",}, 
      {"goto",  GOTO, NORID},
      {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, {"",}, 
      {"do",  DO, NORID},
      {"",}, {"",}, {"",}, {"",}, 
      {"long",  TYPESPEC, RID_LONG},
};

#ifdef __GNUC__
inline
#endif
struct resword *
is_reserved_word (str, len)
     register char *str;
     register unsigned int len;
{
  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register char *s = wordlist[key].name;

          if (*s == *str && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
