/* Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#ifndef __FLOAT_H__
#define __FLOAT_H__
 
#define    FLT_ROUNDS        0
 
#define    FLT_RADIX         16
 
#define    FLT_MANT_DIG      6
#define    DBL_MANT_DIG      14
#define    LDBL_MANT_DIG     28
 
#define    FLT_DIG           6
#define    DBL_DIG          15
#define    LDBL_DIG         32
 
#define    FLT_MIN_EXP     (-64)
#define    DBL_MIN_EXP     (-64)
#define    LDBL_MIN_EXP    (-64)
 
#define    FLT_MIN_10_EXP  (-78)
#define    DBL_MIN_10_EXP  (-78)
#define    LDBL_MIN_10_EXP (-78)
 
#define    FLT_MAX_EXP      63
#define    DBL_MAX_EXP      63
#define    LDBL_MAX_EXP     63
 
#define    FLT_MAX_10_EXP    75
#define    DBL_MAX_10_EXP    75
#define    LDBL_MAX_10_EXP   75
 
extern const long double gcfltmax;
#define    FLT_MAX         ((const float)gcfltmax)
#define    DBL_MAX         ((const double)gcfltmax)
#define    LDBL_MAX        ((const long double)gcfltmax)
 
extern const float gcflteps;
#define    FLT_EPSILON     ((const float)gcflteps)
extern const double gcdbleps;
#define    DBL_EPSILON     ((const double)gcdbleps)
extern const long double gclngeps;
#define    LDBL_EPSILON    ((const long double)gclngeps)
 
extern const long double gcfltmin;
#define    FLT_MIN         ((const float)gcfltmin)
#define    DBL_MIN         ((const double)gcfltmin)
#define    LDBL_MIN        ((const long double)gcfltmin)
 
#endif /* __FLOAT_H__ */
