 #ifndef __mtfh
   #define __mtfh    1
  /***************************************************************
  *  <mtf.h> header file                                         *
  *                                                              *
  *  IBM C/370 Compiler                                          *
  *                                                              *
  *  Program Number: 5688-187                                    *
  *  Version: 2.0                                                *
  *  Release: 1.0                                                *
  *  Modification: 0.0                                           *
  *                                                              *
  *  Copyright:                                                  *
  *  International Business Machines Corporation 1988, 1991      *
  ***************************************************************/
 /***************************************************************
 *  All code applicable when __cplusplus is defined is for      *
 *  potential C++ implementation.  However, this does not imply *
 *  that IBM has or will be making a C++ product available in   *
 *  the future.                                                 *
 ****************************************************************/
 
 #ifdef gcc
    int   __TINIT   (const char *, int);
    #define tinit __TINIT
 
    int __TSCHED  (int, const char *, ...);
    #define tsched __TSCHED
 
    int   __TSYNC (int);
    #define tsyncro __TSYNC
 
    int   __TTERM   (void);
    #define tterm __TTERM
 
    int   __TSTSBT (int, char **);
    #define tsetsubt  __TSTSBT
 
    #define MAXTASK    99  /* Maximum number of subtasks              */
                           /* TSCHED/TSYNCRO PARAMETERS:              */
    #define MTF_ALL   (-1) /* return after all subtasks available     */
    #define MTF_ANY     0  /* return after any subtask  available     */
                           /* MTF RETURN CODES:                       */
    #define MTF_OK      0  /*                                         */
    #define ESUBCALL  (-1) /* tinit call issued from subtask          */
    #define EWRONGOS  (-2) /* tinit unsupported in CMS/IMS/CICS       */
    #define EACTIVE   (-3) /* MTF already active                      */
    #define ENAME2LNG (-4) /* parallel loadmod name longer than 8 char*/
    #define ETASKNUM  (-5) /* task number is <=0 or >MAXTASK          */
    #define ENOMEMMTF (-6) /* insufficient storage for MTF areas      */
    #define EMODFIND  (-7) /* parallel loadmod not found  for parse   */
    #define EMODREAD  (-8) /* parallel loadmod read failed in parse   */
    #define EMODFMT   (-9) /* parallel loadmod bad format during parse*/
    #define EAUTOALC  (-10)/* auto allocate of std stream dd's failed */
    #define ETASKFAIL (-11)/* attempt to attach sub task(s) failed    */
    #define EINACTIVE (-12)/* MTF is inactive (not yet initialized)   */
    #define EBADLNKG  (-13)/* tsched private/builtin linkage not used */
    #define ETASKID   (-14)/* task id is out of range                 */
    #define EENTRY    (-15)/* entry point missing from subtask loadmod*/
    #define ETASKABND (-16)/* subtask has terminated abnormally       */
 #else
  #ifdef __EXTENDED__
    #pragma linkage(__tsched, builtin)
 
    #ifdef __cplusplus
      extern "C" {
    #endif
 
    #pragma map (tinit,"@@TINIT")
    int   tinit   (const char *, int);
 
    int __tsched  (int, const char *, ...);
    #define tsched __tsched
 
    #pragma map (tsyncro,"@@TSYNC")
    int   tsyncro (int);
 
    #pragma map (tterm,"@@TTERM")
    int   tterm   (void);
 
    #pragma map (tsetsubt,"@@TSTSBT")
    int   tsetsubt(int, char **);
 
    #ifdef __cplusplus
               }
    #endif
 
    #define MAXTASK    99  /* Maximum number of subtasks              */
                           /* TSCHED/TSYNCRO PARAMETERS:              */
    #define MTF_ALL   (-1) /* return after all subtasks available     */
    #define MTF_ANY     0  /* return after any subtask  available     */
                           /* MTF RETURN CODES:                       */
    #define MTF_OK      0  /*                                         */
    #define ESUBCALL  (-1) /* tinit call issued from subtask          */
    #define EWRONGOS  (-2) /* tinit unsupported in CMS/IMS/CICS       */
    #define EACTIVE   (-3) /* MTF already active                      */
    #define ENAME2LNG (-4) /* parallel loadmod name longer than 8 char*/
    #define ETASKNUM  (-5) /* task number is <=0 or >MAXTASK          */
    #define ENOMEMMTF (-6) /* insufficient storage for MTF areas      */
    #define EMODFIND  (-7) /* parallel loadmod not found  for parse   */
    #define EMODREAD  (-8) /* parallel loadmod read failed in parse   */
    #define EMODFMT   (-9) /* parallel loadmod bad format during parse*/
    #define EAUTOALC  (-10)/* auto allocate of std stream dd's failed */
    #define ETASKFAIL (-11)/* attempt to attach sub task(s) failed    */
    #define EINACTIVE (-12)/* MTF is inactive (not yet initialized)   */
    #define EBADLNKG  (-13)/* tsched private/builtin linkage not used */
    #define ETASKID   (-14)/* task id is out of range                 */
    #define EENTRY    (-15)/* entry point missing from subtask loadmod*/
    #define ETASKABND (-16)/* subtask has terminated abnormally       */
  #endif
  #endif
#endif
