/* @(#)types.h  1.2 87/11/07 3.9 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a
 * product or program developed by the user.
 *
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
 * THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
 * PARTICULAR  PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
 * TRADE PRACTICE.
 *
 * Sun RPC is provided with no support and without any obligation on
 * the part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 *
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 *
 * In no event will Sun Microsystems, Inc. be liable for any lost
 * revenue or profits or other special, indirect and consequential
 * damages, even if Sun has been advised of the possibility of such
 * damages.
 *
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
 
/*      @(#)types.h 1.18 87/07/24 SMI      */
 
/*
 * Rpc additions to <sys/types.h>
 */
#ifndef __TYPES_RPC_HEADER__
#define __TYPES_RPC_HEADER__
 
#define bool_t  int
 
#define FALSE   (0)
#define TRUE    (1)
 
#define __dontcare__    -1
 
#define mem_alloc               malloc
#define mem_free(ptr, bsize)    free(ptr)
 
#if defined(openedition) || defined(VM) || defined(MVS) || !defined(sun) && defined(MVSNFS)
#include "bsdtocms.h"
#endif
 
/*
 * Selected defines from <sys/types.h>
 */
typedef unsigned char   u_char;
typedef unsigned short  u_short;
typedef unsigned int    u_int;
typedef unsigned long   u_long;
typedef unsigned short  ushort;         /* System V compatibility */
typedef unsigned int    uint;           /* System V compatibility */
 
typedef char *  caddr_t;
typedef long    off_t;
 
/*#include <sys/time.h>*/
 
/*
 * Structure returned by gettimeofday(2) system call,
 * and used in other calls.
 */
 
#include "bsdtime.h"
 
/* For sauthdes.c in which param.h and sys/time.h are excluded */
 
#define NGROUPS 16
#define timercmp(tvp, uvp, cmp) \
        ((tvp)->tv_sec cmp (uvp)->tv_sec || \
         (tvp)->tv_sec == (uvp)->tv_sec && (tvp)->tv_usec cmp\
 (uvp)->tv_usec)
 
/* For netname.c in which param.h is excluded */
 
#define MAXHOSTNAMELEN 64
 
/* For rtime.c in whcih sys/types.h is excluded */
 
#define NBBY    8
 
/*
 * Select uses bit masks of file descriptors in longs.
 * These macros manipulate such bit fields (the filesystem macros use
 * chars). FD_SETSIZE may be defined by the user, but the default here
 * should be >= NOFILE (param.h).
 */
#ifndef FD_SETSIZE
#define FD_SETSIZE      256
#endif
 
typedef long    fd_mask;
#define NFDBITS (sizeof(fd_mask) * NBBY)        /* bits per mask */
#ifndef howmany
#ifdef sun386
#define howmany(x, y)   ((((u_int)(x))+(((u_int)(y))-1))/((u_int)(y)))
#else
#define howmany(x, y)   (((x)+((y)-1))/(y))
#endif
#endif
 
typedef struct fd_set {
        fd_mask fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;
 
#define  FD_SET(n, p)   ((p)->fds_bits[((unsigned)n)/NFDBITS] \
                        |= (1 << (((unsigned)n) % NFDBITS)))
#define  FD_CLR(n, p)   ((p)->fds_bits[((unsigned)n)/NFDBITS] \
                        &= ~(1 << (((unsigned)n) % NFDBITS)))
#define  FD_ISSET(n, p) ((p)->fds_bits[((unsigned)n)/NFDBITS] \
                        & (1 << (((unsigned)n) % NFDBITS)))
#define FD_ZERO(p) bzero((char *)(p), sizeof(*(p)))
 
#endif /* ndef __TYPES_RPC_HEADER__ */
