/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the, 1992 Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

/*
 *	Wide character support
 */

#ifndef __WCSTR_H__
#define __WCSTR_H__
 
#include <features.h>

__BEGIN_DECLS

/* Get wchar_t, size_t and NULL from <stddef.h>.  */
#define	__need_wchar_t
#define	__need_size_t
#define	__need_NULL
#include <stddef.h>

extern wchar_t * wcscat  __P ((wchar_t *__d, __const wchar_t *__s));
extern wchar_t * wcschr  __P ((__const wchar_t *__s, wchar_t __c));
extern int       wcscmp  __P ((__const wchar_t *__s1, __const wchar_t *__s2));
extern wchar_t * wcscpy  __P ((wchar_t *__d, __const wchar_t *__s));
extern size_t    wcscspn __P ((__const wchar_t *__s1, __const wchar_t *__s2));
extern size_t    wcslen  __P ((__const wchar_t *__s));
extern wchar_t * wcsncat __P ((wchar_t *__d, __const wchar_t *__s, size_t __c));
extern int       wcsncmp __P ((__const wchar_t *__s1, __const wchar_t *__s2,
				size_t __c));
extern wchar_t * wcsncpy __P ((wchar_t *__d, __const wchar_t *__s, size_t __c));
extern wchar_t * wcspbrk __P ((__const wchar_t *__s, __const wchar_t *__p));
extern wchar_t * wcsrchr __P ((__const wchar_t *__s, wchar_t __c));
extern size_t    wcsspn  __P ((__const wchar_t *__s, __const wchar_t *__p));
extern wchar_t * wcswcs  __P ((__const wchar_t *__s1, __const wchar_t *__s2));
 
__END_DECLS
 
#endif /* __WCSTR_H__ */
