/***********************************************************************
* ld - Linker shim. This program acts as the "ld" command on UNIX.
***********************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define NORMAL 0
#define ABORT  12

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define LD_CMD "/bin/cc -g"
#define MAXARGS 50


/***********************************************************************
* Main procedure
***********************************************************************/

int
main (int argc, char *argv[])
{
   char *newoptv[MAXARGS];
   char *newobjv[MAXARGS];
   char *outfile;
   char *bp;
   int needgccmain;
   int newoptc;
   int newobjc;
   int i;
   int status;
   char command[256];
   char *gccmain = "/usr/local/lib/gccmain.o";
  
#ifdef DEBUG
   fprintf (stderr,
	    "ld: Entered\n");
#endif

   for (i = 0; i < MAXARGS; i++)
   {
      newoptv[i] = NULL;
      newobjv[i] = NULL;
   }

   newoptc = 0;
   newobjc = 0;
   outfile = NULL;
   needgccmain = TRUE;
   for (i = 1; i < argc; i++)
   {
      bp = argv[i];

      if (*bp == '-')
      {
         bp++;
         switch (*bp)
         {
         case 'o':
            i++;
            outfile = argv[i];
            break;

         case 'l':
            if (strcmp (bp, "lc") && strcmp (bp, "lgcc"))
            {
	       newoptv[newoptc] = argv[i];
	       newoptc++;
            }
            break;

         default:
            newoptv[newoptc] = argv[i];
            newoptc++;
         }
      }

      else
      {
         if (!strcmp (argv[i], "crt0.o"))
         {
	    newobjv[newobjc] = gccmain;
	    needgccmain = FALSE;
         }
         else if (!strcmp (argv[i], gccmain))
         {
	    newobjv[newobjc] = argv[i];
	    needgccmain = FALSE;
         }
         else
         {
	    newobjv[newobjc] = argv[i];
         }
	 newobjc++;
      }

   }

   strcpy (command,
	   LD_CMD);

   if (outfile)
   {
      strcat (command, " -o ");
      strcat (command, outfile);
   }

   for (i = 0; i < newoptc; i++)
   {
      strcat (command, " ");
      strcat (command, newoptv[i]);
   }

   if (needgccmain)
   {
      strcat (command, " ");
      strcat (command, gccmain);
   }

   for (i = 0; i < newobjc; i++)
   {
      strcat (command, " ");
      strcat (command, newobjv[i]);
   }

#ifdef DEBUG
   fprintf (stderr,
	    "ld: command = %s\n",
	    command);
#endif

   status = system (command);
#ifdef DEBUG
   fprintf (stderr,
	    "system: command: status = %d\n",
	    status);
#endif

   exit (status);
}

