/* Definitions of target machine for GNU compiler.  System/370 version.
   Copyright (C) 1989, 1993, 1995, 1996, 1997 Free Software Foundation, Inc.
   Contributed by Jan Stein (jan@cd.chalmers.se).
   Modified for OS/390 LanguageEnvironment C by Dave Pitts (dpitts@cozx.com)

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#define TARGET_VERSION fprintf (stderr, " (370/MVS38)");

/* Specify that we're generating code for MVS.  */

#define TARGET_MVS 1
#define TARGET_HLASM 1
#define TARGET_EBCDIC 1

/* Specify that we're using the GCC macros */

#define TARGET_GCCMAC 1
#define STARTFILE_SPEC ""

/* Specify that we're using macro prolog/epilog.  */

#define TARGET_MACROS 1

/* Options for the preprocessor for this target machine.  */

#define CPP_SPEC "-trigraphs"

/* Names to predefine in the preprocessor for this target machine.  */

#define CPP_PREDEFINES "-DGCC -Dgcc -DMVS -Dmvs -DGCCMAC -Asystem=mvs -Acpu=i370 -Amachine=i370"

#if defined(BUILD_WINDOWS)

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <errno.h>

#include "unixio.h"

#define SINGLE_EXECUTABLE 1
#define ANSI_PROTOTYPES 1
#define PARAMS(ARGS) ARGS
#define PTR void *

#define DEFAULT_TARGET_VERSION "1.1"
#define DEFAULT_TARGET_MACHINE "i370"
#define PREFIX ""
#define TARGET_EBCDIC 1
#define TARGET_NAME "mvs"

#define USE_SHORT_NAMES 1
/* now redefine all functions that are too long
   to handle on MVS, before anyone tries to start
   using them. */
#ifdef USE_SHORT_NAMES
#define reg_base_value_size xxxrgvs
#define reg_known_value_size xxxrkvs
#define lang_specific_driver lsdrver
#define lang_specific_extra_outfiles lspxtra
#define lang_specific_pre_link lspplink
#define libiberty_optr libty_optr
#define libiberty_nptr libty_nptr
#define libiberty_len libty_len
#define gen_rtx_fmt_ee grfee
#define gen_rtx_fmt_e  grfe
#define gen_rtx_fmt_ei grfei
#define gen_rtx_fmt_eE grfebige
#define reg_known_equiv_p rke_p
#define alias_sets_conflict_p asconfp
#define lang_attribute_common lacommon
#define attributes_initialized attinit
#define bitmap_clear_bit bmclrbit
#define bitmap_copy bm_copy
#define bitmap_obstack bm_obs
#define bitmap_obstack_init bm_obsi
#define bitmap_free bm_free
#define bitmap_find_bit bm_find
#define bitmap_first_set_bit bm_fsb
#define bitmap_element_free bm_e_free
#define bitmap_element_allocate bm_e_all
#define bitmap_element_zerop bm_e_zer
#define bitmap_element_link bm_e_link
#define bitmap_equal_p bm_e_p
#define bitmap_ior_and_compl bm_ior
#define bitmap_initialize bm_init
#define apply_args_mode aa_mode
#define apply_args_size aa_size
#define apply_args_reg_offset aa_rgoff
#define apply_args_register_offset aa_register_offset
#define apply_result_size ar_size
#define apply_result_mode ar_mode
#define built_in_decls bi_decls
#define built_in_class_names bi_class
#define built_in_names bi_names
#define expand_builtin_setjmp eb_setjmp
#define expand_builtin_prefetch eb_prefetch
#define expand_builtin_apply_args eb_ap_args
#define expand_builtin_apply_args_1 eb_aa_1
#define expand_builtin_apply eb_apply
#define expand_builtin_return eb_return
#define expand_builtin_classify_type eb_clas_type
#define expand_builtin_mathfn eb_mathfn
#define expand_builtin_constant_p eb_constp
#define expand_builtin_args_info eb_arg_info
#define expand_builtin_next_arg eb_nxt_arg
#define expand_builtin_va_start eb_vas
#define expand_builtin_va_end eb_vae
#define expand_builtin_va_copy eb_vac
#define expand_builtin_memcmp eb_memcmp
#define expand_builtin_strcmp eb_strcmp
#define expand_builtin_strncmp eb_strncmp
#define expand_builtin_strcat eb_strcat
#define expand_builtin_strncat eb_strncat
#define expand_builtin_strspn eb_strspn
#define expand_builtin_strcspn eb_strcspn
#define expand_builtin_memcpy eb_memcpy
#define expand_builtin_strcpy eb_strcpy
#define builtin_strncpy_read_str bi_str
#define expand_builtin_strncpy eb_strncpy
#define builtin_memset_read_str bi_mrs
#define expand_builtin_memset eb_memset
#define expand_builtin_bzero eb_bzero
#define expand_builtin_strlen eb_strlen
#define expand_builtin_strstr eb_strstr
#define expand_builtin_strpbrk eb_strpbrk
#define expand_builtin_strchr eb_strchr
#define expand_builtin_strrchr eb_strrchr
#define expand_builtin_alloca eb_alloca
#define expand_builtin_ffs eb_ffs
#define expand_builtin_frame_address eb_address
#define expand_builtin_fputs eb_fputs
#define expand_builtin_expect eb_expect
#define fold_builtin_constant_p fbi_cp
#define fold_builtin_classify_type fbi_ct
#define calls_function calls_f
#define calls_function_1 calls_f1
#define first_deleted_edge fd_edge
#define first_deleted_block fd_block
#define combine_attempts co_attempts
#define combine_merges co_merges
#define combine_extras co_extras
#define combine_successes co_successes
#define combine_max_regno co_max_regno
#define reg_last_death rl_death
#define reg_last_set rl_set
#define reg_last_set_value rl_sval
#define reg_last_set_label rl_slab
#define reg_last_set_table_tick rl_stt
#define reg_last_set_invalid rl_sinv
#define nonzero_bits_mode nz_bits_mode
#define nonzero_sign_valid nz_sign_valid
#define reg_last_set_mode rl_smode
#define reg_last_set_nonzero_bits rl_snzbits
#define reg_last_set_sign_bit_copies rl_ssbc
#define reg_dead_at_p_1 rd_atp1
#define reg_dead_at_p rd_atp
#define cpp_GCC_INCLUDE_DIR cppgdir
#define cpp_GCC_INCLUDE_DIR_len cppgdlen
#define prev_insn_cc0 pi_cc0
#define prev_insn_cc0_mode pi_ccmode
#define cse_reg_info_free_list cri_flist
#define cse_reg_info_used_list cri_ulist
#define cse_reg_info_used_list_end cri_end
#define cse_basic_block_start cbb_start
#define cse_basic_block_end cbb_end
#define cselib_invalidate_regno cli_regno
#define cselib_invalidate_mem_1 cli_m1
#define cselib_invalidate_mem cli_mem
#define cselib_invalidate_rtx cli_rtx
#define cselib_record_set cli_recset
#define cselib_record_sets cli_rsets
#define cselib_startobj cli_stobj
#define empty_vals mt_vals
#define empty_elt_lists mt_elists
#define empty_elt_loc_lists mt_eloclists
#define if_stack ifstk
#define if_stack_space ifstksp
#define if_stack_pointer ifstkp
#define handle_format_attribute hfmtatt
#define handle_format_arg_attribute hfmtaa
#define c_tree_code_type ctct
#define c_tree_code_length ctcl
#define c_tree_code_name ctcn
#define flag_short_double fshdouble
#define flag_short_wchar fshwchar
#define flag_no_builtin fnobuilt
#define flag_no_nonansi_builtin fnononab
#define current_binding_level cb_level
#define current_extern_inline ce_inline
#define current_function_decl cf_decl
#define current_function_parm_tags cf_ptags
#define current_function_parms cf_parms
#define current_function_prototype_file cf_pf
#define current_function_prototype_line cf_pl
#define current_function_returns_null cf_rnull
#define current_function_returns_abnormally cf_rabn
#define current_function_returns_value cf_rval
#define current_scope_stmt_stack cs_ststk
#define current_stmt_tree cs_tree
#define flag_cond_mismatch fc_mism
#define flag_const_strings fc_str
#define flag_isoc94 f_i94
#define flag_isoc99 f_i99
#define global_binding_level gb_level
#define global_bindings_p gbindp
#define keep_next_if_subblocks kn_ifsub
#define keep_next_level kn_lev
#define keep_next_level_flag knlvlf
#define last_function_parm_tags lf_ptags
#define last_function_parms lf_parms
#define pending_invalid_xref pinvx
#define pending_invalid_xref_file pinvxf
#define pending_invalid_xref_line pinvxl
#define pending_sizes pendsize
#define pending_xref_error pendxref
#define warn_missing_braces wm_brac
#define warn_missing_declarations wm_decl
#define warn_missing_format_attribute wm_fa
#define warn_missing_noreturn wm_noret
#define warn_missing_prototypes wm_prot
#define dollar_arguments_alloc darg_alloc
#define dollar_arguments_count darg_count
#define dollar_arguments_pointer_p darg_pp
#define dollar_arguments_used darg_used
#define dollar_first_arg_num df_argnum
#define dollar_format_warned df_warned
#define printf_flag_pairs pf_pairs
#define printf_flag_specs pf_specs
#define printf_format_type pf_type
#define scanf_flag_pairs sf_pairs
#define scanf_flag_specs sf_specs
#define strfmon_flag_pairs stf_pairs
#define strfmon_flag_specs stf_specs
#define strfmon_format_type stf_fmt
#define strfmon_length_specs stf_leng
#define strftime_flag_pairs sft_fp
#define strftime_flag_specs sft_fs
#define strftime_format_type sft_ft
#define warn_format wfmt
#define warn_format_extra_args wf_exta
#define warn_format_nonliteral wf_nonl
#define warn_format_security wf_sec
#define warn_format_y2k wf_y2k
#define if_stmt_file ifstf
#define if_stmt_line ifstl
#define lang_expand_decl_stmt le_decl
#define lang_expand_stmt le_stmt
#define constructor_asmspec ctr_asm
#define constructor_bit_index ctr_bitin
#define constructor_constant ctr_const
#define constructor_decl ctr_decl
#define constructor_depth ctr_dep
#define constructor_designated ctr_des
#define constructor_elements ctr_elem
#define constructor_erroneous ctr_err
#define constructor_subconstants_deferred ctr_subd
#define constructor_fields ctr_fields
#define constructor_incremental ctr_inc
#define constructor_index ctr_ind
#define constructor_max_index ctr_maxi
#define constructor_no_implicit ctr_noim
#define constructor_pending_elts ctr_pend
#define constructor_range_stack ctr_rang
#define constructor_simple ctr_simp
#define constructor_stack ctr_stk
#define constructor_top_level ctr_top
#define constructor_type ctr_type
#define constructor_unfilled_fields ctr_ufi
#define constructor_unfilled_index ctr_uin
#define designated dsgntd
#define designator_depth dsgdep
#define designator_errorneous dsgerr
#define require_complete_type reqcomp
#define require_constant reqcon
#define require_constant_elements reqcelem
#define require_constant_value reqcval
#define spelling spelg
#define spelling_base spelgb
#define spelling_length spelgl
#define spelling_size spelgs
#define diagnostic_buffer diagbuf
#define diagnostic_context diagcon
#define diagnostic_count diagcnt
#define diagnostic_finish diagfin
#define diagnostic_for_decl diagfor
#define diagnostic_initialize diaginit
#define diagnostic_lock diaglock
#define diagnostic_prefixing_rule_t diagpref
#define global_dc glbdc
#define global_diagnostic_context glbdcontext
#define internal_error interror
#define internal_error_function interfunc
#define last_error_function lerrfunc
#define last_error_tick lerrtick
#define warning_message warnmsg
#define warning_with_decl warnwdecl
#define warning_with_file_and_line warnwfl
#define const_int_htab cihtab
#define const_int_htab_eq cihteq
#define const_int_htab_hash cihthash
#define const_int_rtx cirtx
#define copy_asm_constraints_vector casmconst
#define copy_asm_operands_vector casmopvec
#define copy_insn cpinsn
#define copy_insn_1 cpins1
#define copy_insn_n_scratches cpinnscr
#define copy_insn_scratch_in cpinsi
#define copy_insn_scratch_out cpinso
#define mem_attrs mmattrs
#define mem_attrs_htab mmath
#define mem_attrs_htab_eq mmathe
#define mem_attrs_htab_hash mmathh
#define mem_attrs_mark mmatmark
#define orig_asm_constraints_vector oacvec
#define orig_asm_operands_vector oaovec
#define static_chain_incoming_rtx scincrtx
#define static_chain_rtx stcrtx
#define static_ctor_flag sctorf
#define struct_value_incoming_rtx svincrtx
#define struct_value_rtx svrtx
#define lang_eh_runtime_type leruntype
#define lang_eh_type_covers letypcov
#define sjlj_fc_call_site_ofs sfcall
#define sjlj_fc_data_ofs sfdata
#define sjlj_fc_jbuf_ofs sfjbuf
#define sjlj_fc_ls sfls
#define sjlj_fc_personality_ofs sfpers
#define sjlj_fc_type_node sftype
#define insn_current_address incradd
#define insn_current_align incral
#define insn_current_length incrlen
#define insn_current_reference_address incrra
#define insn_lengths insnlen
#define insn_lengths_max_uid inslmu
#define pedantic pednt
#define pedantic_lvalues pedntlv
#define pedantic_non_lvalue pedntnlval
#define pedantic_omit_one_operand pedntooo
#define size_htab szhtab
#define size_htab_eq szhteq
#define size_htab_hash szhthash
#define current_block curblk
#define current_function_is_leaf curfisleaf
#define current_function_nothrow curfnothrow
#define current_function_sp_is_unchanging curfspunch
#define current_function_uses_only_leaf_regs curfuolr
#define prologue_epilogue_contains prolepilcont
#define purge_addressof purgad
#define purge_addressof_1 purga1
#define purge_addressof_replacements purgar
#define sibcall_epilogue sibepil
#define sibcall_epilogue_contains sipecont
#define COMPILER_PATH CPATH
#define compiler comp
#define compiler_version compvers
#define compilers complrs
#define default_arg defarg
#define default_compilers defcomps
#define delete_temp_files deltmpf
#define delete_this_arg delthisarg
#define input_file_compiler inpfc
#define input_file_number inpfno
#define input_filename inpfname
#define input_filename_length infpflen
#define input_stat inpstat
#define input_stat_set inpsset
#define md_startfile_prefix mdstpref
#define md_startfile_prefix_1 mdstp1
#define multilib_defaults ml_def
#define multilib_defaults_raw ml_dfr
#define multilib_dir ml_dir
#define multilib_exclusions ml_excl
#define multilib_exclusions_raw ml_exr
#define multilib_extra ml_extra
#define multilib_matches ml_mat
#define multilib_matches_raw ml_mraw
#define multilib_obstack ml_obst
#define multilib_raw ml_raw
#define multilib_select ml_sele
#define print_multi_directory pm_dir
#define print_multi_lib pm_lib
#define print_multilib_info pm_info
#define standard_bindir_prefix st_bpref
#define standard_exec_prefix st_expref
#define standard_exec_prefix_1 st_ex1
#define standard_startfile_prefix st_st
#define standard_startfile_prefix_1 st_st1
#define standard_startfile_prefix_2 st_st2
#define startfile sfile
#define startfile_prefixes sfilepr
#define startfile_spec sfilespect
#define switches_need_spaces swneedsp
#define temp_file tfile
#define temp_filename tfilen
#define temp_filename_length tfilelen
#define this_is_library_file thislib
#define this_is_output_file thisout
#define tooldir_base_prefix toolbp
#define tooldir_prefix toolpref
#define user_specs usrspex
#define user_specs_head usrsph
#define user_specs_tail usrspt
#define verbose_flag verbflag
#define verbose_only_flag verboflag
#define warn_std wstd
#define warn_std_ptr wstdptr
#define can_copy_init_p cancip
#define can_copy_p cancopp
#define canon_modify canmod
#define canon_modify_mem_list_set canmmls
#define cprop_avin cpravin
#define cprop_avout cpravout
#define expr_hash_table exphtab
#define expr_hash_table_size exphtsize
#define gcse_mem_operand gcsemo
#define gcse_mems_conflict_p gcsemcp
#define hoist_expr_reaches_here_p hexprhp
#define hoist_exprs hexpres
#define hoist_vbein hvbein
#define hoist_vbeout hvbeout
#define modify_mem_list mmlist
#define modify_mem_list_set mmlset
#define pre_delete predel
#define pre_delete_map predmap
#define pre_insert_copies pricps
#define pre_insert_copy_insn precpin
#define pre_insert_map preinsmap
#define pre_redundant prerdun
#define pre_redundant_insns preredi
#define reg_set_bitmap rs_bitmap
#define reg_set_in_block rs_inblock
#define reg_set_info rs_info
#define reg_set_obstack rs_obstack
#define reg_set_table rs_tab
#define reg_set_table_size rs_tbsize
#define reg_use_count ru_count
#define reg_use_table ru_table
#define set_hash_table sh_tab
#define set_hash_table_size sh_tsize
#define allocno_ alno
#define allocno_compare alnoc
#define allocno_order alnoo
#define allocno_row_words alnorw
#define allocno_to_order alnoto
#define allocno_vec alnovec
#define local_reg_freq lregfreq
#define local_reg_live_length lregll
#define local_reg_n_refs lregnref
#define equiv_mem eqmem
#define equiv_mem_modified eqmemm
#define qty_phys_copy_sugg qp_copy_sugg
#define qty_phys_num_copy_sugg qp_ncopy_sugg
#define qty_phys_num_sugg qp_num_sugg
#define qty_phys_sugg qp_sugg
#define regs_live_at regsla
#define this_insn thisin
#define this_insn_number thsinn
#define indirect_jump_in_fun injinf
#define indirect_jump_in_function injifunc
#define loop_dump_aux ld_aux
#define loop_dump_stream ld_stream
#define debug_rtx drtx
#define debug_rtx_count dr_count
#define debug_rtx_find dr_find
#define debug_rtx_list dr_list
#define debug_rtx_range dr_range
#define print_rtl prrtl
#define print_rtl_single prsing
#define print_rtx prrtx
#define print_rtx_head prxhead
#define total_num_blocks tnblks
#define total_num_blocks_created tlbcreat
#define total_num_branches tnbranch
#define total_num_edges tnedge
#define total_num_edges_ignored tnedgign
#define total_num_edges_instrumented tnedins
#define total_num_never_executed tnnever
#define total_num_passes tnpasses
#define total_num_times_called tntcalled
#define call_fixed_reg_set cfixregset
#define call_fixed_regs cfixrgs
#define call_used cused
#define call_used_reg_set cusdrs
#define call_used_regs cusdregs
#define fixed_reg_set fregset
#define fixed_regs fregs
#define initial_call_used_regs initcur
#define initial_fixed_regs initfr
#define initial_value_struct initvs
#define may_move_in_cost mmincost
#define may_move_out_cost mmoutcost
#define reg_class r_class
#define reg_class_contents rclconts
#define reg_class_names rcnames
#define reg_class_size rcsize
#define reg_class_subclasses rcsubc
#define reg_class_subset_p rcsubp
#define reg_class_subunion rcsubu
#define reg_class_superclasses rcsuper
#define reg_class_superunion rcsupun
#define reg_classes_intersect_p rcintp
#define reg_pref regprf
#define reg_pref_buffer regpbuf
#define reg_preferred_class rpclass
#define flags_set_1 fset1
#define flags_set_1_rtx fset1rtx
#define flags_set_1_set fset2set
#define regmove_bb_head rmbbhead
#define regmove_dump_file rmdumpf
#define regmove_optimize rmopt
#define hard_reg_initial_vals hreginitvals
#define hard_reg_set_here_p hrsetherep
#define hard_regs_live_known hrliveknown
#define subst_reg_equivs sreqvs
#define subst_reg_equivs_changed sreqchanged
#define subst_reloads subrelods
#define this_insn_is_asm thisiasm
#define bad_spill_regs bspregs
#define bad_spill_regs_global bsrglob
#define move2add_last_label_luid mvlll
#define move2add_luid mvluid
#define move2add_note_store mvnote
#define num_eliminable numelm
#define num_eliminable_invariants numelminv
#define offsets_at offsat
#define offsets_known_at offsknown
#define other_input othinp
#define other_input_reload_insns othiri
#define reg_eliminate regelim
#define reg_eliminate_1 regel1
#define reg_equiv_address regea
#define reg_equiv_constant regec
#define reg_equiv_init regei
#define reg_equiv_mem regemem
#define reg_equiv_memory_loc regemloc
#define reg_reloaded_contents regrc
#define reg_reloaded_dead regrdead
#define reg_reloaded_died regrdied
#define reg_reloaded_insn regrinsn
#define reg_reloaded_valid regrvalid
#define reload_combine rl_comb
#define reload_combine_note_store rl_not
#define reload_combine_note_use rl_nou
#define reload_combine_ruid rl_ruid
#define reload_completed rl_comp
#define reload_cse_delete_noop_set rlc_dns
#define reload_cse_move2add rlc_move
#define reload_cse_noop_set_p rlc_noop
#define reload_cse_regs rlc_rgs
#define reload_cse_regs_1 rlc_r1
#define reload_cse_simplify rlc_simp
#define reload_cse_simplify_operands rlc_soper
#define reload_cse_simplify_set rlc_sset
#define reload_first_uid rl_fuid
#define reload_firstobj rl_fobj
#define reload_in_optab rl_iopt
#define reload_in_progress rlinprog
#define reload_inheritance_insn rlininsn
#define reload_inherited rl_inh
#define reload_insn_chain rl_inch
#define reload_insn_firstobj rl_info
#define reload_obstack rl_obst
#define reload_order rl_order
#define reload_out_optab rl_oopt
#define reload_override_in rl_ovin
#define reload_reg_class_lower rlr_cl
#define reload_reg_free_for_value_p rlr_ffv
#define reload_reg_free_p rlr_fp
#define reload_reg_reaches_end_p rlr_rep
#define reload_reg_unavailable rlr_un
#define reload_reg_used rlr_used
#define reload_reg_used_at_all rlr_uaa
#define reload_reg_used_for_inherit rlr_ufi
#define reload_reg_used_in_inpaddr_addr rlr_uiia
#define reload_reg_used_in_input rlr_inp
#define reload_reg_used_in_input_addr rlr_add
#define reload_reg_used_in_insn rlr_isn
#define reload_reg_used_in_op_addr rlruoa
#define reload_reg_used_in_op_addr_reload rluoar
#define reload_reg_used_in_other_addr rlroadd
#define reload_reg_used_in_outaddr_addr rlrioa
#define reload_reg_used_in_output rlruio
#define reload_reg_used_in_output_addr rlruopa
#define reload_spill_index rl_spind
#define reload_startobj rl_start
#define something_changed somechg
#define something_needs_elimination somene
#define spill_reg_order sprego
#define spill_reg_rtx spregr
#define spill_reg_store spregs
#define spill_reg_stored_to spregto
#define spill_regs sregs
#define spill_stack_slot ss_slot
#define spill_stack_slot_width sss_wid
#define used_spill_regs uspregs
#define used_spill_regs_local usprloc
#define rtx_equal_p rteqp
#define executable_blocks exblocks
#define executable_edges exedges
#define ssa_rename_from ssarfrom
#define ssa_rename_from_delete ssafdel
#define ssa_rename_from_equal ssafeq
#define ssa_rename_from_free ssaff
#define ssa_rename_from_hash_function ssafhf
#define ssa_rename_from_hash_table_data ssafhtd
#define ssa_rename_from_ht ssafht
#define ssa_rename_from_initialize ssafinit
#define ssa_rename_from_insert ssafins
#define ssa_rename_from_lookup ssaflook
#define ssa_rename_from_pair ssafpair
#define ssa_rename_from_print ssafprint
#define ssa_rename_from_print_1 ssafp1
#define ssa_rename_from_traverse ssaftrav
#define ssa_rename_to_hard ssatohard
#define ssa_rename_to_insert ssatoi
#define ssa_rename_to_lookup ssatol
#define ssa_rename_to_pseudo ssatop
#define cost_table_ csttab
#define cost_table_initialized csttinit
#define using_eh_for_cleanups usefcln
#define using_eh_for_cleanups_p useefp
#define sizetype_set stypset
#define sizetype_tab styptab
#define align_functions alfuncs
#define align_functions_log alfunlog
#define align_jumps aljump
#define align_jumps_log aljmpl
#define align_jumps_max_skip aljmpms
#define align_labels allab
#define align_labels_log allabl
#define align_labels_max_skip allabms
#define align_loops alloop
#define align_loops_log allopl
#define align_loops_max_skip allopms
#define aux_info_file ainff
#define aux_info_file_name ainffn
#define current_function_func_begin_label cffbl
#define flag_bounded_pointers fbpoint
#define flag_bounds_check fbcheck
#define flag_branch_on_count_reg fbocr
#define flag_branch_probabilities fbprob
#define flag_cse_follow_jumps fcfjump
#define flag_cse_skip_blocks fcskip
#define flag_delayed_branch fdbranch
#define flag_delete_null_pointer_checks fdnpc
#define flag_force_addr ffaddr
#define flag_force_mem ffmem
#define flag_gcse fgcse
#define flag_gcse_lm fgclm
#define flag_gcse_sm fgcsm
#define flag_keep_inline_functions fkinf
#define flag_keep_static_consts fksconst
#define flag_no_common fnocom
#define flag_no_function_cse fnofcse
#define flag_no_ident fnoind
#define flag_no_inline fnoinl
#define flag_no_peephole fnopeep
#define flag_prefetch_loop_arrays fprefl
#define flag_pretend_float fpretf
#define flag_rename_registers frenreg
#define flag_renumber_insns freumin
#define flag_rerun_cse_after_loop frecal
#define flag_rerun_loop_opt frlo
#define flag_schedule_insns fsinsn
#define flag_schedule_insns_after_reload fsciar
#define flag_schedule_interblock fsiblk
#define flag_schedule_speculative fsspec
#define flag_schedule_speculative_load fsspcl
#define flag_schedule_speculative_load_dangerous fspcld
#define flag_ssa fssa
#define flag_ssa_ccp fssaccp
#define flag_ssa_dce fssadce
#define flag_strength_reduce fsreduce
#define flag_strict_aliasing fstralias
#define flag_trapping_math ftrapmath
#define flag_trapv ftrapv
#define flag_unroll_all_loops funraloop
#define flag_unroll_loops funrloop
#define flag_volatile fvolat
#define flag_volatile_global fvolglob
#define flag_volatile_static fvolstat
#define float_handled flhled
#define float_handler flhler
#define float_handler_set flhset
#define g_switch_set gswset
#define g_switch_val gswval
#define g_switch_value gswvue
#define input_file_stack infstk
#define input_file_stack_tick infstick
#define lang_independent_init lindinit
#define lang_independent_options lindopt
#define lang_independent_params lindparm
#define optimize optze
#define optimize_size optzsz
#define optimize_val optzval
#define profile_arc_flag profaflag
#define profile_flag profflag
#define profile_label_no proflno
#define rtl_dump_and_exit rtdande
#define rtl_dump_file rtdfile
#define save_argc savac
#define save_argv savav
#define warn_unused_function wun_func
#define warn_unused_parameter wun_parm
#define warn_unused_value wu_val
#define warn_unused_variable wu_var
#define default_comp_type_attributes defcta
#define default_insert_attributes defiatt
#define default_ms_bitfield_layout_p defmsl
#define default_target_attribute_table deftat
#define default_set_default_type_attributes defsdta
#define default_function_attribute_inlinable_p defatip
#define default_named_section_asm_out_destructor defnsaod
#define default_stabs_asm_out_constructor defsaocn
#define default_named_section_asm_out_constructor defnsaoc

#define integer_all_onesp intaones
#define integer_cst intcst
#define integer_onep intone
#define integer_pow2p intp2p
#define integer_type inttpe
#define integer_types inttys
#define integer_zerop intzerp
#define lang_unsafe_for_reeval lunsfre
#define lang_unsave lunsav
#define lang_unsave_expr_now lunsen
#define last_file lstfile
#define last_filenode lstfnode
#define make_lang_type mltype
#define make_lang_type_fn mltypfn
#define tree_code tcod
#define tree_code_length tcodlen
#define tree_code_name tcodname
#define tree_code_type tcodtype
#define tree_node tnode
#define tree_node_counts tn_counts
#define tree_node_kind_names tn_kind
#define tree_node_sizes tn_size
#define type_hash thash
#define type_hash_add th_add
#define type_hash_canon th_canon
#define type_hash_eq th_eq
#define type_hash_hash th_hash
#define type_hash_list th_list
#define type_hash_lookup th_look
#define type_hash_mark th_mark
#define type_hash_marked_p th_maarp
#define type_hash_table thtab
#define splittable_regs splregs
#define splittable_regs_updates srupda
#define const_hash cnhash
#define const_hash_rtx cnhrtx
#define const_hash_table cnhtab
#define const_str_htab cnstrh
#define const_str_htab_del cnhtdel
#define const_str_htab_eq cnhteq
#define const_str_htab_hash cnhthash
#define defer_addressed_constants defac
#define defer_addressed_constants_flag defacf
#define in_named innam
#define in_named_entry innent
#define in_named_entry_eq ineeq
#define in_named_entry_hash inehash
#define in_named_htab innhtab
#define in_named_name innname
#define mvs_function_check mf_check
#define mvs_function_name mf_name
#define mvs_function_name_length mf_nlen
#define mvs_need_alias mn_alias
#define mvs_need_base_reload mn_base
#define mvs_need_entry mn_entry
#define mvs_need_to_globalize mn_toglob
#define mvs_page_code mp_code
#define mvs_page_lit mp_lit
#define mvs_page_num mp_num
#define regno_save_mode rns_mode
#define regno_save_mem rns_mem
#define reg_dead_regno rd_regno
#define reg_dead_endregno rd_endregno
#define reg_dead_flag rd_flag
#define xstrerror_buf xste_buf
#define print_deps pdeps
#define print_deps_phony_targets pdepsphony
#define read_rtx_lineno rrtxlin
#define read_rtx_filename rrtxfile
#define obstack_exit_failure os_exitf
#define obstack_alloc_failed_handler os_failh
#define _obstack_begin _osbegin
#define _obstack_begin_1 _osbg1
#define _obstack_newchunk _osnchunk
#define _obstack_allocated_p _osallp
#define _obstack_free _osfree
#define _obstack_memory_used _osmemu
#define rest_of_decl_compilation ro_decl_comp
#define rest_of_type_compilation ro_type_comp
#define rest_of_compilation ro_comp
#define htab_hash_pointer hh_point
#define htab_hash_string hh_string
#define inhibit_warnings inh_warn
#define inhibit_output inh_output

#define i370_pr_checkout ip_checkout
#define i370_pr_map ip_map
#define i370_pr_skipit ip_skipit
#define i370_branch_dest ip_bdest
#define i370_branch_length ip_blen
#define i370_output_function_epilogue io_fepil
#define mvs_add_alias mvs_aalias
#define mvs_add_label mvs_alabel
#define mvs_check_alias mvs_calias
#define mvs_check_label mvs_clabel
#define mvs_check_page mvs_cpage
#define mvs_get_alias mvs_galias
#define mvs_get_label mvs_glabel

#define concat_copy cncopy
#define concat_copy2 cncop2
#define vconcat_copy vccopy
#define vconcat_length vclen
#define fibheap_cascading_cut fc_cut
#define fibheap_comp_data fc_data
#define fibheap_compare fcompr
#define fibheap_consolidate fcons
#define fibheap_cut fcut
#define fibheap_delete fdelete
#define fibheap_delete_node fdelnode
#define fibheap_empty fempty
#define fibheap_extr_min_node femn
#define fibheap_extract_min femin
#define fibheap_ins_root finsroot
#define fibheap_insert finsert
#define fibheap_link flink
#define fibheap_min fmin
#define fibheap_min_key fminkey
#define fibheap_new fnew
#define fibheap_rem_root fremroot
#define fibheap_replace_data frepdata
#define fibheap_replace_key frepkey
#define fibheap_replace_key_data frepkdata
#define fibheap_union fhunion
#define fibnode_insert_after finsafter
#define fibnode_new fnodnew
#define fibnode_remove fnodrem
#define htab_find htfind
#define htab_find_slot htfslot
#define htab_find_slot_with_hash htfswhash
#define htab_find_with_hash htfwhash
#define partition partn
#define partition_def partdef
#define partition_delete partdlt
#define partition_elem partelem
#define partition_new partnew
#define partition_print partpr
#define partition_union partun
#define splay_tree stree
#define splay_tree_allocate_fn stralfn
#define splay_tree_compare_fn stcmfn
#define splay_tree_compare_ints stcmints
#define splay_tree_compare_pointers stcmptrs
#define splay_tree_deallocate_fn stdefn
#define splay_tree_delete stdelete
#define splay_tree_delete_helper stdelhelp
#define splay_tree_delete_key_fn stdelkfn
#define splay_tree_delete_value_fn stdelvfn
#define splay_tree_foreach stfeach
#define splay_tree_foreach_fn stfefn
#define splay_tree_foreach_helper stfeh
#define splay_tree_insert stins
#define splay_tree_key stkey
#define splay_tree_lookup stlook
#define splay_tree_max stmax
#define splay_tree_min stmin
#define splay_tree_new stnew
#define splay_tree_new_with_allocator stnewwal
#define splay_tree_node stnode
#define splay_tree_node_s stnods
#define splay_tree_predecessor stpred
#define splay_tree_remove strem
#define splay_tree_s strees
#define splay_tree_splay strsplay
#define splay_tree_splay_helper stshelp
#define splay_tree_successor stsucc
#define splay_tree_xmalloc_allocate stxall
#define splay_tree_xmalloc_deallocate stxdeall
#define xmalloc_failed xmalfail
#define xmalloc_set_program_name xmalspgn

#define find_base_decl fb_decl
#define find_base_term fb_term
#define find_base_value fb_val
#define get_alias_set ga_set
#define get_alias_set_entry ga_se
#define init_alias_analysis ia_anal
#define init_alias_once ia_once
#define nonoverlapping_component_refs_p noncomprefs
#define nonoverlapping_memrefs_p nonmemrefs
#define handle_alias_attribute halias
#define handle_aligned_attribute halign
#define handle_always_inline_attribute halways
#define handle_common_attribute hcommon
#define handle_const_attribute hconsatt
#define handle_constructor_attribute hconstr
#define handle_deprecated_attribute hdeprec
#define handle_destructor_attribute hdestr
#define handle_malloc_attribute hmalloc
#define handle_mode_attribute hmodeatt
#define handle_no_limit_stack_attribute hnolim
#define handle_nocommon_attribute hnocommon
#define handle_noinline_attribute hnoinl
#define handle_noreturn_attribute hnoret
#define handle_packed_attribute hpacked
#define handle_pure_attribute hpureatt
#define handle_unused_attribute hunusedat
#define handle_used_attribute husedatt
#define make_reorder_chain mkreorder
#define make_reorder_chain_1 mkreoc1
#define debug_bit dbgbit
#define debug_bitmap_file dbgbmf
#define default_expand_builtin defexp
#define default_init_builtins definitb
#define eb_strncat ebsncat
#define eb_strncmp ebsncmp
#define eb_strncpy ebsncpy
#define expand_binop expbinop
#define expand_builtin expbuilt
#define expand_builtin_eh_return expbehret
#define expand_builtin_extract_return_addr expbera
#define expand_builtin_expect_jump expbej
#define expand_builtin_frob_return_addr expfra
#define expand_builtin_longjmp expblj
#define expand_builtin_return_addr exprad
#define expand_builtin_saveregs expsregs
#define expand_builtin_setjmp_receiver expsjr
#define expand_builtin_setjmp_setup expsjs
#define expand_builtin_trap exptrap
#define expand_builtin_unwind_init expunwind
#define std_expand_builtin_va_arg stdevarg
#define std_expand_builtin_va_start stdevstart
#define gen_formal_list_for_func_def gflffd
#define gen_formal_list_for_type gflftype
#define builtin_function bifunc
#define builtin_function_2 bifnc2
#define builtin_function_disabled_p bifdp
#define builtin_name biname
#define builtin_type bitype
#define builtin_types bityps
#define c_alignof calof
#define c_alignof_expr calofex
#define c_begin_if_stmt cbegif
#define c_begin_while_stmt cbegws
#define c_common_finish ccomfin
#define c_common_get_alias_set ccomgas
#define c_common_init ccominit
#define c_common_init_options comnopt
#define c_common_nodes_and_builtins ccomnode
#define c_common_post_options ccompo
#define c_expand_builtin cebuilt
#define c_expand_builtin_fprintf cebfpr
#define c_expand_builtin_printf cebprt
#define c_expand_end_cond ceecond
#define c_expand_expr ceexpr
#define c_expand_expr_stmt cexexst
#define c_expand_start_cond cexstcond
#define c_expand_start_else cexstelse
#define c_finish_else cfinelse
#define c_finish_then cfinthen
#define c_finish_while_stmt_ cfinwhile
#define constant_expression_warning conexpw
#define constant_fits_type_p confitt
#define constant_flag conflag
#define type_for_mode typfmod
#define type_for_size typfsize
#define unsigned_conversion_warning ucwarn
#define unsigned_flag uflag
#define unsigned_type untype
#define unsignedp usigp
#define unsignedp0 usigp0
#define unsignedp1 usigp1
#define warn_for_collisions wforcol
#define warn_for_collisions_1 wfor1col
#define c_expand_body cexpbody
#define c_expand_decl_stmt cexpdecl
#define c_expand_deferred_function cexpdff
#define c_expand_return cexpret
#define groktypename gtypn
#define groktypename_in_parm_context gtypninpc
#define implicit_decl impdecl
#define implicit_decl_warning impdwarn
#define implicit_warning impwarn
#define implicitly_declare impdclr
#define lookup_name lname
#define lookup_name_current_level lnamecl
#define lookup_tag lookt
#define lookup_tag_reverse looktr
#define pushdecl pdecl
#define pushdecl_top_level pdecltl
#define shadow_tag shadtag
#define shadow_tag_warned shadtwarn
#define check_format_info chkfinf
#define check_format_info_main chkfmain
#define check_format_info_recurse chkfrec
#define check_format_types chkftype
#define decode_format_attr decfa
#define decode_format_type decft
#define maybe_objc_check_decl mobchkdecl
#define maybe_objc_comptypes mobcomptype
#define c_objc_common_finish_file cocff
#define c_objc_common_init cocinit
#define maybe_apply_pragma_weak mapprweak
#define maybe_apply_renaming_pragma maprenprag
#define genrtl_case_label genclab
#define genrtl_compound_stmt gencstmt
#define genrtl_continue_stmt genconts
#define genrtl_decl_cleanup gendclean
#define genrtl_decl_stmt gendstmt
#define genrtl_do_pushlevel gendpush
#define genrtl_do_stmt gendostmt
#define genrtl_expr_stmt genexst
#define genrtl_expr_stmt_value genesval
#define genrtl_scope_stmt genscope
#define genrtl_switch_stmt genswitch
#define build_complex_type bldctype
#define build_component_ref bldcmpref
#define build_compound_expr bldcexpr
#define build_conditional_expr bldconexp
#define c_expand_asm_operands cexpasm
#define c_sizeof csizeof
#define c_sizeof_nowarn csiznowarn
#define convert_and_check candchk
#define convert_arguments convarg
#define convert_for_assignment convfass
#define convert_p cnv_p
#define decl_constant_value declcval
#define default_conversion defconvr
#define set_init_index setii
#define set_init_label setil
#define set_nonincremental_init setniinit
#define check_sibcall_argument_overlap chksib
#define compute_argument_addresses cargadd
#define compute_argument_block_size cargbs
#define emit_libcall_block el_block
#define emit_library_call el_call
#define emit_library_call_value el_val
#define emit_library_call_value_1 el_vl1
#define precompute_arguments preargs
#define precompute_register_parameters preregp
#define alloc_aux_for_block aauxfb
#define alloc_aux_for_blocks aauxfs
#define alloc_aux_for_edge aafedg
#define alloc_aux_for_edges aafeds
#define clear_aux_for_blocks cafblks
#define clear_aux_for_edges cafedge
#define expunge_block expblk
#define expunge_block_nocompact expblkno
#define free_aux_for_blocks faforb
#define free_aux_for_edges faforedge
#define redirect_edge_pred redpred
#define redirect_edge_succ redsuc
#define redirect_edge_succ_nodup redsunodup
#define flow_dfs_compute_reverse_add_bb fdcradd
#define flow_dfs_compute_reverse_finish fdcrfin
#define flow_dfs_compute_reverse_init fdcrinit
#define remove_fake_edges remfedg
#define remove_fake_successors remfsuc
#define find_basic_blocks fbblk
#define find_basic_blocks_1 fbblk1
#define merge_blocks merblk
#define merge_blocks_nomove merbnomove
#define try_crossjump_bb tcrxbb
#define try_crossjump_to_edge tcrxte
#define cfg_layout_finalize cfglfin
#define cfg_layout_initialize cfglinit
#define scope_to_insns_finalize scptoif
#define scope_to_insns_initialize scptii
#define flow_loop_dump fldump
#define flow_loop_entry_edges_find flefind
#define flow_loop_exit_edges_find fleedg
#define flow_loop_level_compute fllcomp
#define flow_loop_nested_p flnest
#define flow_loop_nodes_find flnodes
#define flow_loop_outside_edge_p flouts
#define flow_loop_pre_header_find flprhfind
#define flow_loop_pre_header_scan flprhscan
#define flow_loop_scan flscan
#define flow_loop_tree_node_add fltree
#define flow_loops_cfg_dump flscfgd
#define flow_loops_dump flsdump
#define flow_loops_find flsfind
#define flow_loops_free flsfree
#define flow_loops_level_compute flslevcomp
#define flow_loops_tree_build flstree
#define flow_loops_update flsupdate
#define can_delete_label_p cdellab
#define can_delete_note_p cdelnote
#define create_basic_block cbasblk
#define create_basic_block_structure cbasbs
#define debug_bb dbgbb
#define debug_bb_n dbgbbn
#define delete_insn delins
#define delete_insn_chain delinchain
#define flow_delete_block fdelblk
#define flow_delete_block_noexpunge fdelbnoexp
#define force_nonfallthru fnonfal
#define force_nonfallthru_and_redirect fnonfd
#define redirect_edge_and_branch reeabranc
#define redirect_edge_and_branch_force reeabfor
#define redirect_jump redirjmp
#define tidy_fallthru_edge tidyfe
#define tidy_fallthru_edges tidfedg
#define update_bb_for_insn upbbfor
#define update_br_prob_note upbprob
#define combine_instructions combinst
#define distribute_links dislinks
#define distribute_notes disnotes
#define do_SUBST dosubst
#define do_SUBST_INT dosubint
#define dump_combine_stats dmpcstat
#define dump_combine_total_stats dmpctotstats
#define get_last_value glstval
#define get_last_value_validate glstvv
#define record_dead_and_set_regs recdasr
#define record_dead_insn recdedins
#define simplify_and_const_int sandcint
#define simplify_binary_operation sbinopt
#define simplify_comparison scomprs
#define simplify_gen_subreg sgensub
#define simplify_gen_unary sgenunry
#define simplify_if_then_else sifthen
#define simplify_logical slogicl
#define simplify_relational_operation sreloper
#define simplify_set simpset
#define simplify_shift_const sshftcons
#define simplify_subreg ssubreg
#define simplify_ternary_operation sternop
#define simplify_unary_operation sunaryop
#define conflict_graph cgraph
#define conflict_graph_add cgadd
#define conflict_graph_arc cgarc
#define conflict_graph_arc_def cgadef
#define conflict_graph_compute cgcomp
#define conflict_graph_conflict_p cgconf
#define conflict_graph_def cgdef
#define conflict_graph_delete cgdel
#define conflict_graph_enum cgenum
#define conflict_graph_enum_fn cgenfn
#define conflict_graph_merge_regs cgmregs
#define conflict_graph_new cgnew
#define conflict_graph_print cgprint
#define convert_to_complex cnvtcompl
#define convert_to_integer cnvtint
#define convert_to_pointer cnvtptr
#define convert_to_real cnvtreal
#define convert_to_vector cnvtvec
#define cpp_error cperr
#define cpp_error_from_errno cperrfe
#define cpp_error_with_line cperrwl
#define cpp_notice_from_errno cpnot
#define cpp_pedwarn cppdwarn
#define cpp_pedwarn_with_line cppdwwl
#define cpp_warning cppwrn
#define cpp_warning_with_line cppwwl
#define cpp_finish cppfin
#define cpp_finish_options cppfino
#define cpp_handle_option cpphopt
#define cpp_handle_options cppopts
#define remove_dup_dir remdupdir
#define remove_dup_dirs remddirs
#define _cpp_lex_direct _cplexd
#define _cpp_lex_token _cpletk
#define cpp_output_line cpoline
#define cpp_output_token cpotok
#define cpp_token cptok
#define cpp_token_as_text cptastext
#define cpp_token_len cptklen
#define parse_identifier pindent
#define parse_identifier_slow pindslow
#define _cpp_do__Pragma _cpdprag
#define _cpp_do_file_change _cpdfcha
#define _cpp_init_directives _cpindir
#define _cpp_init_internal_pragmas _cpintprag
#define cpp_get_callbacks cg_calb
#define cpp_get_line_maps cg_linmaps
#define cpp_get_options cg_opts
#define cpp_get_token cg_token
#define do_include doinc
#define do_include_common doinccom
#define do_include_next doincnext
#define do_pragma doprag
#define do_pragma_dependency doprdep
#define do_pragma_once dopronce
#define do_pragma_poison doprpois
#define do_pragma_system_header doprsysh
#define approx_reg_cost aregcost
#define approx_reg_cost_1 arcst1
#define canon_hash cnnhash
#define canon_hash_string cnnhstr
#define invalidate invalt
#define invalidate_f invalf
#define invalidate_from_clobbers invalc
#define invalidate_memory invalm
#define invalidate_skipped_block invals
#define invalidate_skipped_set invalk
#define record_jump_cond recjcond
#define record_jump_equiv recjequiv
#define remove_invalid_refs remirefs
#define remove_invalid_subreg_refs remisubrefs
#define cselib_lookup cslook
#define cselib_lookup_mem cslokmem
#define discard_useless_locs discul
#define discard_useless_values discuv
#define new_elt_list newelt
#define unchain_one_elt_list unoel
#define unchain_one_elt_loc_list unoell
#define unchain_one_value unoval
#define debug_nothing_charstar dnutcs
#define debug_nothing_int dnutint
#define debug_nothing_int_charstar dnuics
#define debug_nothing_int_int dnuiint
#define debug_nothing_rtx dnurtx
#define debug_nothing_tree dnutree
#define debug_nothing_void dnuvoid
#define DF_REF_READ_WRITE DRR_WR
#define DF_REF_REG_DEF DRR_DEF
#define DF_REF_REG_MEM_LOAD DRR_ML
#define DF_REF_REG_MEM_STORE DRR_MS
#define DF_REF_REG_USE DRR_USE
#define debug_df_chain ddfch
#define debug_df_defno ddfdef
#define debug_df_insn ddfinsn
#define debug_df_ref ddfref
#define debug_df_reg ddfreg
#define debug_df_regno ddfren
#define debug_df_useno ddfuse
#define df_analyse dfanal
#define df_analyse_1 dfana1
#define df_bb_insn_regno_first_def_find dfbbin
#define df_bb_insn_regno_last_use_find dfbirluf
#define df_bb_refs_record dfbrr
#define df_bb_refs_update dfbrupd
#define df_bb_reg_def_chain_create dfdcc
#define df_bb_reg_info_compute dfric
#define df_bb_reg_live_end_p dfrlep
#define df_bb_reg_live_start_p dfrlstrt
#define df_bb_reg_use_chain_create dfbruchcr
#define df_bb_regno_first_def_find dfrfdf
#define df_bb_regno_last_use_find dfrluf
#define df_bb_regs_lives_compare dfrlc
#define df_bitmaps_alloc dfball
#define df_bitmaps_free dfbfree
#define df_chain_dump dfchdmp
#define df_chain_dump_regno dfchdmr
#define df_def_dominates_all_uses_p dfddaup
#define df_def_dominates_uses_p dfdup
#define df_insn_debug dfideb
#define df_insn_debug_regno dfidreg
#define df_insn_delete dfidel
#define df_insn_dominates_all_uses_p dfidaup
#define df_insn_dominates_uses_p dfidup
#define df_insn_mem_replace dfimrep
#define df_insn_modify dfimod
#define df_insn_move_before dfimov
#define df_insn_refs_record dfirrec
#define df_insn_refs_unlink dfirunl
#define df_insn_regno_def_p dfirdef
#define df_insn_table_realloc dfitre
#define df_pattern_emit_after dfpatea
#define df_pattern_emit_before dfpebef
#define df_ref_record dfrrec
#define df_ref_record_1 dfrrc1
#define df_ref_reg_replace dfrrr
#define df_ref_remove dfrrem
#define df_refs_process dfrproc
#define df_refs_queue dfrque
#define df_refs_record dfrsrec
#define df_refs_reg_replace dfrsrp
#define df_refs_update dfrsupd
#define df_reg_use_chain_create dfruchcr
#define df_reg_use_gen dfrug
#define df_regno_debug dfregd
#define hybrid_search_bitmap hybsbit
#define hybrid_search_sbitmap hybssb
#define iterative_dataflow_bitmap itdfb
#define iterative_dataflow_sbitmap itdsb
#define default_diagnostic_finalizer ddfinal
#define default_diagnostic_starter ddstart
#define default_print_error_function dpefunc
#define error_with_decl errwdecl
#define error_with_file_and_line errwfal
#define output_add_character oaddch
#define output_add_newline oaddnl
#define output_add_space oaddsp
#define output_add_string oaddstr
#define output_append oapp
#define output_append_r oappr
#define output_clear oclr
#define output_clear_message_text oclrmt
#define output_decimal odec
#define output_destroy_prefix odestr
#define output_do_printf odoprt
#define output_do_verbatim odverb
#define output_finalize_message ofinmsg
#define output_format oformat
#define output_indent oindent
#define output_is_line_wrapping oisline
#define output_last_position olastpos
#define output_long_decimal olongdec
#define output_long_hexadecimal olongh
#define output_long_octal olongo
#define output_long_unsigned_decimal olongud
#define output_set_maximum_length osetmaxl
#define output_set_prefix osetpref
#define output_space_left ospleft
#define output_state ostate
#define pedwarn_with_decl pwwdecl
#define pedwarn_with_file_and_line pwwfil
#define record_last_error_function reclef
#define record_last_error_module reclem
#define calc_dfs_tree cdfstree
#define calc_dfs_tree_nonrec cdfstnon
#define dw2_asm_output_addr daoaddr
#define dw2_asm_output_addr_rtx daoadr
#define dw2_asm_output_data daod
#define dw2_asm_output_data_sleb128 daodsl
#define dw2_asm_output_data_uleb128 daodul
#define dw2_asm_output_delta daodel
#define dw2_asm_output_delta_sleb128 daodes
#define dw2_asm_output_delta_uleb128 daodeu
#define dw2_asm_output_encoded_addr_rtx daoear
#define dw2_asm_output_nstring daonstr
#define dw2_asm_output_offset daooff
#define dw2_asm_output_pcrel daopcr
#define dw2_output_indirect_constant_1 doinc1
#define dw2_output_indirect_constants doincons
#define mark_indirect_pool mindpol
#define mark_indirect_pool_entry mindpe
#define size_of_encoded_value sofencv
#define size_of_sleb128 sofsleb
#define size_of_uleb128 sofuleb
#define add_insn addin
#define add_insn_after addina
#define add_insn_before addinbef
#define adjust_address_1 adjadd
#define adjust_automodify_address_1 adjaad
#define change_address chadd
#define change_address_1 chadd1
#define emit_barrier embar
#define emit_barrier_after embaf
#define emit_barrier_before embbef
#define emit_call_insn emcins
#define emit_call_insn_before emcibef
#define emit_insn emins
#define emit_insn_after emiaft
#define emit_insn_after_with_line_notes emiafwln
#define emit_insn_before emibef
#define emit_insns emisn
#define emit_insns_after emisaf
#define emit_insns_before emisbf
#define emit_jump_insn emji
#define emit_jump_insn_after emjia
#define emit_jump_insn_before emjib
#define emit_label emlab
#define emit_label_after emlaba
#define emit_label_before emlabb
#define emit_line_note emlnot
#define emit_line_note_after emlnaft
#define emit_line_note_force emlnfor
#define emit_note emnote
#define emit_note_after emnota
#define emit_note_before emnotb
#define gen_highpart genhp
#define gen_highpart_mode genhpmod
#define gen_lowpart_SUBREG genlps
#define gen_lowpart_common genlpc
#define gen_rtvec genrv
#define gen_rtvec_v genrtv
#define gen_rtx_CONST_DOUBLE grcd
#define gen_rtx_CONST_INT grcint
#define gen_rtx_MEM grmem
#define gen_rtx_REG grreg
#define gen_rtx_SUBREG grsub
#define gen_rtx_fmt_E grfmE
#define gen_rtx_fmt_e0 grfme0
#define gen_rtx_fmt_i0 grfmi0
#define gen_rtx_fmt_iuu00iss grfmiss
#define gen_rtx_fmt_ue grfmue
#define gen_rtx_fmt_w grfmtw
#define get_last_insn glinsn
#define get_last_insn_anywhere gliany
#define init_emit iniemi
#define init_emit_once iniemonce
#define operand_subword opsubw
#define operand_subword_force opsubwf
#define push_to_full_sequence ptofseq
#define push_to_sequence ptoseq
#define reorder_insns reoinsns
#define reorder_insns_nobb reoinobb
#define reorder_insns_with_line_notes reoiwln
#define replace_equiv_address repeqadd
#define replace_equiv_address_nv repeqnv
#define reset_used_decls resudec
#define reset_used_flags resuflag
#define restore_emit_status resems
#define restore_line_number_status reslns
#define set_mem_alias_set smemal
#define set_mem_align smalig
#define set_mem_attributes smatt
#define set_mem_expr smexpr
#define set_mem_offset smoffs
#define set_new_first_and_last_insn snfali
#define set_new_last_label_num snllnum
#define start_sequence sseque
#define start_sequence_for_rtl_expr ssqfre
#define subreg_hard_regno subhrn
#define subreg_highpart_offset subhoff
#define subreg_lowpart_offset slopoff
#define subreg_lowpart_p slopp
#define unshare_all_decls unsadecl
#define unshare_all_rtl unsartl
#define unshare_all_rtl_1 unsar1
#define unshare_all_rtl_again unsara
#define action_record arecd
#define action_record_data ardata
#define action_record_eq areceq
#define action_record_hash arechash
#define can_throw_external cantext
#define can_throw_internal cantint
#define collect_eh_region_array colehra
#define collect_one_action_chain coloac
#define convert_from_eh_region_ranges cferrange
#define convert_from_eh_region_ranges_1 cfehrr1
#define convert_to_eh_region_ranges ctehrran
#define convert_to_mode cttomode
#define duplicate_eh_region_1 dehr1
#define duplicate_eh_region_2 dehr2
#define duplicate_eh_regions dehregs
#define ehspec_filter_eq ehspfeq
#define ehspec_filter_hash ehfhash
#define expand_builtin_eh_return_data_regno eberdr
#define expand_eh_region_end expehreg
#define expand_eh_region_end_allowed eereall
#define expand_eh_region_end_cleanup eereclean
#define expand_eh_region_end_fixup eerefix
#define expand_eh_region_end_throw eerethrow
#define expand_eh_region_start eerstart
#define expand_eh_return eehret
#define expand_end_all_catch eendallc
#define expand_end_catch eendcatch
#define expand_expr expexpr
#define expand_start_all_catch expsallc
#define expand_start_catch expscatch
#define for_each_eh_label feehlab
#define for_each_eh_label_1 feehlb1
#define get_exception_filter gexcfil
#define get_exception_pointer gexcptr
#define mark_eh_region mehreg
#define mark_eh_status mehstat
#define mark_ehl_map mehmap
#define mark_ehl_map_entry mehment
#define reachable rchable
#define reachable_code rchacode
#define reachable_handlers rchhand
#define reachable_info rchinfo
#define reachable_next_level rchnxlvl
#define remove_eh_handler remehh
#define remove_exception_handler_label remehl
#define sjlj_emit_dispatch_table sjedt
#define sjlj_emit_func sjefunc
#define sjlj_emit_function_enter sjefent
#define sjlj_emit_function_exit_after sjefexita
#define t2r_mark t2rmk
#define t2r_mark_1 t2rm1
#define ttypes_filter ttflt
#define ttypes_filter_eq ttfeq
#define ttypes_filter_hash ttfhash
#define copy_to_mode_reg copytmr
#define copy_to_reg copytreg
#define copy_to_suggested_reg copytsreg
#define emit_stack_probe emsprob
#define emit_stack_restore emsrest
#define emit_stack_save emssave
#define emit_status emstat
#define memory_address memadd
#define memory_address_noforce memanof
#define memory_address_p memadp
#define emit_store_flag emsflag
#define emit_store_flag_force emsfforc
#define expand_dec expdec
#define expand_divmod expdivm
#define expand_modifier expmod
#define expand_mult expmult
#define expand_mult_add expmadd
#define expand_mult_highpart expmhigh
#define expand_mult_highpart_adjust expmhadj
#define extract_bit_field extbfield
#define extract_fixed_bit_field extfixed
#define extract_split_bit_field extsplit
#define clear_by_pieces clrbyp
#define clear_by_pieces_1 clrbp1
#define convert_modes cnvmod
#define convert_move cnvmov
#define convert_parm_for_inlining cnvpfi
#define do_compare_and_jump docmpaj
#define do_compare_rtx_and_jump docmpraj
#define do_jump_by_parts_equality dojbpe
#define do_jump_by_parts_equality_rtx dojbpr
#define do_jump_by_parts_greater dojpgr
#define do_jump_by_parts_greater_rtx dojprrtx
#define emit_group_load emgrld
#define emit_group_store emgrst
#define emit_move_insn emmov
#define emit_move_insn_1 emmov1
#define highest_pow2_factor hpow2f
#define highest_pow2_factor_for_type hpow2fftyp
#define init_expr initexpr
#define init_expr_once initeonce
#define move_block_from_reg movblkfr
#define move_block_to_reg mvbltoreg
#define move_by_pieces mvbypiec
#define move_by_pieces_1 mvbyp1
#define move_by_pieces_ninsns mvbypnin
#define store_by_pieces stbypic
#define store_by_pieces_1 stbyp1
#define store_by_pieces_2 stybp2
#define store_constructor stconst
#define store_constructor_field stconfld
#define output_addr_const oaddrc
#define output_address oaddress
#define output_asm_insn oasminsn
#define output_asm_label oasmlab
#define output_asm_name oasmname
#define output_asm_operand_names oasmonames
#define output_operand ooperand
#define output_operand_lossage ooploss
#define profile_after_prologue profaft
#define profile_function proffun
#define allocate_bb_life_data allbbld
#define allocate_reg_info allreginf
#define allocate_reg_life_data allrlifed
#define invalidate_mems_from_autoinc invmfauto
#define invalidate_mems_from_set invmfset
#define mark_reg mrkreg
#define mark_regs_live_at_end mreglae
#define mark_set_1 mset1
#define mark_set_regs msetregs
#define mark_used_reg musedreg
#define mark_used_regs museregs
#define propagate_block propblk
#define propagate_block_delete_insn propbdi
#define propagate_block_delete_libcall propblib
#define propagate_block_info propbinf
#define propagate_one_insn proponei
#define verify_wide_reg verwreg
#define verify_wide_reg_1 verwr1
#define const_binop conbin
#define const_binop_1 conbn1
#define fold_convert fconvt
#define fold_convert_1 fconv1
#define invert_tree_comparison invtcomp
#define invert_truthvalue invtvalue
#define operand_equal_for_comparison_p opeefcomp
#define operand_equal_p operep
#define optimize_bit_field_compare optbfc
#define optimize_minmax_comparison optmmcomp
#define size_int_type_wide szitw
#define size_int_wide szintw
#define assign_stack_local asstkloc
#define assign_stack_local_1 asstk1
#define assign_stack_temp asstkt
#define assign_stack_temp_for_type astft
#define expand_fixups expfxps
#define expand_function_end expfend
#define expand_function_start expfst
#define fixup_var_refs fixvr
#define fixup_var_refs_1 fixvr1
#define fixup_var_refs_insn fixvri
#define fixup_var_refs_insns fixvis
#define fixup_var_refs_insns_with_hash fixviwh
#define fixup_var_refs_queue fixvque
#define free_after_compilation faftcomp
#define free_after_parsing faftpar
#define free_temp_slots ftempsl
#define free_temps_for_rtl_expr ftmpforte
#define get_first_block_beg getfblbeg
#define get_first_nonparm_insn getfnonins
#define identify_blocks iblocks
#define identify_blocks_1 iblks1
#define init_function_for_compilation ifuncfor
#define init_function_once ifunconce
#define init_function_start ifuncstart
#define insns_for_mem_comp iformcmp
#define insns_for_mem_entry iforment
#define insns_for_mem_hash iformhash
#define insns_for_mem_newfunc iformnew
#define insns_for_mem_walk iformw
#define insns_for_mem_walk_i iforwi
#define insns_for_mem_walk_info iforwnfo
#define instantiate_decl instdecl
#define instantiate_decls instdcls
#define instantiate_decls_1 instd1
#define instantiate_new_reg instnreg
#define instantiate_virtual_regs instvregs
#define instantiate_virtual_regs_1 instv1
#define pop_function_context popfcon
#define pop_function_context_from popfcf
#define preserve_rtl_expr_result prsrer
#define preserve_temp_slots prstslots
#define push_function_context pushfc
#define push_function_context_to pushft
#define reorder_blocks reorb
#define reorder_blocks_0 reorb0
#define reorder_blocks_1 reorb1
#define reorder_fix_fragments reorff
#define setjmp_protect setjprot
#define setjmp_protect_args setjpa
#define validate_all_switches valalsw
#define validate_switches valswitch
#define validated valdtd
#define compute_ae_gen caegen
#define compute_ae_kill caekill
#define compute_available cavail
#define compute_can_copy ccancopy
#define compute_code_hoist_data ccodhdata
#define compute_code_hoist_vbeinout ccodhvbe
#define compute_cprop_data ccprdata
#define compute_expr_hash_table cexphtab
#define compute_hash_table chashtab
#define compute_kill_rd ckillrd
#define compute_ld_motion_mems cldmot
#define compute_local_properties clocprop
#define compute_pre_data cpredata
#define compute_rd cmpterd
#define compute_set_hash_table cmpsht
#define compute_sets cmptsets
#define compute_store_table cmpstore
#define compute_transp cmptransp
#define compute_transpout cmptpout
#define delete_null_pointer_checks delnpchk
#define delete_null_pointer_checks_1 delnp1
#define expr_reaches_here_p exprhere
#define expr_reaches_here_p_work exprpwrk
#define free_ldst_entry freelde
#define free_ldst_mems freelst
#define hash_expr hashexpr
#define hash_expr_1 hashx1
#define hash_scan_call hashsc
#define hash_scan_insn hashsi
#define hash_scan_set hashss
#define insert_insn_end_bb iiendbb
#define insert_insn_on_edge iionedge
#define insert_insn_start_bb iistart
#define insert_set_in_table iisetin
#define insert_store iistore
#define invalidate_any_buried_refs invanybr
#define invalidate_nonnull_info invnonnull
#define load_killed_in_block_p ldkilinblk
#define load_kills_store ldkillstore
#define pre_expr_reaches_here_p preexrh
#define pre_expr_reaches_here_p_work prexrhwork
#define record_last_mem_set_info rlmemset
#define record_last_reg_set_info rlregset
#define record_last_set_info rlsetinfo
#define store_killed_after sk_after
#define store_killed_before sk_before
#define store_killed_in_insn sk_ininsn
#define gen_rtx_fmt_ grf_
#define gen_rtx_fmt_0 grf_0
#define gen_rtx_fmt_0ww grf_0ww
#define gen_rtx_fmt_Ee grf_Ee
#define gen_rtx_fmt_Ei grf_Ei
#define gen_rtx_fmt_Ess grf_Es
#define gen_rtx_fmt_bi grf_bi
#define gen_rtx_fmt_eEee0 greE0
#define gen_rtx_fmt_eee greee
#define gen_rtx_fmt_eeeee greeee
#define gen_rtx_fmt_eit grfeit
#define gen_rtx_fmt_eti grfeti
#define gen_rtx_fmt_i grfi
#define gen_rtx_fmt_iE grfiE
#define gen_rtx_fmt_iiiiiiiitt grfiii
#define gen_rtx_fmt_is grfis
#define gen_rtx_fmt_isE grfisE
#define gen_rtx_fmt_iss grfiss
#define gen_rtx_fmt_iuu grfiuu
#define gen_rtx_fmt_iuueiee grfiee
#define gen_rtx_fmt_iuueiee0 grfie0
#define gen_rtx_fmt_iuueieee grfiei
#define gen_rtx_fmt_s grf_s
#define gen_rtx_fmt_sE grf_sE
#define gen_rtx_fmt_sEss grfsEs
#define gen_rtx_fmt_ss grfss
#define gen_rtx_fmt_sse grfsse
#define gen_rtx_fmt_ssiEEsi grfssi
#define gen_rtx_fmt_u00 grfu00
#define gen_rtx_fmt_uuEiiiiiibbii grfuuE
#define gen_rtx_fmt_uuuu grfuuu
#define ggc_add_deletable_htab gadel
#define ggc_add_root garoot
#define ggc_add_rtx_root gartxroot
#define ggc_add_rtx_varray_root garvr
#define ggc_add_tree_hash_table_root gatht
#define ggc_add_tree_root gatreer
#define ggc_add_tree_varray_root gatvar
#define ggc_mark_roots gm_roots
#define ggc_mark_rtvec_children gm_rtvec
#define ggc_mark_rtx_children gm_rchild
#define ggc_mark_rtx_children_1 gm_rc1
#define ggc_mark_rtx_ptr gm_rptr
#define ggc_mark_rtx_varray gm_rvarr
#define ggc_mark_rtx_varray_ptr gm_rvptr
#define ggc_mark_struct_function gm_stfunc
#define ggc_mark_tree_hash_table gm_thasht
#define ggc_mark_tree_hash_table_entry gmthte
#define ggc_mark_tree_hash_table_ptr gmthtp
#define ggc_mark_tree_ptr gmtrptr
#define ggc_mark_tree_varray gmtrvar
#define ggc_mark_tree_varray_ptr gmtvptr
#define ggc_mark_trees gmtrees
#define ggc_alloc ggcall
#define ggc_allocated_p ggcalp
#define set_page_group_in_use spginuse
#define set_page_table_entry sptabentr
#define mark_reg_clobber mr_clob
#define mark_reg_conflicts mr_conf
#define mark_reg_death mr_death
#define mark_reg_live_nc mr_livenc
#define mark_reg_store mr_store
#define hash_table htable
#define hash_table_free htabfree
#define hash_table_init htabinit
#define hash_table_init_n htabnn
#define hash_table_key htabkey
#define string_compare strcomp
#define string_copy strcopy
#define hook_void_bool_false hvboolf
#define hook_void_void hookvv
#define cond_exec_get_condition cegetcond
#define cond_exec_process_if_block cepifblk
#define cond_exec_process_insns ceprinsns
#define find_if_block fifblk
#define find_if_case_1 fifcs1
#define find_if_case_2 fifcs2
#define find_if_header fifhdr
#define noce_emit nocemit
#define noce_emit_cmove nocemcm
#define noce_emit_move_insn noceemi
#define noce_get_alt_condition nocegac
#define noce_get_condition nocegcond
#define noce_try_abs nocetabs
#define noce_try_cmove nocetcm
#define noce_try_cmove_arith nocetcmarith
#define noce_try_minmax nocetmin
#define noce_try_store_flag ntsflag
#define noce_try_store_flag_constants ntsfcons
#define noce_try_store_flag_inc ntsfinc
#define noce_try_store_flag_mask ntsfmask
#define gen_abssf2 gsf2
#define gen_abssi2 gsi2
#define gen_adddf3 gdf3
#define gen_adddi3 gadddi3
#define gen_addsf3 gsf3
#define gen_addsi3 gsi3
#define gen_ashldi3 gdi3
#define gen_ashlhi3 ghi3
#define gen_ashlqi3 gqi3
#define gen_ashlsi3 galsi3
#define gen_ashr gashr
#define gen_ashrhi3 gahi3
#define gen_ashrqi3 gaqi3
#define gen_ashrsi3 gasi3
#define gen_call gcall
#define gen_call_value gcallval
#define gen_cmpsf gcmpsf
#define gen_cmpsi gcmpsi
#define gen_cmpstrsi gcmpssi
#define gen_cmpstrsi_1 gcmsi1
#define gen_divsf3 gdivsf3
#define gen_divsi3 gdifsi3
#define gen_extendhisi2 gesi2
#define gen_extendqihi2 gehi2
#define gen_extendqisi2 geqi2
#define gen_extendsfdf2 gesf2
#define gen_extendsidi2 gesid2
#define gen_lshrdi3 gldi3
#define gen_lshrhi3 glhi3
#define gen_lshrqi3 glqi3
#define gen_lshrsi3 glsi3
#define gen_movdf gmovdf
#define gen_movdi gmovdi
#define gen_movsf gmovsf
#define gen_movsi gmovsi
#define gen_movstricthi gmovthi
#define gen_movstrictqi gmovqi
#define gen_movstrsi gmovtrsi
#define gen_movstrsi_1 gmovt1
#define gen_mulsf3 gmulsf3
#define gen_mulsi3 gmulsi3
#define gen_negsf2 gnegsf2
#define gen_negsi2 gnegsi2
#define gen_one_cmplhi2 gochi2
#define gen_one_cmplqi2 gocqi2
#define gen_one_cmplsi2 cocli2
#define gen_subsf3 gensf3
#define gen_truncdfsf2 gentsf2
#define gen_truncsihi2 genthi2
#define gen_tstdf gntsdf
#define gen_tstdi gntsdi
#define gen_tstsf gntssf
#define gen_tstsi gntssi
#define gen_zero_extendhisi2 gzsi2
#define gen_zero_extendqihi2 gzhi2
#define gen_zero_extendqisi2 gzqsi2
#define gen_zero_extendsidi2 gzei2
#define output_1 o_1
#define output_10 o_10
#define output_100 o_100
#define output_101 o_101
#define output_102 o_102
#define output_103 o_103
#define output_104 o_104
#define output_105 o_105
#define output_106 o_106
#define output_107 o_107
#define output_108 o_108
#define output_109 o_109
#define output_11 o_11
#define output_110 o_110
#define output_111 o_111
#define output_112 o_112
#define output_113 o_113
#define output_114 o_114
#define output_115 o_115
#define output_116 o_116
#define output_117 o_117
#define output_118 o_118
#define output_119 o_119
#define output_12 o_12
#define output_120 o_120
#define output_121 o_121
#define output_122 o_122
#define output_123 o_123
#define output_124 o_124
#define output_125 o_125
#define output_126 o_126
#define output_127 o_127
#define output_128 o_128
#define output_129 o_129
#define output_13 o_13
#define output_130 o_130
#define output_131 o_131
#define output_132 o_132
#define output_133 o_133
#define output_134 o_134
#define output_135 o_135
#define output_136 o_136
#define output_137 o_137
#define output_138 o_138
#define output_14 o_14
#define output_15 o_15
#define output_16 o_16
#define output_17 o_17
#define output_18 o_18
#define output_19 o_19
#define output_2 o_2
#define output_20 o_20
#define output_21 o_21
#define output_22 o_22
#define output_23 o_23
#define output_24 o_24
#define output_25 o_25
#define output_26 o_26
#define output_27 o_27
#define output_28 o_28
#define output_29 o_29
#define output_3 o_3
#define output_30 o_30
#define output_31 o_31
#define output_32 o_32
#define output_33 o_33
#define output_34 o_34
#define output_35 o_35
#define output_36 o_36
#define output_37 o_37
#define output_38 o_38
#define output_39 o_39
#define output_4 o_4
#define output_40 o_40
#define output_41 o_41
#define output_42 o_42
#define output_43 o_43
#define output_44 o_44
#define output_45 o_45
#define output_46 o_46
#define output_47 o_47
#define output_48 o_48
#define output_49 o_49
#define output_5 o_5
#define output_50 o_50
#define output_51 o_51
#define output_52 o_52
#define output_53 o_53
#define output_54 o_54
#define output_55 o_55
#define output_56 o_56
#define output_57 o_57
#define output_58 o_58
#define output_59 o_59
#define output_6 o_6
#define output_60 o_60
#define output_61 o_61
#define output_62 o_62
#define output_63 o_63
#define output_64 o_64
#define output_65 o_65
#define output_66 o_66
#define output_67 o_67
#define output_68 o_68
#define output_69 o_69
#define output_7 o_7
#define output_70 o_70
#define output_71 o_71
#define output_72 o_72
#define output_73 o_73
#define output_74 o_74
#define output_75 o_75
#define output_76 o_76
#define output_77 o_77
#define output_78 o_78
#define output_79 o_79
#define output_8 o_8
#define output_80 o_80
#define output_81 o_81
#define output_82 o_82
#define output_83 o_83
#define output_84 o_84
#define output_85 o_85
#define output_86 o_86
#define output_87 o_87
#define output_88 o_88
#define output_89 o_89
#define output_9 o_9
#define output_91 o_91
#define output_92 o_92
#define output_93 o_93
#define output_94 o_94
#define output_95 o_95
#define output_96 o_96
#define output_97 o_97
#define output_98 o_98
#define output_99 o_99
#define copy_insn_list cilist
#define copy_insn_notes cinotes
#define function_attribute_inlinable_p fainlin
#define function_begin_epilogue fbegepi
#define function_cannot_inline_p fcaninl
#define function_decl fdecl
#define function_end_prologue fendprol
#define function_epilogue fepil
#define function_prologue fprol
#define function_type_required ftypreq
#define get_hard_reg_initial_reg ghreinreg
#define get_hard_reg_initial_val ghrinival
#define integrate_decl_tree intdctree
#define integrate_parm_decls intprmdecl
#define set_block_abstract_flags stblkabs
#define set_block_origin_self stblkoself
#define set_decl_abstract_flags sdeclabs
#define set_decl_origin_self sdeclorig
#define condjump_in_parallel_p cjinpar
#define condjump_label cjlabel
#define condjump_p cjumpp
#define get_label_after glabaft
#define get_label_before glabbef
#define invert_exp invexp
#define invert_exp_1 invex1
#define invert_jump invjmp
#define invert_jump_1 invjp1
#define redirect_exp redexp
#define redirect_exp_1 redxp1
#define redirect_jump_1 redjp1
#define returnjump_p retjp
#define returnjump_p_1 retjp1
#define reverse_condition revcond
#define reversed_code revcod
#define reversed_comparison_code revcocode
#define reversed_comparison_code_parts revccpart
#define lhd_tree_dump_dump_tree lhdddtr
#define lhd_tree_dump_type_quals lhddtq
#define lhd_tree_inlining_end_inlining lhdtiei
#define lhd_tree_inlining_walk_subtrees lhtiws
#define lhd_tree_inlining_cannot_inline_tree_fn lhticit
#define lhd_tree_inlining_disregard_inline_limits lhtidin
#define lhd_tree_inlining_add_pending_fn_decls lhiapd
#define lhd_tree_inlining_tree_chain_matters_p lhtitcm
#define lhd_tree_inlining_auto_var_in_fn_p lhiavip
#define lhd_tree_inlining_copy_res_decl_for_inlining lhicrdi
#define lhd_tree_inlining_anon_aggr_type_p lhiaatp
#define lhd_tree_inlining_start_inlining lhtisi
#define lhd_tree_inlining_convert_parm_for_inlining lticpfi

#define compute_antinout_edge cantin
#define compute_earliest cearliest
#define compute_farthest cfarthest
#define compute_insert_delete cinsdel
#define compute_laterin clater
#define compute_nearerout cnearer
#define compute_rev_insert_delete crevidel
#define pre_edge_lcm prelcm
#define pre_edge_rev_lcm prerevlcm
#define free_EXPR_LIST_list fEXlist
#define free_EXPR_LIST_node fEXnode
#define free_INSN_LIST_list fINlist
#define free_INSN_LIST_node fINnode
#define equiv_init_movable_p eqmovp
#define equiv_init_varies_p eqvarp
#define qty_compare qtycmp
#define qty_compare_1 qtycp1
#define qty_sugg_compare qtyscmp
#define qty_sugg_compare_1 qtysc1
#define validate_equiv_mem valeqmem
#define validate_equiv_mem_from_store valemfs
#define validate_replace_rtx valrrtx
#define check_insn_for_bivs cinsbiv
#define check_insn_for_givs cinsgiv
#define combine_givs cgivs
#define combine_givs_p cgivsp
#define combine_givs_stats cgivss
#define combine_movables cmovable
#define consec_sets_giv cnsgiv
#define consec_sets_invariant_p cnsinvp
#define debug_iv_class divclas
#define debug_ivs divs
#define debug_loop dloop
#define debug_loops dloops
#define express_from expfrom
#define express_from_1 expfr1
#define get_condition gcond
#define get_condition_for_loop gcondfl
#define libcall_other_reg liboreg
#define loop_biv_dump lbivdump
#define loop_biv_eliminable_p lbivelp
#define loop_bivs_check lbivsc
#define loop_bivs_find lbivsf
#define loop_bivs_init_find lbivsif
#define loop_call_insn_emit_before lcieb
#define loop_call_insn_hoist lcih
#define loop_giv_dump lg_dump
#define loop_giv_reduce_benefit lg_redben
#define loop_givs_check lgs_check
#define loop_givs_dead_check lgs_dcheck
#define loop_givs_find lgs_find
#define loop_givs_reduce lgs_reduce
#define loop_givs_rescan lgs_rscan
#define loop_insn_callback li_callback
#define loop_insn_emit_after li_emaft
#define loop_insn_emit_before li_embef
#define loop_insn_first_p li_firstp
#define loop_insn_hoist li_hoist
#define loop_insn_sink li_sink
#define loop_insn_sink_or_swim li_sors
#define loop_iv_add_mult_emit_before li_ameb
#define loop_iv_add_mult_hoist li_amh
#define loop_iv_add_mult_sink li_ams
#define loop_iv_class_dump li_cldump
#define loop_ivs livs
#define loop_ivs_dump livsd
#define loop_ivs_free livsfree
#define loop_movables lmova
#define loop_movables_add lmovadd
#define loop_movables_free lmovfree
#define loop_reg loopreg
#define loop_reg_used_before_p lr_ubef
#define loop_regs lregs
#define loop_regs_scan lregscan
#define loop_regs_update lregsupd
#define maybe_eliminate_biv melbiv
#define maybe_eliminate_biv_1 melbv1
#define replace_label replabl
#define replace_loop_mem rl_mem
#define replace_loop_mems rlmems
#define replace_loop_reg rlreg
#define replace_loop_regs rlregs
#define replace_regs rregs
#define replace_rtx rplrtx
#define rtx_equal_for_loop_p rtxeflp
#define rtx_equal_for_prefetch_p rtxefpp
#define sge_plus sgepls
#define sge_plus_constant sgepcons
#define deps_add_default_target da_deft
#define deps_add_dep da_dep
#define deps_add_target da_target
#define emit_cmp_and_jump_insn_1 ecaji1
#define emit_cmp_and_jump_insns ecaji
#define emit_cmp_insn emcmpi
#define expand_cmplxdiv_straight ecstra
#define expand_cmplxdiv_wide ecwide
#define expand_complex_abs ecabs
#define expand_fix expfx
#define expand_float expfloat
#define expand_shift expshift
#define expand_simple_binop expsbin
#define expand_simple_unop expsunop
#define init_optab inoptb
#define init_optabs inptbs
#define init_optabv inptbv
#define prepare_cmp_insn prcmpinsn
#define prepare_float_lib prfloatlib
#define prepare_operand propernd
#define estimate_bb_frequencies ebbfreq
#define estimate_loops_at_level elatlev
#define estimate_probability eprobab
#define predict_edge predge
#define predict_edge_def predgdef
#define predict_insn predinsn
#define predict_insn_def pridef
#define print_node prnode
#define print_node_brief prnodbrief
#define __fetch_gcov_type __fgcovt
#define __fetch_long __flong
#define __write_gcov_type __wrgctyp
#define __write_long __wrlong
#define ereal_from_double erfdoub
#define ereal_from_float erffloat
#define ereal_from_int effint
#define ereal_from_uint effuint
#define ereal_to_decimal ertodec
#define ereal_to_int ertoint
#define ereal_unto_double eruntodb
#define ereal_unto_float eruntofl
#define target_isinf tgtisinf
#define target_isnan tgtisnan
#define constrain_operands cstoper
#define constrain_operands_cached cstocach
#define constraint cstrt
#define constraints cstrts
#define extract_constrain_insn_cached ecstrica
#define extract_insn einsn
#define extract_insn_cached einsnc
#define find_single_use fsuse
#define find_single_use_1 fsuse1
#define init_recog irecog
#define init_recog_no_volatile irecnov
#define offsettable_address_p offadd
#define offsettable_memref_p offmem
#define offsettable_nonstrict_memref_p offnsmem
#define split_all_insns spltains
#define split_all_insns_noflow spltnof
#define validate_change valchange
#define validate_replace_rtx_1 valrt1
#define validate_replace_rtx_group valrtg
#define validate_replace_rtx_subexp valrts
#define validate_replace_src valrsc
#define validate_replace_src_1 valrs1
#define validate_replace_src_data valrsd
#define init_reg_modes inregmo
#define init_reg_sets inregsets
#define init_reg_sets_1 inregs1
#define init_regs inregs
#define reg_scan rscan
#define reg_scan_mark_refs rscanmr
#define reg_scan_update rscanu
#define regclass rclass
#define regclass_init rclasinit
#define combine_stack_adjustments cstkadj
#define fixup_match_1 fmat1
#define fixup_match_2 fmat2
#define optimize_reg_copy_ orcpy_
#define optimize_reg_copy_1 orcpy1
#define optimize_reg_copy_2 orcpy2
#define copyprop_hardreg_forward chforw
#define copyprop_hardreg_forward_1 chfwd1
#define kill_value kilval
#define kill_value_regno kilvreg
#define replace_oldest_value_addr repovadd
#define replace_oldest_value_mem repovm
#define scan_rtx scrtx
#define scan_rtx_address scnradd
#define scan_rtx_reg scrreg
#define copy_replacements cpyr
#define copy_replacements_1 cpyr1
#define debug_reload dbgrel
#define debug_reload_to_stream dbgrtostr
#define find_reloads freloads
#define find_reloads_address freladd
#define find_reloads_address_1 frela1
#define find_reloads_address_part frelap
#define find_reloads_subreg_address frsubadd
#define find_reloads_toplev frtoplev
#define refers_to_mem_for_reload_p refmemr
#define refers_to_regno_for_reload_p refregr
#define choose_reload_regs chrere
#define choose_reload_regs_init chrerinit
#define delete_address_reloads delarel
#define delete_address_reloads_1 delar1
#define eliminate_regs elregs
#define eliminate_regs_in_insn elregii
#define elimination_effects eleffects
#define set_initial_elim_offsets setineo
#define set_initial_label_offsets setinloff
#define update_eliminable_offsets upeloff
#define update_eliminables upelim
#define _fatal_insn _fatins
#define _fatal_insn_not_found _fatnotf
#define computed_jump_p compjp
#define computed_jump_p_1 compj1
#define dead_or_set_p dedset
#define dead_or_set_regno_p detsreg
#define find_reg_equal_equiv_note fregeen
#define find_reg_fusage fregfus
#define find_reg_note fregnote
#define find_regno_fusage fregnfus
#define find_regno_note fregnono
#define insn_dependent_p insdepp
#define insn_dependent_p_1 insdp1
#define modified_between_p modbetwe
#define modified_in_p modinp
#define reg_referenced_between_p rrefbet
#define reg_referenced_p rrefp
#define reg_set_between_p regstbp
#define reg_set_last rsetlast
#define reg_set_p rsetp
#define remove_node_from_expr_list rmnfel
#define remove_note remnote
#define replace_dest repdest
#define rtx_addr_can_trap_p rtadcant
#define rtx_addr_varies_p rtadvarp
#define subreg_regno sregno
#define subreg_regno_off sregoff
#define volatile_insn_p volinsp
#define volatile_refs_p volrefp
#define dump_sbitmap dsbitm
#define dump_sbitmap_vector dsbitv
#define sbitmap_a_and_b sbaandb
#define sbitmap_a_and_b_or_c sbabc
#define sbitmap_a_or_b sbaorb
#define sbitmap_a_or_b_and_c sbaorbc
#define sbitmap_a_subset_b_p sasubbp
#define sbitmap_a_xor_b saxorb
#define sbitmap_alloc sballoc
#define sbitmap_copy sbcopy
#define sbitmap_difference sbdiff
#define sbitmap_equal sbequal
#define sbitmap_first_set_bit sbfsetbit
#define sbitmap_intersection_of_preds sbintpred
#define sbitmap_intersection_of_succs sbintsucc
#define sbitmap_last_set_bit sblastsb
#define sbitmap_not sbnot
#define sbitmap_ones sbones
#define sbitmap_ptr sbptr
#define sbitmap_union_of_diff sbundiff
#define sbitmap_union_of_preds sbunpreds
#define sbitmap_union_of_succs sbunsuccs
#define sbitmap_vector_alloc sbvalloc
#define sbitmap_vector_ones sbvones
#define sbitmap_vector_zero sbveczero
#define sbitmap_zero sbzero
#define simplify_binary_is2orm1 sbis2or1
#define simplify_binary_is2orm1_args sbi2args
#define simplify_binary_real sbreal
#define simplify_binary_real_args sbrargs
#define simplify_gen_binary sgbin
#define simplify_gen_relational sgrelat
#define simplify_gen_ternary sgtern
#define simplify_plus_minus spminus
#define simplify_plus_minus_op_data spminopdata
#define simplify_plus_minus_op_data_cmp spmopdat
#define simplify_replace_rtx sreprtx
#define simplify_unary_real sunarrl
#define simplify_unary_real_args sunrargs
#define defs_to_undefined deftound
#define defs_to_varying deftovary
#define ssa_ccp_substitute_constants ssaccp
#define inherently_necessary_register inreg
#define inherently_necessary_register_1 inreg1
#define inherently_necessary_set inset
#define inherently_necessary_set_p insetp
#define coalesce_if_unconflicting coalifu
#define coalesce_reg_in_phi coalrip
#define coalesce_regs_in_copies coalrc
#define compute_coalesced_reg_partition ccregp
#define compute_dominance_frontiers cdfront
#define compute_dominance_frontiers_1 cdfr1
#define convert_from_ssa cvtfrssa
#define convert_to_ssa cvttossa
#define find_evaluations feval
#define find_evaluations_1 feval1
#define insert_phi_node inphin
#define insert_phi_nodes inphns
#define rename_equivalent_regs reeqregs
#define rename_equivalent_regs_in_insn reeqrii
#define emit_jump emjmp
#define emit_jump_if_reachable ejifreach
#define expand_anon_union_decl eanonunion
#define expand_asm expasm
#define expand_asm_operands expasop
#define expand_assignment expassign
#define expand_cleanups expclean
#define expand_computed_goto expcgoto
#define expand_continue_loop expcoloop
#define expand_decl expdcl
#define expand_decl_cleanup xpdcleanup
#define expand_decl_cleanup_eh expdcleh
#define expand_decl_init expdinit
#define expand_elseif eeeeif
#define expand_end_bindings eebind
#define expand_end_case_dummy eecasdum
#define expand_end_case_type eecastype
#define expand_end_cond eecond
#define expand_end_loop exeloop
#define expand_end_null_loop eenullloop
#define expand_end_stmt_expr eestexpr
#define expand_end_target_temps eetarg
#define expand_exit_loop eeloop
#define expand_exit_loop_if_false eelopif
#define expand_exit_loop_top_cond eeloptc
#define expand_exit_something eesome
#define expand_expr_stmt eestmt
#define expand_expr_stmt_value eesval
#define expand_fixup expfup
#define expand_goto expgot
#define expand_goto_internal expgoi
#define expand_label explab
#define expand_loop_continue_here explconth
#define expand_nl_goto_receiver expgorec
#define expand_nl_goto_receivers expgorrs
#define expand_nl_handler_label exphndlab
#define expand_null_return expnret
#define expand_null_return_1 expnrt1
#define expand_start_bindings_and_block esbandb
#define expand_start_case escase
#define expand_start_case_dummy escsdum
#define expand_start_cond escond
#define expand_start_else eselse
#define expand_start_elseif eselif
#define expand_start_loop estloop
#define expand_start_loop_continue_elsewhere esloce
#define expand_start_target_temps estgtps

#define expand_start_null_loop esnuloop
#define expand_start_stmt_expr essexpr
#define expand_start_target_te estte
#define init_stmt istmt
#define init_stmt_for_function istforf
#define mark_case_nesting mcnest
#define mark_case_node mcnode
#define node_has_high_bound ndhashb
#define node_has_low_bound ndhaslb
#define pushcase pcase
#define pushcase_range pcasrang
#define resolve_operand_name_1 ropnm1
#define resolve_operand_names ropnms
#define finalize_record_size finrecsz
#define finalize_type_size fintypesz
#define mode_for_size modfrsize
#define mode_for_size_tree modfrtree
#define normalize_offset normoff
#define normalize_rli normrli
#define pos_from_bit pfrbit
#define pos_from_byte pfrbyt
#define put_pending_size pupsiz
#define put_pending_sizes pupszs
#define rli_size_so_far rlissof
#define rli_size_unit_so_far rlisusofar
#define get_identifier getident
#define get_identifier_with_length getiwl
#define mark_ident mrkident
#define mark_ident_hash mrkidhash
#define timevar_accumulate tvacc
#define timevar_def tvdef
#define timevar_get tvget
#define timevar_id_t tvidt
#define timevar_pop tvpop
#define timevar_print tvprint
#define timevar_push tvpush
#define timevar_stack_def tvstdef
#define timevar_start tfstart
#define timevar_stop tvstop
#define timevar_time_def tvtimedef
#define display_help disphlp
#define display_target_options disptgt
#define dump_flag dmpflg
#define dump_flag_name dmpflname
#define dump_string dmpstr
#define dump_string_field dmpstfield
#define queue_and_dump_index qanddind
#define queue_and_dump_type qanddtyp
#define copy_body cpybod
#define copy_body_r cpybdr
#define expand_call_inline expcinl
#define expand_calls_inline expclsinl
#define expand_constant expconst
#define walk_tree wlktree
#define walk_tree_fn wlktfn
#define walk_tree_without_duplicates wlktwd
#define attribute at_te
#define attribute_hash_list atthal
#define attribute_list_contained attlcont
#define attribute_spec atspec
#define attribute_table at_tab
#define attributes at_ts
#define build_common_tree_nodes bctnodes
#define build_common_tree_nodes_2 bctno2
#define build_complex bcomplex
#define build_decl bdecl
#define build_decl_attribute_variant bdeclav
#define build_index_2_type bi2type
#define build_index_type bindtyp
#define build_int_2_wide bint2wid
#define build_real breal
#define build_real_from_int_cst brfricst
#define build_real_from_int_cst_1 brfic1
#define build_reference_type breftype
#define build_type_attribute_variant bypatv
#define build_type_copy btypecp
#define build_type_no_quals btypnoqual
#define chain_member chmem
#define chain_member_purpose chmemp
#define chain_member_value chmemv
#define get_file_function_name getffn
#define get_file_function_name_long getfnl
#define get_set_constructor_bits getscb
#define get_set_constructor_bytes getsbytes
#define mark_tree_hashtable mthash
#define mark_tree_hashtable_entry mthase
#define simple_cst_equal scstequal
#define simple_cst_list_equal scstle
#define stabilize_reference stabref
#define stabilize_reference_1 stabrf1
#define tree_int_cst ticst
#define tree_int_cst_compare ticstcc
#define tree_int_cst_equal ticste
#define tree_int_cst_lt ticstlt
#define tree_int_cst_msb ticstmsb
#define tree_int_cst_sgn ticstsgn
#define unsave_expr unsexp
#define unsave_expr_1 unsxp1
#define unsave_expr_now unsxnow
#define unsave_expr_now_r unsxnr
#define find_splittable_givs fspltgivs
#define find_splittable_regs fspltregs
#define assemble_a assa
#define assemble_align assal
#define assemble_asm assasm
#define assemble_constant_align assca
#define assemble_end_function assef
#define assemble_external assext
#define assemble_external_libcall asselibc
#define assemble_global assglb
#define assemble_integer assint
#define assemble_integer_with_op asiwo
#define assemble_label asslab
#define assemble_name assname
#define assemble_real assreal
#define assemble_start_function asfunc
#define assemble_static_space asstsp
#define assemble_string assstr
#define assemble_trampoline_template astrtemp
#define assemble_variable assvar
#define assemble_vtable_entry assvtent
#define assemble_vtable_inherit assvinh
#define assemble_zeros asszero
#define assembler_name assrname
#define compare_constant cmpconst
#define compare_constant_1 cmpcs1
#define compare_constant_rtx cmpcrtx
#define decode_reg_name decrname
#define decode_rtx_const decrconst
#define default_assemble_integer defai
#define default_coff_asm_named_section defcans
#define default_elf_asm_named_section defeans
#define default_exception_section defesec
#define default_no_named_section defnonsec
#define default_pe_asm_named_section defpeasm
#define default_section_type_flags defsectyp
#define get_pool_constant gpconst
#define get_pool_constant_for_function gpcoforf
#define get_pool_constant_mark gpcmark
#define get_pool_mode gpmode
#define get_pool_mode_for_function gpmform
#define get_pool_offset gpoffs
#define get_pool_size gpsize
#define immed_real_const irlcnst
#define immed_real_const_1 irlc1
#define init_varasm_once ivaronce
#define init_varasm_status ivarstat
#define make_decl_one_only mdoneonly
#define make_decl_rtl mddclrtl
#define mark_const_hash_entry mchashe
#define mark_const_str_htab mcstrhtab
#define mark_const_str_htab_1 mcsht1
#define mark_constant mconst
#define mark_constant_pool mconsp
#define mark_constants mconss
#define mergeable_constant_section mergcs
#define mergeable_string_section mergss
#define named_section namsec
#define named_section_first_declaration namsfd
#define named_section_flags namsflag
#define output_addressed_constants oacnsts
#define output_after_function_constants oafcons
#define output_constant oconst
#define output_constant_def oconstdef
#define output_constant_def_contents ocnsdc
#define output_constant_pool oconspl
#define output_constructor oconsr
#define record_constant reccon
#define record_constant_1 reccn1
#define record_constant_rtx reccnrtx
#define basic_block_for_insn bbforin
#define basic_block_info bbinfo
#define cpp_include_defaults cpidefls
#define cpp_included cpincldd
#define current_nesting_level cnestlvl
#define current_function_has_exception_handlers cfhasxchdl
#define flag_dump_unnumbered flgdmpun
#define flag_dump_rtl_in_asm flgdrtl
#define flag_inline_trees flintrs
#define flag_inline_functions flinfncs
#define flag_noniso_default_format_attributes flnisodef
#define flag_non_call_exceptions flncalxcpt
#define flag_signed_bitfields flsbitf
#define flag_signed_char flschr
#define function_tail_eff_head ftailefh
#define function_types_compatible_p ftcompat
#define function_invariant_p finvarp
#define function_section fsectn
#define global_rtl glbrtl
#define global_regs glbrgs
#define immediate_operand imoperand
#define immediate_size_expand imszexp
#define incomplete_type_error inctyperr
#define incomplete_decl_finalize_hook incdecfinh
#define indirect_pool indpool
#define indirect_jump_in_function_p indjip
#define indirect_operand indopr
#define indirect_symref_ok indsym
#define inline_forbidden_p inlforbp
#define inline_function_decl inlfdecl
#define lang_expand_function_end lefend
#define lang_expand_expr leexpr
#define lang_mark_tree lmrktree
#define lang_mark_false_label_stack lmflselabst
#define max_reg_num mxrgnm
#define max_reg_before_loop mxrgbl
#define parse_in prsein
#define parse_include prsincl
#define parse_input_constraint prsicns
#define rtx_equal_for_memref_p reqfmem
#define rtx_equal_for_field_assignment_p reffass
#define rtx_equal_for_cselib_p refcselib
#define rtx_equal_function_value_matters refvmat
#define tail_recursion_label_p treclp
#define tail_recursion_label_list trllist
#define tail_recursion_args trecargs
#define warn_cast_qual wcqual
#define warn_cast_align wcalign
#define warn_deprecated_use wrndepus
#define warn_deprecated_decl wrnddecl
#define current_declspecs cfdspx
#define current_loop crntloop
#define current_funcdef_number crtfdnum
#define current_funcdef_fde cffde
#define current_function_has_inlines cfhasinl
#define current_line cline
#define current_file cfile
#define current_output_insn coutinsn
#define current_insn_predicate cripred
#define current_bb curbb
#define current_live_regs curlivregs
#define translate_options tr_options
#define translate_name tr_name
#define preprocess_constraints pp_constr
#define preprocessor_options pp_opts
#define merge_blocks_move_predecessor_nojumps merbmpn
#define merge_blocks_move_successor_nojumps merbmsn
#define combine_simplify_rtx cnsmprtx
#define combine_reserved_comparison_code cnrsvcc
#define notice_stack_pointer_modification_1 nstkpmd1
#define notice_stack_pointer_modification nstkpm
#define compute_iterated_dominance_frontiers citrdfr
#define compute_conservative_reg_partition ccnsrpart
#define control_dependent_block_to_edge_map_create cdbemcreate
#define control_dependent_block_to_edge_map_free cdbemfree
#define output_file_directive ofdirect
#define output_func_start_profiler ofstprof
#define output_function_exception_table ofxtable
#define _cpp_free_buff _cfbuff
#define _cpp_free_definition _cfdefn
#define _cpp_init_includes _cpiincl
#define _cpp_init_hashtable _cpihtab
#define _cpp_init_tokenrun _cpitoken
#define _cpp_pop_file_buffer _cpfbuff
#define _cpp_pop_buffer _cppbuff
#define _cpp_pop_context _cpcontext
#define address_cost adrcost
#define address_operand adroper
#define allocate_dynamic_stack_space aldynstks
#define allocate_initial_values alinval
#define allocate_reload_reg alrelreg
#define build_array_declarator bardecl
#define build_array_ref barref
#define build_array_type baratyp
#define build_compound_literal bcmplit
#define build_continue_stmt bcntstmt
#define build_external_ref bextref
#define build_expr_wfl bexwfl
#define build_function_call_expr bfcaexpr
#define build_function_call bfnccall
#define build_function_type bftype
#define build_indirect_ref bindcref
#define build_insn_chain binsnchn
#define build_stmt bldstmt
#define build_store_vectors bldstvecs
#define build_string bldstring
#define c_finish_while_stmt_cond cfinwhst
#define c_finish_case cfincase
#define check_for_loop_decls chkfldecls
#define check_for_label_ref chkflref
#define check_fold_consts chkfcnsts
#define check_for_full_enumeration_handling chkffeh
#define check_function_format chkfformat
#define cleanup_cfg clnpcfg
#define cleanup_subreg_operands clnpsoper
#define cleanup_barriers clnpbarr
#define combine_strings cmbstrngs
#define combine_pending_stack_adjustment_and_call cpsaac
#define combine_reversed_comparison_code crevccode
#define combine_temp_slots ctslots
#define combine_regs cmbregs
#define combine_predictions_for_insn cmprforins
#define combine_stack_adjustments_for_block cstadjfblk
#define combine_reloads cmbrlds
#define compare_from_rtx cmpfrtx
#define compare_blocks cmpblks
#define compare_tree_int ctreent
#define comparison_dominates_p cmdominsp
#define comparison_operator cmpoprt
#define compute_outgoing_frequencies ceofreq
#define compute_bb_for_insn cebforin
#define compute_alignments cmpalgn
#define compute_insns_for_mem cmpifmem
#define compute_luids celuids
#define compute_branch_probabilities cbprobab
#define compute_use_by_pseudos cusebyps
#define compute_record_mode cmprecmod
#define copy_rtx_if_shared cprtifshr
#define copy_rtx_and_substitute cprandsub
#define copy_rtx cpyrtx
#define cpp_defined cppdfnd
#define cpp_define cppdefin
#define debug_bitmap dbgbtmap
#define debug_biv dbgbiv
#define debug_regset dbregset
#define debug_real dbreal
#define debug_true_tree dtrtree
#define declare_parm_level dcplevl
#define declare_nonlocal_label dcnonll
#define declare_return_variable dcrvar
#define declare_weak dcweak
#define default_function_array_conversion dfarconv
#define default_eh_frame_section dfehsect
#define default_function_pro_epilogue dfprepil
#define default_stabs_asm_out_destructor dstbaod
#define expand_arg x_arg
#define expand_and x_and
#define expand_abs x_abs
#define expand_cond x_cond
#define expand_call x_call
#define expand_compound_operation x_compound
#define expand_inc x_inc
#define expand_increment x_incr
#define expand_inline_function x_inline
#define expand_tree_builtin x_tree_blt
#define expand_twoval_binop x_twoval
#define finish_enum f_enum
#define finish_eh_generation f_ehgener
#define finish_expr_for_function f_exprff
#define finish_fname_decls f_fnamed
#define finish_function f_function
#define finish_file f_file
#define finish_incomplete_decl f_incdecl
#define finish_init f_init
#define finish_struct f_struct
#define finish_stmt_tree f_s_tree
#define finish_spills f_spills
#define for_each_insn_in_loop f_e_iil
#define for_each_rtx f_e_rtx
#define for_each_successor_phi f_e_succ
#define gen_lowpart_for_combine g_l_f_c
#define gen_lowpart_if_possible g_l_i_p
#define get_frame_alias_set g_f_alias
#define get_frame_size g_f_size
#define get_func_frame_size g_f_f_size
#define get_func_hard_reg_initial_val g_f_h_reg
#define get_inner_reference g_i_ref
#define get_inner_array_type g_i_arr
#define get_insns g_ins
#define get_insn_template g_ins_t
#define get_insn_name g_insname
#define ggc_alloc_cleared g_allclr
#define ggc_alloc_string g_allstr
#define ggc_print_common_statistics g_prcmstat
#define ggc_print_statistics g_prstats
#define init_EXPR_INSN_LIST_cache i_ex_cache
#define initialize_argument_information i_arg_inf
#define initialize_uninitialized_subregs i_un_sub
#define initialize_for_inline i_for_inl
#define initialize_sizetypes i_sizety
#define initialize_inlined_parameters i_in_par
#define initializer_constant_valid_p i_consvalp
#define lookup_label lklabel
#define lookup_line lkline
#define make_tree mktre
#define make_tree_vec mktvec
#define mark_stmt_tree msttree
#define mark_stmt_status msstat
#define mark_varargs mvarargs
#define mark_varasm_status mvarasm
#define maybe_build_cleanup mbbclnup
#define maybe_building_objc_message_expr mbbobmexpr
#define next_insn nxtinsn
#define next_insn_in_loop nxtiil
#define next_insn_tests_no_inequality nxtitni
#define next_insn_no_annul nxtina
#define next_nonnote_insn nxtnon
#define next_nondeleted_insn nxtndel
#define optimize_bit_field optbfld
#define optimize_reg_copy_3 optrcpy3
#define optimize_sibling_and_tail_recursive_calls optstrc
#define optimize_unexecutable_edges optunxedge
#define optimize_tail_recursion opttrecurs
#define optimize_inline_calls oticalls
#define output_dependence oudep
#define output_deps oudeps
#define output_deferred_addressed_constants oudef
#define pedwarn_init pdwinit
#define print_rtl_with_bb prrtlwbb
#define print_rtl_graph_with_bb prrgwbb
#define readonly_fields_p rdofldsp
#define readonly_warning rdowarn
#define readonly_data_section rdodsec
#define real_value_truncate rvaltrunc
#define real_value_from_int_cst rvalfic
#define record_base_value rbvalue
#define record_builtin_type rbtype
#define record_biv rcdbiv
#define reg_overlap_mentioned_for_reload_p romfrp
#define reg_overlap_mentioned_p romp
#define regno_clobbered_at_setjmp regclatsj
#define regno_clobbered_p regclbd
#define reverse_comparison revcomp
#define reverse_condition_maybe_unordered revcndmu
#define safe_from_p sffrmp
#define safe_from_earlyclobber sfreclb
#define set_block sblock
#define set_block_levels sblevels
#define set_block_for_insn sbfinsn
#define shorten_compare shcmpre
#define shorten_branches shrtbranch
#define simplify_giv_expr smpgive
#define simplify_rtx sfyrtx
#define simplify_subtraction sfysubtr
#define subreg_realpart_p sr_rp_p
#define subreg_regno_offset sr_r_o
#define unsigned_condition unscond
#define variable_size varsize
#define variable_section varsec
#endif

/* unfortunately toplev.c doesn't compile with IFOX
   because there are more than 399 external references.
   To combat this problem, we merge all these flags
   into a single one.  Quite ugly indeed. */
/*#define USING_IFOX 1*/
#if USING_IFOX
#undef flag_test_coverage
#undef flag_branch_probabilities
#undef flag_reorder_blocks
#undef flag_rename_registers
#undef flag_cprop_registers
#undef flag_force_mem
#undef flag_force_addr
#undef flag_defer_pop
#undef flag_float_store
#undef flag_cse_follow_jumps
#undef flag_cse_skip_blocks
#undef flag_expensive_optimizations
#undef flag_thread_jumps
#undef flag_strength_reduce
#undef flag_unroll_loops
#undef flag_unroll_all_loops
#undef flag_prefetch_loop_arrays
#undef flag_move_all_movables
#undef flag_reduce_all_givs
#undef flag_regmove
#undef flag_writable_strings
#undef flag_no_function_cse
#undef flag_omit_frame_pointer
#undef flag_function_sections
#undef flag_data_sections
#undef flag_no_peephole
#undef flag_optimize_sibling_calls
#undef flag_complex_divide_method
#undef flag_volatile
#undef flag_volatile_global
#undef flag_volatile_static
#undef flag_syntax_only
#define flag_test_coverage flag_print_asm_name
#define flag_branch_probabilities flag_print_asm_name
#define flag_reorder_blocks flag_print_asm_name
#define flag_rename_registers flag_print_asm_name
#define flag_cprop_registers flag_print_asm_name
#define flag_force_mem flag_print_asm_name
#define flag_force_addr flag_print_asm_name
#define flag_defer_pop flag_print_asm_name
#define flag_float_store flag_print_asm_name
#define flag_cse_follow_jumps flag_print_asm_name
#define flag_cse_skip_blocks flag_print_asm_name
#define flag_expensive_optimizations flag_print_asm_name
#define flag_thread_jumps flag_print_asm_name
#define flag_strength_reduce flag_print_asm_name
#define flag_unroll_loops flag_print_asm_name
#define flag_unroll_all_loops flag_print_asm_name
#define flag_prefetch_loop_arrays flag_print_asm_name
#define flag_move_all_movables flag_print_asm_name
#define flag_reduce_all_givs flag_print_asm_name
#define flag_regmove flag_print_asm_name
#define flag_writable_strings flag_print_asm_name
#define flag_no_function_cse flag_print_asm_name
#define flag_omit_frame_pointer flag_print_asm_name
#define flag_function_sections flag_print_asm_name
#define flag_data_sections flag_print_asm_name
#define flag_no_peephole flag_print_asm_name
#define flag_optimize_sibling_calls flag_print_asm_name
#define flag_complex_divide_method flag_print_asm_name
#define flag_volatile flag_print_asm_name
#define flag_volatile_global flag_print_asm_name
#define flag_volatile_static flag_print_asm_name
#define flag_syntax_only flag_print_asm_name
#endif

#define IN_GCC 1

/* we define this in order to get consistent results
   regardless of whether using gcc or non-gcc compiler */
#define GCC_VERSION 0
#include "ansidecl.h"

#include "i370.h"
#include "defaults.h"

#include "auto-host.h"

/* Provide three core typedefs used by everything, if we are compiling
   GCC.  These used to be found in rtl.h and tree.h, but this is no
   longer practical.  Providing these here rather that system.h allows
   the typedefs to be used everywhere within GCC. */
#ifndef RTX_FORWARD
#define RTX_FORWARD 1
struct rtx_def;
typedef struct rtx_def *rtx;
struct rtvec_def;
typedef struct rtvec_def *rtvec;
union tree_node;
typedef union tree_node *tree;
#endif

#include "libiberty.h"

/* override some of libiberty's stuff with our own */
#ifdef __MVS__
#define make_temp_file(a) "DD:WORK"
#else
#define make_temp_file(a) tmpnam(NULL)
#endif
#define pwait(a,b,c) (0)

#ifndef POSIX
#define POSIX
#endif

#ifndef GENERATOR_FILE
/* insn-constants is empty on MVS */
#ifndef __MVS__
# include "insn-constants.h"
#endif
# include "insn-flags.h"
#endif

#include "system.h"

#include "machmode.h"
#include "real.h"

#define getpwd() ""

#endif /* BUILD_WINDOWS */
