#!/bin/sh

#
# Default definitions, change as needed.
#

#STEPLIB=HLA.SASMMOD1
#export STEPLIB

srcfile=
outfile="a.out"
ext=
debugflag=0
listflag=0
lstopt="NOLIST"

#use the XOBJECT line if you have PTF UQ43481 applied.

#asopts="NODECK,OBJECT,NOESD,NORLD,NOXREF,XOBJECT"
asopts="NODECK,OBJECT,NOESD,NORLD,NOXREF"

#echo Args: $@

#
# Ensure that we have something to do.
#

if [ "$1" = "" ]
then
   echo "usage: as [-a][-o filename] filename"
   exit 1
fi

#
# Process arguments.
#

arg_="$@ --"
#echo arg_="$arg_"
eval set -- "$arg_"

while [ $# -gt 0 ] 
do
   case "$1" in
   -- )   # end of options
      shift
      break
      ;;
   -D )
      debugflag=1
      shift
      ;;
   -a )
      lstopt="LIST(133)"
      listflag=1
      shift
      ;;
   -o )
      outfile=$2
      shift ; shift
      ;;
   -* )
      echo "Unsupported option $1"
      echo "usage: as [-a][-o filename] filename"
      exit 1
      ;;
   * )
      srcfile="$srcfile $1"
      x=`echo $1 | echofile | cut -f2 -d.`
      if [ "$x" = "s" ]
      then
         ext="$x"
      fi
      shift
      ;;
   esac
done

asopts="$asopts,$lstopt"

if [ $debugflag -eq 1 ]; then
   echo srcfile   = $srcfile
   echo outfile   = $outfile
   echo asopts    = $asopts
fi

#
# Process each file.
#

for file in $srcfile
do

   if [ ! -f $file ]
   then
      echo "as: File $file does not exist"
      exit 1
   fi

   # Isolate file components.

   cwd=`pwd` 
   if [ $debugflag -eq 1 ]; then
      echo cwd = $cwd
   fi
   dirname=`echo $file | echodir`
   if [ $debugflag -eq 1 ]; then
      echo srcdirname = $dirname
   fi
   filename=`echo $file | echofile | cut -f1 -d.`
   if [ $debugflag -eq 1 ]; then
      echo srcfilename = $filename
   fi
   if [ "$dirname" = "." ]; then
      fullsrc="$cwd/$filename"
   else
      fullsrc="$dirname/$filename"
   fi
   if [ $debugflag -eq 1 ]; then
      echo fullsrc = $fullsrc
   fi
   ext=`echo $file | echofile | cut -f2 -d.`
   if [ $debugflag -eq 1 ]; then
      echo srcext = $ext
   fi

   dirname=`echo $outfile | echodir`
   if [ $debugflag -eq 1 ]; then
      echo objdirname = $dirname
   fi
   filename=`echo $outfile | echofile`
   if [ $debugflag -eq 1 ]; then
      echo objfilename = $filename
   fi
   if [ "$dirname" = "." ]; then
      fullobj="$cwd/$filename"
   else
      fullobj="$outfile"
   fi
   if [ $debugflag -eq 1 ]; then
      echo fullobj = $fullobj
   fi


   # Process file based on extension.

   case "$ext" in
   390 | asm | s )
      rm -f $fullobj $fullsrc.lst
      expand $file | trunc80 | fix80 >$fullsrc.asf
      as2 $fullsrc.asf \
	  $fullobj \
	  $fullsrc.lsf \
	  $asopts
      rc=$?
      rm -f $fullsrc.asf 
      if [ -f $fullsrc.lsf ]
      then
	 if [ $listflag -eq 1 ]; then
	    lstods <$fullsrc.lsf >$fullsrc.lst
	 fi
	 rm -f $fullsrc.lsf
      fi
      if [ $rc -gt 4 ]
      then
	 echo "as: Assembly failed"
	 rm -f $fullobj
	 exit 1
      fi
      chmod 644 $fullobj
      ;;
   * )
      echo "as: File $file assembly not supported"
      exit 1
      ;;
   esac

done

