/***********************************************************************
* ld - Linker shim. This program acts as the "ld" command on UNIX.
***********************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define NORMAL 0
#define ABORT  12

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define LD_CMD "/bin/cc -g"
#define LD_OUTOPT " -o "
#define TEMPSPEC "ldXXXXXX"
#define MAXARGS 50
#define MAPSIZE 80


/***********************************************************************
* Main procedure
***********************************************************************/

int
main (int argc, char *argv[])
{
   char *newoptv[MAXARGS];
   char *newobjv[MAXARGS];
   char *newlibv[MAXARGS];
   char *command;
   char *outfile;
   char *bp;
   int commandlen;
   int needgccmain;
   int newoptc;
   int newobjc;
   int newlibc;
   int mapmode;
   int i;
   int status;
   char mkname[32];
   char mapname[MAPSIZE];
   char mapoption[MAPSIZE];
   char *gccmain = "/usr/local/lib/gccmain.o";
  
#ifdef DEBUG
   fprintf (stderr, "ld: Entered\n");
#endif

   if (argc == 1)
   {
      fprintf (stderr, "usage: ld -o outfile objfile... \n");
      fprintf (stderr, "          [-m] [-Lsearchdir] [-larchive]\n");
      exit (1);
   }

   for (i = 0; i < MAXARGS; i++)
   {
      newoptv[i] = NULL;
      newobjv[i] = NULL;
      newlibv[i] = NULL;
   }

   newoptc = 0;
   newobjc = 0;
   newlibc = 0;
   commandlen = MAPSIZE + strlen(LD_CMD) + strlen(LD_OUTOPT);
   mapmode = FALSE;
   outfile = NULL;
   needgccmain = TRUE;
   for (i = 1; i < argc; i++)
   {
      bp = argv[i];

      if (*bp == '-')
      {
         bp++;
         switch (*bp)
         {
         case 'l':
            if (strcmp (bp, "lc") && strcmp (bp, "lgcc"))
            {
	       newlibv[newlibc] = argv[i];
	       commandlen += strlen(argv[i]) + 1;
	       newlibc++;
            }
            break;

         case 'm':
	    mapmode = TRUE;
	    strcpy (mkname, TEMPSPEC);
	    if ((bp = (char *)mktemp (mkname)) == NULL)
	    {
	       perror ("ld: Can't mktemp");
	       return (ABORT);
	    }

	    sprintf (mapname, "/tmp/%s.m", bp);
	    sprintf (mapoption, " -V >%s", mapname);
            break;

         case 'o':
            i++;
            outfile = argv[i];
	    commandlen += strlen(argv[i]) + 1;
            break;

         default:
            newoptv[newoptc] = argv[i];
	    commandlen += strlen(argv[i]) + 1;
            newoptc++;
         }
      }

      else
      {
         if (!strcmp (argv[i], "crt0.o"))
         {
	    newobjv[newobjc] = gccmain;
	    commandlen += strlen(gccmain) + 1;
	    needgccmain = FALSE;
         }
         else if (!strcmp (argv[i], gccmain))
         {
	    newobjv[newobjc] = argv[i];
	    commandlen += strlen(argv[i]) + 1;
	    needgccmain = FALSE;
         }
         else
         {
	    newobjv[newobjc] = argv[i];
	    commandlen += strlen(argv[i]) + 1;
         }
	 newobjc++;
	 if (newobjc >= MAXARGS)
	 {
	    fprintf (stderr, "ld: obj MAXARGS exceeded\n");
	    exit (1);
	 }
      }

   }

   if (needgccmain)
   {
      commandlen += strlen(gccmain) + 1;
   }

   if ((command = malloc (commandlen)) == NULL)
   {
      fprintf (stderr, "ld: Can't allocate command buffer\n");
      exit (1);
   }
   strcpy (command, LD_CMD);

   if (outfile)
   {
      strcat (command, LD_OUTOPT);
      strcat (command, outfile);
   }

   for (i = 0; i < newoptc; i++)
   {
      strcat (command, " ");
      strcat (command, newoptv[i]);
   }

   if (needgccmain)
   {
      strcat (command, " ");
      strcat (command, gccmain);
   }

   for (i = 0; i < newobjc; i++)
   {
      strcat (command, " ");
      strcat (command, newobjv[i]);
   }

   for (i = 0; i < newlibc; i++)
   {
      strcat (command, " ");
      strcat (command, newlibv[i]);
   }

   if (mapmode)
   {
      strcat (command, mapoption);
   }

#ifdef DEBUG
   fprintf (stderr, "ld: command = %s\n", command);
#endif

   status = system (command);
#ifdef DEBUG
   fprintf (stderr, "system: command: status = %d\n", status);
#endif

   if (mapmode)
   {
      FILE *fd;
      FILE *ofd = stdout;
      char buff[256];

      if ((fd = fopen (mapname, "r")) == NULL)
      {
         perror ("ld: Can't open temp listing");
	 return (ABORT);
      }

      strcpy (buff, outfile);
      strcat (buff, ".map");
      if ((ofd = fopen (buff, "w")) == NULL)
      {
	 perror ("Can't open listing");
	 return (ABORT);
      }

      while (fgets (buff, sizeof (buff), fd) != NULL)
      {
	 if (buff[0] == '1')
	 {
	    fputc ('\f', ofd);
	 }
	 fputs (&buff[1], ofd);
      }
      if (ofd != stdout) fclose (ofd);
      fclose (fd);
      unlink (mapname);
   }

   exit (status);
}

