#!/bin/sh

#
# Default definitions, change as needed.
#

#STEPLIB=SYS1.LINKLIB
#export STEPLIB

UTILDIR=/usr/local

objfile=
outfile="a.out"
libs=
libdirs=
debugflag=0
listflag=0
lstopt="NOLIST,NOMAP,NOXREF"

#echo Args: $@

#
# Ensure that we have something to do.
#

if [ "$1" = "" ]
then
   echo "usage: ld [-m][-o filename] filename... [-llib][-Ldir]"
   exit 1
fi

echo "  MODE AMODE(31),RMODE(ANY)" >/tmp/ld$PPID.lin
echo "  INCLUDE '$UTILDIR/lib/gccmain.o'" >>/tmp/ld$PPID.lin

#
# Process arguments.
#

arg_="$@ --"
#echo arg_="$arg_"
eval set -- "$arg_"

while [ $# -gt 0 ] 
do
   case "$1" in
   -- )   # end of options
      shift
      break
      ;;
   -D )
      debugflag=1
      shift
      ;;
   -m )
      lstopt="LIST,MAP,NOXREF"
      listflag=1
      shift
      ;;
   -o )
      outfile=$2
      shift ; shift
      ;;
   -L* )
      libdir=`echo $1 | cut -c3-255`
      libdirs="$libdirs $libdir"
      shift
      ;;
   -l* )
      lib=`echo $1 | cut -c3-255`
      libs="$libs $lib"
      shift
      ;;
   -* )
      echo "Unsupported option $1"
      echo "usage: ld [-m][-o filename] filename... [-llib][-Ldir]"
      exit 1
      ;;
   * )
      if [ ! -f $1 ]
      then
	 echo "ld: File $1 does not exist"
	 exit 1
      fi
      f=`echo $1 | echofile`
      if [ "$f" != "gccmain.o" ]
      then
	 x=`echo $f | cut -f2 -d.`
	 if [ "$x" = "o" ]
	 then
	    case "$1" in
	    /* | .* )
	       echo "  INCLUDE '$1'" >>/tmp/ld$PPID.lin
	       ;;
	    *)
	       echo "  INCLUDE './$1'" >>/tmp/ld$PPID.lin
	       ;;
	    esac
	 else
	    echo "ld: File $1 linking not supported"
	    exit 1
	 fi
      fi
      shift
      ;;
   esac
done

if [ $debugflag -eq 1 ]; then
   echo outfile   = $outfile
   echo lstopt    = $lstopt
   echo libdirs   = $libdirs
   echo libs      = $libs
fi

#
# Process each lib and ensure it exists.
#

for libdir in $libdirs
do
   for lib in $libs
   do
      if [ -f $libdir/lib$lib.a ]
      then
	       echo "  AUTOCALL '$libdir/lib$lib.a'" >>/tmp/ld$PPID.lin
      fi
   done
done

#
# Do the link.
#

cwd=`pwd` 
if [ $debugflag -eq 1 ]; then
   echo cwd = $cwd
fi
dirname=`echo $outfile | echodir`
if [ $debugflag -eq 1 ]; then
   echo outdirname = $dirname
fi
filename=`echo $outfile | echofile`
if [ $debugflag -eq 1 ]; then
   echo outfilename = $filename
fi
if [ "$dirname" = "." ]; then
   fullout="$cwd/$filename"
else
   fullout="$dirname/$filename"
fi
if [ $debugflag -eq 1 ]; then
   echo fullout = $fullout
fi

rm -f $fullout $fullout.map
cat /tmp/ld$PPID.lin | fix80 >/tmp/ld$PPID.lsf

ld2 /tmp/ld$PPID.lsf \
   $fullout \
   /tmp/ld$PPID.msf \
   $lstopt
rc=$?

rm -f /tmp/ld$PPID.lsf /tmp/ld$PPID.lin
if [ $listflag -eq 1 ]; then
   ver=`uname -v`
   case "$ver" in
      03)
        lstopt=-l121
	;;
      *)
        lstopt=-r
	;;
   esac
   lstods $lstopt </tmp/ld$PPID.msf >$fullout.map
fi
rm -f /tmp/ld$PPID.msf

if [ $rc -gt 4 ]
then
   echo "ld: link failed"
   rm -f $fullout
   exit 1
fi
chmod 755 $fullout
exit 0

