/***************************************************************************
*
* lstods - List ouput dataset copies fixed record output into a UNIX file
*          with conversion of ANSI controls.
*
* Changes:
*      11/19/98   DGP   Original
*      07/27/99   DGP   Added options
*
***************************************************************************/

#include <stdio.h>
#include <ctype.h>

#define LINELENGTH 133

static char usage[] = "\
usage: lstods [options]\n\
   -ln      Line length\n\
   -r       Record structured\n\
   -sn      Start position\n\
";

main (int argc, char **argv)
{
   int ndx;
   int length = LINELENGTH;
   int start = 1;
   int records = 0;
   char buf[LINELENGTH + 4];

   for (ndx = 1; ndx < argc; ndx++)
   {
      if (*argv[ndx] == '-')
      {
	 argv[ndx]++;
	 switch (*argv[ndx])
	 {
	 case 'l':		/* line Length */
	    argv[ndx]++;
	    length = atoi (argv[ndx]);
	    if (length < 0)
	    {
	       fprintf (stderr,
			"Invalid line length\n");
	       goto USAGE;
	    }
	    break;
	 case 'r':		/* Record structured */
	    records = 1;
	    break;
	 case 's':		/* start position */
	    argv[ndx]++;
	    start = atoi (argv[ndx]);
	    if (length < 0)
	    {
	       fprintf (stderr,
			"Invalid start position\n");
	       goto USAGE;
	    }
	    break;
	 default:
	    fprintf (stderr,
		     "Invalid Option selection '%c'\n",
		     *argv[ndx]);
	    goto USAGE;
	 }			/* of option switch */
      }
      else
      {
      USAGE:
	 fprintf (stderr,
		  usage);
	 exit (12);
      }
   }

   while (1)
   {
      int i;
      int j;

      if (records)
      {
         if (fgets (buf,
		    length,
		    stdin) == NULL)
         {
	    break;
	 }
	 i = strlen (buf) - 1;
      }
      else
      {
	 if (fread (buf,
		    1,
		    length,
		    stdin) != length)
         {
	    break;
	 }
	 i = length;
      }

      j = start;

      if (start > 0) switch (buf[0])
      {
      case '1':
	fputc ('\f',
	       stdout);
	break;
      case '-':
	fputc ('\n',
	       stdout);
	fputc ('\n',
	       stdout);
	fputc ('\n',
	       stdout);
      case '0':
	fputc ('\n',
	       stdout);
	fputc ('\n',
	       stdout);
	break;
      case '+':
	fputc ('\r',
	       stdout);
	break;
      default: ;
      }

      while (--i > j)
      {
	 if (buf[i] != ' ')
	 {
	     i++;
	     break;
	 }
      }
      buf[i++] = '\n';
      buf[i] = '\0';
      fputs (&buf[j],
	    stdout);
   }
}
