/***************************************************************************
*
* trim - Trims tailing blanks from the input file.
*
* Changes:
*      07/28/99   DGP   Original
*
***************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>

int
main (int argc, char **argv)
{
   FILE	*ifd, *ofd;
   int i;
   char	ibuffer[BUFSIZ];

   if (argc > 3)
   {
      fprintf (stderr,
	       "usage: trim [ifile [ofile]]\n");
      exit (1);
   }

   if (argc == 1)
   {
      ifd = stdin;
      ofd = stdout;
   }
   else
   {
      if ((ifd = fopen (argv[1],
			"r")) == NULL)
      {
	 fprintf (stderr,
		  "Can't open input file: %s:",
		  argv[1]);
	 perror ("");
	 exit (1);
      }

      if (argc == 3)
      {
	 if ((ofd = fopen (argv[2],
			   "w")) == NULL)
	 {
	    fprintf (stderr,
		     "Can't open output file: %s:",
		     argv[2]);
	    perror ("");
	    fclose (ifd);
	    exit (1);
	 }
      }
      else
      {
	 ofd = stdout;
      }
   }


   while (1)
   {
      memset (ibuffer,
	      ' ',
	      BUFSIZ);
      if (!fgets (ibuffer,
	          BUFSIZ,
		  ifd))
      {
	 break;
      }
      for (i = strlen (ibuffer) - 1;
	   i && isspace (ibuffer[i]);
	   i--) ;
      ibuffer[++i] = '\n';
      ibuffer[++i] = '\0';
      fputs (ibuffer,
	     ofd);
   }

   if (ifd != stdin)
   {
      fclose (ifd);
   }
   if (ofd != stdout)
   {
      fclose (ofd);
   }

}
