#ifndef __STDARG_H__
#define __STDARG_H__

#ifndef __psizeof
    /* cast: pointer to function returning type         */
    /* sizeof is asked for the size of the return type! */
#define __psizeof(type) \
      (sizeof (   (* (type (*)()) 0 )() )   )
#endif

#ifndef __nextword
    /* Given a pointer, move it to the next word boundary. This */
    /* trick works by moving just past the word boundary of     */
    /* interest, and then knocking off the bottom two bits.     */
#define __nextword(base)      (((unsigned)(base)+3)&~(3))
#endif

#define __CURR  0
#define __NEXT  1
#ifndef __valist
#define __valist 1
     typedef char *___valist[2];
#endif
#define va_list ___valist

  /* va_list is an array of two pointers to char                   */
  /* the first, __CURR, is initialized to the address              */
  /* of the identified parameter, and the second, __NEXT, is the   */
  /* address in __CURR plus the sizeof the parameter represented   */
  /* by __CURR. Essentially, __NEXT points just past __CURR.       */
#define va_start(ap, arg) \
    (void)( \
      (ap)[__CURR] = (char *)&(arg), \
      (ap)[__NEXT] = (ap)[__CURR] + sizeof (arg) \
    )

  /* Although __NEXT points just past __CURR, it may need to be    */
  /* adjusted to account for alignment constraints. __nextword does */
  /* any adjustments needed, and the adjusted value is the new     */
  /* value of __CURR. __NEXT is then again move just past __CURR,  */
  /* and the value in __CURR is returned.                          */
#define va_arg(ap, type) \
    ( \
      (ap)[__CURR] = (char *) __nextword((ap)[__NEXT]), \
      (ap)[__NEXT] = (ap)[__CURR] + __psizeof(type), \
      *(type *)(ap)[__CURR]\
    )

#define va_end(ap) \
      (void)((ap)[__CURR] = (char *)0, (ap)[__NEXT] = (char *)0)

#endif
