/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the, 1992 Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

/*
 *	POSIX Standard: 2.6 Primitive System Data Types	<sys/types.h>
 */

#ifndef	_SYS_TYPES_H

#define	_SYS_TYPES_H	1
#include <features.h>

__BEGIN_DECLS

#include <gnu/types.h>

#ifdef	__USE_BSD
#if !defined(__ushort)
#define __ushort         1
#define ushort __u_short_type
#endif
#if !defined(__ulong)
#define __ulong    1
#define ulong __u_long_type
#endif

#if !defined(__u_char)
#define __u_char    1
#define u_char __u_char_type
#endif
#if !defined(__u_short)
#define __u_short   1
#define u_short __u_short_type
#endif
#ifndef __u_int
#define __u_int 1
#define u_int __u_int_type
#endif
#if !defined(__u_long)
#define __u_long    1
#define u_long __u_long_type
#endif
#define quad __quad
#define u_quad __u_quad
#define	fsid_t __fsid_type
#endif

#define dev_t __dev_type
#ifndef __gid_t
#define __gid_t 1
#define gid_t __gid_type
#endif
#define ino_t __ino_type
#define mode_t __mode_type
#define nlink_t __nlink_type
#define off_t __off_type
#define pid_t __pid_type
#ifndef __uid_t
#define __uid_t 1
#define uid_t __uid_type
#endif
#ifndef	ssize_t
#define	ssize_t	__ssize_type
#endif

#ifdef	__USE_BSD
#define daddr_t __daddr_type
#if !defined(__caddr_t)                                                     
#define __caddr_t        1                                               
#define caddr_t __caddr_type
#endif
#endif

#ifndef __fd_set_type
#define __fd_set_type  1
#define fd_set __fd_set 
#endif

#define	__need_time_t
#include <time.h>

#define	__need_size_t
#include <stddef.h>

#if defined(__openedition__)
#if !defined(__sigset_t)
#define __sigset_t 1
typedef struct {
   unsigned long  __sigs_0;
   unsigned long  __sigs_1;
} sigset_t ;
#endif
/* OS390 2.8 stuff */
#if !defined(__osenv_token_t)
#define __osenv_token_t 1
typedef struct {
   char __[8];
} __osenv_token;
#endif
#if !defined(__pthread_rwlockattr_t)
#define __pthread_rwlockattr_t  1
typedef struct {
   char __[4];
} pthread_rwlockattr_t;
#endif
#if !defined(__pthread_rwlock_t)
#define __pthread_rwlock_t 1
typedef struct {
   char __[4];
} pthread_rwlock_t;
#endif
/* END 2.8 stuff */
#if !defined(__mcontext_t)
#define __mcontext_t 1
typedef int mcontext_t[40];
#endif
#if !defined(__caddr_t)                                                     
#define __caddr_t        1                                               
#define caddr_t __caddr_type
#endif                                                                      
#ifndef __i_addr
#define __i_addr    1
typedef unsigned long in_addr_t;
typedef in_addr_t ip_addr_t;
#endif
#ifndef __clock_t
#define __clock_t    1
#define clock_t __clock_type
#endif
#ifndef __key_t
#define __key_t   1
typedef long key_t;
#endif

#ifndef __pthread_t
#define __pthread_t  1
typedef struct {
	  char __[8];
} pthread_t;
#endif
#ifndef __pthread_attr_t
#define __pthread_attr_t  1
typedef  struct {
	  char __[88];
} pthread_attr_t;
#endif
#ifndef __pthread_mutex_t
#define __pthread_mutex_t  1
typedef struct {
	 char __[4];
} pthread_mutex_t;
#endif
#ifndef __pthread_mutexattr_t
#define __pthread_mutexattr_t  1
typedef struct {
	 char __[4];
} pthread_mutexattr_t;
#endif
#ifndef __pthread_cond_t
#define __pthread_cond_t  1
typedef struct {
	 char __[4];
}  pthread_cond_t;
#endif
#ifndef __pthread_condattr_t
#define __pthread_condattr_t  1
typedef struct {
	 char __[4];
} pthread_condattr_t;
#endif
#ifndef __pthread_key_t
#define __pthread_key_t  1
typedef struct {
	 char __[4];
} pthread_key_t;
#endif
#ifndef __pthread_once_t
#define __pthread_once_t  1
typedef int pthread_once_t;
#endif

#if !defined(__id_t)
#define __id_t  1
typedef int id_t;
#endif

#if !defined(__mtm_t)
#define __mtm_t 1
typedef unsigned int mtm_t;
#endif

#endif

#ifdef	__USE_BSD

#define	FD_SETSIZE	__FD_SETSIZE
#define	FD_ZERO(set)	__FD_ZERO(set)
#define	FD_SET(d, set)	__FD_SET((d), (set))
#define	FD_CLR(d, set)	__FD_CLR((d), (set))
#define	FD_ISSET(d, set)__FD_ISSET((d), (set))

/* This being here makes the `select' prototype valid whether or not
   we have already included <sys/time.h> to define `struct timeval'.  */
struct timeval;

/* Check the first NFDS descriptors each in READFDS (if not NULL) for read
   readiness, in WRITEFDS (if not NULL) for write readiness, and in EXCEPTFDS
   (if not NULL) for exceptional conditions.  If TIMEOUT is not NULL, time out
   after waiting the interval specified therein.  Returns the number of ready
   descriptors, or -1 for errors.  */
extern int __select __P ((int __nfds, __fd_set *__readfds,
			  __fd_set *__writefds, __fd_set *__exceptfds,
			  struct timeval *__timeout));
extern int select __P ((int __nfds, __fd_set *__readfds,
			__fd_set *__writefds, __fd_set *__exceptfds,
			struct timeval *__timeout));

#endif /* Use BSD.  */


__END_DECLS

#endif /* sys/types.h */
