/***************************************************************************
*
* A2E - ASCII to EBCDIC conversion utility.
*
* Usage:
*
*    a2e [-p] [-] [filename]
*
* Where:
*	-p	 = Specifies padding output records to 80 bytes.
*       - 	 = Specifies to read stdin. This is to allow options.
*	filename = Specifies the file to be processed.
*
* If no arguments are given; the default is to read from stdin and
* write to stdout without padding.
*
***************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define LINE_MAX 80

/*
** ASCII to EBCDIC conversion table. 
*/

static unsigned char ascebc[256] =
{
 /*00  NL    SH    SX    EX    ET    NQ    AK    BL */
      0x00, 0x01, 0x02, 0x03, 0x37, 0x2D, 0x2E, 0x2F,
 /*08  BS    HT    LF    VT    FF    CR    SO    SI */
      0x16, 0x05, 0x15, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
 /*10  DL    D1    D2    D3    D4    NK    SN    EB */
      0x10, 0x11, 0x12, 0x13, 0x3C, 0x3D, 0x32, 0x26,
 /*18  CN    EM    SB    EC    FS    GS    RS    US */
      0x18, 0x19, 0x3F, 0x27, 0x1C, 0x1D, 0x1E, 0x1F,
 /*20  SP     !     "     #     $     %     &     ' */
      0x40, 0x5A, 0x7F, 0x7B, 0x5B, 0x6C, 0x50, 0x7D,
 /*28   (     )     *     +     ,     -    .      / */
      0x4D, 0x5D, 0x5C, 0x4E, 0x6B, 0x60, 0x4B, 0x61,
 /*30   0     1     2     3     4     5     6     7 */
      0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7,
 /*38   8     9     :     ;     <     =     >     ? */
      0xF8, 0xF9, 0x7A, 0x5E, 0x4C, 0x7E, 0x6E, 0x6F,
 /*40   @     A     B     C     D     E     F     G */
      0x7C, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7,
 /*48   H     I     J     K     L     M     N     O */
      0xC8, 0xC9, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6,
 /*50   P     Q     R     S     T     U     V     W */
      0xD7, 0xD8, 0xD9, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6,
 /*58   X     Y     Z     [     \     ]     ^     _ */
      0xE7, 0xE8, 0xE9, 0xAD, 0xE0, 0xBD, 0x5F, 0x6D,
 /*60   `     a     b     c     d     e     f     g */
      0x79, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
 /*68   h     i     j     k     l     m     n     o */
      0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,
 /*70   p     q     r     s     t     u     v     w */
      0x97, 0x98, 0x99, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6,
 /*78   x     y     z     {     |     }     ~    DL */
      0xA7, 0xA8, 0xA9, 0xC0, 0x4F, 0xD0, 0xA1, 0x07,
 /*80                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*88                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*90                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*98                   CENT                        */
      0x6F, 0x6F, 0x6F, 0x4A, 0x6F, 0x6F, 0x6F, 0x6F,
 /*A0                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*A8                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*B0                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*B8                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*C0                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*C8                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*D0                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*D8                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*E0                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*E8                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*F0                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F,
 /*F8                                               */
      0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0x6F, 0xFF
};

static int
convert (FILE *ifd, int pad)
{
   int col = 0;
   int c;

   while ((c = fgetc (ifd)) >= 0)
   {
      if (pad)
      {
         if (c == '\n')
	 {
	    for (c = col; c < LINE_MAX; c++)
	       fputc (ascebc[' '], stdout);
	    col = 0;
	 }
	 else
	 {
	    col++;
	    if (col < LINE_MAX)
	       fputc (ascebc[c & 0xFF], stdout);
	    else
	    {
	       while ((c = fgetc (ifd)) != '\n') ;
	       col = 0;
	    }
	 }
      }
      else
	 fputc (ascebc[c & 0xFF], stdout);
   }
}

main (int argc, char *argv[])
{
   int pad = 0;
   int i;
   FILE	*ifd;

   if (argc == 1)
   {
      convert (stdin, pad);
   }
   else
   {
      for (i = 1; i < argc; i++)
      {
         if (*argv[i] == '-')
	 {
	    argv[i]++;
	    switch (*argv[i])
	    {
	       case '\0':
	          convert (stdin, pad);
		  break;

	       case 'p':
		  pad = 1;
	          break;

	       default:
	          fprintf (stderr, "Unknown option: %c\n", *argv[i]);
		  fprintf (stderr, "usage: a2e [-p] [-] [file]\n");
		  exit (1);
	    }
	 }
	 else
	 {
	    if ((ifd = fopen (argv[i], "r")) != NULL)
	    {
	       convert (ifd, pad);
	       fclose (ifd);

	    }
	    else
	    {
	       fprintf (stderr, "Can't open input file: %s\n", argv[i]);
	       exit (1);
	    }
	 }
      }
   }
}
