/***************************************************************************
*
* getfpos - Get the current end of file position.
*
* Usage:
*
*    getfpos pathname
*
* Where:
*	filename = Specifies the file to be processed.
*
* The file position is written to stdout.
*
***************************************************************************/

#include <stdio.h>

main (int argc, char **argv)
{
   FILE *fd;
   long pos;
   char temp[256];

   if (argc != 2)
   {
      printf ("usage: getfpos pathname\n");
      exit (1);
   }

   if ((fd = fopen (argv[1], "a+")) == NULL)
   {
      sprintf (temp, "fopen failed: %s", argv[1]);
      perror (temp);
      exit (1);
   }

   if ((pos = ftell (fd)) < 0)
   {
      sprintf (temp, "ftell failed: %s", argv[1]);
      perror (temp);
      exit (1);
   }

   fclose (fd);
   printf ("%ld\n", pos);
}
