/***************************************************************************
*
* getpart - Get part of a file starting at a specified position to EOF.
*
* Usage:
*
*    getpart pathname pos
*
* Where:
*	pathname = Specifies the file to be processed.
*	pos	 = Specifies the position to begin.
*
* The file is positioned to pos and then read with the output going to
* stdout.
*
***************************************************************************/

#include <stdio.h>

main (int argc, char **argv)
{
   FILE *fd;
   long pos;
   char temp[256];

   if (argc != 3)
   {
      printf ("usage: getpart pathname pos\n");
      exit (1);
   }

   if ((fd = fopen (argv[1], "r")) == NULL)
   {
      sprintf (temp, "fopen failed: %s", argv[1]);
      perror (temp);
      exit (1);
   }

   pos = atoi (argv[2]);
   if (fseek (fd, pos, SEEK_SET) < 0)
   {
      sprintf (temp, "fseek failed: %s", argv[1]);
      perror (temp);
      exit (1);
   }

   /* We use getc/putc because file may be binary */

   while (!feof(fd))
   {
      int c;

      if ((c = fgetc (fd)) < 0)
      {
         break;
      }
      fputc (c, stdout);
   }

   fclose (fd);
}
