/***********************************************************************
*
* asmbcd.h - Convert characters to decimal BCD.
*
* Changes:
*   02/08/07   DGP   Original.
*	
***********************************************************************/

/*
 * Decimal BCD to native table.
 */

unsigned char tonative[100] = {

/* 00 */ ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
/* 10 */ ' ', ' ', ' ', ' ', ' ', '.', ')', ' ', ' ', 'g',
/* 20 */ '+', ' ', ' ', ' ', ' ', '$', '*', ' ', ' ', ' ',
/* 30 */ '-', '/', ' ', ' ', ' ', ',', '(', ' ', ' ', 's',
/* 40 */ ' ', ' ', ' ', ' ', ' ', '=', '@', ' ', ' ', 't',
/* 50 */ ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
/* 60 */ '^', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
/* 70 */ '_', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R',
/* 80 */ 'r', ' ', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
/* 90 */ '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
};

#if '\n' == 0x0A && ' ' == 0x20 && '0' == 0x30 \
  && 'A' == 0x41 && 'a' == 0x61 && '!' == 0x21

/*
** ASCII to Decimal BCD conversion table. 
*/

static unsigned char tobcd[128] =
{
 /*00  NL   SH   SX   EX   ET   NQ   AK   BL */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*08  BS   HT   LF   VT   FF   CR   SO   SI */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*10  DL   D1   D2   D3   D4   NK   SN   EB */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*18  CN   EM   SB   EC   FS   GS   RS   US */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*20  SP    !    "    #    $    %    &    ' */
       00,  46, 255,  45,  25,  36,  20, 255,
 /*28   (    )    *    +    ,    -    .    / */
       36,  16,  26,  20,  35,  30,  15,  31,
 /*30   0    1    2    3    4    5    6    7 */
       90,  91,  92,  93,  94,  95,  96,  97,
 /*38   8    9    :    ;    <    =    >    ? */
       98,  99, 255, 255, 255,  45, 255, 255,
 /*40   @    A    B    C    D    E    F    G */
       46,  61,  62,  63,  64,  65,  66,  67,
 /*48   H    I    J    K    L    M    N    O */
       68,  69,  71,  72,  73,  74,  75,  76,
 /*50   P    Q    R    S    T    U    V    W */
       77,  78,  79,  82,  83,  84,  85,  86,
 /*58   X    Y    Z    [    \    ]    ^    _ */
       87,  88,  89, 255, 255, 255,  60,  70,
 /*60   `    a    b    c    d    e    f    g */
      255, 255, 255, 255, 255, 255, 255,  19,
 /*68   h    i    j    k    l    m    n    o */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*70   p    q    r    s    t    u    v    w */
      255, 255,  80,  39,  49, 255, 255, 255,
 /*78   x    y    z    {    |    }    ~   DL */
      255, 255, 255, 255, 255, 255, 255, 255
};

#endif /* ASCII */

#if '\n' == 0x15 && ' ' == 0x40 && '0' == 0xf0 \
  && 'A' == 0xC1 && 'a' == 0x81 && '!' == 0x5A

/*
** EBCDIC to Decimal BCD conversion table. 
*/

static unsigned char tobcd[256] =
{
 /*00  NU   SH   SX   EX   PF   HT   LC   DL */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*08            SM   VT   FF   CR   SO   SI */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*10  DE   D1   D2   TM   RS   NL   BS   IL */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*18  CN   EM   CC   C1   FS   GS   RS   US */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*20  DS   SS   FS        BP   LF   EB   EC */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*28            SM   C2   EQ   AK   BL      */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*30            SY        PN   RS   UC   ET */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*38                 C3   D4   NK        SU */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*40  SP                                    */
      000, 255, 255, 255, 255, 255, 255, 255,
 /*48          CENT    .    <    (    +    | */
      255, 255, 255, 255, 255,  36,  20, 255,
 /*50   &                                    */
       20, 255, 255, 255, 255, 255, 255, 255,
 /*58             !    $    *    )    ;    ^ */
      255, 255,  46,  25,  26,  16, 255,  60,
 /*60   -    /                               */
       30,  31, 255, 255, 255, 255, 255, 255,
 /*68             |    ,    %    _    >    ? */
      255, 255, 255,  35,  36,  70, 255, 255,
 /*70                                        */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*78        `    :    #    @    '    =    " */
      255, 255, 255,  45,  46, 255,  45, 255,
 /*80        a    b    c    d    e    f    g */
      255, 255, 255, 255, 255, 255, 255,  19,
 /*88   h    i         {                     */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*90        j    k    l    m    n    o    p */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*98   q    r         }                     */
      255,  80, 255, 255, 255, 255, 255, 255,
 /*A0        ~    s    t    u    v    w    x */
      255, 255,  39,  49, 255, 255, 255, 255,
 /*A8   y    z                   [           */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*B0                                        */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*B8                            ]           */
      255, 255, 255, 255, 255, 255, 255, 255,
 /*C0   {    A    B    C    D    E    F    G */
      255,  61,  62,  63,  64,  65,  66,  67,
 /*C8   H    I                               */
       68,  69, 255, 255, 255, 255, 255, 255,
 /*D0   }    J    K    L    M    N    O    P */
      255,  71,  72,  73,  74,  75,  76,  77,
 /*D8   Q    R                               */
       78,  79, 255, 255, 255, 255, 255, 255,
 /*E0   \         S    T    U    V    W    X */
      255, 255,  82,  83,  84,  85,  86,  87,
 /*E8   Y    Z                               */
       88,  89, 255, 255, 255, 255, 255, 255,
 /*F0   0    1    2    3    4    5    6    7 */
       90,  91,  92,  93,  94,  95,  96,  97,
 /*F8   8    9                               */
       98,  99, 255, 255, 255, 255, 255, 255
};

#endif /* EBCDIC */

