/***********************************************************************
*
* asmsymbols.h - System symbols for the IBM 7090 computer.
*
* Changes:
*   12/29/10   DGP   Copy from asm7090.c
*	
***********************************************************************/

/*
** IBSYS System nucleus defintions (MONSYM).
*/

static int mondefsset;
static SysDefs mapmondefs[] =
{
   { "SYSTRA", "S.S", 000100 },
   { "SYSDAT", "S.S", 000101 },
   { "SYSCUR", "S.S", 000102 },
   { "SYSRET", "S.S", 000103 },
   { "SYSKEY", "S.S", 000104 },
   { "SYSSWS", "S.S", 000105 },
   { "SYSPOS", "S.S", 000106 },
   { "SYSUNI", "S.S", 000107 },
   { "SYSUBC", "S.S", 000110 },
   { "SYSUAV", "S.S", 000111 },
   { "SYSUCW", "S.S", 000112 },
   { "SYSRPT", "S.S", 000113 },
   { "SYSCEM", "S.S", 000114 },
   { "SYSDMP", "S.S", 000115 },
   { "SYSIOX", "S.S", 000116 },
   { "SYSIDR", "S.S", 000117 },
   { "SYSCOR", "S.S", 000120 },
   { "SYSLDR", "S.S", 000121 },
   { "SYSACC", "S.S", 000122 },
   { "SYSPID", "S.S", 000123 },
   { "SYSCYD", "S.S", 000124 },
   { "SYSSLD", "S.S", 000126 },
   { "SYSTCH", "S.S", 000127 },
   { "SYSTWT", "S.S", 000131 },
   { "SYSGET", "S.S", 000132 },
   { "SYSJOB", "S.S", 000133 },
   { ".CHEXI", "",    000134 },
   { ".MODSW", "",    000135 },
   /* SYSUNI table */
   { "SYSLB1", "S.S", 000140 },
   { "SYSLB2", "S.S", 000141 },
   { "SYSLB3", "S.S", 000142 },
   { "SYSLB4", "S.S", 000143 },
   { "SYSCRD", "S.S", 000144 },
   { "SYSPRT", "S.S", 000145 },
   { "SYSPCH", "S.S", 000146 },
   { "SYSOU1", "S.S", 000147 },
   { "SYSOU2", "S.S", 000150 },
   { "SYSIN1", "S.S", 000151 },
   { "SYSIN2", "S.S", 000152 },
   { "SYSPP1", "S.S", 000153 },
   { "SYSPP2", "S.S", 000154 },
   { "SYSCK1", "S.S", 000155 },
   { "SYSCK2", "S.S", 000156 },
   { "SYSUT1", "S.S", 000157 },
   { "SYSUT2", "S.S", 000160 },
   { "SYSUT3", "S.S", 000161 },
   { "SYSUT4", "S.S", 000162 },
   { "SYSUT5", "S.S", 000163 },
   { "SYSUT6", "S.S", 000164 },
   { "SYSUT7", "S.S", 000165 },
   { "SYSUT8", "S.S", 000166 },
   { "SYSUT9", "S.S", 000167 },
   /* IOEX communications region */
   { ".ACTV",  "",    000702 },
   { ".NDSEL", "",    000704 },
   { ".MWR",   "",    000706 },
   { ".PUNCH", "",    000707 },
   { ".ENBSW", "",    000710 },
   { ".PAWS",  "",    000711 },
   { ".PAUSE", "",    000712 },
   { ".STOP",  "",    000713 },
   { ".SYMUN", "",    000714 },
   { ".DECVD", "",    000715 },
   { ".DECVA", "",    000716 },
   { ".CKWAT", "",    000717 },
   { ".BCD5R", "",    000720 },
   { ".BCD5X", "",    000721 },
   { ".CVPRT", "",    000722 },
   { ".STOPD", "",    000723 },
   { ".CHXAC", "",    000724 },
   { ".URRX",  "",    000725 },
   { ".RCTX",  "",    000726 },
   { ".RCHX",  "",    000727 },
   { ".TCOX",  "",    000730 },
   { ".TRCX",  "",    000731 },
   { ".ETTX",  "",    000732 },
   { ".TEFX",  "",    000733 },
   { ".TRAPX", "",    000734 },
   { ".TRAPS", "",    000735 },
   { ".COMM",  "",    000736 },
   { ".LTPOS", "",    000737 },
   { ".IOXSI", "",    000740 },
   { ".CHPSW", "",    000741 },
   { ".TRPSW", "",    000742 },
   { ".FDAMT", "",    000743 },
   { ".SDCXI", "",    000744 },
   { ".STCXI", "",    000745 },
   { ".COMMD", "",    000746 },
   { ".IBCDZ", "",    000747 },
   { ".CHXSP", "",    000750 },
   { ".BLKSW", "",    000751 },
   { "SYSORG", "S.S", 002652 },
   { "SYSEND", "S.S", 077777 },
   { "",       "",    -1     }
};

/*
** IBJOB defintions (JOBSYM), pulls in mapmondefs.
*/

static int jobdefsset;
static SysDefs jobdefs[] =
{
   { "SYSLOC", "", 021234 },
   { "SYSFAZ", "", 021235 },
   { "IBJCOR", "", 021236 },
   { "IBJDAT", "", 021237 },
   { ".JLDAT", "", 021240 },
   { ".JTYPE", "", 021242 },
   { ".JLIN",  "", 021243 },
   { ".JVER",  "", 021244 },
   { ".JKAPU", "", 021245 },
   { "SYSDSB", "", 021246 },
   { ".FDPOS", "", 021250 },
   { "SSTRA",  "", 021253 },
   { "ACTION", "", 021254 },
   { "JOBIN",  "", 021255 },
   { "JOBOU",  "", 021256 },
   { "JOBPP",  "", 021257 },
   { "IOEDIT", "", 021260 },
   { "JREEL",  "", 021261 },
   { "SUBSP",  "", 021262 },
   { "PUNCH",  "", 021263 },
   { "SYSSHD", "", 021264 },
   { "LILDMP", "", 021265 },
   { "IBSLB",  "", 021266 },
   { "PRSW",   "", 021267 },
   { "DEFINE", "", 021347 },
   { "JOIN",   "", 021351 },
   { "ATTACH", "", 021353 },
   { "CLOSE",  "", 021355 },
   { "OPEN",   "", 021357 },
   { "READ",   "", 021361 },
   { "WRITE",  "", 021363 },
   { "STASH",  "", 021365 },
   { "SUBSYS", "", 021412 },
   { "",       "", -1     }
};

/*
** FAP SST IBSYS symbols.
*/

static int ifapdefsset;
static SysDefs ifapmondefs[] =
{
   { "SYSTRA", "", 000100 },
   { "SYSDAT", "", 000101 },
   { "SYSCUR", "", 000102 },
   { "SYSRET", "", 000103 },
   { "SYSKEY", "", 000104 },
   { "SYSSWS", "", 000105 },
   { "SYSPOS", "", 000106 },
   { "SYSUNI", "", 000107 },
   { "SYSUBC", "", 000110 },
   { "SYSUAV", "", 000111 },
   { "SYSUCW", "", 000112 },
   { "SYSRPT", "", 000113 },
   { "SYSCEM", "", 000114 },
   { "SYSDMP", "", 000115 },
   { "SYSIOX", "", 000116 },
   { "SYSIDR", "", 000117 },
   { "SYSCOR", "", 000120 },
   { "SYSLDR", "", 000121 },
   { "SYSACC", "", 000122 },
   { "SYSPID", "", 000123 },
   { "SYSCYD", "", 000124 },
   { "SYSSLD", "", 000126 },
   { "SYSTCH", "", 000127 },
   { "SYSTWT", "", 000131 },
   { "SYSGET", "", 000132 },
   { "SYSJOB", "", 000133 },
   { ".CHEXI", "", 000134 },
   { ".MODSW", "", 000135 },
   /* SYSUNI table */
   { "SYSLB1", "", 000140 },
   { "SYSLB2", "", 000141 },
   { "SYSLB3", "", 000142 },
   { "SYSLB4", "", 000143 },
   { "SYSCRD", "", 000144 },
   { "SYSPRT", "", 000145 },
   { "SYSPCH", "", 000146 },
   { "SYSOU1", "", 000147 },
   { "SYSOU2", "", 000150 },
   { "SYSIN1", "", 000151 },
   { "SYSIN2", "", 000152 },
   { "SYSPP1", "", 000153 },
   { "SYSPP2", "", 000154 },
   { "SYSCK1", "", 000155 },
   { "SYSCK2", "", 000156 },
   { "SYSUT1", "", 000157 },
   { "SYSUT2", "", 000160 },
   { "SYSUT3", "", 000161 },
   { "SYSUT4", "", 000162 },
   /* IOEX communications region */
   { "(ACTIV", "", 000702 },
   { "(ACTVX", "", 000703 },
   { "(NDATA", "", 000704 },
   { "(NDSLX", "", 000705 },
   { "(PROUT", "", 000706 },
   { "(PUNCH", "", 000707 },
   { "(ENBSW", "", 000710 },
   { "(PAWSX", "", 000711 },
   { "(PAUSE", "", 000712 },
   { "(STOPX", "", 000713 },
   { "(SYMUN", "", 000714 },
   { "(DECVD", "", 000715 },
   { "(DECVA", "", 000716 },
   { "(CKWAT", "", 000717 },
   { "(BCD5R", "", 000720 },
   { "(BCD5X", "", 000721 },
   { "(CVPRT", "", 000722 },
   { "(STOPD", "", 000723 },
   { "(CHXAC", "", 000724 },
   { "(URRXI", "", 000725 },
   { "(RCTXI", "", 000726 },
   { "(RCHXI", "", 000727 },
   { "(TCOXI", "", 000730 },
   { "(TRCXI", "", 000731 },
   { "(ETTXI", "", 000732 },
   { "(TEFXI", "", 000733 },
   { "(TRAPX", "", 000734 },
   { "(TRAPS", "", 000735 },
   { "(COMMM", "", 000736 },
   { "(LTPOS", "", 000737 },
   { "(IOXSI", "", 000740 },
   { "(CHPSW", "", 000741 },
   { "(TRPSW", "", 000742 },
   { "(FDAMT", "", 000743 },
   { "(SDCXI", "", 000744 },
   { "(STCXI", "", 000745 },
   { "(COMMD", "", 000746 },
   { "(IBCDZ", "", 000747 },
   { "(CHXSP", "", 000750 },
   { "SYSORG", "", 003720 },
   { "SYSEND", "", 077777 },
   { "",       "", -1     }
};

/*
** FAP SST FORTRAN symbols, pulls in ifapmoddefs.
*/

static int ffapdefsset;
static SysDefs ffapmondefs[] =
{
   { "LIBTAP", "", 000001 },
   { "SYSTAP", "", 000001 },
   { "FINTAP", "", 000002 },
   { "SINTAP", "", 000003 },
   { "TINTAP", "", 000004 },
   { "MINTAP", "", 000005 },
   { "MLSTAP", "", 000006 },
   { "MBNTAP", "", 000007 },
   { "MCHTAP", "", 000010 },
   { "SNPTAP", "", 000011 },
   { "(SNAP)", "", 001000 },
   { "FLAGBX", "", 003730 },
   { "LINECT", "", 003731 },
   { "DATEBX", "", 003732 },
   { "(PCBK)", "", 003733 },
   { "BOTTOM", "", 003734 },
   { "(TPER)", "", 004000 },
   { "(CHKU)", "", 010000 },
   { "(SUNV)", "", 010002 },
   { "(SUAV)", "", 010003 },
   { "(SKBP)", "", 020000 },
   { "(SKDP)", "", 020002 },
   { "(SKBC)", "", 020010 },
   { "(SKDC)", "", 020012 },
   { "(RBNP)", "", 040000 },
   { "(WBNP)", "", 040001 },
   { "(RDNP)", "", 040002 },
   { "(WDNP)", "", 040003 },
   { "(RBEP)", "", 040004 },
   { "(WEFP)", "", 040005 },
   { "(RDEP)", "", 040006 },
   { "(RBNC)", "", 040010 },
   { "(WBNC)", "", 040011 },
   { "(RDNC)", "", 040012 },
   { "(WDNC)", "", 040013 },
   { "(RBEC)", "", 040014 },
   { "(WEFC)", "", 040015 },
   { "(RDEC)", "", 040016 },
   { "(WROW)", "", 040031 },
   { "BOTIOP", "", 073600 },
   { "(LOAD)", "", 073600 },
   { "(DIAG)", "", 073603 },
   { "(TAPE)", "", 073606 },
   { "(PRNT)", "", 073611 },
   { "(PNCH)", "", 073614 },
   { "(STAT)", "", 073617 },
   { "(REST)", "", 073622 },
   { "(STDN)", "", 073626 },
   { "(SECL)", "", 073643 },
   { "(MECL)", "", 073644 },
   { "(DGLD)", "", 073645 },
   { "(PGCT)", "", 073651 },
   { "(LIBT)", "", 073652 },
   { "(FGBX)", "", 073660 },
   { "(LNCT)", "", 073661 },
   { "(DATE)", "", 073662 },
   { "(SNCT)", "", 073663 },
   { "(MSLN)", "", 073664 },
   { "(ENDS)", "", 073665 },
   { "(LODR)", "", 073666 },
   { "(LBLD)", "", 073667 },
   { "(SCHU)", "", 073672 },
   { "TOPMEM", "", 077677 },
   { "",       "", -1     }
}; 

