       REM                                                              EQU00002
       REM     ... CTSS EQUIVALENCE PACKAGE ...                         EQU00003
       REM                                                              EQU00004
N      EQU     40            NO. OF CONSOLES THAT MAY BE CONNECTED      EQU00005
A      EQU     1             FLAG FOR MEMORY UNIT A                     EQU00006
B      EQU     2             FLAG FOR MEMORY UNIT B                     EQU00007
P      EQU     4             FLAG FOR PROTECTED TRANSMISSION            EQU00008
QUITL  EQU     3             MAX. USER BREAK LEVEL                      EQU00009
LCBUF  EQU     20            LENGTH OF USER COMMAND BUFFER              EQU00010
MAXLV  EQU     10            MAX. NO. OF LEVELS IN SCHEDULING QUEUES    EQU00011
CDEPTH EQU     5             MAX. NO. OF SUB-COMMANDS                   EQU00012
CLNGTH EQU     LCBUF         MAX. LENGTH OF SINGLE SUB-COMMAND          EQU00013
NWDSPT EQU     432           NO. OF WORDS PER DISK RECORD               EQU00014
BASE   EQU     0             STARTING LOCATION FOR ALL CTSS USERS       EQU00015
WDSLIN EQU     14            NO. OF WORDS PER FULL TYPED LINE           EQU00016
GROUPS EQU     35            MAX. NO. OF PARTY GROUPS                   EQU00017
TSSMAX EQU     20            2*NUMBER OF SLOTS FOR TSSFIL'S             EQU00018
ACTFIL EQU     10            MAX. NO. OF ACTIVE FILES FOR USER          EQU00019
AFSCON EQU     26            ACTIVE FILE STATUS TABLE LENGTH CONSTANT   EQU00020
AFSENL EQU     22            ACTIVE FILE STATUS TABLE LENGTH PER FILE   EQU00021
AFS1LN EQU     AFSCON+1*AFSENL FILE STATUS TABLE FOR CTSS               EQU00022
AFS2LN EQU     AFSCON+ACTFIL*AFSENL FILE STATUS TABLE FOR USER          EQU00023
Q1U1LN EQU     1+9*4         LENGTH OF QUEUE FOR DISK/DRUM FOR CTSS     EQU00024
Q1U2LN EQU     1+9*7         LENGTH OF QUEUE FOR DISK/DRUM FOR USER     EQU00025
Q3U1LN EQU     0             LENGTH OF QUEUE FOR TAPE FOR CTSS          EQU00026
Q3U2LN EQU     1+8*5         LENGTH OF QUEUE FOR TAPE FOR USER          EQU00027
FSBENL EQU     8             FILE SAVE BLOCK ENTRY LENGTH PER FILE      EQU00028
FSBLKL EQU     FSBENL*ACTFIL FILE STATUS BLOCK LENGTH FOR USAVE         EQU00029
OLDTOP BOOL    77461         NORMAL END OF COMMON PACKAGE               EQU00030
NEWTOP BOOL    77777         DESIRED END OF COMMON PACKAGE              EQU00031
COMRLC EQU     OLDTOP-NEWTOP COMMON RELOCATION                          EQU00032
       REM                                                              EQU00033
       REM     BLOCK EQUIVALENCES FOR QLOAD VARIABLES                   EQU00034
       REM                                                              EQU00035
Q.CUR  EQU     0             CURRENT VALUE OF PARAMETER                 EQU00036
Q.MAX  EQU     1             MAXIMUM VALUE                              EQU00037
Q.MIN  EQU     2             MINIMUM VALUE (PLATEAU FOR MXUSRS)         EQU00038
Q.UPDT EQU     3             TIME INCREMENT BEFORE INCREASING           EQU00039
Q.DNDT EQU     4             TIME INCREMENT BEFORE DECREASING           EQU00040
Q.UPTM EQU     5             TOTTIM TO INCREASE PARAMETER               EQU00041
Q.DNTM EQU     6             TOTTIM TO DECREASE IT                      EQU00042
Q.UPVR EQU     7             AMOUNT TO INCREMENT PARAMETER              EQU00043
Q.DNVR EQU     8             AMOUNT TO DECREMENT PARAMETER              EQU00044
Q.TBL  EQU     9             SIZE OF STANDARD PARAMATER BLOCK           EQU00045
       REM                                                              EQU00046
       REM     BIT EQUIVALENCES FOR USER STATUS SWITCHES IN THE         EQU00047
       REM     ARRAY 'USWICH'. THESE ARE ALTERABLE AT TRAP TIME.        EQU00048
       REM                                                              EQU00049
       REM     .. RIGHT HALF EQUIVALENCES                               EQU00050
       REM                                                              EQU00051
NOTIME BOOL    1             1 IF USER OUT OF TIME                      EQU00052
HUNGBT BOOL    2             1 IF USER DATA PHONE HUNG UP               EQU00053
MESGBT BOOL    4             1 IF OPERATOR MESSAGE TO BE SENT           EQU00054
USRBIT BOOL    10            1 IF USER HAS BEEN INITIALIZED AT DIALUP   EQU00055
INPBIT BOOL    20            1 IF USER INPUT BUFFERS FULL               EQU00056
       REM                                                              EQU00057
NTIMCD BOOL    700000        THREE BIT NOTIME CODE (0-7)                EQU00058
       REM                   .. 0 = UNSPECIFIED                         EQU00059
       REM                   .. 1 = SYSTEM COMEDOWN                     EQU00060
       REM                   .. 2 = ALLOTTED TIME EXCEEDED              EQU00061
       REM                   .. 3 = INACTIVE TIME EXCEEDED              EQU00062
       REM                   .. 4 = FIB ESTTIM EXCEEDED                 EQU00063
       REM                   .. 5 = USER HUNG UP PHONE                  EQU00064
       REM                   .. 6 = QLOAD KILL                          EQU00065
       REM                   .. 7 = OTHER (LOGIN, ETC.)                 EQU00066
       REM                                                              EQU00067
       REM     .. LEFT HALF EQUIVALENCES                                EQU00068
       REM                                                              EQU00069
UCOMBT BOOL    100           1 IF CURRENT COMMAND INITIATED BY USER     EQU00070
UCHNBT BOOL    200           1 IF USER COMMAND SET VIA CHNCOM           EQU00071
UCMLBT BOOL    400           1 IF USER TYPED COMMAND LINE               EQU00072
UCBFBT BOOL    1000          1 IF COMMAND BUFFER SET UP                 EQU00073
INTBIT BOOL    2000          1 IF USER HIT INTERRUPT                    EQU00074
LOGTBT BOOL    10000         1 IF USER WAITING FOR LOGOUT               EQU00075
       REM                                                              EQU00076
       REM     BIT EQUIVALENCES FOR USER OPTION BITS FOUND IN           EQU00077
       REM     'USROPT'. THESE MUST NEVER BE SET AT TRAP TIME           EQU00078
       REM                                                              EQU00079
       REM     .. RIGHT HALF EQUIVALENCES                               EQU00080
       REM                                                              EQU00081
UFLBIT BOOL    1             1 IF TO LOAD COMMAND FROM USER UFD FIRST   EQU00082
UFLBT  BOOL    2             1 IF TO LOAD FROM OTHER UFD IF NOT FOUND   EQU00083
RSTFBT BOOL    4             1 IF FILES TO BE RESET ON DISK COMMAND     EQU00084
ENBBIT BOOL    10            1 IF USER SUBSYSTEM ENABLED                EQU00085
INHBIT BOOL    20            1 IF SUBSYSTEM INHIBITED FOR END OF COMMANDEQU00086
SYSBIT BOOL    40            1 IF CURRENT USER PROGRAM IS SUBSYSTEM     EQU00087
SAVEBT BOOL    100           1 IF SUBSYSTEM SAVE ENABLED                EQU00088
DIALBT BOOL    200           1 IF USER 'DIALABLE'                       EQU00089
       REM                                                              EQU00090
       REM     .. LEFT HALF EQUIVALENCES                                EQU00091
       REM                                                              EQU00092
CLKBIT BOOL    100           1 IF USER SIMULATED INTERVAL TIMER ON      EQU00093
NQTBIT BOOL    200           1 IF USER MAY NOT 'QUIT' CURRENT COMMAND   EQU00094
NINTBT BOOL    400           1 IF USER NOT TO BE INTERRUPTED            EQU00095
NKILBT BOOL    1000          1 IF USER IMMUNE TO AUTO-LOGOUT            EQU00096
XEQBIT BOOL    2000          1 IF CURRENT USER PROGRAM EXECUTE-ONLY     EQU00097
       REM                                                              EQU00098
       REM     BIT DEFINITIONS FOR TYPEWRITER MODE SWITCHES.            EQU00099
       REM     THESE ARE COMMON TO BOTH USWICH AND USROPT               EQU00100
       REM                                                              EQU00101
FULBIT BOOL    1             1 IF USER IN 12-BIT MODE                   EQU00102
NCVBIT BOOL    2             1 IF USER IN NO-CONVERT MODE               EQU00103
NBKBIT BOOL    4             1 IF USER IN NO-BREAK MODE                 EQU00104
GPHBIT BOOL    10            1 IF USER IN GRAPHIC INPUT MODE            EQU00105
       REM                                                              EQU00106
TPWRSW BOOL    77            MASK FOR TYPEWRITER SWITCHES               EQU00107
       REM                                                              EQU00108
       REM     BIT EQUIVALENCES FOR SUBSYSTEM STATUS SWITCHES           EQU00109
       REM                                                              EQU00110
SB.CMD BOOL    1             1 IF SUBSYSTEM ENABLED FOR NEW COMMAND     EQU00111
SB.TSX BOOL    2             1 IF SUBSYSTEM ENABLED FOR DEAD/DORMNT CALLEQU00112
SB.CHN BOOL    4             1 IF SUBSYSTEM ENABLED FOR END OF CHAIN    EQU00113
SB.ERR BOOL    10            1 IF SUBSYSTEM ENABLED FOR ERROR           EQU00114
       REM                                                              EQU00115
       REM     BIT EQUIVALENCES FOR COMMAND TYPE SPECIFICATION          EQU00116
       REM     WITHIN THE COMMAND PROCESSOR                             EQU00117
       REM                                                              EQU00118
.ATR   BOOL    1             1 IF COMMAND IS A-CORE TRANSFER            EQU00119
.DSK   BOOL    2             1 IF CORE IMAGE TO BE LOADED FROM DISK     EQU00120
.SYS   BOOL    4             1 IF COMMAND MAY BE LOADED FROM SYSTEM ONLYEQU00121
.CPY   BOOL    10            1 IF COMMAND BUFFER TO BE COPIED           EQU00122
.MEM   BOOL    20            1 IF USER CORE IMAGE REQUIRED              EQU00123
.USR   BOOL    40            1 IF COMMAND MAY BE ISSUED BY USER         EQU00124
.LGN   BOOL    100           1 IF COMMAND USABLE WHEN LOGGED IN         EQU00125
.LGT   BOOL    200           1 IF COMMAND USABLE WHEN LOGGED OUT        EQU00126
.LOG   BOOL    400           1 IF COMMAND IS LOGOUT, OTOLOG, ETC.       EQU00127
.UFL   BOOL    1000          1 IF COMMAND TO BE LOADED FROM USER UFD    EQU00128
.SAV   BOOL    2000          1 IF USER CORE IMAGE TO BE PRESERVED       EQU00129
.CLC   BOOL    4000          1 IF USER COMMAND COUNTER PRESERVED        EQU00130
.SUB   BOOL    10000         1 IF COMMAND IMMUNE TO SUBSYS TRAP         EQU00131
       REM                                                              EQU00132
       REM     BIT EQUIVALENCES FOR USER DUMP AND RESTORE OPTIONS       EQU00133
       REM                                                              EQU00134
D.DSK  BOOL    1             ACTIVE FILE STATUS                         EQU00135
D.OPT  BOOL    2             USER OPTIONS                               EQU00136
D.DIR  BOOL    4             DIRECTORY SWITCHING                        EQU00137
D.TSF  BOOL    10            TSSFIL SWITCHING                           EQU00138
D.COM  BOOL    20            COMMAND BUFFERS                            EQU00139
D.SAV  BOOL    40            MACH. COND., CORE IMAGE                    EQU00140
       REM                                                              EQU00141
L.DSK  BOOL    1             ACTIVE FILE STATUS                         EQU00142
L.OPT  BOOL    2             USER OPTIONS                               EQU00143
L.DIR  BOOL    4             DIRECTORY SWITCHING                        EQU00144
L.TSF  BOOL    10            TSSFIL SWITCHING                           EQU00145
L.COM  BOOL    20            COMMAND BUFFERS                            EQU00146
L.CPU  BOOL    40            MACHINE CONDITIONS                         EQU00147
L.MEM  BOOL    100           CORE IMAGE                                 EQU00148
       REM                                                              EQU00149
       REM     BIT EQUIVALENCES FOR USER RESTRICTION CODE IN            EQU00150
       REM     'RCODE' ARRAY AND 'URCODE'                               EQU00151
       REM                                                              EQU00152
       REM     .. RIGHT HALF EQUIVALENCES                               EQU00153
       REM                                                              EQU00154
RCOMBT BOOL    1             1 IF USER MAY USE COMMON FILES             EQU00155
RCALBT BOOL    2             1 IF USER MAY MAKE PRIVILEGED FILE CALLS   EQU00156
RPROBT BOOL    4             1 IF USER MAY MODIFY 'P' FILE OF OTHER USEREQU00157
RPRVBT BOOL    10            1 IF USER MAY READ 'V' FILE OF OTHER USER  EQU00158
RPATBT BOOL    20            1 IF USER MAY PATCH THE SUPERVISOR         EQU00159
RKLDBT BOOL    40            1 IF USER MAY USE THE ESL DISPLAY (KLUDGE) EQU00160
R636BT BOOL    100           1 IF USER MAY USE THE 636 TAPE CALLS       EQU00161
RDSKBT BOOL    200           1 IF USER MAY NOT USE DISK LOADED COMMANDS EQU00162
RTSSBT BOOL    400           1 IF USER MAY NOT ALTER FILE DIRECTORY     EQU00163
RSYSBT BOOL    1000          1 IF USER MAY ALTER SUBSYSTEM STATUS       EQU00164
ROPRBT BOOL    2000          1 IF USER MAY USE OPERATOR FUNCTIONS       EQU00165
       REM                                                              EQU00166
       REM     .. LEFT HALF EQUIVALENCES                                EQU00167
       REM                                                              EQU00168
UBACBT BOOL    1             USER IS BACKGROUND SYSTEM                  EQU00169
UFORBT BOOL    2             USER IS FOREGROUND                         EQU00170
UFIBBT BOOL    4             USER IS FIB                                EQU00171
UDEMBT BOOL    10            USER IS INCREMENTAL DUMPER (DAEMON)        EQU00172
UPRCBT BOOL    20            USER IS PRIVILEGED COMMAND                 EQU00173
       REM                                                              EQU00174
NBACBT BOOL    1000          USER IS NOT BACKGROUND SYSTEM              EQU00175
NFORBT BOOL    2000          USER IS NOT FOREGROUND                     EQU00176
NFIBBT BOOL    4000          USER IS NOT FIB                            EQU00177
NDEMBT BOOL    10000         USER IS NOT INCREMENTAL DUMPER             EQU00178
NPRCBT BOOL    20000         USER IS NOT PRIVILEGED COMMAND             EQU00179
       REM                                                              EQU00180
       REM                                                              EQU00181
       REM                                                              EQU00182
       REM                                                              EQU00184
COMNAM MACRO   NAME          TO GENERATE CTSS MODULE NAMES              EQU00185
       BCI     1,NAME'8A     .. MACRO MUST BE CORRECTED EVERY TIME      EQU00186
COMNAM END                   .. CTSS IS REASSEMBLED...                  EQU00187
       REM                                                              EQU00188
CTSSID MACRO                 CTSS FILE DIRECTORY NAME                   EQU00189
       BCI     2, M1416CMFL02                                           EQU00190
CTSSID END                                                              EQU00191
       REM                                                              EQU00192
TSSFID MACRO                 SYSTEM TSSFIL NAME                         EQU00193
       BCI     2, M1416CMFL04                                           EQU00194
TSSFID END                                                              EQU00195
       REM                                                              EQU00196
SCHEDL MACRO   EVENT,USER,ARG CALL SCHEDULING ALGORITHM                 EQU00197
       TSX     SCHEDL,4      ..                                         EQU00198
       PAR     EVENT         ..                                         EQU00199
       PAR     USER          ..                                         EQU00200
       PAR     ARG           ..                                         EQU00201
SCHEDL END                                                              EQU00202
       REM                                                              EQU00203
SETAB  MACRO   A,B,C         SET CORE SWITCHES IN FILE SYSTEM           EQU00204
       TSX     SETAB,4       ..                                         EQU00205
       IFF     1,*,A         ..                                         EQU00206
       PAR     M0            ..                                         EQU00207
       IFF     0,*,A         ..                                         EQU00208
       PAR     A             ..                                         EQU00209
       IFF     1,*,B         ..                                         EQU00210
       PAR     M0            ..                                         EQU00211
       IFF     0,*,B         ..                                         EQU00212
       PAR     B             ..                                         EQU00213
       IFF     1,*,C         ..                                         EQU00214
       PAR     M0            ..                                         EQU00215
       IFF     0,*,C         ..                                         EQU00216
       PAR     C             ..                                         EQU00217
SETAB  END                                                              EQU00218
       REM                                                              EQU00219
TYPEX  MACRO   NAME,LOC,N,USERNO,OPTION,MODE                            EQU00220
       TSX     NAME,4        ..                                         EQU00221
       IFF     MODE,,,       ..                                         EQU00222
       MZE     LOC,,N        ..                                         EQU00223
       IFF     MODE,0,,      ..                                         EQU00224
       PZE     LOC,,N        ..                                         EQU00225
       PZE     USERNO,,OPTION                                           EQU00226
TYPEX  END                                                              EQU00227
       REM                                                              EQU00228
TYPE   MACRO   MESG,LOC,N    TYPE COMMENT TO CURRENT USER               EQU00229
       TYPEX   WRFLX,LOC,N,USER,.F.,0                                   EQU00230
       RMT                                                              EQU00231
       PMC     ON                                                       EQU00232
LOC    BCI     MESG                                                     EQU00233
       PMC     OFF                                                      EQU00234
N      EQU     *-LOC                                                    EQU00235
       RMT                                                              EQU00236
TYPE   END                                                              EQU00237
       REM                                                              EQU00238
TYPEA  MACRO   MESG,LOC,N    TYPE COMMENT TO USER W/O C.R.              EQU00239
       TYPEX   WRFLXA,LOC,N,USER,.F.,0                                  EQU00240
       RMT                                                              EQU00241
       PMC     ON                                                       EQU00242
LOC    BCI     MESG                                                     EQU00243
       PMC     OFF                                                      EQU00244
N      EQU     *-LOC                                                    EQU00245
       RMT                                                              EQU00246
TYPEA  END                                                              EQU00247
       REM                                                              EQU00248
TYPEF  MACRO   MESG,LOC,N    TYPE COMMENT IN FULL MODE                  EQU00249
       TYPEX   WRFLX,LOC,N,USER,.F.,1                                   EQU00250
       RMT                                                              EQU00251
       PMC     ON                                                       EQU00252
LOC    12BIT   MESG                                                     EQU00253
       PMC     OFF                                                      EQU00254
N      EQU     *-LOC                                                    EQU00255
       RMT                                                              EQU00256
TYPEF  END                                                              EQU00257
       REM                                                              EQU00258
WRTYPE MACRO   L,LOC,N,USERNO,MODE TYPE LINE ON USER CONSOLE            EQU00259
       TSX     $.WRFX'L,4    ..                                         EQU00260
       IFF     MODE,,,       ..                                         EQU00261
       MZE     LOC,,N        ..                                         EQU00262
       IFF     MODE,0,,      ..                                         EQU00263
       PZE     LOC,,N        ..                                         EQU00264
       PZE     USERNO        ..                                         EQU00265
       TRA     *+1           .. NULL FULL RETURN                        EQU00266
WRTYPE END                                                              EQU00267
       REM                                                              EQU00268
WTYPE  MACRO   USERNO,MESG,LOC,N TYPE COMMENT TO FOREGROUND USER        EQU00269
       WRTYPE  ,LOC,N,USERNO,0                                          EQU00270
       RMT                                                              EQU00271
       PMC     ON                                                       EQU00272
LOC    BCI     MESG                                                     EQU00273
       PMC     OFF                                                      EQU00274
N      EQU     *-LOC                                                    EQU00275
       RMT                                                              EQU00276
WTYPE  END                                                              EQU00277
       REM                                                              EQU00278
WTYPEA MACRO   USERNO,MESG,LOC,N TYPE COMMENT W/O C.R.                  EQU00279
       WRTYPE  A,LOC,N,USERNO,0                                         EQU00280
       RMT                                                              EQU00281
       PMC     ON                                                       EQU00282
LOC    BCI     MESG                                                     EQU00283
       PMC     OFF                                                      EQU00284
N      EQU     *-LOC                                                    EQU00285
       RMT                                                              EQU00286
WTYPEA END                                                              EQU00287
       REM                                                              EQU00288
WTYPEF MACRO   USERNO,MESG,LOC,N TYPE COMMENT IN FULL MODE              EQU00289
       WRTYPE  ,LOC,N,USERNO,1                                          EQU00290
       RMT                                                              EQU00291
       PMC     ON                                                       EQU00292
LOC    12BIT   MESG                                                     EQU00293
       PMC     OFF                                                      EQU00294
N      EQU     *-LOC                                                    EQU00295
       RMT                                                              EQU00296
WTYPEF END                                                              EQU00297
       REM                                                              EQU00298
.I.    EQU     0             CODE FOR IGNORE OPTION IN TYPEX            EQU00299
.F.    EQU     1             CODE FOR FORCE OPTION IN TYPEX             EQU00300
       REM                                                              EQU00301
TEMPS  MACRO   SYMBOL        GENERATE TEPORARY STORAGE                  EQU00302
       IRP     SYMBOL        ..                                         EQU00303
SYMBOL PZE     0             ..                                         EQU00304
       IRP                   ..                                         EQU00305
TEMPS  END                                                              EQU00306
       REM                                                              EQU00307
LDISW  MACRO   LOC,T         LOAD USER SWITCHES                         EQU00308
       IFF     1,,LOC        ..                                         EQU00309
       LDI     USWICH,T      ..                                         EQU00310
       IFF     0,,LOC        ..                                         EQU00311
       LDI     LOC,T         ..                                         EQU00312
LDISW  END                                                              EQU00313
       REM                                                              EQU00314
STISW  MACRO   LOC,T         STORE USER SWITCHES                        EQU00315
       IFF     1,,LOC        ..                                         EQU00316
       STI     USWICH,T      ..                                         EQU00317
       IFF     0,,LOC        ..                                         EQU00318
       STI     LOC,T         ..                                         EQU00319
STISW  END                                                              EQU00320
       REM                                                              EQU00321
       REM                                                              EQU00323
