#include <stdio.h>
#include <ctype.h>
#include <string.h> 
#include <math.h>

#include "parser.h"
#include "errors.h"

int  err_flag;

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/***********************************************************************
*
* Parse_Error - Print parsing error
*
***********************************************************************/

Parse_Error ( int cause, int state )
{
   int j;
 
   err_flag = TRUE;
 
   switch ( cause )
   {
 
      case BAD_VAR:
         fputs ( "Variables not allowed", stderr );
         break;
 
      case BAD_EXPR:
         fputs ( "Bad expression", stderr );
         switch ( state )
         {
            case FOR_EXPR :
               fputs ( " in FOR/SET, missing '='", stderr );
               break;
            case IF_EXPR:
               fputs ( " in IF", stderr );
               break;
            case TAB_EXPR:
               fputs ( " in tab value", stderr );
               break;
            default: ;
         }
         break;
 
      case BAD_FUNC:
         fputs ( "Invalid function", stderr );
         break;
 
      case BAD_STRING:
         fputs ( "Bad text string", stderr );
         break;
 
      case BAD_NUM:
         fputs ( "Bad number", stderr );
         break;
 
      case MEM_OVERFLOW:
         fputs ( "Overflow - ", stderr );
         switch ( state )
         {
            case LINE_OVERFLOW:
               fputs ( "line buffer", stderr );
               break;
            case SYMBOL_OVERFLOW:
               fputs ( "symbol table", stderr );
               break;
            case STACK_OVERFLOW:
               fputs ( "stack", stderr );
            default: ;
         }
         break;
 
      case PARSE_ERROR:
         switch ( state )
         {
#include "perrors.h"
            default:
               fprintf ( stderr, "(%d) Parse error", state );
         }
         break;
 
      case SCAN_ERROR:
         switch ( state )
         {
            case 4:
            case 9:
               fputs ( "Bad exponent sign", stderr );
               break;
            case 7:
               fputs ( "Bad fraction", stderr );
               break;
            case 8:
               fputs ( "Exponent overflow", stderr );
               break;
            default:
               fprintf ( stderr, "Scan error = %d", state );
         }
         break;
 
      case INTERP_ERROR:
         switch ( state )
         {
            case ZERO_DIVIDE:
               fputs ( "Divide by zero", stderr );
               break;
            case NEG_SQRT:
               fputs ( "Negative SQRT", stderr );
               break;
            case NEG_LOG:
               fputs ( "Negative or zero LOG", stderr );
               break;
            default:
               fprintf ( stderr, "Interp error = %d", state );
         }
         break;
 
      default:
         fputs ( "Undefined error", stderr );
   }
   fputs ( "\n", stderr );
 
} /* Parse_Error */

main ( int argc, char *argv[] )
{
   char expr[BUFSIZ], *bp;
   float value;

   srand ( 1 );
   while ( TRUE ) {
      printf ( "Enter expression: " );
      if ((bp = fgets ( expr, sizeof(expr), stdin )) != NULL ) {
         *strchr(bp,'\n') = '\0';
         value = Parser ( bp );
         if ( !err_flag )
            printf ( "Value = %10.4f\n", value );
      }
      else
         break;
   }

}
