       TITL    'TMS9900 FORTH'
       IDT     'FORTH'
************************************************************
*
* FORTH/990
*
*      Modified by DAVE PITTS for:
*      1) CONDITIONAL ASSEMBLY FOR:
*           STANDARD fig-FORTH
*           STANDALONE OPERATION W/ PRINTER OPTION
*           TX/DX OS
*      2) DX10 3.X MACRO ASSEMBLER
*
*      NOTE: The standard and standalone operation supports
*            only an EIA terminal, NOT a 911 or 913 VDT.
*
* The following routines are system dependent and may
* need to be modified for use on a particular system:
*      KEY.............Character input
*      EMIT............Character output
*      ?TERMINAL.......Test for BREAK key
*      R/W.............Disk I/O interface
*
************************************************************
       DEF     FORENT,FOREND
*
       DXOP     IN,1
       DXOP     OUT,2
       DXOP     SVC,15
*
* REGISTER EQUATES
*
R0     EQU  0
R1     EQU  1
R2     EQU  2
R3     EQU  3
R4     EQU  4
R5     EQU  5
R6     EQU  6
R7     EQU  7
R8     EQU  8
R9     EQU  9
R10    EQU  10
R11    EQU  11
R12    EQU  12
R13    EQU  13
R14    EQU  14
R15    EQU  15
*
* CONFIGURATION PARAMETERS
*
*  STANDARD fig-FORTH = 0
*
STD    EQU     0
*
*  STAND ALONE = 1
*
SA     EQU     1
*
*  TX/DX OS = 2
*
OS     EQU     2
*
* SELECT SYSTEM TYPE
*
SYSTEM EQU     SA              SYSTEM TYPE
*
YES    EQU     1
NO     EQU     0
*
* SELECT IF PRINTER
*
PRINTR EQU     YES
*
TRMADD EQU     >000            TERMINAL CRU BASE (NON-OS SYSTEMS)
PRTCRU EQU     >040            DEFAULT PRINTER CRU BASE
TMLUNO EQU     0               TERMINAL LUNO (OS SYSTEMS)
PTLUNO EQU     10              PRINTER LUNO (OS SYSTEMS)
DKLUNO EQU     15              DISK LUNO (OS SYSTEMS)
SECSIZ EQU     128             DISK SECTOR SIZE
SECTRK EQU     26              SECTORS/TRACK
TRKDSK EQU     77              TRACKS/DISK
DSKCRU EQU     >080            DISK CRU ADDRESS (SA SYSTEMS)
       PAGE
*
* SYSTEM PARAMETERS
*
DUPLEX EQU     >22             FULL/HALF DUPLEX
ZRAM   EQU     >2000           START OF RAM
ZROM   EQU     >300            START OF ROM
SYSBYT EQU     22              # BYTES FOR SYSTEM VARS.
ZCR    EQU     >0D             CARRIAGE RETURN
ZPEROD EQU     '.'             PERIOD
ZFF    EQU     >0C             FORM FEED
ZLF    EQU     >0A             LINE FEED
ZRUB   EQU     >08             RUBOUT (DEL on VT100)
ZBELL  EQU     >07             BELL
ZSPACE EQU     ' '             SPACE
ZLNLEN EQU     80+1            LINE LENGTH
ZDQOTE EQU     '"'             DBL. QUOTE
ZRPARN EQU     ')'             RGT. PAREN.
ZSLASH EQU     '/'             SLASH
ZZERO  EQU     '0'
ZMINUS EQU     '-'
ZLETI  EQU     'I'
ZLETO  EQU     'O'
ZXON   EQU     >11             X-ON
ZXOFF  EQU     >13             X-OFF
*
* REGISTERS
*
ZCRU   EQU     12              CRU BASE
ZW     EQU     10              CODE RETURN POINTER
ZR     EQU     9               RETURN STACK POINTER
ZIP    EQU     8               INSTRUCTION POINTER
ZSP    EQU     7               PARAMETER STACK POINTER
ZNEXT  EQU     6               NEXT POINTER
ZTEMP1 EQU     5               TEMP 1
ZTEMP2 EQU     4               TEMP 2
ZTEMP3 EQU     3               TEMP 3
*
* EIA EQUATES
*
TTYI   EQU     0               FOR BREAK DETECTION
DTR    EQU     9               DATA TERMINAL READY
RTS    EQU     10              REQUEST TO SEND
WRQ    EQU     11              WRITE REQUEST
RRQ    EQU     12              READ REQUEST
       PAGE
*
       ASMIF   SYSTEM=STD
         AORG  ZROM
       ASMEND
*
* STARTING POINT
*
FORENT
ORIG
       ASMIF   SYSTEM=OS
         DATA  MAINWS,MAIN1,0
       ASMELS
         B     @MAIN1          COLD START
         B     @MAIN2          WARM START
       ASMEND
*
* INITIALIZATION TABLE
*
       DATA    9900,1          CPU TYPE, REVISION
XBS    DATA    ZRUB
UP     DATA    USER0           USER VARIABLE POINTER
* INITIAL VALUES FOR USER VARIABLES
XUSER0 DATA    0,0,0
XSP    DATA    STAX            BASE OF THE STACK
XR     DATA    RSTAX           BASE OF THE RETURN STACK
XTIB   DATA    STAX            TERMINAL INPUT BUFFER
XWIDTH DATA    31              NAME WIDTH
XWARNG DATA    0               NO DISK YET
XFENCE DATA    VEND            PROTECTED DICTIONARY
XGDP   DATA    LOWRAM          COLD START DP
XGVLNK DATA    FORLNK
*
* VARIOUS SYSTEM CONSTANTS
*
XNEXT  DATA    NEXT
XIPC   DATA    COLD+2          COLD VALUE FOR IP
XIPW   DATA    ABORT           WARM VALUE FOR IP
XVCLNK DATA    FORLNK          COLD START FOR VOC-LINK
XVLINK DATA    VLINK           COLD START FOR VOC POINTER
       PAGE
*
* COLD START ENTRY POINT
*
MAIN1

       ASMIF   SYSTEM<OS
         LIMI  0               INHIBIT INTERRUPTS
         LWPI  MAINWS          POINT TO WORKSPACE
       ASMEND

       ASMIF   SYSTEM=SA
         CLR   @GSKEW          SET NO SKEW
         LI    ZCRU,TRMADD     INITIALIZE EIA I/F
         MOV   ZCRU,@GPRTBS    SET DEFAULT OUTPUT BASE
         SBO   DTR
         SBO   RTS
       ASMEND
       ASMIF   PRINTR=YES&SYSTEM=SA
         LI    ZCRU,PRTCRU     INITIALIZE PRINTER I/F
         SBO   DTR
         SBO   RTS
       ASMEND

       MOV     @XIPC,ZIP
       MOV     @XVLINK,@FORLNK+2       RESET VOC POINTER

       ASMIF   SYSTEM<OS
*
* CONFIGURE THE NUMBER OF BUFFERS AVAILABLE BASED ON THE AVAILABLE
* MEMORY (DYNAMIC ALLOCATION)
*
         LI    ZTEMP1,ZBUFF    BUFFERS BEGINNING
SEARCH
         AI    ZTEMP1,128+4    BYTES/BUFFER + OVERHEAD
         MOV   *ZTEMP1,ZTEMP2  GET CONTENTS
         INV   *ZTEMP1         TRY TO FLIP IT
         C     *ZTEMP1,ZTEMP2  IF IT FLIPPED THEN
         JNE   SEARCH             KEEP SEARCHING
* NON-EXISTANT MEMORY ENCOUNTERED
         AI    ZTEMP1,-132     BACK UP TO LAST GOOD LOC
         MOV   ZTEMP1,@ENDROM  SAVE DEBUG POINTER
         MOV   ZTEMP1,@HI+2    SAVE HI ADDRESS
         MOV   ZTEMP1,@LIMIT+2 SAVE NEW LIMIT
         JMP   START
*
* WARM START ENTRY
*
MAIN2
         LIMI  0
         LWPI  MAINWS
         MOV   @XIPW,ZIP
       ASMEND

*
START
       MOV     @XSP,ZSP
       MOV     @XR,ZR
       MOV     @XNEXT,ZNEXT

       ASMIF   SYSTEM=STD
         CLR   @DUPLEX         SET HALF DUPLEX
       ASMEND

NEXT
       MOV     *ZIP+,ZW
       MOV     *ZW+,ZTEMP1     ZW POINTS TO PFA !!
       B       *ZTEMP1
       PAGE
*
* START OF DICTIONARY
*
       BYTE    >83
       TEXT    'LI'
       BYTE    'T'+>80
       DATA    0               END OF LINK LIST
LIT
       DATA    $+2
       DECT    ZSP
       MOV     *ZIP+,*ZSP      PICKUP & STORE LITERAL
       B       *ZNEXT
*
       BYTE    >87
       TEXT    'EXECUT'
       BYTE    'E'+>80
       DATA    LIT-6
EXEC
       DATA    $+2
       MOV     *ZSP+,ZW        GET ADDRESS
       MOV     *ZW+,ZTEMP1
       B       *ZTEMP1         GO DO IT
*
       BYTE    >86
       TEXT    'BRANCH'
       BYTE    >A0
       DATA    EXEC-10
BRAN
       DATA    $+2
BRAN2
       A       *ZIP,ZIP        COMPUTE FINAL ADDRESS
       B       *ZNEXT          TRANSFER
*
       BYTE    >87
       TEXT    '0BRANC'
       BYTE    'H'+>80
       DATA    BRAN-10
ZBRAN
       DATA    $+2
       MOV     *ZSP,*ZSP+      CONDITIONAL BRANCH
       JEQ     BRAN2
BUMP
       INCT    ZIP
       B       *ZNEXT
*
       BYTE    >86
       TEXT    '(LOOP)'
       BYTE    >A0
       DATA    ZBRAN-10
LOOP
       DATA    $+2
       INC     *ZR
       JMP     PLOP1
*
       BYTE    >87
       TEXT    '(+LOOP'
       BYTE    ')'+>80
       DATA    LOOP-10
PLOOP
       DATA    $+2
       MOV     *ZSP+,ZTEMP1
       A       ZTEMP1,*ZR      ADD LOOP INDEX
       MOV     ZTEMP1,ZTEMP1   CHECK DIRECTION
       JLT     PLOP2
PLOP1
       C       *ZR,@2(ZR)      CHECK LIMIT
       JLT     BRAN2
       JMP     PLOP5           EXIT
PLOP2
       C       *ZR,@2(ZR)
       JGT     BRAN2
PLOP5
       AI      ZR,4            DROP LOOP ADDRESS
       JMP     BUMP
*
       BYTE    >84
       TEXT    '(DO)'
       BYTE    >A0
       DATA    PLOOP-10
DO
       DATA    $+2
       AI      ZR,-4
       MOV     *ZSP+,*ZR       PUSH TERMINAL VALUE
       MOV     *ZSP+,@2(ZR)    PUSH INITIAL VALUE
       B       *ZNEXT
*
       BYTE    >81
       BYTE    'I'+>80
       DATA    DO-8
I
       DATA    $+2
       DECT    ZSP
       MOV     *ZR,*ZSP        GET INNER LOOP INDEX
       B       *ZNEXT
*
       BYTE    >81
       BYTE    'J'+>80
       DATA    I-4
J
       DATA    $+2
       DECT    ZSP
       MOV     @4(ZR),*ZSP     GET OUTER LOOP INDEX
       B       *ZNEXT
*
       BYTE    >85
       TEXT    'DIGI'
       BYTE    'T'+>80
       DATA    J-4
DIGIT
       DATA    $+2
       MOV     *ZSP+,ZTEMP1    BASE
       MOV     *ZSP,ZTEMP2
       AI      ZTEMP2,->30
       CI      ZTEMP2,10
       JL      DIG1
       AI      ZTEMP2,-7       HEX
       CI      ZTEMP2,10
XTEN   EQU     $-2
       JHE     DIG1
DIG3
       CLR     *ZSP            BAD RANGE
       B       *ZNEXT
DIG1
       C       ZTEMP2,ZTEMP1
       JHE     DIG3
       MOV     ZTEMP2,*ZSP
       DECT    ZSP
       MOV     @XTRUE,*ZSP
       B       *ZNEXT
*
       ASMIF   SYSTEM=OS
         BYTE  >83
         TEXT  'BY'
         BYTE  'E'+>80
         DATA  DIGIT-8
BYE
         DATA  $+2
         LI    R1,>0100+TMLUNO
         ABS   @TRMOPN         IF TERMINAL IS OPEN THEN
         JLT   BYE010
         MOV   R1,@TRMOPC         CLOSE TERMINAL
         SVC   @TRMSCB
BYE010
         ABS   @DSKOPN         IF DISK IS OPEN THEN
         JLT   BYE020
         MOVB  R1,@DSKOPC         CLOSE DISK
         SVC   @DSKSCB
BYE020
         LI    R1,>0100+PTLUNO
         ABS   @PRTOPN         IF PRINTER IS OPEN THEN
         JLT   BYE030
         MOV   R1,@TRMOPC         CLOSE PRINTER
         SVC   @TRMSCB
BYE030
         SVC   @EOT            TERMINATE FORTH
EOT
         DATA  >1600
       ASMEND
*
       BYTE    >86
       TEXT    '(FIND)'
       BYTE    >A0
       ASMIF   SYSTEM=OS
         DATA  BYE-6
       ASMELS
         DATA  DIGIT-8
       ASMEND
PFIND
       DATA    $+2
       MOV     *ZSP,ZTEMP1     NFA
       CLR     *ZSP
       CLR     ZW
PF1
       MOV     @2(ZSP),ZTEMP2  STRING
       MOVB    *ZTEMP1,@1(ZSP) STACK THE COUNT BYTE
       MOVB    *ZTEMP1+,ZW
       MOVB    *ZTEMP2+,ZTEMP3
       XOR     ZW,ZTEMP3
       ANDI    ZTEMP3,>3F00    CLEAR LOW BYTE
       SLA     ZTEMP3,1        CLEAR CARRY
       JNE     PF3
PF2
       MOVB    *ZTEMP1+,ZW
       MOVB    *ZTEMP2+,ZTEMP3
       XOR     ZW,ZTEMP3
       SLA     ZTEMP3,1        SAVE SIGN AS CARRY
       JNE     PF25
       JNC     PF2
*
       AI      ZTEMP1,4        FOUND IT
       MOV     ZTEMP1,@2(ZSP)
       DECT    ZSP
       MOV     @XTRUE,*ZSP
       B       *ZNEXT
*
PF25
       JOC     PF35
PF3
       MOVB    *ZTEMP1+,ZW     SKIP REMAINDER OF WORD
       JGT     PF3
PF35
       MOV     *ZTEMP1,ZTEMP1  POINT TO NEXT WORD
       JNE     PF1
       INCT    ZSP             END OF LIST
       CLR     *ZSP
       B       *ZNEXT          FAILURE EXIT
*
       BYTE    >87
       TEXT    'ENCLOS'
       BYTE    'E'+>80
       DATA    PFIND-10
ENCL
       DATA    $+2
       MOV     *ZSP+,ZTEMP1    DELIMITER
       MOV     *ZSP,ZTEMP2     ADDRESS
       SWPB    ZTEMP1
       SETO    ZTEMP3          COUNTER
ENC1
       INC     ZTEMP3
       CB      ZTEMP1,*ZTEMP2+
       JEQ     ENC1            SKIP INITIAL DELIMITERS
       DEC     ZTEMP2
       AI      ZSP,-6
       MOV     ZTEMP3,@4(ZSP)  FIRST CHAR
       MOV     ZTEMP3,*ZSP     NEXT CHAR TO ANALYZE
       INC     ZTEMP3
       MOV     ZTEMP3,@2(ZSP)  END OF WORD
       MOVB    *ZTEMP2,*ZTEMP2 CHECK FOR NULL WORD
       JNE     ENC4
       B       *ZNEXT
ENC4
       INC     ZTEMP2
ENC2
       MOV     ZTEMP3,@2(ZSP)
       MOVB    *ZTEMP2,*ZTEMP2
       JEQ     ENC3
       INC     ZTEMP3
       CB      ZTEMP1,*ZTEMP2+
       JNE     ENC2
ENC3
       MOV     ZTEMP3,*ZSP
       B       *ZNEXT
       PAGE
*
* KEY, EMIT, CR, ?TERMINAL ARE HERE
*
       BYTE    >83
       TEXT    'KE'
       BYTE    'Y'+>80
       DATA    ENCL-10
KEY
       DATA    $+2
       DECT    ZSP             MAKE ROOM
       CLR     *ZSP

       ASMIF   SYSTEM=STD
         IN    *ZSP
       ASMEND

       ASMIF   SYSTEM=SA
         LI    ZCRU,TRMADD     SET TERMINAL ADDRESS
         CLR   ZTEMP1
         TB    RRQ
         JNE   $-2
         STCR  ZTEMP1,8
         SBZ   RRQ
         CI    ZTEMP1,>7F00
         JNE   KEY005
         LI    ZTEMP1,>0800
KEY005   MOVB  ZTEMP1,*ZSP
       ASMEND

       ASMIF   SYSTEM=OS
         ABS   @TRMOPN         IF TERMINAL NOT OPEN THEN
         JGT   KEY010
         BL    @OPNTRM            OPEN IT
KEY010
         MOV   R15,R15         IF BUFFER EMPTY THEN
         JNE   KEY020
         LI    R1,>0900           SET READ ON LUNO 0
READOP   EQU   $-2
         MOVB  R1,@TRMOPC
         LI    R2,TBUFIN          SET BUFFER ADDRESS
         MOV   R2,@TRMBUF
         SVC   @TRMSCB            READ LINE
         MOV   @TRMCHC,R15        GET CHARACTER COUNT
         MOVB  @XCR,@TBUFIN(R15)  SET A C.R.
         INC   R15
KEY020
         MOVB  *R2+,*ZSP       GET A CHAR FROM THE BUFFER
         DEC   R15
       ASMEND

       SWPB    *ZSP
       B       *ZNEXT
*
       BYTE    >84
       TEXT    'EMIT'
       BYTE    >A0
       DATA    KEY-6
EMIT
       DATA    $+2
       SWPB    *ZSP            POSITION CHAR

       ASMIF   SYSTEM=STD
         OUT   *ZSP+           OUTPUT IT
       ASMEND

       ASMIF   SYSTEM=SA
         MOV   @GPRTBS,ZCRU    SET TERMINAL ADDRESS
         LDCR  *ZSP,8          OUTPUT CHAR
         INCT  ZSP
         TB    WRQ
         JNE   $-2
         SBZ   WRQ
         TB    RRQ             SEE IF CHARACTER AT I/F
         JNE   EMI020
         STCR  R1,8            THERE IS, GET IT
         SBZ   RRQ
         SRL   R1,8
         CI    R1,ZXOFF        IF XOFF THEN
         JNE   EMI020
EMI010
         TB    RRQ                WAIT FOR XON
         JNE   $-2
         STCR  R1,8
         SBZ   RRQ
         SRL   R1,8
         CI    R1,ZXON
         JNE   EMI010
EMI020
       ASMEND

       ASMIF   SYSTEM=OS
         MOV   @GPRTBS,R1      IF PBASE IS SET
         JEQ   EMI005
         LI    R1,>0300+PTLUNO
         ABS   @PRTOPN            USE PRINTER LUN
         JGT   EMI010
         JMP   EMI007
EMI005
         LI    R1,TMLUNO
         ABS   @TRMOPN         IF TERMINAL NOT OPEN THEN
         JGT   EMI010
EMI007
         BL    @OPNTRM            OPEN IT
EMI010
         SB    R1,R1
         AI    R1,>0B00
WRITOP   EQU   $-2
         MOV   R1,@TRMOPC
         MOVB  *ZSP,R1         GET CHAR
         INCT  ZSP
         MOVB  R1,*R13+
         INC   R14
         CI    R14,ZLNLEN-2    IF COUNT >= LINELEN OR
         JNE   EMI015
         MOVB  @XCR,*R13+
         MOVB  @XLF,*R13
         INCT  R14
         JMP   EMI017
EMI015
         CB    R1,@XLF            CHAR = L.F. THEN
         JNE   EMI020
EMI017
         MOV   R14,@TRMCHC        WRITE OUT CURRENT BUFFER
         JEQ   EMI020
         LI    R13,TBUFOU
         MOV   R13,@TRMBUF
         SVC   @TRMSCB            OUTPUT BUFFER
         CLR   R14
         CLR   @GOUT
EMI020
       ASMEND

       INC     @GOUT
       B       *ZNEXT
*
       ASMIF   SYSTEM=OS
OPNTRM
         AI    R1,0            OPEN TERMINAL
OPENOP   EQU   $-2
         MOV   R1,@TRMOPC
         SVC   @TRMSCB
         CLR   R15             INPUT CHAR COUNT
         CLR   R14             OUTPUT CHAR COUNT
         LI    R13,TBUFOU      POINT TO OUTPUT BUFFER
         RT
       ASMEND
*
       BYTE    >82
       TEXT    'CR'
       BYTE    >A0
       DATA    EMIT-8
CR
       DATA    DOCOL,PTYPE
       BYTE    2               ISSUE <CR> <LF>
XCR    BYTE    ZCR
XLF    BYTE    ZLF,0
       DATA    SEMIS
*
       BYTE    >89
       TEXT    '?TERMINA'
       BYTE    'L'+>80
       DATA    CR-6
QTERM
       DATA    $+2
       CLR     R0

       ASMIF   SYSTEM=OS
         SVC   @GETEVT
         MOVB  @GETEVT+1,R1
         JNE   NOBRK
         CB    @EVTCHR,@CMDKEY
         JNE   NOBRK
       ASMELS
         LI    ZCRU,TRMADD     SET TERMINAL ADDRESS
         TB    TTYI            TEST FOR BREAK
         JEQ   NOBRK
         TB    TTYI
         JNE   $-4             WAIT FOR END
       ASMEND

       INC     R0
NOBRK
       DECT    ZSP
       MOV     R0,*ZSP
       B       *ZNEXT
*
       BYTE    >85
       TEXT    'CMOV'
       BYTE    'E'+>80
       DATA    QTERM-12
CMOVE
       DATA    $+2
       MOV     *ZSP+,ZTEMP1
       MOV     *ZSP+,ZTEMP2
       MOV     *ZSP+,ZTEMP3    COUNT, DEST, SOURCE
       MOV     ZTEMP1,ZTEMP1
       JEQ     CM1
CM2
       MOVB    *ZTEMP3+,*ZTEMP2+
       DEC     ZTEMP1
       JNE     CM2
CM1
       B       *ZNEXT
*
       BYTE    >82
       TEXT    'U*'
       BYTE    >A0
       DATA    CMOVE-8
MULT
       DATA    $+2
       MOV     *ZSP+,ZTEMP2
       MPY     *ZSP,ZTEMP2     UNSIGNED MULTIPLY
       MOV     ZTEMP2+1,*ZSP
       DECT    ZSP
       MOV     ZTEMP2,*ZSP
       B       *ZNEXT
*
       BYTE    >82
       TEXT    'U/'
       BYTE    >A0
       DATA    MULT-6
DIV
       DATA    $+2
       MOV     @2(ZSP),ZTEMP2
       MOV     @4(ZSP),ZTEMP2+1
       DIV     *ZSP+,ZTEMP2    UNSIGNED DIVIDE
       MOV     ZTEMP2,*ZSP
       MOV     ZTEMP2+1,@2(ZSP)
       B       *ZNEXT
*
       BYTE    >83
       TEXT    'AN'
       BYTE    'D'+>80
       DATA    DIV-6
AND
       DATA    $+2
       INV     *ZSP            LOGICAL NOT
       SZC     *ZSP+,*ZSP      LOGICAL NOT AND
       B       *ZNEXT
*
       BYTE    >82
       TEXT    'OR'
       BYTE    >A0
       DATA    AND-6
OR
       DATA    $+2
       SOC     *ZSP+,*ZSP      LOGICAL OR
       B       *ZNEXT
*
       BYTE    >83
       TEXT    'XO'
       BYTE    'R'+>80
       DATA    OR-6
XOR
       DATA    $+2
       MOV     *ZSP+,ZTEMP1
       XOR     *ZSP,ZTEMP1     LOGICAL EXCLUSIVE OR
       MOV     ZTEMP1,*ZSP
       B       *ZNEXT
*
       BYTE    >83
       TEXT    'SP'
       BYTE    '@'+>80
       DATA    XOR-6
SPAT
       DATA    $+2
       DECT    ZSP
       MOV     ZSP,*ZSP        PUSH STACK POINTER
       INCT    *ZSP
       B       *ZNEXT
*
       BYTE    >83
       TEXT    'SP'
       BYTE    '!'+>80
       DATA    SPAT-6
SPSTOR
       DATA    $+2
       MOV     @UP,ZTEMP1      INIT STACK POINTER
       MOV     @GSZERO-USER0(ZTEMP1),ZSP
       B       *ZNEXT
*
       BYTE    >83
       TEXT    'RP'
       BYTE    '!'+>80
       DATA    SPSTOR-6
RPSTOR
       DATA    $+2
       MOV     @UP,ZTEMP1      INIT RETURN POINTER
       MOV     @GRZERO-USER0(ZTEMP1),ZR
       B       *ZNEXT
*
       BYTE    >82
       TEXT    ';S'
       BYTE    >A0
       DATA    RPSTOR-6
SEMIS
       DATA    $+2
       MOV     *ZR+,ZIP        GET RETURN
       B       *ZNEXT
*
       BYTE    >85
       TEXT    'LEAV'
       BYTE    'E'+>80
       DATA    SEMIS-6
LEAVE
       DATA    $+2
       MOV     *ZR,@2(ZR)      FORCE EXIT
       B       *ZNEXT
*
       BYTE    >82
       TEXT    '>R'
       BYTE    >A0
       DATA    LEAVE-8
TOR
       DATA    $+2
       DECT    ZR
       MOV     *ZSP+,*ZR       MOVE STACK TO RETURN
       B       *ZNEXT
*
       BYTE    >82
       TEXT    'R>'
       BYTE    >A0
       DATA    TOR-6
FROMR
       DATA    $+2
       DECT    ZSP
       MOV     *ZR+,*ZSP       MOVE RETURN TO STACK
       B       *ZNEXT
*
       BYTE    >81
       BYTE    'R'+>80
       DATA    FROMR-6
R
       DATA    $+2
       DECT    ZSP
       MOV     *ZR,*ZSP        COPY RETURN TO STACK
       B       *ZNEXT
*
       BYTE    >82
       TEXT    '0='
       BYTE    >A0
       DATA    R-4
ZEQU
       DATA    $+2
       MOV     *ZSP,*ZSP       TEST FOR EQUAL TO ZERO
       JEQ     PSHTR
       JMP     PSHFL
*
       BYTE    >82
       TEXT    '0<'
       BYTE    >A0
       DATA    ZEQU-6
ZLESS
       DATA    $+2
       MOV     *ZSP,*ZSP       TEST FOR LESS THAN ZERO
       JLT     PSHTR
PSHFL
       CLR     *ZSP
       B       *ZNEXT
PSHTR
       MOV     @XTRUE,*ZSP
       B       *ZNEXT
*
       BYTE    >81
       BYTE    '+'+>80
       DATA    ZLESS-6
PLUS
       DATA    $+2
       A       *ZSP+,*ZSP      ADD TWO ITEMS
       B       *ZNEXT
*
       BYTE    >82
       TEXT    'D+'
       BYTE    >A0
       DATA    PLUS-4
DPLUS
       DATA    $+2
       A       *ZSP+,@2(ZSP)   DOUBLE PRECISION ADD
       A       *ZSP+,@2(ZSP)
       JNC     DP1
       INC     *ZSP
DP1
       B       *ZNEXT
*
       BYTE    >85
       TEXT    'MINU'
       BYTE    'S'+>80
       DATA    DPLUS-6
MINUS
       DATA    $+2
       NEG     *ZSP            NEGATE TOP
       B       *ZNEXT
*
       BYTE    >86
       TEXT    'DMINUS'
       BYTE    >A0
       DATA    MINUS-8
DMINUS
       DATA    $+2
       INV     @2(ZSP)         DOUBLE PRECISION NEGATE
       INV     *ZSP
       INC     @2(ZSP)
       JNC     DM1
       INC     *ZSP            UNDERFLOW
DM1
       B       *ZNEXT
*
       BYTE    >84
       TEXT    'OVER'
       BYTE    >A0
       DATA    DMINUS-10
OVER
       DATA    $+2
       DECT    ZSP
       MOV     @4(ZSP),*ZSP    N1 N2 -> N1 N2 N1
       B       *ZNEXT
*
       BYTE    >84
       TEXT    'DROP'
       BYTE    >A0
       DATA    OVER-8
DROP
       DATA    $+2
       INCT    ZSP             N1 N2 -> N1
       B       *ZNEXT
*
       BYTE    >84
       TEXT    'SWAP'
       BYTE    >A0
       DATA    DROP-8
SWAP
       DATA    $+2
       MOV     *ZSP,ZTEMP1
       MOV     @2(ZSP),*ZSP    N1 N2 -> N2 N1
       MOV     ZTEMP1,@2(ZSP)
       B       *ZNEXT
*
       BYTE    >83
       TEXT    'DU'
       BYTE    'P'+>80
       DATA    SWAP-8
DUP
       DATA    $+2
       DECT    ZSP
       MOV     @2(ZSP),*ZSP    N -> N N
       B       *ZNEXT
*
       BYTE    >82
       TEXT    '+!'
       BYTE    >A0
       DATA    DUP-6
PSTORE
       DATA    $+2
       MOV     *ZSP+,ZTEMP1
       A       *ZSP+,*ZTEMP1   ADD STACK TO MEMORY
       B       *ZNEXT
*
       BYTE    >86
       TEXT    'TOGGLE'
       BYTE    >A0
       DATA    PSTORE-6
TOGGLE
       DATA    $+2
       MOV     *ZSP+,ZTEMP1    VALUE
       MOV     *ZSP+,ZTEMP2    ADDRESS
       MOVB    *ZTEMP2,ZTEMP3
       SWPB    ZTEMP1
       XOR     ZTEMP1,ZTEMP3
       MOVB    ZTEMP3,*ZTEMP2
       B       *ZNEXT
*
       BYTE    >81
       BYTE    '@'+>80
       DATA    TOGGLE-10
AT
       DATA    $+2
       MOV     *ZSP,ZTEMP1     GET ADDRESS
       MOV     *ZTEMP1,*ZSP    GET CONTENTS
       B       *ZNEXT
*
       BYTE    >82
       TEXT    'C@'
       BYTE    >A0
       DATA    AT-4
CAT
       DATA    $+2
       MOV     *ZSP,ZTEMP1
       MOVB    *ZTEMP1,ZTEMP1
       SRL     ZTEMP1,8
       MOV     ZTEMP1,*ZSP     CHARACTERS IN LOW BYTE
       B       *ZNEXT
*
       BYTE    >81
       BYTE    '!'+>80
       DATA    CAT-6
STORE
       DATA    $+2
       MOV     *ZSP+,ZTEMP1    GET ADDRESS
       MOV     *ZSP+,*ZTEMP1   STORE VALUE
       B       *ZNEXT
*
       BYTE    >82
       TEXT    'C!'
       BYTE    >A0
       DATA    STORE-4
CSTORE
       DATA    $+2
       MOV     *ZSP+,ZTEMP1
       MOVB    @1(ZSP),*ZTEMP1 STORE CHARACTER
       INCT    ZSP
       B       *ZNEXT
*
       BYTE    >81
       BYTE    ':'+>80
       DATA    CSTORE-6
COLON
       DATA    DOCOL,QEXEC,STRCSP,CURR,AT,CONT
       DATA    STORE,CREATE,RTBKT,PSCODE
DOCOL
       DECT    ZR              BASIC
       MOV     ZIP,*ZR
       MOV     ZW,ZIP
       B       *ZNEXT
*
       BYTE    >C1
       BYTE    ';'+>80
       DATA    COLON-4
SEMI
       DATA    DOCOL,QCSP,COMPI,SEMIS,SMUDGE,LBKT,SEMIS
*
       BYTE    >88
       TEXT    'CONSTANT'
       BYTE    >A0
       DATA    SEMI-4
CON
       DATA    DOCOL,CREATE,SMUDGE,COMMA,PSCODE
DOCON
       DECT    ZSP             BASIC
       MOV     *ZW,*ZSP        PUSH CONSTANT
       B       *ZNEXT
*
       BYTE    >88
       TEXT    'VARIABLE'
       BYTE    >A0
       DATA    CON-12
VAR
       DATA    DOCOL,CON,PSCODE
DOVAR
       DECT    ZSP
       MOV     ZW,*ZSP         PUSH ADDRESS
       B       *ZNEXT
*
       BYTE    >84
       TEXT    'USER'
       BYTE    >A0
       DATA    VAR-12
USER
       DATA    DOCOL,CON,PSCODE
DOUSER
       DECT    ZSP
       MOV     *ZW,*ZSP
       A       @UP,*ZSP
       B       *ZNEXT
*
       BYTE    >87
       TEXT    '<BUILD'
       BYTE    'S'+>80
       DATA    USER-8
BUILDS
       DATA    DOCOL,ZERO,CON,SEMIS
*
       BYTE    >85
       TEXT    'DOES'
       BYTE    '>'+>80
       DATA    BUILDS-10
DOES
       DATA    DOCOL,FROMR,LATEST,PFA,STORE,PSCODE
* OUT OF ORDER DUE TO SHORT JUMP
DODOES
       DECT    ZSP
       MOV     ZW,*ZSP
       INCT    *ZSP
       MOV     *ZW,ZW
       JMP     DOCOL
*
       BYTE    >81
       BYTE    '0'+>80
       DATA    DOES-8
ZERO
       DATA    DOCON,0
*
       BYTE    >81
       BYTE    '1'+>80
       DATA    ZERO-4
ONE
       DATA    DOCON
X1W
XTRUE
       DATA    1
*
       BYTE    >81
       BYTE    '2'+>80
       DATA    ONE-4
TWO
       DATA    DOCON,2
*
       BYTE    >81
       BYTE    '3'+>80
       DATA    TWO-4
THREE
       DATA    DOCON,3
*
       BYTE    >82
       TEXT    'BL'
       BYTE    >A0
       DATA    THREE-4
BL
       DATA    DOCON,ZSPACE
*
       BYTE    >83
       TEXT    'C/'
       BYTE    'L'+>80
       DATA    BL-6
CL
       DATA    DOCON,64
*
       BYTE    >85
       TEXT    'FIRS'
       BYTE    'T'+>80
       DATA    CL-6
FIRST
       DATA    DOCON,ZBUFF
*
       BYTE    >85
       TEXT    'LIMI'
       BYTE    'T'+>80
       DATA    FIRST-8
LIMIT
       DATA    DOCON,ZHI
*
       BYTE    >85
       TEXT    'B/BU'
       BYTE    'F'+>80
       DATA    LIMIT-8
BPBUF
       DATA    DOCON,SECSIZ
*
       BYTE    >85
       TEXT    'B/SC'
       BYTE    'R'+>80
       DATA    BPBUF-8
BPSCR
       DATA    DOCON,8
*
       BYTE    >82
       TEXT    'S0'
       BYTE    >A0
       DATA    BPSCR-8
SZERO
       DATA    DOUSER,GSZERO-USER0
*
       BYTE    >82
       TEXT    'R0'
       BYTE    >A0
       DATA    SZERO-6
RZERO
       DATA    DOUSER,GRZERO-USER0
*
       BYTE    >83
       TEXT    'TI'
       BYTE    'B'+>80
       DATA    RZERO-6
TIB
       DATA    DOUSER,GTIB-USER0
*
       BYTE    >85
       TEXT    'WIDT'
       BYTE    'H'+>80
       DATA    TIB-6
WIDTH
       DATA    DOUSER,GWIDTH-USER0
*
       BYTE    >87
       TEXT    'WARNIN'
       BYTE    'G'+>80
       DATA    WIDTH-8
WARNG
       DATA    DOUSER,GWARNG-USER0
*
       BYTE    >85
       TEXT    'FENC'
       BYTE    'E'+>80
       DATA    WARNG-10
FENCE
       DATA    DOUSER,GFENCE-USER0
*
       BYTE    >82
       TEXT    'DP'
       BYTE    >A0
       DATA    FENCE-8
DP
       DATA    DOUSER,GDP-USER0
*
       BYTE    >88
       TEXT    'VOC-LINK'
       BYTE    >A0
       DATA    DP-6
VOCLNK
       DATA    DOUSER,GVLNK-USER0
*
       BYTE    >83
       TEXT    'BL'
       BYTE    'K'+>80
       DATA    VOCLNK-12
BLK
       DATA    DOUSER,GBLK-USER0
*
       BYTE    >82
       TEXT    'IN'
       BYTE    >A0
       DATA    BLK-6
IN
       DATA    DOUSER,GIN-USER0
*
       BYTE    >83
       TEXT    'OU'
       BYTE    'T'+>80
       DATA    IN-6
OUT
       DATA    DOUSER,GOUT-USER0
*
       BYTE    >83
       TEXT    'SC'
       BYTE    'R'+>80
       DATA    OUT-6
SCR
       DATA    DOUSER,GSCR-USER0
*
       BYTE    >86
       TEXT    'OFFSET'
       BYTE    >A0
       DATA    SCR-6
OFFSET
       DATA    DOUSER,GOFSET-USER0
*
       BYTE    >84
       TEXT    'SKEW'
       BYTE    >A0
       DATA    OFFSET-10
SKEW
       DATA    DOUSER,GSKEW-USER0
*
       BYTE    >87
       TEXT    'CONTEX'
       BYTE    'T'+>80
       DATA    SKEW-8
CONT
       DATA    DOUSER,GCONT-USER0
*
       BYTE    >87
       TEXT    'CURREN'
       BYTE    'T'+>80
       DATA    CONT-10
CURR
       DATA    DOUSER,GCURR-USER0
*
       BYTE    >85
       TEXT    'STAT'
       BYTE    'E'+>80
       DATA    CURR-10
STATE
       DATA    DOUSER,GSTATE-USER0
*
       BYTE    >84
       TEXT    'BASE'
       BYTE    >A0
       DATA    STATE-8
BASE
       DATA    DOUSER,GBASE-USER0
*
       BYTE    >83
       TEXT    'DP'
       BYTE    'L'+>80
       DATA    BASE-8
DPL
       DATA    DOUSER,GDPL-USER0
*
       BYTE    >83
       TEXT    'FL'
       BYTE    'D'+>80
       DATA    DPL-6
FLD
       DATA    DOUSER,GFLD-USER0
*
       BYTE    >83
       TEXT    'CS'
       BYTE    'P'+>80
       DATA    FLD-6
CSP
       DATA    DOUSER,GCSP-USER0
*
       BYTE    >82
       TEXT    'R#'
       BYTE    >A0
       DATA    CSP-6
RNUM
       DATA    DOUSER,GRNUM-USER0
*
       BYTE    >83
       TEXT    'HL'
       BYTE    'D'+>80
       DATA    RNUM-6
HLD
       DATA    DOUSER,GHLD-USER0
*
       ASMIF   PRINTR=YES
         BYTE  >85
         TEXT  'PBAS'
         BYTE  'E'+>80
         DATA  HLD-6
PBASE
         DATA  DOUSER,GPRTBS-USER0
       ASMEND
*
       BYTE    >82
       TEXT    '1+'
       BYTE    >A0
       ASMIF   PRINTR=YES
         DATA  PBASE-8
       ASMELS
         DATA  HLD-6
       ASMEND
ONEP
       DATA    $+2
       INC     *ZSP            INCREMENT STACK TOP
       B       *ZNEXT
*
       BYTE    >82
       TEXT    '2+'
       BYTE    >A0
       DATA    ONEP-6
TWOP
       DATA    $+2
       INCT    *ZSP            ADD 2 TO STACK TOP
       B       *ZNEXT
*
       BYTE    >84
       TEXT    'HERE'
       BYTE    >A0
       DATA    TWOP-6
HERE
       DATA    DOCOL,DP,AT,SEMIS
*
       BYTE    >85
       TEXT    'ALLO'
       BYTE    'T'+>80
       DATA    HERE-8
ALLOT
       DATA    DOCOL,DP,PSTORE,SEMIS
*
       BYTE    >81
       BYTE    ','+>80
       DATA    ALLOT-8
COMMA
       DATA    DOCOL,HERE,STORE,TWO,ALLOT,SEMIS
*
       BYTE    >82
       TEXT    'C,'
       BYTE    >A0
       DATA    COMMA-4
CCOMMA
       DATA    DOCOL,HERE,CSTORE,ONE,ALLOT,SEMIS
*
* DANGEROUS SINCE MAKES DP ODD
*
       BYTE    >81
       BYTE    '-'+>80
       DATA    CCOMMA-6
SUB
       DATA    $+2
       S       *ZSP+,*ZSP
       B       *ZNEXT
*
       BYTE    >81
       BYTE    '='+>80
       DATA    SUB-4
EQUAL
       DATA    DOCOL,SUB,ZEQU,SEMIS
*
       BYTE    >81
       BYTE    '<'+>80
       DATA    EQUAL-4
LESS
       DATA    DOCOL,SUB,ZLESS,SEMIS
*
       BYTE    >81
       BYTE    '>'+>80
       DATA    LESS-4
GREAT
       DATA    DOCOL,SWAP,SUB,ZLESS,SEMIS
*
       BYTE    >83
       TEXT    'RO'
       BYTE    'T'+>80
       DATA    GREAT-4
ROT
       DATA    DOCOL,TOR,SWAP,FROMR,SWAP,SEMIS
*
       BYTE    >85
       TEXT    'SPAC'
       BYTE    'E'+>80
       DATA    ROT-6
SPACE
       DATA    DOCOL,BL,EMIT,SEMIS
*
       BYTE    >84
       TEXT    '-DUP'
       BYTE    >A0
       DATA    SPACE-8
DDUP
       DATA    DOCOL,DUP,ZBRAN,QDUP1-$,DUP
QDUP1
       DATA    SEMIS
*
       BYTE    >88
       TEXT    'TRAVERSE'
       BYTE    >A0
       DATA    DDUP-8
TRAVRS
       DATA    DOCOL,SWAP
TRA1
       DATA    OVER,PLUS,LIT,>7F,OVER
       DATA    CAT,LESS,ZBRAN,TRA1-$
       DATA    SWAP,DROP,SEMIS
*
       BYTE    >83
       TEXT    'LF'
       BYTE    'A'+>80
       DATA    TRAVRS-12
LFA
       DATA    DOCOL,LIT,4,SUB,SEMIS
*
       BYTE    >83
       TEXT    'CF'
       BYTE    'A'+>80
       DATA    LFA-6
CFA
       DATA    DOCOL,TWO,SUB,SEMIS
*
       BYTE    >83
       TEXT    'NF'
       BYTE    'A'+>80
       DATA    CFA-6
NFA
       DATA    DOCOL,LIT,5,SUB,LIT,-1,TRAVRS,SEMIS
*
       BYTE    >83
       TEXT    'PF'
       BYTE    'A'+>80
       DATA    NFA-6
PFA
       DATA    DOCOL,ONE,TRAVRS,LIT,5,PLUS,SEMIS
*
       BYTE    >86
       TEXT    'LATEST'
       BYTE    >A0
       DATA    PFA-6
LATEST
       DATA    DOCOL,CURR,AT,AT,SEMIS
*
       BYTE    >84
       TEXT    '!CSP'
       BYTE    >A0
       DATA    LATEST-10
STRCSP
       DATA    DOCOL,SPAT,CSP,STORE,SEMIS
*
       BYTE    >86
       TEXT    '?ERROR'
       BYTE    >A0
       DATA    STRCSP-8
QERROR
       DATA    DOCOL,SWAP,ZBRAN,QERR1-$,ERROR,SEMIS
QERR1
       DATA    DROP,SEMIS
*
       BYTE    >85
       TEXT    '?COM'
       BYTE    'P'+>80
       DATA    QERROR-10
QCOMP
       DATA    DOCOL,STATE,AT,ZEQU,LIT,17,QERROR,SEMIS
*
       BYTE    >85
       TEXT    '?EXE'
       BYTE    'C'+>80
       DATA    QCOMP-8
QEXEC
       DATA    DOCOL,STATE,AT,LIT,18,QERROR,SEMIS
*
       BYTE    >86
       TEXT    '?PAIRS'
       BYTE    >A0
       DATA    QEXEC-8
QPAIRS
       DATA    DOCOL,SUB,LIT,19,QERROR,SEMIS
*
       BYTE    >84
       TEXT    '?CSP'
       BYTE    >A0
       DATA    QPAIRS-10
QCSP
       DATA    DOCOL,SPAT,CSP,AT,SUB,LIT,20,QERROR,SEMIS
*
       BYTE    >88
       TEXT    '?LOADING'
       BYTE    >A0
       DATA    QCSP-8
QLOAD
       DATA    DOCOL,BLK,AT,ZEQU,LIT,22,QERROR,SEMIS
*
       BYTE    >87
       TEXT    'COMPIL'
       BYTE    'E'+>80
       DATA    QLOAD-12
COMPI
       DATA    DOCOL,QCOMP,FROMR,DUP,TWOP,TOR,AT,COMMA,SEMIS
*
       BYTE    >C1
       BYTE    '['+>80
       DATA    COMPI-10
LBKT
       DATA    DOCOL,ZERO,STATE,STORE,SEMIS
*
       BYTE    >81
       BYTE    ']'+>80
       DATA    LBKT-4
RTBKT
       DATA    DOCOL,LIT,>C0,STATE,STORE,SEMIS
*
       BYTE    >86
       TEXT    'SMUDGE'
       BYTE    >A0
       DATA    RTBKT-4
SMUDGE
       DATA    DOCOL,LATEST,LIT,>20,TOGGLE,SEMIS
*
       BYTE    >83
       TEXT    'HE'
       BYTE    'X'+>80
       DATA    SMUDGE-10
HEX
       DATA    DOCOL,LIT,16,BASE,STORE,SEMIS
*
       BYTE    >87
       TEXT    'DECIMA'
       BYTE    'L'+>80
       DATA    HEX-6
DEC
       DATA    DOCOL,LIT,10,BASE,STORE,SEMIS
*
       BYTE    >87
       TEXT    '(;CODE'
       BYTE    ')'+>80
       DATA    DEC-10
PSCODE
       DATA    DOCOL,FROMR,LATEST,PFA,CFA,STORE,SEMIS
*
       BYTE    >C5
       TEXT    ';COD'
       BYTE    'E'+>80
       DATA    PSCODE-10
SEMIC
       DATA    DOCOL,QCSP,COMPI,PSCODE,LBKT,SMUDGE,ASSMB
       DATA    SEMIS
*
       BYTE    >85
       TEXT    'COUN'
       BYTE    'T'+>80
       DATA    SEMIC-8
COUNT
       DATA    DOCOL,DUP,ONEP,SWAP,CAT,SEMIS
*
       BYTE    >84
       TEXT    'TYPE'
       BYTE    >A0
       DATA    COUNT-8
TYPE
       DATA    DOCOL,DDUP,ZBRAN,TYP2-$,OVER,PLUS,SWAP,DO
TYP1
       DATA    I,CAT,EMIT,LOOP,TYP1-$,SEMIS
TYP2
       DATA    DROP,SEMIS
*
       BYTE    >89
       TEXT    '-TRAILIN'
       BYTE    'G'+>80
       DATA    TYPE-8
DTRAIL
       DATA    DOCOL,DUP,ZERO,DO
DTRL1
       DATA    OVER,OVER,PLUS,ONE,SUB,CAT,BL,SUB
       DATA    ZBRAN,DTRL2-$,LEAVE,BRAN,DTRL3-$
DTRL2
       DATA    ONE,SUB
DTRL3
       DATA    LOOP,DTRL1-$,SEMIS
*
       BYTE    >84
       TEXT    '(.")'
       BYTE    >A0
       DATA    DTRAIL-12
PTYPE
       DATA    DOCOL,R,COUNT,DUP,ONEP,ECELLS,FROMR,PLUS
       DATA    TOR,TYPE,SEMIS
*
       BYTE    >C2
       TEXT    '."'
       BYTE    >A0
       DATA    PTYPE-8
STRING
       DATA    DOCOL,LIT,ZDQOTE,STATE,AT,ZBRAN,STR1-$
       DATA    COMPI,PTYPE,WORD,HERE,CAT,ONEP
       DATA    ECELLS,ALLOT,SEMIS
STR1
       DATA    WORD,HERE,COUNT,TYPE,SEMIS
*
       BYTE    >86
       TEXT    '?STACK'
       BYTE    >A0
       DATA    STRING-6
QSTACK
       DATA    DOCOL,SPAT,SZERO,AT,GREAT,ONE,QERROR
       DATA    SPAT,HERE,LESS,TWO,QERROR,SEMIS
*
       BYTE    >86
       TEXT    '=CELLS'
       BYTE    >A0
       DATA    QSTACK-10
ECELLS
       DATA    $+2
       INC     *ZSP
       SZC     @X1W,*ZSP       FORCE EVEN ADDRESS
       B       *ZNEXT
*
       BYTE    >86
       TEXT    'EXPECT'
       BYTE    >A0
       DATA    ECELLS-10
EXPECT
       DATA    DOCOL,OVER,PLUS,OVER,DO
EXP1
       DATA    KEY,DUP,LIT,XBS,AT,EQUAL,ZBRAN,EXP2-$
       DATA    DROP,LIT,8,OVER,I,EQUAL,DUP,FROMR,TWO,SUB
       DATA    PLUS,TOR,SUB
       ASMIF   SYSTEM=SA
        DATA   DUP,LIT,8,EQUAL,ZBRAN,EXP1A-$
        DATA   LIT,8,EMIT,LIT,>20,EMIT
EXP1A
       ASMEND
       DATA    BRAN,EXP3-$
EXP2
       DATA    DUP,LIT,ZCR,EQUAL,ZBRAN,EXP4-$

       ASMIF   SYSTEM=OS
        DATA   CR
       ASMEND

       DATA    LEAVE,DROP,BL,ZERO,BRAN,EXP5-$
EXP4
       DATA    DUP
EXP5
       DATA    I,CSTORE,ZERO,I,ONEP,CSTORE,ZERO,I,TWOP
       DATA    CSTORE
EXP3

       ASMIF   SYSTEM=OS
        DATA   DROP
       ASMELS
        DATA   EMIT
       ASMEND

       DATA    LOOP,EXP1-$,DROP,SEMIS
*
       BYTE    >85
       TEXT    'QUER'
       BYTE    'Y'+>80
       DATA    EXPECT-10
QUERY
       DATA    DOCOL,TIB,AT,LIT,ZLNLEN,EXPECT
       DATA    ZERO,IN,STORE,SEMIS
*
       BYTE    >C1
       BYTE    >80
       DATA    QUERY-8
NULL
       DATA    DOCOL,BLK,AT,ZBRAN,NULL2-$,ONE
       DATA    BLK,PSTORE,ZERO,IN,STORE,BLK,AT
       DATA    BPSCR,MOD,ZEQU,ZBRAN,NULL4-$,QEXEC
NULL2
       DATA    FROMR,DROP
NULL4
       DATA    SEMIS
*
       BYTE    >84
       TEXT    'FILL'
       BYTE    >A0
       DATA    NULL-4
FILL
       DATA    DOCOL,SWAP,TOR,OVER,CSTORE,DUP,ONEP
       DATA    FROMR,ONE,SUB,CMOVE,SEMIS
*
       BYTE    >85
       TEXT    'ERAS'
       BYTE    'E'+>80
       DATA    FILL-8
ERASE
       DATA    DOCOL,ZERO,FILL,SEMIS
*
       BYTE    >86
       TEXT    'BLANKS'
       BYTE    >A0
       DATA    ERASE-8
BLANKS
       DATA    DOCOL,BL,FILL,SEMIS
*
       BYTE    >84
       TEXT    'HOLD'
       BYTE    >A0
       DATA    BLANKS-10
HOLD
       DATA    DOCOL,LIT,-1,HLD,PSTORE,HLD,AT,CSTORE,SEMIS
*
       BYTE    >83
       TEXT    'PA'
       BYTE    'D'+>80
       DATA    HOLD-8
PAD
       DATA    DOCOL,HERE,LIT,68,PLUS,SEMIS
*
       BYTE    >84
       TEXT    'WORD'
       BYTE    >A0
       DATA    PAD-6
WORD
       DATA    DOCOL,BLK,AT,ZBRAN,WORD1-$,BLK,AT
       DATA    BLOCK,BRAN,WORD2-$
WORD1
       DATA    TIB,AT
WORD2
       DATA    IN,AT,PLUS,SWAP,ENCL,HERE,LIT,34,BLANKS
       DATA    IN,PSTORE,OVER,SUB,TOR,R,HERE,CSTORE
       DATA    PLUS,HERE,ONEP,FROMR,CMOVE,SEMIS
*
       BYTE    >88
       TEXT    '(NUMBER)'
       BYTE    >A0
       DATA    WORD-8
PNUMB
       DATA    DOCOL
PNUM0
       DATA    ONEP,DUP,TOR,CAT,BASE,AT,DIGIT,ZBRAN
       DATA    PNUM1-$,SWAP,BASE,AT,MULT,DROP,ROT
       DATA    BASE,AT,MULT,DPLUS,DPL,AT,ONEP,ZBRAN
       DATA    PNUM2-$,ONE,DPL,PSTORE
PNUM2
       DATA    FROMR,BRAN,PNUM0-$
PNUM1
       DATA    FROMR,SEMIS
*
       BYTE    >86
       TEXT    'NUMBER'
       BYTE    >A0
       DATA    PNUMB-12
NUMB
       DATA    DOCOL,ZERO,ZERO,ROT,DUP,ONEP,CAT,LIT
       DATA    ZMINUS,EQUAL,DUP,TOR,PLUS,LIT,-1
NUM3
       DATA    DPL,STORE,PNUMB,DUP,CAT,BL,SUB,ZBRAN
       DATA    NUM1-$,DUP,CAT,LIT,ZPEROD,SUB,ZERO
       DATA    QERROR,ZERO,BRAN,NUM3-$
NUM1
       DATA    DROP,FROMR,ZBRAN,NUM2-$,DMINUS
NUM2
       DATA    SEMIS
*
       BYTE    >85
       TEXT    '-FIN'
       BYTE    'D'+>80
       DATA    NUMB-10
DFIND
       DATA    DOCOL,BL,WORD,HERE,CONT,AT,AT,PFIND,DUP
       DATA    ZEQU,ZBRAN,PTIC1-$,DROP,HERE,LATEST,PFIND
PTIC1
       DATA    SEMIS
*
       BYTE    >87
       TEXT    '(ABORT'
       BYTE    ')'+>80
       DATA    DFIND-8
PABORT
       DATA    DOCOL,ABORT,SEMIS
*
       BYTE    >85
       TEXT    'ERRO'
       BYTE    'R'+>80
       DATA    PABORT-10
ERROR
       DATA    DOCOL,LIT,TRMADD,PBASE,STORE,WARNG,AT,ZLESS,ZBRAN,ERR1-$
       DATA    PABORT
ERR1
       DATA    HERE,COUNT,TYPE,PTYPE
       BYTE    3
       TEXT    ' ? '
       DATA    MESSAG,SPSTOR,IN,AT,BLK,AT,QUIT,SEMIS
*
       BYTE    >83
       TEXT    'ID'
       BYTE    '.'+>80
       DATA    ERROR-8
IDDOT
       DATA    DOCOL,PAD,LIT,ZSPACE,LIT,95,FILL,DUP,PFA
       DATA    LFA,OVER,SUB,PAD,SWAP,CMOVE,PAD,COUNT
       DATA    LIT,>1F,AND,TYPE,SPACE,SEMIS
*
       BYTE    >86
       TEXT    'CREATE'
       BYTE    >A0
       DATA    IDDOT-6
CREATE
       DATA    DOCOL,DFIND,ZBRAN,CRE1-$,DROP,NFA,IDDOT
       DATA    LIT,4,MESSAG,SPACE
CRE1
       DATA    HERE,DUP,CAT,WIDTH,AT,MIN,ONEP,ECELLS
       DATA    ALLOT,DUP,LIT,>A0,TOGGLE,HERE,ONE,SUB
       DATA    LIT,>80,TOGGLE,LATEST,COMMA,CURR,AT
       DATA    STORE,HERE,TWOP,COMMA,SEMIS
*
       BYTE    >C9
       TEXT    '[COMPILE'
       BYTE    ']'+>80
       DATA    CREATE-10
BCOMPI
       DATA    DOCOL,DFIND,ZEQU,ZERO,QERROR,DROP,CFA
       DATA    COMMA,SEMIS
*
       BYTE    >C7
       TEXT    'LITERA'
       BYTE    'L'+>80
       DATA    BCOMPI-12
LITER
       DATA    DOCOL,STATE,AT,ZBRAN,LIT1-$,COMPI
       DATA    LIT,COMMA
LIT1
       DATA    SEMIS
*
       BYTE    >C8
       TEXT    'DLITERAL'
       BYTE    >A0
       DATA    LITER-10
DLITER
       DATA    DOCOL,STATE,AT,ZBRAN,DLIT1-$,SWAP
       DATA    LITER,LITER
DLIT1
       DATA    SEMIS
*
       BYTE    >89
       TEXT    'INTERPRE'
       BYTE    'T'+>80
       DATA    DLITER-12
INTER
       DATA    DOCOL
INT1
       DATA    DFIND,ZBRAN,INT2-$,STATE,AT,LESS
       DATA    ZBRAN,INT4-$,CFA,COMMA,BRAN,INT1-$
INT4
       DATA    CFA,EXEC,QSTACK,BRAN,INT1-$
INT2
       DATA    HERE,NUMB,DPL,AT,ONEP,ZBRAN,INT3-$
       DATA    DLITER,BRAN,INT5-$
INT3
       DATA    DROP,LITER
INT5
       DATA    QSTACK,BRAN,INT1-$
*
       BYTE    >89
       TEXT    'IMMEDIAT'
       BYTE    'E'+>80
       DATA    INTER-12
IMMED
       DATA    DOCOL,LATEST,LIT,>40,TOGGLE,SEMIS
*
       BYTE    >8A
       TEXT    'VOCABULARY'
       BYTE    >A0
       DATA    IMMED-12
VOCAB
       DATA    DOCOL,BUILDS,LIT,>81A0,COMMA,CURR
       DATA    AT,CFA,COMMA,HERE,VOCLNK,AT,COMMA
       DATA    VOCLNK,STORE,DOES
DOVOC
       DATA    TWOP,CONT,STORE,SEMIS
*
       BYTE    >C5
       TEXT    'FORT'
       BYTE    'H'+>80
       DATA    VOCAB-14
FORTH
       DATA    DODOES,DOVOC
FORLNK
       DATA    >81A0,VLINK,0
*
       BYTE    >8B
       TEXT    'DEFINITION'
       BYTE    'S'+>80
       DATA    FORTH-8
DEFIN
       DATA    DOCOL,CONT,AT,CURR,STORE,SEMIS
*
       BYTE    >C1
       BYTE    '('+>80
       DATA    DEFIN-14
PAREN
       DATA    DOCOL,LIT,ZRPARN,WORD,SEMIS
*
       BYTE    >84
       TEXT    'QUIT'
       BYTE    >A0
       DATA    PAREN-4
QUIT
       DATA    DOCOL,ZERO,BLK,STORE,LBKT
QUIT1
       DATA    RPSTOR,CR,QUERY,INTER,STATE,AT
       DATA    ZEQU,ZBRAN,QUIT1-$,PTYPE
       BYTE    3
       TEXT    ' OK'
       DATA    BRAN,QUIT1-$
*
       BYTE    >85
       TEXT    'ABOR'
       BYTE    'T'+>80
       DATA    QUIT-8
ABORT
       DATA    DOCOL,SPSTOR,DEC,CR,PTYPE
       BYTE    MSIZE
TITLE
       TEXT    'TI-990 FORTH 1.0.2'
MSIZE  EQU     $-TITLE
       EVEN
       DATA    FORTH,DEFIN,QUIT
*
       BYTE    >84
       TEXT    'COLD'
       BYTE    >A0
       DATA    ABORT-8
COLD
       DATA    ORIG,LIT,XUSER0,LIT,USER0,LIT,SYSBYT
       DATA    CMOVE,DR0,EMPBUF,LIT,-1,DPL,STORE,ABORT
*
       BYTE    >84
       TEXT    'S->D'
       BYTE    >A0
       DATA    COLD-8
STOD
       DATA    $+2
       SETO    ZTEMP1          ASSUME MINUS
       MOV     *ZSP,*ZSP       TEST VALUE
       JLT     ST1
       CLR     ZTEMP1          POSITIVE
ST1
       DECT    ZSP
       MOV     ZTEMP1,*ZSP     PUSH UPPER VALUE
       B       *ZNEXT
*
       BYTE    >82
       TEXT    '+-'
       BYTE    >A0
       DATA    STOD-8
PM
       DATA    DOCOL,ZLESS,ZBRAN,PM1-$,MINUS
PM1
       DATA    SEMIS
*
       BYTE    >83
       TEXT    'D+'
       BYTE    '-'+>80
       DATA    PM-6
DPM
       DATA    DOCOL,ZLESS,ZBRAN,DPM1-$,DMINUS
DPM1
       DATA    SEMIS
*
       BYTE    >83
       TEXT    'AB'
       BYTE    'S'+>80
       DATA    DPM-6
ABS
       DATA    $+2
       ABS     *ZSP            ABSOLUTE VALUE
       B       *ZNEXT
*
       BYTE    >84
       TEXT    'DABS'
       BYTE    >A0
       DATA    ABS-6
DABS
       DATA    DOCOL,DUP,DPM,SEMIS
*
       BYTE    >83
       TEXT    'MI'
       BYTE    'N'+>80
       DATA    DABS-8
MIN
       DATA    $+2
       C       @2(ZSP),*ZSP
       JLT     MN1
       MOV     *ZSP,@2(ZSP)    PUT MIN ON TOP
MN1
       INCT    ZSP
       B       *ZNEXT
*
       BYTE    >83
       TEXT    'MA'
       BYTE    'X'+>80
       DATA    MIN-6
MAX
       DATA    $+2
       C       *ZSP,@2(ZSP)
       JLT     MX1
       MOV     *ZSP,@2(ZSP)    PUT MAX ON TOP
MX1
       INCT    ZSP
       B       *ZNEXT
*
       BYTE    >82
       TEXT    'M*'
       BYTE    >A0
       DATA    MAX-6
MSTAR
       DATA    DOCOL,OVER,OVER,XOR,TOR,ABS,SWAP,ABS
       DATA    MULT,FROMR,DPM,SEMIS
*
       BYTE    >82
       TEXT    'M/'
       BYTE    >A0
       DATA    MSTAR-6
MSLASH
       DATA    DOCOL,OVER,TOR,TOR,DABS,R,ABS,DIV
       DATA    FROMR,R,XOR,PM,SWAP,FROMR,PM,SWAP,SEMIS
*
       BYTE    >81
       BYTE    '*'+>80
       DATA    MSLASH-6
TIMES
       DATA    DOCOL,MULT,DROP,SEMIS
*
       BYTE    >84
       TEXT    '/MOD'
       BYTE    >A0
       DATA    TIMES-4
DMOD
       DATA    DOCOL,TOR,STOD,FROMR,MSLASH,SEMIS
*
       BYTE    >81
       BYTE    '/'+>80
       DATA    DMOD-8
DDIV
       DATA    DOCOL,DMOD,SWAP,DROP,SEMIS
*
       BYTE    >83
       TEXT    'MO'
       BYTE    'D'+>80
       DATA    DDIV-4
MOD
       DATA    DOCOL,DMOD,DROP,SEMIS
*
       BYTE    >85
       TEXT    '*/MO'
       BYTE    'D'+>80
       DATA    MOD-6
MDMOD
       DATA    DOCOL,TOR,MSTAR,FROMR,MSLASH,SEMIS
*
       BYTE    >82
       TEXT    '*/'
       BYTE    >A0
       DATA    MDMOD-8
MD
       DATA    DOCOL,MDMOD,SWAP,DROP,SEMIS
*
       BYTE    >85
       TEXT    'M/MO'
       BYTE    'D'+>80
       DATA    MD-6
MSLMOD
       DATA    DOCOL,TOR,ZERO,R,DIV,FROMR,SWAP
       DATA    TOR,DIV,FROMR,SEMIS
*
       BYTE    >83
       TEXT    'US'
       BYTE    'E'+>80
       DATA    MSLMOD-8
USE
       DATA    DOVAR,ZBUFF
*
       BYTE    >84
       TEXT    'PREV'
       BYTE    >A0
       DATA    USE-6
PREV
       DATA    DOVAR,ZBUFF
*
       BYTE    >84
       TEXT    '+BUF'
       BYTE    >A0
       DATA    PREV-8
PLSBF
       DATA    DOCOL,BPBUF,LIT,4,PLUS,PLUS,DUP,LIMIT
       DATA    EQUAL,ZBRAN,PLSB1-$,DROP,FIRST
PLSB1
       DATA    DUP,PREV,AT,SUB,SEMIS
*
       BYTE    >86
       TEXT    'UPDATE'
       BYTE    >A0
       DATA    PLSBF-8
UPDATE
       DATA    DOCOL,PREV,AT,AT,LIT,>8000,OR,PREV,AT
       DATA    STORE,SEMIS
*
       BYTE    >8D
       TEXT    'EMPTY-BUFFER'
       BYTE    'S'+>80
       DATA    UPDATE-10
EMPBUF
       DATA    DOCOL,FIRST,LIMIT,OVER,SUB,ERASE,SEMIS
*
       BYTE    >83
       TEXT    'DR'
       BYTE    '0'+>80
       DATA    EMPBUF-16
DR0
       DATA    DOCOL,ZERO,OFFSET,STORE,SEMIS
*
       BYTE    >83
       TEXT    'DR'
       BYTE    '1'+>80
       DATA    DR0-6
DR1
       DATA    DOCOL,LIT,2000,OFFSET,STORE,SEMIS
*
       BYTE    >86
       TEXT    'BUFFER'
       BYTE    >A0
       DATA    DR1-6
BUFFER
       DATA    DOCOL,USE,AT,DUP,TOR
BUF1
       DATA    PLSBF,ZBRAN,BUF1-$,USE,STORE,R,AT,ZLESS
       DATA    ZBRAN,BUF2-$,R,TWOP,R,AT,LIT,>7FFF,AND
       DATA    ZERO,RSLW
BUF2
       DATA    R,STORE,R,PREV,STORE,FROMR,TWOP,SEMIS
*
       BYTE    >85
       TEXT    'BLOC'
       BYTE    'K'+>80
       DATA    BUFFER-10
BLOCK
       DATA    DOCOL,OFFSET,AT,PLUS,TOR,PREV,AT,DUP,AT
       DATA    R,SUB,DUP,PLUS,ZBRAN,BLK1-$
BLK2
       DATA    PLSBF,ZEQU,ZBRAN,BLK3-$,DROP,R,BUFFER,DUP
       DATA    R,ONE,RSLW,TWO,SUB
BLK3
       DATA    DUP,AT,R,SUB,DUP,PLUS,ZEQU,ZBRAN,BLK2-$
       DATA    DUP,PREV,STORE
BLK1
       DATA    FROMR,DROP,TWOP,SEMIS
*
       BYTE    >86
       TEXT    '(LINE)'
       BYTE    >A0
       DATA    BLOCK-8
PLINE
       DATA    DOCOL,TOR,LIT,64,BPBUF,MDMOD,FROMR,BPSCR
       DATA    TIMES,PLUS,BLOCK,PLUS,LIT,64,SEMIS
*
       BYTE    >85
       TEXT    '.LIN'
       BYTE    'E'+>80
       DATA    PLINE-10
DOTLN
       DATA    DOCOL,PLINE,DTRAIL,TYPE,SEMIS
*
       BYTE    >87
       TEXT    'MESSAG'
       BYTE    'E'+>80
       DATA    DOTLN-8
MESSAG
       DATA    DOCOL,LIT,TRMADD,PBASE,STORE,WARNG,AT,ZBRAN,MSG1-$
       DATA    DDUP,ZBRAN,MSG2-$
       DATA    LIT,4,OFFSET,AT,BPSCR,DIV,SUB,DOTLN,SEMIS
MSG1
       DATA    PTYPE
       BYTE    7
       TEXT    ' MSG # '
       DATA    DOT
MSG2
       DATA    SEMIS
*
       BYTE    >84
       TEXT    'LOAD'
       BYTE    >A0
       DATA    MESSAG-10
LOAD
       DATA    DOCOL,BLK,AT,TOR,IN,AT,TOR,ZERO,IN,STORE
       DATA    BPSCR,TIMES,BLK,STORE,INTER,FROMR,IN
       DATA    STORE,FROMR,BLK,STORE,SEMIS
*
       BYTE    >C3
       TEXT    '--'
       BYTE    '>'+>80
       DATA    LOAD-8
ARRO
       DATA    DOCOL,QLOAD,ZERO,IN,STORE,BPSCR,BLK,AT
       DATA    OVER,MOD,SUB,BLK,PSTORE,SEMIS
*
       BYTE    >82
       TEXT    'HI'
       BYTE    >A0
       DATA    ARRO-6
HI
       DATA    DOCON,ZHI
*
       BYTE    >82
       TEXT    'LO'
       BYTE    >A0
       DATA    HI-6
LO
       DATA    DOCON,ZLO
*
       BYTE    >83
       TEXT    'R/'
       BYTE    'W'+>80
       DATA    LO-6
RSLW
       DATA    DOCOL,LIT,DBUFF+12,HLD,STORE,SWAP,ZERO
       DATA    OVER,GREAT,OVER,LIT,3999,GREAT,OR,LIT,6
       DATA    QERROR,LIT,ZCR,HOLD,LIT,2000,DMOD,HL,DROP
       DATA    LIT,ZSLASH,HOLD,BL,HOLD,LIT,26,DMOD,SWAP
       DATA    ONEP,HL,HL,DROP,BL,HOLD,HL,HL,DROP,BL,HOLD
       DATA    ZBRAN,RSLW1-$,LIT
XLETI
       DATA    ZLETI,BRAN,RSLW2-$
RSLW1
       DATA    LIT,ZLETO
RSLW2
       DATA    HOLD,HLD,AT,DISKRW,LIT,8,QERROR,SEMIS
*
* DISK READ/WRITE ROUTINE
*
* PARAMETER BUFFER FORMAT:
*
*      C TT SS /D
*
*  WHERE:      C  - I=INPUT, O=OUTPUT
*              TT - TRACK NUMBER (0-77)
*              SS - SECTOR (1-26)
*              D  - DRIVE NUMBER
*
DISKRW
       DATA    $+2
       MOV     *ZSP+,R0        GET TEXT POINTER
       MOV     *ZSP,R1         GET DATA ADDRESS
       SETO    *ZSP            SET ERROR FOR RETURN
       BLWP    @DISKH          CALL DISK HANDLER
       DATA    DSKERR          ERROR RETURN ADDRESS
       CLR     *ZSP            NO ERROR OCCURED
DSKERR
       B       *ZNEXT
*
* INTERNAL ROUTINE
*
HL
       DATA    DOCOL,ZERO,LIT,10,DIV,SWAP,LIT,ZZERO
       DATA    PLUS,HOLD,SEMIS
*
* HERE ENDS THE META COMPILER
*
       BYTE    >85
       TEXT    'CASE'
       BYTE    ':'+>80
       DATA    RSLW-6
CASE
       DATA    DOCOL,BUILDS,SMUDGE,ABS,ONE,SUB,COMMA
       DATA    RTBKT,DOES
DOCASE
       DATA    DUP,AT,ROT,ABS,MIN,DUP,PLUS,PLUS,TWOP
       DATA    AT,EXEC,SEMIS
*
       BYTE    >C1
       BYTE    ''''+>80
       DATA    CASE-8
TICK
       DATA    DOCOL,DFIND,ZEQU,ZERO,QERROR,DROP,LITER,SEMIS
*
       BYTE    >86
       TEXT    'FORGET'
       BYTE    >A0
       DATA    TICK-4
FORGET
       DATA    DOCOL,CURR,AT,CONT,AT,SUB,LIT,24,QERROR
       DATA    TICK,DUP,FENCE,AT,LESS,LIT,21,QERROR,DUP
       DATA    NFA,DP,STORE,LFA,AT,CURR,AT,STORE,SEMIS
*
       BYTE    >84
       TEXT    'BACK'
       BYTE    >A0
       DATA    FORGET-10
BACK
       DATA    DOCOL,HERE,SUB,COMMA,SEMIS
*
       BYTE    >C5
       TEXT    'BEGI'
       BYTE    'N'+>80
       DATA    BACK-8
BEGIN
       DATA    DOCOL,QCOMP,HERE,ONE,SEMIS
*
       BYTE    >C5
       TEXT    'ENDI'
       BYTE    'F'+>80
       DATA    BEGIN-8
ENDIF
       DATA    DOCOL,QCOMP,TWO,QPAIRS,HERE,OVER,SUB,SWAP
       DATA    STORE,SEMIS
*
       BYTE    >C4
       TEXT    'THEN'
       BYTE    >A0
       DATA    ENDIF-8
THEN
       DATA    DOCOL,ENDIF,SEMIS
*
       BYTE    >C2
       TEXT    'DO'
       BYTE    >A0
       DATA    THEN-8
IDO
       DATA    DOCOL,COMPI,DO,HERE,THREE,SEMIS
*
       BYTE    >C4
       TEXT    'LOOP'
       BYTE    >A0
       DATA    IDO-6
ILOOP
       DATA    DOCOL,THREE,QPAIRS,COMPI,LOOP,BACK,SEMIS
*
       BYTE    >C5
       TEXT    '+LOO'
       BYTE    'P'+>80
       DATA    ILOOP-8
IPLUP
       DATA    DOCOL,THREE,QPAIRS,COMPI,PLOOP,BACK,SEMIS
*
       BYTE    >C5
       TEXT    'UNTI'
       BYTE    'L'+>80
       DATA    IPLUP-8
UNTIL
       DATA    DOCOL,ONE,QPAIRS,COMPI,ZBRAN,BACK,SEMIS
*
       BYTE    >C3
       TEXT    'EN'
       BYTE    'D'+>80
       DATA    UNTIL-8
END
       DATA    DOCOL,UNTIL,SEMIS
*
       BYTE    >C5
       TEXT    'AGAI'
       BYTE    'N'+>80
       DATA    END-6
AGAIN
       DATA    DOCOL,ONE,QPAIRS,COMPI,BRAN,BACK,SEMIS
*
       BYTE    >C6
       TEXT    'REPEAT'
       BYTE    >A0
       DATA    AGAIN-8
REPEAT
       DATA    DOCOL,TOR,TOR,AGAIN,FROMR,FROMR,TWO
       DATA    SUB,ENDIF,SEMIS
*
       BYTE    >C2
       TEXT    'IF'
       BYTE    >A0
       DATA    REPEAT-10
IF
       DATA    DOCOL,COMPI,ZBRAN,HERE,ZERO,COMMA,TWO,SEMIS
*
       BYTE    >C5
       TEXT    'WHIL'
       BYTE    'E'+>80
       DATA    IF-6
WHILE
       DATA    DOCOL,IF,TWOP,SEMIS
*
       BYTE    >C4
       TEXT    'ELSE'
       BYTE    >A0
       DATA    WHILE-8
ELSE
       DATA    DOCOL,TWO,QPAIRS,COMPI,BRAN,HERE,ZERO
       DATA    COMMA,SWAP,TWO,ENDIF,TWO,SEMIS
*
       BYTE    >86
       TEXT    'SPACES'
       BYTE    >A0
       DATA    ELSE-8
SPACS
       DATA    DOCOL,ZERO,MAX,DDUP,ZBRAN,SPS2-$,ZERO,DO
SPS1
       DATA    SPACE,LOOP,SPS1-$
SPS2
       DATA    SEMIS
*
       BYTE    >82
       TEXT    '<#'
       BYTE    >A0
       DATA    SPACS-10
STRTCN
       DATA    DOCOL,PAD,HLD,STORE,SEMIS
*
       BYTE    >82
       TEXT    '#>'
       BYTE    >A0
       DATA    STRTCN-6
STPCNV
       DATA    DOCOL,DROP,DROP,HLD,AT,PAD,OVER,SUB,SEMIS
*
       BYTE    >84
       TEXT    'SIGN'
       BYTE    >A0
       DATA    STPCNV-6
SIGN
       DATA    DOCOL,ROT,ZLESS,ZBRAN,SGN2-$,LIT,ZMINUS,HOLD
SGN2
       DATA    SEMIS
*
       BYTE    >81
       BYTE    '#'+>80
       DATA    SIGN-8
NUMSGN
       DATA    DOCOL,PAD,HLD,AT,SUB,DPL,AT,EQUAL,ZBRAN
       DATA    NS2-$,LIT,ZPEROD,HOLD
NS2
       DATA    BASE,AT,MSLMOD,ROT,LIT,9,OVER,LESS,ZBRAN
       DATA    NS1-$,LIT,7,PLUS
NS1
       DATA    LIT,ZZERO,PLUS,HOLD,SEMIS
*
       BYTE    >82
       TEXT    '#S'
       BYTE    >A0
       DATA    NUMSGN-4
NUMS
       DATA    DOCOL,NUMSGN,OVER,OVER,OR,ZEQU,ZBRAN
       DATA    NUMS+2-$,SEMIS
*
       BYTE    >83
       TEXT    'D.'
       BYTE    'R'+>80
       DATA    NUMS-6
DDOTR
       DATA    DOCOL,TOR,SWAP,OVER,DABS,STRTCN,NUMS,SIGN
       DATA    STPCNV,FROMR,OVER,SUB,SPACS,TYPE,SEMIS
*
       BYTE    >82
       TEXT    '.R'
       BYTE    >A0
       DATA    DDOTR-6
DOTR
       DATA    DOCOL,TOR,STOD,FROMR,DDOTR,SEMIS
*
       BYTE    >82
       TEXT    'D.'
       BYTE    >A0
       DATA    DOTR-6
DDOT
       DATA    DOCOL,ZERO,DDOTR,SPACE,SEMIS
*
       BYTE    >81
       BYTE    '.'+>80
       DATA    DDOT-6
DOT
       DATA    DOCOL,STOD,DDOT,SEMIS
*
       BYTE    >81
       BYTE    '?'+>80
       DATA    DOT-4
QMRK
       DATA    DOCOL,AT,DOT,SEMIS
*
       BYTE    >82
       TEXT    'U.'
       BYTE    >A0
       DATA    QMRK-4
UDOT
       DATA    DOCOL,ZERO,DDOT,SEMIS
*
       BYTE    >84
       TEXT    'LIST'
       BYTE    >A0
       DATA    UDOT-6
LIST
       DATA    DOCOL,BASE,AT,SWAP,DEC,CR,DUP,SCR,STORE,PTYPE
       BYTE    6
       TEXT    'SCR # '
       EVEN
       DATA    DOT,LIT,16,ZERO,DO
LIST1
       DATA    CR,I,THREE,DOTR,SPACE,I,SCR,AT,DOTLN
       DATA    LOOP,LIST1-$,CR,BASE,STORE,SEMIS
*
       BYTE    >85
       TEXT    'INDE'
       BYTE    'X'+>80
       DATA    LIST-8
INDEX
       DATA    DOCOL,BASE,AT,ROT,ROT,LIT,ZFF,EMIT
       DATA    CR,ONEP,SWAP,DEC,DO
IDX1
       DATA    CR,I,THREE,DOTR,SPACE,ZERO,I,DOTLN
       DATA    LOOP,IDX1-$,BASE,STORE,SEMIS
*
       BYTE    >85
       TEXT    'TRIA'
       BYTE    'D'+>80
       DATA    INDEX-8
TRIAD
       DATA    DOCOL,LIT,ZFF,EMIT,THREE,DDIV,THREE
       DATA    TIMES,THREE,OVER,PLUS,SWAP,DO
TRI1
*       DATA    CR,I,LIST,LOOP,TRI1-$,CR,LIT,15
*       DATA    MESSAG,CR,SEMIS
       DATA    CR,I,LIST,LOOP,TRI1-$,CR
       DATA    SEMIS
*
VLINK
       BYTE    >85
       TEXT    'VLIS'
       BYTE    'T'+>80
       DATA    TRIAD-8
VLIST
       DATA    DOCOL,LIT,ZLNLEN,OUT,STORE,CONT,AT,AT
HELP1
       DATA    OUT,AT,LIT,70,GREAT,ZBRAN,HELP2-$
       DATA    CR,ZERO,OUT,STORE
HELP2
       DATA    DUP,IDDOT,SPACE,SPACE,PFA,LFA,AT,DUP
       DATA    ZEQU,QTERM,OR,ZBRAN,HELP1-$,DROP,SEMIS
*
* END OF PROTECTED WORDS
*
VEND   EQU     $
*
ASSMB
       DATA    DOCOL,SEMIS
       DATA    -1
ENDROM DATA    ENDRAM
FOREND EQU     $
       PAGE
*
* DATA DEFINITIONS
*
       ASMIF   SYSTEM=STD
         AORG  ZRAM
       ASMEND
*
DSIZE  EQU     4               SIZE OF DICTIONAY (IN KBYTES)
LOWRAM EQU     $               STACKS
       BSS     1024*DSIZE      START OF RAM DICTIONARY
       BSS     128
STAX   EQU     $               PARAMETER STACK
       BSS     160             INPUT BUFFER
RSTAX  EQU     $               RETURN STACK
*
* USER VARIABLES
*
USER0  BSS     6
GSZERO BSS     2               S0
GRZERO BSS     2               R0
GTIB   BSS     2               TERMINAL INPUT BUFFER
GWIDTH BSS     2               NAME WIDTH
GWARNG BSS     2               WARNING FLAG, DISK=1
GFENCE BSS     2               PROTECTED DICTIONARY
GDP    BSS     2               DICTIONARY POINTER
GVLNK  BSS     2               VOCABULARY LINK
*
* THE FOLLOWING ARE INITIALIZED BY PROGRAM
*
GBLK   BSS     2               BLOCK NUMBER
GIN    BSS     2               NEXT INPUT CHAR. OFFSET
GOUT   BSS     2               OUTPUT POINTER
GSCR   BSS     2               CURRENT SCREEN
GOFSET BSS     2               DISK OFFSET
GCONT  BSS     2               CONTEXT VOCABULARY
GCURR  BSS     2               CURRENT VOCABULARY
GSTATE BSS     2               COMPILING OR NOT
GBASE  BSS     2               NUMBER BASE (RADIX)
GDPL   BSS     2               DECIMAL POINT LOCATION
GFLD   BSS     2               OUTPUT FIELD WIDTH
GCSP   BSS     2               CHECK OF STACK POSITION
GRNUM  BSS     2               EDIT CURSOR POSITION
GHLD   BSS     2               POINTER TO FORMATED OUTPUT
GPRTBS BSS     2               OUTPUT PRINTER CRU BASE
GSKEW  BSS     2               SKEW SWITCH
*
MAINWS BSS     32              MAIN WORKSPACE
DBUFF  BSS     12              DISK COMMAND BUFFER
*
       ASMIF   SYSTEM=OS
*
* TERMINAL SVC BLOCK
*
TRMSCB   DATA  0
TRMOPC   BYTE  0               OP CODE
TRMLUN   BYTE  $-$             LUNO
TRMFLG   DATA  0               FLAGS
TRMBUF   DATA  $-$             BUFFER ADDRESS
TRMLRL   DATA  ZLNLEN          LOG. REC. LEN.
TRMCHC   DATA  ZLNLEN          CHAR. CNT.
*
TRMOPN   DATA  -1              TERMINAL OPEN FLAG
PRTOPN   DATA  -1              PRINTER OPEN FLAG
*
TBUFIN   BSS   ZLNLEN          TERMINAL INPUT BUFFER
         EVEN
TBUFOU   BSS   ZLNLEN          TERMINAL OUTPUT BUFFER
         EVEN
*
GETEVT   DATA  >3900           GET EVENT SCB
EVTCHR   DATA  0+TMLUNO
*
CMDKEY   DATA  >9800           COMMAND KEY
       ASMEND
       PAGE
*
* STANDARD DISK HANDLER
*
       ASMIF   SYSTEM=STD
*
DISKH    EQU   >F804           DISK HANDLER INTERFACE
       ASMEND
       PAGE
*
* STAND ALONE DISK HANDLER
*
       ASMIF   SYSTEM=SA
*
DISKH
         DATA  DISKWS,DISKAD
DISKWS
         DATA  0               R0
         DATA  0               R1
         DATA  0               R2
         DATA  0               R3
         DATA  0               R4
         DATA  0               R5
         DATA  0               R6
         DATA  0               R7
         DATA  $-$             R8  - ERROR RETURN
         DATA  $-$             R9  - BUFFER POINTER
         DATA  $-$             R10 - PARAMETER POINTER
         DATA  0               R11
         DATA  DSKCRU          R12 - FLOPPY CRU BASE
         BSS   6               R13-R15 RETURN CONTEXT
*
SEEKCM   EQU   >1000           SEEK COMMAND
READCM   EQU   >4000           READ COMMAND
WRITCM   EQU   >7000           WRITE COMMAND
STOPCM   EQU   >B000           STOP COMMAND
CMDBAS   EQU   >20             COMMAND BASE
DATBAS   EQU   >FFC0           DATA BASE
ERRMSK   EQU   >1BFC           ERROR MASK
OPCOMP   EQU   >0F             OPERATION COMPLETE - CMDBAS
CBUSY    EQU   >0A             CONTROLLER BUSY - CMDBAS
CTLBSY   EQU   >1A             CONTROLLER BUSY - DATBAS
XFER     EQU   >11             TRANSFER READY - DATBAS
GOTWRD   EQU   >0F             GOT WORD - DATBAS
*
* PROCESS DISK REQUEST
*
DISKAD
         MOV   @R0*2(R13),R10  GET PARM ADDR
         MOV   @R1*2(R13),R9   GET BUFFER ADDR
         MOV   *R14+,R8        GET ERROR VECTOR
         LI    R6,READTR       SET READ OP
         CB    *R10+,@XLETI+1  IF NOT INPUT THEN
         JEQ   DSK020
         LI    R6,WRITTR          SET WRITE OP
DSK020
         INC   R10             BUMP TO TRACK
         BL    @GETNUM         CONVERT TRACK
         MOV   R0,R2
         CI    R2,TRKDSK
         JHE   DSK040
         INC   R10             BUMP TO SECTOR
         BL    @GETNUM         CONVERT SECTOR
         MOV   R0,R3
         MOV   @GSKEW,R0
         JEQ   DSK030
         MOVB  @SECSKW(R3),R3  APPLY SKEW (INTERLEAVING)
         SRL   R3,8
DSK030
         INCT  R10             BUMP TO DRIVE
         MOVB  *R10,R10
         SRL   R10,8
         AI    R10,->30
         SLA   R10,10
         B     *R6             GO PROCESS COMMAND
DSK040
         MOV   R8,R14
         RTWP
*
* READ FROM TRACK
*
READTR
         MOV   R2,R0          GET TRACK
         BL    @SEEK          SEEK TO TRACK
         MOV   R3,R0          GET SECTOR
         ORI   R0,READCM      MAKE A READ COMMAND
         BL    @ISSUE1        ISSUE READ
         LI    R2,SECSIZ      READ ENTIRE SECTOR
READ10
         BL    @XFRRDY        GO WAIT FOR READY
         STCR  R1,0           GET DATA WORD
         SBZ   GOTWRD         SIGNAL RECEIVED
         MOVB  R1,*R9+        STORE IN USER'S AREA
         SWPB  R1
         MOVB  R1,*R9+
         DECT  R2
         JGT   READ10
STOPIT
         LI    R0,STOPCM      STOP CONTROLLER
         BL    @ISSUE2
         RTWP
*
* WRITE TO TRACK
*
WRITTR
         MOV   R2,R0          GET TRACK
         BL    @SEEK          SEEK TO TRACK
         MOV   R3,R0          GET SECTOR
         ORI   R0,WRITCM      MAKE A WRITE COMMAND
         BL    @ISSUE1        ISSUE WRITE
         LI    R2,SECSIZ      WRITE A SECTOR
WRIT10
         BL    @XFRRDY        GO WAIT UNTIL READY
         MOVB  *R9+,R1        GET A WORD FROM USER
         SWPB  R1
         MOVB  *R9+,R1
         SWPB  R1
         LDCR  R1,0           WRITE IT
         DECT  R2
         JGT   WRIT10
         BL    @XFRRDY        INSURE LAST WORD SENT
         JMP   STOPIT         GO STOP CONTROLLER
*
* SEEK TO TRACK
*
SEEK
         ORI   R0,SEEKCM         SEEK
*
* ISSUE COMMANDS TO FLOPPY
*
ISSUE
         LI    R6,DECODE
         JMP   ISU010
ISSUE1
         LI    R6,DECOD1
ISU010
         ORI   R12,CMDBAS     ENSURE COMMAND BASE
*
         LI    R5,20000       CONTROLLER BUSY TIMEOUT
ISU020
         TB    CBUSY          WAIT UNTIL CONTROLLER FREE
         JNE   ISU030
         DEC   R5
         JGT   ISU020
ISSUE2
         LI    R6,DECODE
ISU030
         ORI   R12,CMDBAS     ENSURE COMMAND BASE
         SOC   R10,R0         SET DRIVE NUMBER
         LDCR  R0,0           ISSUE COMMAND
ISU040
         TB    OPCOMP         WAIT UNTIL OP COMPLETE
         JNE   ISU040
         STCR  R5,0           READ STATUS
         B     *R6            GO DECODE STATUS
*
* STATUS DECODER
*
DECODE
         SETO  R7
         LDCR  R7,0           CLEAR STATUS PORT
DECOD1
         CLR   R7
         ANDI  R5,ERRMSK
         JEQ   DEC020
         MOV   R8,R14
         RTWP
DEC020
         B     *R11
*
* WAIT FOR TRANSFER READY
*
XFRRDY
         ANDI  R12,DATBAS     SET TO DATA BASE
XFR010
         TB    XFER           IF TRANSFER READY THEN
         JNE   XFR020
         B     *R11              RETURN
XFR020
         TB    CTLBSY         ELSE IF CONTROLLER BUSY THEN
         JEQ   XFR010            WAIT
         ORI   R12,CMDBAS     ELSE CONTROLER STOPPED
         STCR  R5,0              WHY ?
         BL    @DECODE
         RTWP
*
SECSKW   EQU   $-1            SECTOR INTERLEAVING TABLE
         BYTE  5,11,17,23,3,9,15
         BYTE  21,1,7,13,19,25
         BYTE  6,12,18,24,4,10,16
         BYTE  22,2,8,14,20,26
       ASMEND
       PAGE
*
* TX/DX OS DISK HANDLER
*
       ASMIF   SYSTEM=OS
*
DISKH
         DATA  DISKWS,DISKAD
DISKWS
         DATA  0               R0
         DATA  0               R1
         DATA  0               R2
         DATA  0               R3
         DATA  SECTRK          R4  - SECTORS/TRACK
         DATA  DSKSCB          R5  - DISK SCB ADDRESS
         DATA  DSKOPC          R6  - DISK SCB OPCODE
DSKOPN   DATA  -1              R7  - DISK OPEN FLAG
         DATA  $-$             R8  - DISK ERROR RETURN VECTOR
         DATA  $-$             R9  - BUFFER POINTER
         DATA  $-$             R10 - PARAMETER POINTER
         DATA  0               R11
         DATA  GETNUM          R12 - CONVERT NUMBER ROUTINE
         BSS   6               R13-R15 RETURN CONTEXT
*
* DISK SVC BLOCK
*
DSKSCB   DATA  0
DSKOPC   BYTE  0               OPCODE
DSKLUN   BYTE  DKLUNO          LUNO
DSKFLG   DATA  0               FLAGS
DSKBUF   DATA  0               BUFFER ADDRESS
DSKLRL   DATA  SECSIZ          LOGICAL RECORD LEN,
DSKCHC   DATA  SECSIZ          CHAR.COUNT
         DATA  0               REC. NUM HI
DSKREC   DATA  0               REC. NUM LO
*
* PROCESS DISK REQUEST
*
DISKAD
         MOV   @R0*2(R13),R10  GET PARM ADDR
         MOV   @R1*2(R13),R9   GET BUFFER ADDR
         MOV   *R14+,R8        GET ERROR VECTOR
         ABS   R7              IF DISK NOT OPEN THEN
         JGT   DSK010
         MOVB  @OPENOP,*R6        OPEN IT
         SVC   *R5
         MOVB  @1(R5),R0          IF OPEN ERROR THEN
         JNE   DSK025                GO SET ERROR
DSK010
         MOVB  @READOP,*R6     SET READ OP
         CB    *R10+,@XLETI+1  IF NOT INPUT THEN
         JEQ   DSK020
         MOVB  @WRITOP,*R6        SET WRITE OP
DSK020
         INC   R10             BUMP TO TRACK
         BL    *R12            CONVERT TRACK
         MOV   R0,R2
         MPY   R4,R2           TRACK * SECT/TRK
         INC   R10             BUMP TO SECTOR
         BL    *R12            CONVERT SECTOR
         DEC   R0
         A     R0,R3
         MOV   R3,@DSKREC
         MOV   R9,@DSKBUF
         SVC   *R5             DO I/O
         MOVB  @1(R5),R0       IF ERROR THEN
         JEQ   DSK030
DSK025
         MOV   R8,R14             SET ERROR VECTOR
DSK030
         RTWP
       ASMEND
       PAGE
*
* GET A NUMBER FOR THE DISK HANDLER
*
       ASMIF SYSTEM>STD
GETNUM
         MOVB  *R10+,R0        GET DIGIT
         SRL   R0,8
         AI    R0,->30         STRIP ASCII
         MPY   @XTEN,R0
         MOVB  *R10+,R0        GET DIGIT
         SRL   R0,8
         AI    R0,->30         STRIP ASCII
         A     R1,R0
         RT
       ASMEND
       PAGE
*
* SCREEN BUFFERS
*
NSCR   EQU     16              BUFFER FOR 16 SCREENS
ZBUFF  BSS     128+4*8*NSCR    I/O BUFFERS
ZLO    EQU     ZBUFF           PSEUDO DISK
ZHI    EQU     $
ENDRAM EQU     ZHI
*
       END     MAIN1
