/* Subroutines for the C front end for System/370.
   Copyright (C) 1989, 1993, 1995, 1997, 1998, 1999, 2000
   Free Software Foundation, Inc.
   Contributed by Jan Stein (jan@cd.chalmers.se).
   Modified for OS/390 LanguageEnvironment C by Dave Pitts (dpitts@cozx.com)
   Hacked for Linux-ELF/390 by Linas Vepstas (linas@linas.org) 

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GCC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "tree.h"
#include "toplev.h"
#include "cpplib.h"
#include "c-pragma.h"
#include "tm_p.h"

#ifdef TARGET_HLASM

#define BAD(msgid) do { warning (msgid); return; } while (0)

/* #pragma map (name, alias) -
   In this implementation both name and alias are required to be
   identifiers.  The older code seemed to be more permissive.  Can
   anyone clarify?  */

void
i370_pr_map (pfile)
     cpp_reader *pfile ATTRIBUTE_UNUSED;
{
  tree name, alias, x;

  if (c_lex (&x) != CPP_OPEN_PAREN)
    BAD ("missing '(' after '#pragma map' - ignored");

  if (c_lex (&name) != CPP_NAME)
    BAD ("missing identifer name in '#pragma map' - ignored");

  if (c_lex (&x) != CPP_COMMA)
    BAD ("malformed '#pragma map' - ignored");

  if (c_lex (&alias) != CPP_STRING)
    BAD ("missing alias name in '#pragma map' - ignored");

  if (c_lex (&x) != CPP_CLOSE_PAREN)
    BAD ("missing ')' for '#pragma map' - ignored");

  if (c_lex (&x) != CPP_EOF)
    warning ("junk at end of '#pragma map'");

  mvs_add_alias (IDENTIFIER_POINTER (name), TREE_STRING_POINTER (alias), 1);
}

/* #pragma linkage (name, mode) -
   In this implementation both name and alias are required to be
   identifiers.  The older code seemed to be more permissive.  Can
   anyone clarify?  */

void
i370_pr_linkage (pfile)
     cpp_reader *pfile ATTRIBUTE_UNUSED;
{
  tree name, mode, x;

  if (c_lex (&x) != CPP_OPEN_PAREN)
    BAD ("missing '(' after '#pragma linkage' - ignored");

  if (c_lex (&name) != CPP_NAME)
    BAD ("missing identifer name in '#pragma linkage' - ignored");

  if (c_lex (&x) != CPP_COMMA)
    BAD ("malformed '#pragma linkage' - ignored");

  if (c_lex (&mode) != CPP_STRING)
    BAD ("missing linkage mode in '#pragma linkage' - ignored");

  if (c_lex (&x) != CPP_CLOSE_PAREN)
    BAD ("missing ')' for '#pragma linkage' - ignored");

  if (c_lex (&x) != CPP_EOF)
    warning ("junk at end of '#pragma linkage'");

}

/* #pragma checkout (mode) -
   In this implementation both name and alias are required to be
   identifiers.  The older code seemed to be more permissive.  Can
   anyone clarify?  */

void
i370_pr_checkout (pfile)
     cpp_reader *pfile ATTRIBUTE_UNUSED;
{
  tree mode, x;

  if (c_lex (&x) != CPP_OPEN_PAREN)
    BAD ("missing '(' after '#pragma checkout' - ignored");

  if (c_lex (&mode) != CPP_NAME)
    BAD ("missing checkout mode in '#pragma checkout' - ignored");

  if (c_lex (&x) != CPP_CLOSE_PAREN)
    BAD ("missing ')' for '#pragma checkout' - ignored");

  if (c_lex (&x) != CPP_EOF)
    warning ("junk at end of '#pragma checkout'");

}

/* #pragma nomargins
   #pragma nosequence
   We just ignore. */

void
i370_pr_skipit (pfile)
     cpp_reader *pfile ATTRIBUTE_UNUSED;
{
}

#endif
