/* Definitions of target machine for GNU compiler, for a TI990 with DX10
   Copyright (C) 1995, 1996, 1999, 2000 Free Software Foundation, Inc.
   Contributed by Dave Pitts (dpitts@cozx.com)

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#define OS_DX10

/* The name of the current function.  */

extern char *ti990_function_name;
extern int ti990_function_name_length;

#undef TARGET_VERSION
#define TARGET_VERSION fprintf (stderr, " (ti990/dx10)");

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
   the stack pointer does not matter.  The value is tested only in
   functions that have frame pointers.
   No definition is equivalent to always zero.  */

#undef EXIT_IGNORE_STACK
#define EXIT_IGNORE_STACK	1

/* Target OS preprocessor built-ins.  */
#define TARGET_OS_CPP_BUILTINS()		\
    do {					\
	builtin_define_std ("dx10");		\
	builtin_define_std ("DX10");		\
	builtin_define ("__ti990__");		\
	builtin_assert ("system=dx10");		\
    } while (0)

#ifdef LIB_SPEC
#undef LIB_SPEC
#endif
#define LIB_SPEC "-lc -lsoft -lsci"

#ifdef LIBGCC_SPEC
#undef LIBGCC_SPEC
#endif
#define LIBGCC_SPEC ""
