/*#define DEBUGOPERAND*/
/* Subroutines for gcc for ti990.
   Copyright (C) 1994, 1995, 1996, 1997, 1998, 1999, 2001
   Free Software Foundation, Inc.
   Contributed by Dave Pitts (dpitts@cozx.com)

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GCC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "rtl.h"
#include "regs.h"
#include "hard-reg-set.h"
#include "real.h"
#include "insn-config.h"
#include "conditions.h"
#include "function.h"
#include "output.h"
#include "insn-attr.h"
#include "flags.h"
#include "recog.h"
#include "tree.h"
#include "expr.h"
#include "toplev.h"
#include "tm_p.h"
#include "target.h"
#include "target-def.h"

/* Current source module.  */
char *ti990_module = 0;

/* Current function name.  */
char *ti990_function_name = 0;
int ti990_function_name_length = 0;

int ti990_gen_retval = 0;
int ti990_plog_id = 0;
int ti990_emit_ckpt = 0;

/* This is where the condition code register lives.  */
/* rtx cc0_reg_rtx; - no longer needed? */

static bool ti990_assemble_integer (rtx, unsigned int, int);
static void ti990_globalize_label (FILE *, const char *);
static void ti990_output_function_prologue (FILE *, HOST_WIDE_INT);
static void ti990_output_function_epilogue (FILE *, HOST_WIDE_INT);
static void ti990_file_start (void);
static void ti990_file_end (void);
static int litout = FALSE;
static int atout = FALSE;

/* Initialize the GCC target structure.  */
#undef TARGET_ASM_BYTE_OP
#define TARGET_ASM_BYTE_OP "\tBYTE\t"
#undef TARGET_ASM_ALIGNED_HI_OP
#define TARGET_ASM_ALIGNED_HI_OP "\tDATA\t"
#undef TARGET_ASM_ALIGNED_SI_OP
#define TARGET_ASM_ALIGNED_SI_OP "\tLONG\t"
#undef TARGET_ASM_ALIGNED_DI_OP
#define TARGET_ASM_ALIGNED_DI_OP "\tQUAD\t"

#undef TARGET_ASM_INTEGER
#define TARGET_ASM_INTEGER ti990_assemble_integer
#undef TARGET_ASM_GLOBALIZE_LABEL
#define TARGET_ASM_GLOBALIZE_LABEL ti990_globalize_label

#undef TARGET_ASM_FUNCTION_PROLOGUE
#define TARGET_ASM_FUNCTION_PROLOGUE ti990_output_function_prologue
#undef TARGET_ASM_FUNCTION_EPILOGUE
#define TARGET_ASM_FUNCTION_EPILOGUE ti990_output_function_epilogue
#undef TARGET_ASM_FILE_START
#define TARGET_ASM_FILE_START ti990_file_start
#undef TARGET_ASM_FILE_END
#define TARGET_ASM_FILE_END ti990_file_end

struct gcc_target targetm = TARGET_INITIALIZER;

#define INLINE_PROLOGUE

/* Nonzero if OP is a valid second operand for an arithmetic insn.  */

int
arith_operand (op, mode)
     rtx op;
     enum machine_mode mode;
{
  return (register_operand (op, mode) || GET_CODE (op) == CONST_INT);
}

int
float_register (op, mode)
     rtx op;
     enum machine_mode mode;
{
  return (register_operand(op,mode));
}

rtx
ti990_function_value (tree valtype, tree func ATTRIBUTE_UNUSED)
{
  ti990_gen_retval = TYPE_MODE(valtype);
  return gen_rtx_REG (TYPE_MODE (valtype),
		      BASE_RETURN_VALUE_REG(TYPE_MODE(valtype)));
}

/*
   stream is a stdio stream to output the code to.
   size is an int: how many units of temporary storage to allocate.
   Refer to the array `regs_ever_live' to determine which registers
   to save; `regs_ever_live[I]' is nonzero if register number I
   is ever used in the function.  This macro is responsible for
   knowing which registers should not be saved even if used.  
*/

static void
ti990_output_function_prologue (stream, size)
     FILE *stream;
     HOST_WIDE_INT size;
{							       
    HOST_WIDE_INT fsize = ((size) + 1) & ~1;

    ti990_emit_ckpt = 0;
    fprintf (stream,
	     "* function prologue %s, frame size = %ld, args = %d\n",
	     ti990_function_name, fsize, current_function_outgoing_args_size);

#ifdef INLINE_PROLOGUE
    /* Set up local frame workspace addressability */
    fprintf (stream, "\tSTWP\t%s\n", reg_names[FRAME_POINTER_REGNUM]);

    /* local variables start after the workspace */
#ifdef STACK_GROWS_DOWNWARD
    fprintf (stream, "\tAI\t%s,-%d\n", reg_names[FRAME_POINTER_REGNUM], 32);
#else
    fprintf (stream, "\tAI\t%s,%d\n", reg_names[FRAME_POINTER_REGNUM], 32);
#endif

    /* So does stack frame */
    fprintf (stream, "\tMOV\t%s,%s\n",
	     reg_names[FRAME_POINTER_REGNUM], reg_names[STACK_POINTER_REGNUM]);

    /* make stack frame, always allow for workspace and local variables */
    if (fsize)
    {
       if (fsize == 2)
	  fprintf (stream,
#ifdef FRAME_GROWS_DOWNWARD
		   "\tDECT\t%s\n",
#else
		   "\tINCT\t%s\n",
#endif
		   reg_names[STACK_POINTER_REGNUM]);
       else
	  fprintf (stream,
#ifdef FRAME_GROWS_DOWNWARD
		   "\tAI\t%s,-%ld\n",
#else
		   "\tAI\t%s,%ld\n",
#endif
	  	   reg_names[STACK_POINTER_REGNUM], fsize);
    }

    if (flag_stack_check)
    {
       fprintf (stream, "\tC\t@__stktop,%s\n", reg_names[STACK_POINTER_REGNUM]);
       fprintf (stream, "\tJH\t__plog%02d\n", ti990_plog_id);
       fprintf (stream, "\tBL\t@__stkoverflow\n");
       fprintf (stream, "\tTEXT\t'%s'\n", ti990_function_name);
       fprintf (stream, "\tBYTE\t0\n");
       fprintf (stream, "\tEVEN\n");
       fprintf (stream, "__plog%02d\n", ti990_plog_id);
       ti990_plog_id++;
    }

    fprintf (stream, "\tMOV\t@2(R13),R9\n");
#else
    fprintf (stream,
	     "\tLI\tR1,%ld\n", fsize);
   
    fprintf (stream,"\tBL\t@_csv\n");
#endif
    fprintf (stream, "* end of prologue\n");		
}

/*
   The function epilogue should not depend on the current stack pointer!
   It should use the frame pointer only.  This is mandatory because
   of alloca; we also take advantage of it to omit stack adjustments
   before returning.  */

static void
ti990_output_function_epilogue (stream, size)
     FILE *stream;
     HOST_WIDE_INT size;
{								
    fprintf (stream, "*function epilogue: gen = %d\n", ti990_gen_retval);
    if (ti990_gen_retval)
    {
       switch (ti990_gen_retval)
       {
       case VOIDmode:
	 break;

       case DImode:
       case DFmode:
	 if (TARGET_12)
	  {
	   if (!ti990_emit_ckpt)
	     {
		ti990_emit_ckpt = 1;
		fprintf (stream,  "\tSETO\tR12\n");
	     }
           fprintf (stream, "\tMOVS\tR0,*R13,8,R12\n");
	  }
	 else
	  {
	    fprintf (stream, "\tMOV\tR3,@6(R13)\n");
	    fprintf (stream, "\tMOV\tR2,@4(R13)\n");
	    fprintf (stream, "\tMOV\tR1,@2(R13)\n");
	    fprintf (stream, "\tMOV\tR0,*R13\n");
	  }
         break;

       case SImode:
       case SFmode:
	 if (TARGET_12)
	  {
	   if (!ti990_emit_ckpt)
	     {
		ti990_emit_ckpt = 1;
		fprintf (stream,  "\tSETO\tR12\n");
	     }
           fprintf (stream, "\tMOVS\tR0,*R13,4,R12\n");
	  }
	 else
	  {
	    fprintf (stream, "\tMOV\tR1,@2(R13)\n");
	    fprintf (stream, "\tMOV\tR0,*R13\n");
	  }
	  break;

       default:
	 fprintf (stream, "\tMOV\tR1,@2(R13)\n");
         fprintf (stream, "\tMOV\tR0,*R13\n");
       }
    }
    ti990_gen_retval = 0;
    fprintf (stream, "\tRTWP\n");					
    fprintf (stream, "* end of epilogue\n");
}

static void
ti990_file_start ()
{
  extern const char *main_input_filename;
  extern const char *asm_file_name;
  char temp[256];
  char *bp, *fp;
  if (asm_file_name)
    {
      if (strncmp (asm_file_name, "/tmp", 4) == 0)
        fp = (char *)main_input_filename;
      else
        fp = (char *)asm_file_name;
    }
  else fp = (char *)main_input_filename;
  if ((bp = strrchr (fp, '/')) == NULL)
    bp = fp;
  else bp++;
  while (*bp == '_') bp++;
  strcpy (temp, bp);
  if ((bp = strchr (temp, '.')) != NULL) *bp = '\0';
  for (bp = temp; *bp; bp++)
    *bp = ISLOWER(*bp) ? TOUPPER(*bp) : *bp;

  ti990_module = (char *) xmalloc (strlen(temp)+2);
  strcpy (ti990_module, temp);
  for (bp = temp; *bp; bp++)
    *bp = ISUPPER(*bp) ? TOLOWER(*bp) : *bp;
  temp[8] = '\0';
  fprintf (asm_out_file, "\tIDT\t'%s'\n", temp);
  fprintf (asm_out_file, "\tOPTION\tBUNLST,DUNLST,TUNLST,MUNLST\n");
  if (flag_stack_check)
     fprintf (asm_out_file, "\tLREF\t__stktop,__stkoverflow\n");
#ifndef INLINE_PROLOGUE
   fprintf (asm_out_file, "\tLREF\t_csv\n");
#endif
}

static void
ti990_file_end ()
{
  fputs ("\tEND\n", asm_out_file);
}

/* This is how to output a command to make the user-level label named NAME
   defined for reference from other files.  */

static void
ti990_globalize_label (FILE *stream, const char *name)
{
  fputs ("\tLDEF\t", stream);
  assemble_name (stream, name);
  fputs("\n", stream);
}

/* Output an ascii string.  */

#define ASCII_TEXT_LENGTH 44

void
output_ascii (file, p, size)
     FILE *file;
     const char *p;
     int size;
{
  int i, j;
  int incntrl = FALSE;

  for (i = 0, j = 0; i < size; i++, j++)
    {
      int c = p[i];
      if (c < 0)
	c += 256;
      if (ISCNTRL(c))
        {
	  if (j % ASCII_TEXT_LENGTH != 0)
	    fprintf (file, "'\n");
	  j = -1;
	  if (incntrl)
	    fprintf (file, ",");
	  else
	    fprintf (file, "\tBYTE\t");
	  fprintf (file, ">%02X", c);
	  incntrl = TRUE;
	}
      else
        {
	  if (incntrl)
	    fprintf (file, "\n");
	  incntrl = FALSE;
	  if (j % ASCII_TEXT_LENGTH == 0)
	    fprintf (file, "\tTEXT\t'");
          if (c == '\'')
	    fprintf (file, "%c", c);
          fprintf (file, "%c", c);
	  if (j % ASCII_TEXT_LENGTH == ASCII_TEXT_LENGTH - 1)
	    fprintf (file, "'\n");
        }
    }
  if (incntrl)
    fprintf (file, "\n");
  else if (j % ASCII_TEXT_LENGTH != 0)
    fprintf (file, "'\n");
}


void
print_operand_address (file, addr)
     FILE *file;
     register rtx addr;
{
  register rtx breg;
  rtx offset;
  int splatout;

  splatout = FALSE;

#ifdef DEBUGOPERAND
   fprintf (file, "[print_operand_address: ");
#endif

 retry:

  switch (GET_CODE (addr))
    {
    case MEM:
#ifdef DEBUGOPERAND
      fprintf (file, "MEM ");
#endif
      addr = XEXP (addr, 0);
      if (!atout && GET_CODE(addr) != REG)
      {
	 atout = TRUE;
         putc ('@', file);
      }
      if (!splatout && GET_CODE(addr) == REG)
      {
	 splatout = TRUE;
         putc ('*', file);
      }
      goto retry;

    case REG:
#ifdef DEBUGOPERAND
      fprintf (file, "REG ");
#endif
      if (!splatout)
      {
	 splatout = TRUE;
         putc ('*', file);
      }
      fprintf (file, "%s", reg_names[REGNO (addr)]);
      break;

    case POST_MODIFY:
    case POST_INC:
#ifdef DEBUGOPERAND
      fprintf (file, "POST ");
#endif
      fprintf (file, "*%s+", reg_names[REGNO (XEXP (addr, 0))]);
      break;

    case PLUS:
#ifdef DEBUGOPERAND
      fprintf (file, "PLUS: ");
      //print_rtl_single (file, addr);
#endif
      breg = 0;
      offset = 0;
      if (CONSTANT_ADDRESS_P (XEXP (addr, 0))
	  || GET_CODE (XEXP (addr, 0)) == MEM)
	{
	  offset = XEXP (addr, 0);
	  addr = XEXP (addr, 1);
	}
      else if (CONSTANT_ADDRESS_P (XEXP (addr, 1))
	       || GET_CODE (XEXP (addr, 1)) == MEM)
	{
	  offset = XEXP (addr, 1);
	  addr = XEXP (addr, 0);
	}
      if (GET_CODE (addr) != PLUS)
	;
      else if (GET_CODE (XEXP (addr, 0)) == REG)
	{
	  breg = XEXP (addr, 0);
	  addr = XEXP (addr, 1);
	}
      else if (GET_CODE (XEXP (addr, 1)) == REG)
	{
	  breg = XEXP (addr, 1);
	  addr = XEXP (addr, 0);
	}
      if (GET_CODE (addr) == REG)
	{
	  if (breg != 0) abort();
	  breg = addr;
	  addr = 0;
	}
      if (offset != 0)
	{
	  if (addr != 0) abort();
	  addr = offset;
	}
      if (addr != 0)
        {
	if (!atout)
	 {
	   atout = TRUE;
           putc ('@', file);
	 }
	output_addr_const_ti990 (file, addr);
	}
      if (breg != 0)
	{
	  if (GET_CODE (breg) != REG) abort();
	  fprintf (file, "(%s)", reg_names[REGNO (breg)]);
	}
      break;

    case CONST_INT:
#ifdef DEBUGOPERAND
      fprintf (file, "CONST_INT: ");
#endif
      if (!atout)
      {
	 atout = TRUE;
         putc ('@', file);
      }
      output_addr_const_ti990 (file, addr);
      break;

    default:
#ifdef DEBUGOPERAND
      fprintf (file, "default: ");
      //print_rtl_single (file, addr);
#endif
      output_addr_const_ti990 (file, addr);
    }
#ifdef DEBUGOPERAND
   fprintf (file, "]");
#endif
}

/* Target hook to assemble integer objects.  We need to use the
   990-specific version of output_addr_const.  */

static bool
ti990_assemble_integer (x, size, aligned_p)
     rtx x;
     unsigned int size;
     int aligned_p;
{
  litout = atout = TRUE;
  if (aligned_p)
    switch (size)
      {
      case 1:
	fprintf (asm_out_file, "\tBYTE\t");
	output_addr_const_ti990 (asm_out_file, x);
	fprintf (asm_out_file, "\n");
	return true;

      case 2:
	fprintf (asm_out_file, "\tDATA\t");
	output_addr_const_ti990 (asm_out_file, x);
	fprintf (asm_out_file, "\n");
	return true;

      case 4:
	fprintf (asm_out_file, "\tLONG\t");
	output_addr_const_ti990 (asm_out_file, x);
	fprintf (asm_out_file, "\n");
	return true;

      case 8:
	fprintf (asm_out_file, "\tQUAD\t");
	output_addr_const_ti990 (asm_out_file, x);
	fprintf (asm_out_file, "\n");
	return true;
      }
  return default_assemble_integer (x, size, aligned_p);
}


/* register move costs, indexed by regs */

static int move_costs[N_REG_CLASSES][N_REG_CLASSES] = 
{
             /* NO  MUL  GEN  ALL */

/* NO */     {  0,   0,   0,   0},
/* MUL */    {  0,   2,   2,  22},
/* GEN */    {  0,   2,   2,  22},
/* ALL */    {  0,  22,  22,  22}
};


/* -- note that some moves are tremendously expensive, 
   because they require lots of tricks! do we have to 
   charge the costs incurred by secondary reload class 
   -- as we do here with 22 -- or not ? */

int 
register_move_cost(c1, c2)
  enum reg_class c1, c2;
{
    return move_costs[(int)c1][(int)c2];
}

const char *
output_jump(pos, neg, length)
  const char *pos, *neg;
  int length;
{
    static int x = 0;
    
    static char buf[1000];

    switch (length)
    {
      case 1:
	
	strcpy(buf, pos);
	strcat(buf, "\t%l0");
	return buf;
	
      case 3:
	
	if (neg)
	{
	   sprintf(buf, "%s\tJMP_%d\n\tB\t@%%l0\nJMP_%d", neg, x, x);
	   x++;
	}
	else
	   strcpy (buf,"B\t@%l0");
	return buf;
	
      default:
	abort();
    }
    
}

void
notice_update_cc_on_set(exp, insn)
  rtx exp;
  rtx insn ATTRIBUTE_UNUSED;
{
    if (GET_CODE (SET_DEST (exp)) == CC0)
    { 
	cc_status.flags = 0;					
	cc_status.value1 = SET_DEST (exp);			
	cc_status.value2 = SET_SRC (exp);			

	/*
	if (GET_MODE(SET_SRC(exp)) == DFmode)
	    cc_status.flags |= CC_IN_FPU;
	*/	
    }							
    else if (GET_CODE (SET_SRC (exp)) == CALL)		
    { 
	CC_STATUS_INIT; 
    }
    else if (SET_DEST(exp) == pc_rtx)
    { 
	/* jump */
    }
    else if ((GET_CODE (SET_DEST (exp)) == REG
	      || GET_CODE (SET_DEST (exp)) == MEM)
	     && GET_CODE (SET_SRC (exp)) != PC
	     && (GET_MODE (SET_DEST(exp)) == HImode
		 || GET_MODE (SET_DEST(exp)) == QImode))
    { 
	cc_status.flags = 0;					
	cc_status.value1 = SET_SRC (exp);   			
	cc_status.value2 = SET_DEST (exp);			
	
	if (cc_status.value1 && GET_CODE (cc_status.value1) == REG	
	    && cc_status.value2					
	    && reg_overlap_mentioned_p (cc_status.value1, cc_status.value2))
    	    cc_status.value2 = 0;					
	if (cc_status.value1 && GET_CODE (cc_status.value1) == MEM	
	    && cc_status.value2					
	    && GET_CODE (cc_status.value2) == MEM)			
	    cc_status.value2 = 0; 					
    }							
    else if (GET_CODE (SET_DEST (exp)) == REG)       		
	/* what's this ? */					
    { 
	if ((cc_status.value1					
	     && reg_overlap_mentioned_p (SET_DEST (exp), cc_status.value1)))
	    cc_status.value1 = 0;				
	if ((cc_status.value2					
	     && reg_overlap_mentioned_p (SET_DEST (exp), cc_status.value2)))
	    cc_status.value2 = 0;				
    }							
    else /* if (GET_CODE (SET_DEST (exp)) == MEM)	*/	
    {  
	/* the last else is a bit paranoiac, but since nearly all instructions 
	   play with condition codes, it's reasonable! */

	CC_STATUS_INIT; /* paranoia*/ 
    }		        
}


int
simple_memory_operand(op, mode)
     rtx op;
     enum machine_mode mode ATTRIBUTE_UNUSED;
{
    rtx addr;

    /* Eliminate non-memory operations */
    if (GET_CODE (op) != MEM)
	return FALSE;

    /* Decode the address now.  */

  indirection:
    
    addr = XEXP (op, 0);

    switch (GET_CODE (addr))
    {
      case REG:
	/* (R0) - no extra cost */
	return 1;
	
      case POST_INC:
	/* *R0+ - cheap! */
	return 0;
	
      case MEM:
	/* cheap - is encoded in addressing mode info! 

	   -- except for @(Rx), which has to be @0(Rx) !!! */

	if (GET_CODE (XEXP (addr, 0)) == REG)
	    return 0;
	
	op=addr;
	goto indirection;
	
      case CONST_INT:
      case LABEL_REF:	       
      case CONST:
      case SYMBOL_REF:
	/* @=address - extra cost */
	return 0;

      case PLUS:
	/* @X(R0) - extra cost */
	return 0;

      default:
	break;
    }
    
    return FALSE;
}


/*
 * output a block move:
 *
 * operands[0]	... to
 * operands[1]  ... from
 * operands[2]  ... length
 * operands[3]  ... alignment
 * operands[4]  ... scratch register
 */

 
const char *
output_block_move(operands)
  rtx *operands;
{
    static int count = 0;
    char buf[200];
    
    if (GET_CODE(operands[2]) == CONST_INT && ! optimize_size)
    {
	if (INTVAL(operands[2]) < 5 && INTVAL(operands[3]) == 1)
	{
	    register int i;
	    
	    if (TARGET_12)
	    {
	       if (!ti990_emit_ckpt)
		{
		   ti990_emit_ckpt = 1;
		   output_asm_insn("SETO	R12", operands);
		}
	       output_asm_insn("MOVS	*%1+,*%0+,%i2,R12", operands);
	    }
	    else
	    {
	       for (i = 1; i <= INTVAL(operands[2]); i++)
		   output_asm_insn("MOVB	*%1+,*%0+", operands);
	    }

	    return "";
	}
	else if (INTVAL(operands[2]) < 10 && INTVAL(operands[3]) == 2)
	{
	    register int i;
	    
	    if (TARGET_12)
	    {
	       if (!ti990_emit_ckpt)
		{
		   ti990_emit_ckpt = 1;
		   output_asm_insn("SETO	R12", operands);
		}
	       output_asm_insn("MOVS	*%1+,*%0+,%i2,R12", operands);
	    }
	    else
	    {
	       for (i = 1; i <= INTVAL(operands[2])/2; i++)
		   output_asm_insn("MOV	*%1+,*%0+", operands);
	    }
	    
	    /* may I assume that moved quantity is 
	       multiple of alignment ???

	       I HOPE SO !
	    */

	    return "";
	}
	else if (TARGET_12)
	{
	    register int i;
	    char temp[80];

	    i = INTVAL(operands[2]);
	    while (i > 0)
	    {
	       if (!ti990_emit_ckpt)
		{
		   ti990_emit_ckpt = 1;
		   output_asm_insn("SETO	R12", operands);
		}
	       if (i >= 14)
		  output_asm_insn("MOVS	*%1+,*%0+,14,R12", operands);
	       else
	       {
		  sprintf (temp, "MOVS	*%%1+,*%%0+,%d,R12", i);
		  output_asm_insn(temp, operands);
	       }
	       i -= 14;
	    }
	    return "";
	}
	

	/* can do other clever things, maybe... */
    }

    if (CONSTANT_P(operands[2]))
    {
	register int i;
	char temp[80];

	i = INTVAL(operands[2]);
	/* just move count to scratch */
	sprintf (temp, "LI	%%4,%d", i);
	output_asm_insn(temp, operands);
    }
    else
    {
	/* just clobber the register */
	operands[4] = operands[2];
    }
    

    /* switch over alignment */
    switch (INTVAL(operands[3]))
    {
      case 1:
	
	/* 
	  x
	     MOVB *%1+,*%0+
	     DEC %4
	     JGT x

	*/

	sprintf(buf, "\nmovestrhi%d", count);
	output_asm_insn(buf, NULL);
	
	output_asm_insn("MOVB	*%1+,*%0+", operands);
        output_asm_insn("DEC	%4", operands);
	sprintf(buf, "JGT	movestrhi%d", count);
        output_asm_insn(buf, NULL);
	
	count ++;
	break;
	
      case 2:
	
	/* 
	     SRA %4,1
	   x
	     MOV *%1+,*%0+
	     DEC %4
	     JGT x
	*/

      generate_compact_code:

	output_asm_insn("SRA	%4,1", operands);

	sprintf(buf, "\nmovestrhi%d", count);
	output_asm_insn(buf, NULL);
	
	output_asm_insn("MOV	*%1+,*%0+", operands);
        output_asm_insn("DEC	%4", operands);
        sprintf(buf, "JGT	movestrhi%d", count);
        output_asm_insn(buf, NULL);
	
	count ++;
	break;

      case 4:
	
	/*

	   SRA %4,2

	   x

	     MOV *%1+,*%0+
	     MOV *%1+,*%0+
	     DEC %4
	     JGT x
	*/

	if (optimize_size)
	    goto generate_compact_code;
	
	output_asm_insn("SRA	%4,2", operands);

	sprintf(buf, "\nmovestrhi%d", count);
	output_asm_insn(buf, NULL);
	
	output_asm_insn("MOV	*%1+,*%0+", operands);
	output_asm_insn("MOV	*%1+,*%0+", operands);
        output_asm_insn("DEC	%4", operands);
        sprintf(buf, "JGT	movestrhi%d", count);
        output_asm_insn(buf, NULL);
	
	count ++;
	break;
       
      default:
	
	/*
	   
	   SRA %4,3

	   x

	     MOV *%1+,*%0+
	     MOV *%1+,*%0+
	     MOV *%1+,*%0+
	     MOV *%1+,*%0+
	     DEC %4
	     JGT x
	*/


	if (optimize_size)
	    goto generate_compact_code;
	
	output_asm_insn("SRA	%4,3", operands);

	sprintf(buf, "\nmovestrhi%d", count);
	output_asm_insn(buf, NULL);
	
	output_asm_insn("MOV	*%1+,*%0+", operands);
	output_asm_insn("MOV	*%1+,*%0+", operands);
	output_asm_insn("MOV	*%1+,*%0+", operands);
	output_asm_insn("MOV	*%1+,*%0+", operands);
	
        output_asm_insn("DEC	%4", operands);
        sprintf(buf, "JGT	movestrhi%d", count);
        output_asm_insn(buf, NULL);
	
	count ++;
	break;
	
	;
	
    }
    
    return "";
}

/* for future use */
int
comparison_operator_index(op)
  rtx op;
{
    switch (GET_CODE(op))
    {
      case NE:
	return 0;
	
      case EQ:
	return 1;
	
      case GE:
	return 2;
	
      case GT:
	return 3;
	
      case LE:
	return 4;
	
      case LT:
	return 5;
	
      case GEU:
	return 6;
	
      case GTU:
	return 7;

      case LEU:
	return 8;
	
      case LTU:
	return 9;
	
      default:
	return -1;
    }
}    
	
int
legitimate_address_p (mode, address)
  enum machine_mode mode;
  rtx address;
{
#define REG_OK_STRICT 
    GO_IF_LEGITIMATE_ADDRESS(mode, address, win);
    
    return 0;
    
  win:
    return 1;

#undef REG_OK_STRICT
}

/* A copy of output_addr_const modified for ti990 expression syntax.
   output_addr_const also gets called for %cDIGIT and %nDIGIT, which we don't
   use, and for debugging output, which we don't support with this port either.
   So this copy should get called whenever needed.
*/
void
output_addr_const_ti990 (FILE *file, rtx x)
{
  char buf[256];

#ifdef DEBUGOPERAND
   fprintf (file, "[output_addr_const_ti990: ");
#endif
 restart:
  switch (GET_CODE (x))
    {
    case PC:
#ifdef DEBUGOPERAND
      fprintf (file, "PC ");
#endif
      if (flag_pic)
	putc ('$', file);
      else
	abort ();
      break;

    case SYMBOL_REF:
#ifdef DEBUGOPERAND
      fprintf (file, "SYMBOL_REF flags = %0x ", SYMBOL_REF_FLAGS(x));
#endif
      if (SYMBOL_REF_FUNCTION_P(x) && !litout)
      {
        putc ('=', file);
        litout = TRUE;
      }
      if (!atout)
      {
        atout = TRUE;
        putc ('@', file);
      }
      assemble_name (file, XSTR (x, 0));
      break;

    case LABEL_REF:
#ifdef DEBUGOPERAND
      fprintf (file, "LABEL_REF ");
#endif
      ASM_GENERATE_INTERNAL_LABEL (buf, "L", CODE_LABEL_NUMBER (XEXP (x, 0)));
      assemble_name (file, buf);
      break;

    case CODE_LABEL:
#ifdef DEBUGOPERAND
      fprintf (file, "CODE_LABEL ");
#endif
      ASM_GENERATE_INTERNAL_LABEL (buf, "L", CODE_LABEL_NUMBER (x));
      assemble_name (file, buf);
      break;

    case CONST_INT:
#ifdef DEBUGOPERAND
      fprintf (file, "CONST_INT ");
#endif
      if (GET_MODE (x) == HImode || GET_MODE (x) == QImode)
        fprintf (file, "%hd", (short) INTVAL (x) & 0xFFFF);
      else
        fprintf (file, "%ld", INTVAL (x));
      break;

    case CONST:
#ifdef DEBUGOPERAND
      fprintf (file, "CONST ");
#endif
      output_addr_const_ti990 (file, XEXP (x, 0));
      break;

    case CONST_DOUBLE:
#ifdef DEBUGOPERAND
      fprintf (file, "CONST_DOUBLE ");
#endif
      if (GET_MODE (x) == VOIDmode)
	{
	  /* We can use %o if the number is one word and positive.  */
	  if (CONST_DOUBLE_HIGH (x))
	    abort (); /* Should we just silently drop the high part?  */
	  else
	    fprintf (file, "%ho", (unsigned short) CONST_DOUBLE_LOW (x));
	}
      else
	/* We can't handle floating point constants;
	   PRINT_OPERAND must handle them.  */
	output_operand_lossage ("floating constant misused");
      break;

    case PLUS:
#ifdef DEBUGOPERAND
      fprintf (file, "PLUS ");
#endif
      if (GET_CODE (XEXP (x, 0)) == CONST_INT)
	{
	  output_addr_const_ti990 (file, XEXP (x, 1));
	  if (INTVAL (XEXP (x, 0)) >= 0)
	    fprintf (file, "+");
	  output_addr_const_ti990 (file, XEXP (x, 0));
	}
      else
	{
	  output_addr_const_ti990 (file, XEXP (x, 0));
	  if (INTVAL (XEXP (x, 1)) >= 0)
	    fprintf (file, "+");
	  output_addr_const_ti990 (file, XEXP (x, 1));
	}
      break;

    case MINUS:
#ifdef DEBUGOPERAND
      fprintf (file, "MINUS ");
#endif
      x = simplify_subtraction (x);
      if (GET_CODE (x) != MINUS)
	goto restart;

      output_addr_const_ti990 (file, XEXP (x, 0));
      fprintf (file, "-");
      if (GET_CODE (XEXP (x, 1)) == CONST_INT
	  && INTVAL (XEXP (x, 1)) < 0)
	{
	  fprintf (file, targetm.asm_out.open_paren);
	  output_addr_const_ti990 (file, XEXP (x, 1));
	  fprintf (file, targetm.asm_out.close_paren);
	}
      else
	output_addr_const_ti990 (file, XEXP (x, 1));
      break;

    case ZERO_EXTEND:
    case SIGN_EXTEND:
#ifdef DEBUGOPERAND
      fprintf (file, "EXTEND ");
#endif
      output_addr_const_ti990 (file, XEXP (x, 0));
      break;

    default:
#ifdef DEBUGOPERAND
      fprintf (file, "default: ");
      //print_rtl_single (file, x);
#endif
      output_operand_lossage ("invalid expression as operand");
    }
#ifdef DEBUGOPERAND
   fprintf (file, "]");
#endif
}

/* Print operand X (an rtx) in assembler syntax to file FILE.
   CODE is a letter or dot (`z' in `%z0') or 0 if no letter was specified.
   For `%' followed by punctuation, CODE is the punctuation and X is null.
   code i == print true immediate operand.
*/

void
print_operand (FILE *file, rtx x, int code)
{
  enum rtx_code xcode;
  xcode = GET_CODE (x);
#ifdef DEBUGOPERAND
  fprintf (file, "[print_operand: code = %c(%x), xcode = %d ",
	   isalpha(code) ? code : '.', code, xcode );
#endif
  litout = FALSE;
  atout = FALSE;

  switch (xcode)
    {
    case REG:
#ifdef DEBUGOPERAND
      fprintf (file, "REG ");
#endif
      fprintf (file, "%s", reg_names[REGNO (x)]);
      break;

    case MEM:
#ifdef DEBUGOPERAND
      fprintf (file, "MEM ");
#endif
      if (code == 'C')
        {
	  if (GET_CODE(XEXP(x,0)) == REG)
	    fprintf (file, "%s", reg_names[REGNO (XEXP(x,0))]);
	  else
	    {
	      if (!SYMBOL_REF_EXTERNAL_P(x))
	      {
		 putc ('=', file);
		 litout = TRUE;
	      }
	      output_address (XEXP (x, 0));
	    }
	}
      else
        {
	  if (code == 'i')
	    {
	      if (GET_CODE(XEXP(x,0)) == REG)
	        {
		  fprintf (file, "%s", reg_names[REGNO (XEXP(x,0))]);
		  break;
		}
	      if (SYMBOL_REF_FUNCTION_P(XEXP(x,0)))
	      {
	         litout = TRUE;
		 atout = TRUE;
	      }
	      else if (!SYMBOL_REF_EXTERNAL_P(XEXP(x,0)))
	      {
		 putc ('=', file);
		 litout = TRUE;
	      }
	    }
	  output_address (XEXP (x, 0));
	}
      break;

    case CONST_DOUBLE:
#ifdef DEBUGOPERAND
      fprintf (file, "CONST_DOUBLE ");
#endif
      if (GET_MODE(x) == DImode)
        {
          fprintf (file, "=Q>%08lX%08lX",
	           CONST_DOUBLE_HIGH (x), CONST_DOUBLE_LOW (x));
        }
      else
        {
          char buf[50];
          if (GET_MODE (x) == DFmode)
	   {
	    real_to_decimal (buf, CONST_DOUBLE_REAL_VALUE (x),
				    sizeof (buf), 16, 1);
	    fprintf (file, "=D%s", buf);
	   }
          else
	   {
	    real_to_decimal (buf, CONST_DOUBLE_REAL_VALUE (x),
				    sizeof (buf), 8, 1);
	    fprintf (file, "=F%s", buf);
	   }
        }
      break;

    case CONST_INT:
#ifdef DEBUGOPERAND
      fprintf (file, "CONST_INT : code = %c", code);
#endif
      if (code != 'i')
        {
#ifdef DEBUGOPERAND
	  fprintf (file, "imm mode = %d, code = %d, val = %d\n",
		 GET_MODE(x), code,INTVAL(x));
#endif
	  if (code == 'b')
	    fputs ("=B", file);
	  else  if (code == 'L')
	    fputs ("=L", file);
	  else  if (code == 'Q')
	    fputs ("=Q", file);
	  else
	    fputs ("=W", file);
	}
      output_addr_const_ti990 (file, x);
      break;

    default:
#ifdef DEBUGOPERAND
      fprintf (file, "default: ");
      //print_rtl_single (file, x);
#endif
      if (code == 'i')
      {
	 atout = TRUE;
      }
      else
      {
        putc ('=', file);
      }
      litout = TRUE;
      output_addr_const_ti990 (file, x);
    }
#ifdef DEBUGOPERAND
   fprintf (file, "]");
#endif
}
