/* Definitions of target machine for GNU compiler, for the ti990
   Copyright (C) 1994, 1995, 1996, 1998, 1999, 2000, 2001, 2002
   Free Software Foundation, Inc.
   Contributed by Dave Pitts (dpitts@cozx.com)

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


/* The source file module.  */

/* Target CPU builtins.  */
#define TARGET_CPU_CPP_BUILTINS()		\
  do						\
    {						\
      builtin_define_std ("GCC");		\
      builtin_define_std ("gcc");		\
      builtin_assert ("machine=ti990");		\
      builtin_assert ("cpu=ti990");		\
    }						\
  while (0)

extern char *ti990_module;
extern int ti990_gen_retval;
extern int ti990_emit_ckpt;

/* Print subsidiary information on the compiler version in use.  */
#define TARGET_VERSION fprintf (stderr, " (ti990)");


/* Generate DBX debugging information.  */

/* #define DBX_DEBUGGING_INFO */

/* Run-time compilation parameters selecting different hardware subsets.
*/

extern int target_flags;

/* Macro to define tables used to set the flags.
   This is a list in braces of triplets in braces,
   each triplet being { "NAME", VALUE, DOC }
   where VALUE is the bits to set or minus the bits to clear and DOC
   is the documentation for --help (NULL if intentionally undocumented).
   An empty string NAME is used to identify the default VALUE.  */

#define TARGET_SWITCHES  						\
{/* is 990/12 */							\
    { "model12", 1, N_("Generate code for a 990/12") },			\
    { "model10", -1, N_("Generate code for a 990/10") },		\
/* use movstrhi for bcopy */                                            \
    { "bcopy", 2, NULL },                                               \
    { "bcopy-builtin", -2, NULL },                                      \
/* default */								\
    { "", TARGET_DEFAULT, NULL}						\
}

#define TARGET_DEFAULT (0)

#define TARGET_12		(target_flags & 1)
#define TARGET_10		(! TARGET_12)

#define TARGET_BCOPY_BUILTIN    (! (target_flags & 2))

#define HAS_INIT_SECTION


/* TYPE SIZES */
#define CHAR_TYPE_SIZE		8
#define SHORT_TYPE_SIZE		16
#define INT_TYPE_SIZE		16
#define LONG_TYPE_SIZE		32
#define LONG_LONG_TYPE_SIZE	64     

/* if we set FLOAT_TYPE_SIZE to 32, we could have the benefit 
   of saving core for huge arrays - the definitions are 
   already in md */
#define FLOAT_TYPE_SIZE		32
#define DOUBLE_TYPE_SIZE	64
#define LONG_DOUBLE_TYPE_SIZE	64

/* machine types from ansi */
#define SIZE_TYPE "unsigned int" 	/* definition of size_t */
#define WCHAR_TYPE "int" 		/* or long int???? */
#define WCHAR_TYPE_SIZE 16

#define PTRDIFF_TYPE "int"

/* target machine storage layout */

/* Define this if most significant bit is lowest numbered
   in instructions that operate on numbered bit-fields.  */
#define BITS_BIG_ENDIAN 1

/* Define this if most significant byte of a word is the lowest numbered.  */
#define BYTES_BIG_ENDIAN 1

/* Define this if most significant word of a multiword number is numbered.  */
#define WORDS_BIG_ENDIAN 1

/* number of bits in an addressable storage unit */
#define BITS_PER_UNIT 8

/* Width in bits of a "word", which is the contents of a machine register.
   Note that this is not necessarily the width of data type `int';
   if using 16-bit ints on a 68000, this would still be 32.
   But on a machine with 16-bit registers, this would be 16.  */
/*  This is a machine with 16-bit registers */
#define BITS_PER_WORD 16

/* Width of a word, in units (bytes). 

   UNITS OR BYTES - seems like units */
#define UNITS_PER_WORD 2

/* Maximum sized of reasonable data type 
   DImode or Dfmode ...*/
#define MAX_FIXED_MODE_SIZE 64	

/* Width in bits of a pointer.
   See also the macro `Pmode' defined below.  */
#define POINTER_SIZE 16

/* Allocation boundary (in *bits*) for storing pointers in memory.  */
#define POINTER_BOUNDARY 16

/* Allocation boundary (in *bits*) for storing arguments in argument list.  */
#define PARM_BOUNDARY 16

/* Boundary (in *bits*) on which stack pointer should be aligned.  */
#define STACK_BOUNDARY 16

/* Allocation boundary (in *bits*) for the code of a function.  */
#define FUNCTION_BOUNDARY 16

/* Alignment of field after `int : 0' in a structure.  */
#define EMPTY_FIELD_BOUNDARY 16

/* No data type wants to be aligned rounder than this.  */
#define BIGGEST_ALIGNMENT 16

/* Define target floating point format.  ti990 uses IBM float */

#define TARGET_FLOAT_FORMAT IBM_FLOAT_FORMAT

/* Define this if move instructions will actually fail to work
   when given unaligned data.  */
#define STRICT_ALIGNMENT 1

/* Standard register usage.  */

/* Number of actual hardware registers.
   The hardware registers are assigned numbers for the compiler
   from 0 to just below FIRST_PSEUDO_REGISTER.
   All registers that the compiler knows about must be given numbers,
   even those that are not normally considered general registers.
   I've generalized the floating point usage of registers using Macros. All
   of the machine dependent issues are removed from gcc.
*/

#define FIRST_PSEUDO_REGISTER 16

/* 1 for registers that have pervasive standard uses
   and are not available for the register allocator.
*/

/* don't let them touch RTWP regs for the time being !*/

#define FIXED_REGISTERS  \
{0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, }



/* 1 for registers not available across function calls.
   These must include the FIXED_REGISTERS and also any
   registers that can be used without being saved.
   The latter must include the registers where values are returned
   and the register where structure-value addresses are passed.
   Aside from that, you can include as many other registers as you like.  */

#define CALL_USED_REGISTERS  \
{1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, }


/* Return number of consecutive hard regs needed starting at reg REGNO
   to hold something of mode MODE.
   This is ordinarily the length in words of a value of mode MODE
   but can be less for certain modes in special long registers.  */

#define HARD_REGNO_NREGS(REGNO, MODE)   				\
   ((GET_MODE_SIZE(MODE)+UNITS_PER_WORD-1) / UNITS_PER_WORD)

/* Value is 1 if hard register REGNO can hold a value of machine-mode MODE.
   On the 990, the cpu registers can hold any mode - check alignment */

#define HARD_REGNO_MODE_OK(REGNO, MODE) 		\
  ((REGNO) < 16 ? (((REGNO) & 1) == 0 || 				\
		  (((MODE) != DImode) && ((MODE) != DFmode)))		\
		: ((MODE) == SFmode || (MODE) == DFmode))

/* Value is 1 if it is a good idea to tie two pseudo registers
   when one has mode MODE1 and one has mode MODE2.
   If HARD_REGNO_MODE_OK could produce different values for MODE1 and MODE2,
   for any hard reg, then this must be 0 for correct output.  */
#define MODES_TIEABLE_P(MODE1, MODE2)					\
  (((MODE1) == SFmode || (MODE1) == DFmode)				\
   == ((MODE2) == SFmode || (MODE2) == DFmode))

/* Specify the registers used for certain standard purposes.
   The values of these macros are register numbers.  */

/* the 990 pc in not overloaded on a register that the compiler knows about.  */
/*#define PC_REGNUM  15 */

/* Register to use for pushing function arguments.  */
#define STACK_POINTER_REGNUM 11

/* Base register for access to local variables of the function.  */
#define FRAME_POINTER_REGNUM 10

/* Value should be nonzero if functions must have frame pointers.
   Zero means the frame pointer need not be set up (and parms
   may be accessed via the stack pointer) in functions that seem suitable.
   This is computed in `reload', in reload1.c.
  */

#define FRAME_POINTER_REQUIRED 1

/* Base register for access to arguments of the function.  */
#define ARG_POINTER_REGNUM 9

/* Register in which static-chain is passed to a function.  */
/* ??? - i don't want to give up a reg for this! */
#define STATIC_CHAIN_REGNUM 15

/* Register in which address to store a structure value
   is passed to a function.  
   let's make it an invisible first argument!!! */

#define STRUCT_VALUE 0


/* Define the classes of registers for register constraints in the
   machine description.  Also define ranges of constants.

   One of the classes must always be named ALL_REGS and include all hard regs.
   If there is more than one class, another class must be named NO_REGS
   and contain no registers.

   The name GENERAL_REGS must be the name of a class (or an alias for
   another name such as ALL_REGS).  This is the class of registers
   that is allowed by "g" or "r" in a register constraint.
   Also, registers outside this class are allocated only when
   instructions express preferences for them.

   The classes must be numbered in nondecreasing order; that is,
   a larger-numbered class must never be contained completely
   in a smaller-numbered class.

   For any two classes, it is very desirable that there be another
   class that represents their union.  */
   
/* The ti990 has a couple of classes:

GENERAL_REGS are all cpu.
INDEX_REGS registers for indexing.
*/

enum reg_class { NO_REGS, GENERAL_REGS, INDEX_REGS, \
   ALL_REGS, LIM_REG_CLASSES };

#define N_REG_CLASSES (int) LIM_REG_CLASSES

/* have to allow this till cmpsi/tstsi are fixed in a better way !! */
#define SMALL_REGISTER_CLASSES 1

/* Since GENERAL_REGS is the same class as ALL_REGS,
   don't give it a different class number; just make it an alias.  */

/* #define GENERAL_REGS ALL_REGS */

/* Give names of register classes as strings for dump file.   */

#define REG_CLASS_NAMES {"NO_REGS", "GENERAL_REGS", "INDEX_REGS", \
   "ALL_REGS" }

/* Define which registers fit in which classes.
   This is an initializer for a vector of HARD_REG_SET
   of length N_REG_CLASSES.  */

#define REG_CLASS_CONTENTS {{0}, {0x0ffff}, {0x0fffe}, {0x0ffff}}

/* The same information, inverted:
   Return the class number of the smallest class containing
   reg number REGNO.  This could be a conditional expression
   or could index an array.  */

#define REGNO_REG_CLASS(REGNO) 		\
((REGNO > 0) ? INDEX_REGS : GENERAL_REGS)


/* The class value for index registers, and the one for base regs.  */
#define INDEX_REG_CLASS INDEX_REGS
#define BASE_REG_CLASS INDEX_REGS

/* Get reg_class from a letter such as appears in the machine description.  */

#define REG_CLASS_FROM_LETTER(C)	\
  ((C) == 'a' ? INDEX_REGS :		\
  ((C) == 'd' ? GENERAL_REGS :		\
  ((C) == 'f' ? GENERAL_REGS : NO_REGS)))


/* The letters I, J, K, L and M in a register constraint string
   can be used to stand for particular ranges of immediate operands.
   This macro defines what the ranges are.
   C is the letter, and VALUE is a constant value.
   Return 1 if VALUE is in the range specified by C.

   I		bits 16-31 0000
   J		bits 00-15 0000
   K		completely random 32 bit
   L,M,N	-1,1,0 respectively
   O 		where doing shifts in sequence is faster than 
                one big shift 
*/

#define CONST_OK_FOR_LETTER_P(VALUE, C)  		\
  ((C) == 'I' ? ((VALUE) & 0xffff0000) == 0		\
   : (C) == 'J' ? ((VALUE) & 0x0000ffff) == 0  	       	\
   : (C) == 'K' ? (((VALUE) & 0xffff0000) != 0		\
		   && ((VALUE) & 0x0000ffff) != 0)	\
   : (C) == 'L' ? ((VALUE) == 1)			\
   : (C) == 'M' ? ((VALUE) == -1)			\
   : (C) == 'N' ? ((VALUE) == 0)			\
   : (C) == 'O' ? (abs(VALUE) >1 && abs(VALUE) <= 4)	\
   : 0)

/* Similar, but for floating constants, and defining letters G and H.
   Here VALUE is the CONST_DOUBLE rtx itself.  */

#define CONST_DOUBLE_OK_FOR_LETTER_P(VALUE, C)  \
  ((C) == 'G' && XINT (VALUE, 0) == 0 && XINT (VALUE, 1) == 0)


/* Letters in the range `Q' through `U' may be defined in a
   machine-dependent fashion to stand for arbitrary operand types. 
   The machine description macro `EXTRA_CONSTRAINT' is passed the
   operand as its first argument and the constraint letter as its
   second operand.

   `Q'	is for memory references using take more than 1 instruction.
   `R'	is for memory references which take 1 word for the instruction.  */
#define EXTRA_CONSTRAINT(OP,CODE)					\
  ((GET_CODE (OP) != MEM) ? 0						\
   : !legitimate_address_p (GET_MODE (OP), XEXP (OP, 0)) ? 0		\
   : ((CODE) == 'Q')	  ? !simple_memory_operand (OP, GET_MODE (OP))	\
   : ((CODE) == 'R')	  ? simple_memory_operand (OP, GET_MODE (OP))	\
   : 0)

/* Given an rtx X being reloaded into a reg required to be
   in class CLASS, return the class of reg to actually use.
   In general this is just CLASS; but on some machines
   in some cases it is preferable to use a more restrictive class.  
*/

#define PREFERRED_RELOAD_CLASS(X,CLASS) 	\
  (GET_CODE(X) == CONST_DOUBLE ? GENERAL_REGS :                            \
   GET_CODE(X) == CONST_INT ? (reload_in_progress ? INDEX_REGS : GENERAL_REGS):\
   GET_CODE(X) == LABEL_REF ||                                        \
   GET_CODE(X) == SYMBOL_REF ||                                       \
   GET_CODE(X) == CONST ? INDEX_REGS : (CLASS))


/* Return the maximum number of consecutive registers
   needed to represent mode MODE in a register of class CLASS.  */
#define CLASS_MAX_NREGS(CLASS, MODE)	\
   ((GET_MODE_SIZE (MODE) + UNITS_PER_WORD - 1) / UNITS_PER_WORD)


/* Stack layout; function entry, exit and calling.  */

/* Define this if pushing a word on the stack
   makes the stack pointer a smaller address.  */
/*#define STACK_GROWS_DOWNWARD*/

/* Define this if the nominal address of the stack frame
   is at the high-address end of the local variables;
   that is, each additional local variable allocated
   goes at a more negative offset in the frame.
*/
/*#define FRAME_GROWS_DOWNWARD*/

/* Offset within stack frame to start allocating local variables at.
   If FRAME_GROWS_DOWNWARD, this is the offset to the END of the
   first local allocated.  Otherwise, it is the offset to the BEGINNING
   of the first local allocated.  */

#define STARTING_FRAME_OFFSET 0

#define INITIAL_FRAME_POINTER_OFFSET(DEPTH) (DEPTH) = STARTING_FRAME_OFFSET

/* If we generate an insn to push BYTES bytes,
   this says how many the stack pointer really advances by.
   On the ti990, the stack is on an even boundary */
/* #define PUSH_ROUNDING(BYTES) ((BYTES + 1) & ~1) */

/* Accumulate the outgoing argument count so we can request the right
   DSA size and determine stack offset.  */

#define ACCUMULATE_OUTGOING_ARGS 1

/* Offset of first parameter from the argument pointer register value.  */

#define FIRST_PARM_OFFSET(FNDECL) 0

/* Value is 1 if returning from a function call automatically
   pops the arguments described by the number-of-args field in the call.
   FUNDECL is the declaration node of the function (as a tree),
   FUNTYPE is the data type of the function (as a tree),
   or for a library call it is an identifier node for the subroutine name.  */

#define RETURN_POPS_ARGS(FUNDECL,FUNTYPE,SIZE) 0

/* Define how to find the value returned by a function.
   VALTYPE is the data type of the value (as a tree).
   If the precise function being called is known, FUNC is its FUNCTION_DECL;
   otherwise, FUNC is 0.  */

#define BASE_RETURN_VALUE_REG(MODE) 0

/* On the ti990 the value is found in R0 */

#define FUNCTION_VALUE(VALTYPE, FUNC)  \
   ti990_function_value ((VALTYPE),(FUNC))

/* Define how to find the value returned by a library function
   assuming the value has mode MODE.  */

#define LIBCALL_VALUE(MODE)  gen_rtx_REG (MODE, BASE_RETURN_VALUE_REG(MODE))

/* 1 if N is a possible register number for a function value
   as seen by the caller.
   On the 990, the first "output" reg is the only register thus used. 
*/

#define FUNCTION_VALUE_REGNO_P(N) ((N) == 0)

/* should probably return DImode and DFmode in memory,lest
   we fill up all regs!
*/

#define RETURN_IN_MEMORY(TYPE)	\
  (TYPE_MODE(TYPE) == DImode || TYPE_MODE(TYPE) == DFmode)


/* 1 if N is a possible register number for function argument passing.  */

#define FUNCTION_ARG_REGNO_P(N) 0

/* Define a data type for recording info about an argument list
   during the scan of that argument list.  This data type should
   hold all necessary information about the function itself
   and about the args processed so far, enough to enable macros
   such as FUNCTION_ARG to determine where the next arg should go.
*/

#define CUMULATIVE_ARGS int

/* Initialize a variable CUM of type CUMULATIVE_ARGS
   for a call to a function whose data type is FNTYPE.
   For a library call, FNTYPE is 0.

   ...., the offset normally starts at 0, but starts at 1 word
   when the function gets a structure-value-address as an
   invisible first argument.  */

#define INIT_CUMULATIVE_ARGS(CUM,FNTYPE,LIBNAME,INDIRECT,N_NAMED_ARGS) \
 ((CUM) = 0)

/* Update the data in CUM to advance over an argument
   of mode MODE and data type TYPE.
   (TYPE is null for libcalls where that information may not be available.)  
*/


#define FUNCTION_ARG_ADVANCE(CUM, MODE, TYPE, NAMED)	\
 ((CUM) += ((MODE) != BLKmode			\
	    ? (GET_MODE_SIZE (MODE))		\
	    : (int_size_in_bytes (TYPE))))	

/* Determine where to put an argument to a function.
   Value is zero to push the argument on the stack,
   or a hard register in which to store the argument.

   MODE is the argument's machine mode.
   TYPE is the data type of the argument (as a tree).
    This is null for libcalls where that information may
    not be available.
   CUM is a variable of type CUMULATIVE_ARGS which gives info about
    the preceding args and about the function being called.
   NAMED is nonzero if this argument is a named parameter
    (otherwise it is an extra parameter matching an ellipsis).  */

#define FUNCTION_ARG(CUM, MODE, TYPE, NAMED)  0

/* Define where a function finds its arguments.
   This would be different from FUNCTION_ARG if we had register windows.  */
/*
#define FUNCTION_INCOMING_ARG(CUM, MODE, TYPE, NAMED)	\
  FUNCTION_ARG (CUM, MODE, TYPE, NAMED)
*/

/* For an arg passed partly in registers and partly in memory,
   this is the number of registers used.
   For args passed entirely in registers or entirely in memory, zero.  */

#define FUNCTION_ARG_PARTIAL_NREGS(CUM, MODE, TYPE, NAMED) 0

/* Output assembler code to FILE to increment profiler label # LABELNO
   for profiling a function entry.  */

#define FUNCTION_PROFILER(FILE, LABELNO)  \
   abort ();

/* EXIT_IGNORE_STACK should be nonzero if, when returning from a function,
   the stack pointer does not matter.  The value is tested only in
   functions that have frame pointers.
   No definition is equivalent to always zero.  */

extern int may_call_alloca;

#define EXIT_IGNORE_STACK	1

/* Addressing modes, and classification of registers for them.  */

/* #define HAVE_PRE_INCREMENT 0 */
/* #define HAVE_PRE_DECREMENT 0 */

/* #define HAVE_POST_DECREMENT 0 */
#define HAVE_POST_INCREMENT 1

/* Macros to check register numbers against specific register classes.  */

/* These assume that REGNO is a hard or pseudo reg number.
   They give nonzero only if REGNO is a hard reg of the suitable class
   or a pseudo reg currently allocated to a suitable hard reg.
   Since they use reg_renumber, they are safe only once reg_renumber
   has been allocated, which happens in local-alloc.c.  */

#define REGNO_OK_FOR_INDEX_P(REGNO) \
  ( ((REGNO) > 0 && (REGNO) < 16) )

#define REGNO_OK_FOR_BASE_P(REGNO) REGNO_OK_FOR_INDEX_P(REGNO)

#define REGNO_OK_FOR_DATA_P(REGNO) 					\
  ((REGNO) < 16 || (unsigned) reg_renumber[REGNO] < 16)

#define REGNO_OK_FOR_FP_P(REGNO) 					\
  ((unsigned) ((REGNO) < 5) || (unsigned) (reg_renumber[REGNO] < 5))

/* Now macros that check whether X is a register and also,
   strictly, whether it is in a specified class.
*/

/* 1 if X is a data register.  */

#define DATA_REG_P(X) (REG_P (X) && REGNO_OK_FOR_DATA_P (REGNO (X)))

/* 1 if X is an fp register.  */

#define FP_REG_P(X) (REG_P (X) && REGNO_OK_FOR_FP_P (REGNO (X)))



/* Maximum number of registers that can appear in a valid memory address.  */

#define MAX_REGS_PER_ADDRESS 1

/* Recognize any constant value that is a valid address.  */

#define CONSTANT_ADDRESS_P(X)  CONSTANT_P (X)

/* Nonzero if the constant value X is a legitimate general operand.
   It is given that X satisfies CONSTANT_P or is a CONST_DOUBLE.  */

#define LEGITIMATE_CONSTANT_P(X) (1)

/* The macros REG_OK_FOR..._P assume that the arg is a REG rtx
   and check its validity for a certain class.
   We have two alternate definitions for each of them.
   The usual definition accepts all pseudo regs; the other rejects
   them unless they have been allocated suitable hard regs.
   The symbol REG_OK_STRICT causes the latter definition to be used.

   Most source files want to accept pseudo regs in the hope that
   they will get allocated to the class that the insn wants them to be in.
   Source files for reload pass need to be strict.
   After reload, it makes no difference, since pseudo regs have
   been eliminated by then.  */

#ifndef REG_OK_STRICT

/* Nonzero if X is a hard reg that can be used as an index or if it is
   a pseudo reg.  */
#define REG_OK_FOR_INDEX_P(X)						\
  ((REGNO(X) > 0 && REGNO(X) < 16) || REGNO(X) > 16)

/* Nonzero if X is a hard reg that can be used as a base reg or if it is
   a pseudo reg.  */
#define REG_OK_FOR_BASE_P(X) REG_OK_FOR_INDEX_P(X)

#else

/* Nonzero if X is a hard reg that can be used as an index.  */
#define REG_OK_FOR_INDEX_P(X) REGNO_OK_FOR_INDEX_P (REGNO (X))
#define REG_OK_FOR_BASE_P(X) REGNO_OK_FOR_BASE_P (REGNO (X))

#endif

/* GO_IF_LEGITIMATE_ADDRESS recognizes an RTL expression
   that is a valid memory address for an instruction.
   The MODE argument is the machine mode for the MEM expression
   that wants to use this address.

*/

#define GO_IF_LEGITIMATE_ADDRESS(mode, operand, ADDR) \
{						      \
    rtx xfoob;								\
									\
    /* accept R0 */							\
    if (GET_CODE (operand) == REG					\
	&& REG_OK_FOR_BASE_P(operand))					\
      goto ADDR;							\
									\
    /* accept @address */						\
    if (CONSTANT_ADDRESS_P (operand))					\
      goto ADDR;							\
    									\
    /* accept @X(R0) */							\
    if (GET_CODE (operand) == PLUS       				\
	&& GET_CODE (XEXP (operand, 0)) == REG				\
	&& REG_OK_FOR_BASE_P (XEXP (operand, 0))			\
	&& CONSTANT_ADDRESS_P (XEXP (operand, 1)))			\
      goto ADDR;							\
    									\
    /* accept *R0+ */							\
    if (GET_CODE (operand) == POST_INC					\
	&& GET_CODE (XEXP (operand, 0)) == REG				\
	&& REG_OK_FOR_BASE_P (XEXP (operand, 0)))			\
      goto ADDR;							\
    									\
  /* anything else is invalid */					\
  fail: ;								\
}

/* Try machine-dependent ways of modifying an illegitimate address
   to be legitimate.  If we find one, return the new, valid address.
   This macro is used in only one place: `memory_address' in explow.c.

   OLDX is the address as it was before break_out_memory_refs was called.
   In some cases it is useful to look at this to decide what needs to be done.

   MODE and WIN are passed so that this macro can use
   GO_IF_LEGITIMATE_ADDRESS.

   It is always safe for this macro to do nothing.  It exists to recognize
   opportunities to optimize the output.  */

#define LEGITIMIZE_ADDRESS(X,OLDX,MODE,WIN)	{}


/* Go to LABEL if ADDR (a legitimate address expression)
   has an effect that depends on the machine mode it is used for.
   On the 990 this is for postinc */

#define GO_IF_MODE_DEPENDENT_ADDRESS(ADDR,LABEL)			\
 { if (GET_CODE (ADDR) == POST_INC)					\
     goto LABEL; 							\
 }


/* Specify the machine mode that this machine uses
   for the index in the tablejump instruction.  */
#define CASE_VECTOR_MODE HImode

/* Define this if a raw index is all that is needed for a
   `tablejump' insn.  */
#define CASE_TAKES_INDEX_RAW

/* Define as C expression which evaluates to nonzero if the tablejump
   instruction expects the table to contain offsets from the address of the
   table.
   Do not define this if the table should contain absolute addresses. */
/* #define CASE_VECTOR_PC_RELATIVE 1 */

/* Define this as 1 if `char' should by default be signed; else as 0.  */
#define DEFAULT_SIGNED_CHAR 1

/* Max number of bytes we can move from memory to memory
   in one reasonably fast instruction.  
*/

#define MOVE_MAX 2

/* Nonzero if access to memory by byte is slow and undesirable. -
*/
#define SLOW_BYTE_ACCESS 0

/* Do not break .stabs pseudos into continuations.  */
#define DBX_CONTIN_LENGTH 0

/* Value is 1 if truncating an integer of INPREC bits to OUTPREC bits
   is done just by pretending it is already truncated.  */
#define TRULY_NOOP_TRUNCATION(OUTPREC, INPREC) 1


/* We assume that the store-condition-codes instructions store 0 for false
   and some other value for true.  This is the value stored for true.  */

/* #define STORE_FLAG_VALUE 1 */

/* Specify the machine mode that pointers have.
   After generation of rtl, the compiler makes no further distinction
   between pointers and any other objects of this machine mode.  */
#define Pmode HImode

/* A function address in a call instruction
   is a word address (for indexing purposes)
   so give the MEM rtx a word's mode.  */
#define FUNCTION_MODE HImode

/* Define this if addresses of constant functions
   shouldn't be put through pseudo regs where they can be cse'd.
   Desirable on machines where ordinary constants are expensive
   but a CALL with constant address is cheap.  */
/* #define NO_FUNCTION_CSE */

/* Tell emit-rtl.c how to initialize special values on a per-function base.  */
extern int optimize;
extern struct rtx_def *cc0_reg_rtx;

#define CC_STATUS_MDEP rtx

#define CC_STATUS_MDEP_INIT (cc_status.mdep = 0)

/* Tell final.c how to eliminate redundant test instructions.  */

/* Do UPDATE_CC if EXP is a set, used in
   NOTICE_UPDATE_CC 

   floats only do compare correctly, else nullify ...

   get cc0 out soon ...
*/

/* Store in cc_status the expressions
   that the condition codes will describe
   after execution of an instruction whose pattern is EXP.
   Do not alter them if the instruction would not alter the cc's.  */

#define NOTICE_UPDATE_CC(EXP, INSN) 					\
{ if (GET_CODE (EXP) == SET)						\
    {									\
      notice_update_cc_on_set(EXP, INSN);				\
    }									\
  else if (GET_CODE (EXP) == PARALLEL					\
	   && GET_CODE (XVECEXP (EXP, 0, 0)) == SET)			\
    {									\
      notice_update_cc_on_set(XVECEXP (EXP, 0, 0), INSN);		\
    }									\
  else if (GET_CODE (EXP) == CALL)					\
    { /* all bets are off */ CC_STATUS_INIT; }				\
  if (cc_status.value1 && GET_CODE (cc_status.value1) == REG		\
      && cc_status.value2						\
      && reg_overlap_mentioned_p (cc_status.value1, cc_status.value2))	\
    { 									\
      printf ("here!\n");						\
      cc_status.value2 = 0;						\
    }									\
}


/* Output to assembler file text saying following lines
   may contain character constants, extra white space, comments, etc.  */

#define ASM_APP_ON ""

/* Output to assembler file text saying following lines
   no longer contain unusual constructs.  */

#define ASM_APP_OFF ""
#define ASM_COMMENT_START "* "

/* Output before read-only data.  */
#define TEXT_SECTION_ASM_OP "\tEVEN\n\tPSEG\t\tText section"

/* Output before writable data.  */
#define DATA_SECTION_ASM_OP "\tEVEN\n\tPSEG\t\tData section"

/* Output before BSS data.  */
#define BSS_SECTION_ASM_OP "\tEVEN\n\tDSEG\t\tBSS section"

#define ASM_OUTPUT_BSS(FILE, DECL, NAME, SIZE, ROUNDED) \
  asm_output_bss ((FILE), (DECL), (NAME), (SIZE), (ROUNDED))

/* How to refer to registers in assembler output.
   This sequence is indexed by compiler's hard-register-number (see above).  */

#define REGISTER_NAMES \
{"R0",  "R1",  "R2",  "R3",  "R4",  "R5",  "R6",  "R7",	\
 "R8",  "R9", "R10", "R11", "R12", "R13", "R14", "R15",	}

/* This is how to output the definition of a user-level label named NAME,
   such as the label on a static function or variable NAME.  */

#define ASM_OUTPUT_LABEL(FILE,NAME)	\
  do { assemble_name (FILE, NAME); fputs ("\n", FILE); } while (0)

#define ASM_OUTPUT_EXTERNAL(FILE,DECL,NAME)				\
do { fputs ("\tLREF\t", FILE); assemble_name(FILE, NAME); fputs ("\n", FILE); } while (0)

/* The prefix to add to user-visible assembler symbols. */

#define USER_LABEL_PREFIX "_"

/* This is how to store into the string LABEL
   the symbol_ref name of an internal numbered label where
   PREFIX is the class of label and NUM is the number within the class.
   This is suitable for output with `assemble_name'.  */

#define ASM_GENERATE_INTERNAL_LABEL(LABEL,PREFIX,NUM)	\
  do { ti990_emit_ckpt = 0; sprintf (LABEL, "%s%d", PREFIX, NUM); } while (0)
       

#define ASM_OUTPUT_ASCII(FILE, P, SIZE)  \
  output_ascii (FILE, P, SIZE)

/* This is how to output an element of a case-vector that is absolute.  */

#define ASM_OUTPUT_ADDR_VEC_ELT(FILE, VALUE)  \
  fprintf (FILE, "\tDATA\t_L%d\n", VALUE)

/* This is how to output an element of a case-vector that is relative.
   Don't define this if it is not supported. */

/* #define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, VALUE, REL) */

/* This is how to output an assembler line
   that says to advance the location counter
   to a multiple of 2**LOG bytes. 

   who needs this????
*/

#define ASM_OUTPUT_ALIGN(FILE,LOG)	\
  switch (LOG)				\
    {					\
      case 0:				\
	break;				\
      case 1:				\
	fprintf (FILE, "\tEVEN\n");	\
	break;				\
      default:				\
	abort ();			\
    }

#define ASM_OUTPUT_SKIP(FILE,SIZE)  \
  fprintf (FILE, "\tBSS\t%d\n", (SIZE))

/* This says how to output an assembler line
   to define a global common symbol.  */
#define ASM_OUTPUT_COMMON(FILE, NAME, SIZE, ROUNDED)  \
( fprintf ((FILE), "\tLDEF\t"),			\
  assemble_name ((FILE), (NAME)),		\
  fprintf ((FILE), "\n"),			\
  fprintf ((FILE),"\tEVEN\n\tCSEG\t'"),		\
  assemble_name ((FILE), (NAME)),		\
  fprintf ((FILE), "'\n"),			\
  assemble_name ((FILE), (NAME)),		\
  fprintf ((FILE), "\n\tBSS\t%d\n", (ROUNDED)),	\
  fprintf ((FILE),"\tCEND\n")			\
)

/* This says how to output an assembler line
   to define a local common symbol.  */

#define ASM_OUTPUT_LOCAL(FILE, NAME, SIZE, ROUNDED)  \
( bss_section(),				\
  assemble_name ((FILE), (NAME)),		\
  fprintf ((FILE), "\n\tBSS\t%d\n", (ROUNDED)))

/* Store in OUTPUT a string (made with alloca) containing
   an assembler-name for a local static variable named NAME.
   LABELNO is an integer which is different for each call.  */

#define ASM_FORMAT_PRIVATE_NAME(OUTPUT, NAME, LABELNO)	\
( (OUTPUT) = (char *) alloca (strlen ((NAME)) + 10),	\
  sprintf ((OUTPUT), "%s.%d", (NAME), (LABELNO)))

/* Print operand X (an rtx) in assembler syntax to file FILE.
   CODE is a letter or dot (`z' in `%z0') or 0 if no letter was specified.
   For `%' followed by punctuation, CODE is the punctuation and X is null.

*/

#define PRINT_OPERAND(FILE, X, CODE)  print_operand(FILE,X,CODE)

/* Print a memory address as an operand to reference that memory location.  */

#define PRINT_OPERAND_ADDRESS(FILE, ADDR) print_operand_address(FILE,ADDR)

#define ASM_OUTPUT_REG_PUSH(FILE,REGNO)					     \
{									     \
  fprintf (FILE, "*PUSH\n");						     \
  fprintf (FILE, "\tDECT\tR%d\n", FRAME_POINTER_REGNUM);		     \
  fprintf (FILE, "\tMOV\t%s,*R%d\n", reg_names[REGNO], FRAME_POINTER_REGNUM); \
}

#define ASM_OUTPUT_REG_POP(FILE,REGNO)                 			     \
{                                                       		     \
  fprintf (FILE, "*POP\n");						     \
  fprintf (FILE, "\tINCT\tR%d\n", FRAME_POINTER_REGNUM);		     \
  fprintf (FILE, "\tMOV\t*R%d,%s\n", FRAME_POINTER_REGNUM, reg_names[REGNO]); \
}

#define ASM_DECLARE_FUNCTION_NAME(STREAM, NAME, DECL)			\
do {									\
  if (strlen (NAME) + 1 > ti990_function_name_length)			\
    {									\
      if (ti990_function_name)						\
	free (ti990_function_name);					\
      ti990_function_name = 0;						\
    }									\
  if (!ti990_function_name)						\
    {									\
      ti990_function_name_length = strlen (NAME) * 2 + 1;		\
      ti990_function_name = (char *) xmalloc (ti990_function_name_length); \
    }									\
  strcpy (ti990_function_name, NAME);					\
  ASM_OUTPUT_LABEL (STREAM, NAME);					\
} while (0)


/* trampoline - how should i do it in separate i+d ? 
   have some allocate_trampoline magic??? 

   the following should work for shared I/D: */

/* lets see whether this works as trampoline:
MV	#STATIC, $4	0x940Y	0x0000 <- STATIC; Y = STATIC_CHAIN_REGNUM
JMP	FUNCTION	0x0058  0x0000 <- FUNCTION
*/

#define TRAMPOLINE_TEMPLATE(FILE)	\
{					\
  assemble_aligned_integer (2, GEN_INT (0x9400+STATIC_CHAIN_REGNUM));	\
  assemble_aligned_integer (2, const0_rtx);				\
  assemble_aligned_integer (2, GEN_INT(0x0058));			\
  assemble_aligned_integer (2, const0_rtx);				\
}

#define TRAMPOLINE_SIZE 8
#define TRAMPOLINE_ALIGNMENT 16

/* Emit RTL insns to initialize the variable parts of a trampoline.
   FNADDR is an RTX for the address of the function's pure code.
   CXT is an RTX for the static chain value for the function.  */

#define INITIALIZE_TRAMPOLINE(TRAMP,FNADDR,CXT)	\
{					\
  emit_move_insn (gen_rtx_MEM (HImode, plus_constant (TRAMP, 2)), CXT); \
  emit_move_insn (gen_rtx_MEM (HImode, plus_constant (TRAMP, 6)), FNADDR); \
}


/* Some machines may desire to change what optimizations are
   performed for various optimization levels.   This macro, if
   defined, is executed once just after the optimization level is
   determined and before the remainder of the command options have
   been parsed.  Values set in this macro are used as the default
   values for the other command line options.

   LEVEL is the optimization level specified; 2 if -O2 is
   specified, 1 if -O is specified, and 0 if neither is specified.  */

#define OPTIMIZATION_OPTIONS(LEVEL,SIZE)				\
{									\
  if (LEVEL >= 3)							\
    {									\
      if (! SIZE)							\
        flag_inline_functions		= 1;				\
      flag_omit_frame_pointer		= 1;				\
      /* flag_unroll_loops			= 1; */			\
    }									\
}


/* there is no point in avoiding branches on a 990, 
   since branches are really cheap - I just want to find out
   how much difference the BRANCH_COST macro makes in code */
#define BRANCH_COST (0)


#define COMPARE_FLAG_MODE HImode
