;;- Machine description for the ti990 for GNU C compiler
;; Copyright (C) 1994, 1995, 1997, 1998, 1999, 2000, 2001
;; Free Software Foundation, Inc.
;; Contributed by Dave Pitts (dpitts@cozx.com)

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;; DI & DF is 64 bit
;; SI & SF is 32 bit
;; HI is 16 bit
;; QI is 8 bit 

;; NOTE: Since the TI990 register byte instructions use the top half of the
;; register and GCC expects things in the lower half *sigh*; we use the 
;; memory address of the lower byte of the register. Example: We add the value
;; in register 1 to some value in memory:
;;
;;     AB     @R1*2-31(R10),@memory
;;
;; Register 9  - Is used to access the calling functions arguments.
;; Register 10 - Points to the local variable storage, which happens to be just
;;               beyond the register workspace.
;; Register 11 - Points to the end of the local variable storage. And is used
;;               to push arguments to called functions and called workspace.
;; Register 12 - Is used as scratch and called function linkage.
;; Register 13 - Caller's workspace address.
;; Register 14 - Caller's return address.
;; Register 15 - Caller's status.

;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

;; define attributes
;; currently type is only fpu or arith or unknown, maybe branch later ?
;; default is arith
(define_attr "type" "unknown,arith,fp" (const_string "arith"))

;; length default is 1 word each
(define_attr "length" "" (const_int 1))

;; a user's asm statement
(define_asm_attributes
  [(set_attr "type" "unknown")
; all bets are off how long it is - make it 256, forces long jumps 
; whenever jumping around it !!!
   (set_attr "length" "256")])

;; Compare instructions.

(define_insn "cmpdi"
  [(set (cc0)
	(compare (match_operand:DI 0 "general_operand" "")
		 (match_operand:DI 1 "general_operand" "")))]
  "TARGET_12"
  "*
{
   static char inst[100];
   inst[0] = 0;
   if (!ti990_emit_ckpt)
    {
       ti990_emit_ckpt = 1;
       strcpy (inst, \"SETO	R12\;\");
    }
   if (GET_CODE(operands[1]) == CONST_INT)
     strcat (inst, \"CS	%0,%Q1,8,R12\");
   else if (GET_CODE(operands[0]) == CONST_INT)
     strcat (inst, \"CS	%Q0,%1,8,R12\");
   else
     strcat (inst, \"CS	%0,%1,8,R12\");
   return inst;
}"
  [(set_attr "length" "5")])

(define_insn "cmpsi"
  [(set (cc0)
	(compare (match_operand:SI 0 "general_operand" "")
		 (match_operand:SI 1 "general_operand" "")))]
  "TARGET_12"
  "*
{
   static char inst[100];
   inst[0] = 0;
   if (!ti990_emit_ckpt)
    {
       ti990_emit_ckpt = 1;
       strcpy (inst, \"SETO	R12\;\");
    }
   if (GET_CODE(operands[1]) == CONST_INT)
       strcat (inst, \"CS	%0,%L1,4,R12\");
   else if (GET_CODE(operands[0]) == CONST_INT)
       strcat (inst, \"CS	%L0,%1,4,R12\");
   else
       strcat (inst, \"CS	%0,%1,4,R12\");
   return inst;
}"
  [(set_attr "length" "5")])


(define_insn "cmphi"
  [(set (cc0)
	(compare (match_operand:HI 0 "general_operand" "rR,rR,Qi,Qi")
		 (match_operand:HI 1 "general_operand" "rR,Qi,rR,Qi")))]
  ""
  "*
{
  if (GET_CODE(operands[1]) == CONST_INT)
  {
    if (REG_P(operands[0]))
      return \"CI	%0,%i1\";
    return \"C	%0,%w1\";
  }
  else if (GET_CODE(operands[0]) == CONST_INT)
    return \"C	%w0,%1\";
  else if (GET_CODE (operands[1]) != MEM && GET_CODE(operands[1]) != REG)
    {
      if (REG_P (operands[0]))
       return \"CI	%0,%i1\";
    }
  return \"C	%0,%1\";
}"
  [(set_attr "length" "1,2,2,3")])

(define_insn "cmpqi"
  [(set (cc0)
	(compare (match_operand:QI 0 "general_operand" "rR,rR,Qi,Qi")
		 (match_operand:QI 1 "general_operand" "rR,Qi,rR,Qi")))]
  ""
  "*
{
  if (REG_P (operands[0]))
    {
      if (GET_CODE (operands[1]) == CONST_INT)
        return \"CB	@%0*2-31(R10),%b1\";
      if (REG_P (operands[1]))
        return \"CB	@%0*2-31(R10),@%1*2-31(R10)\";
      return \"CB	@%0*2-31(R10),%1\";
    }
  if (REG_P (operands[1]))
    {
      if (GET_CODE (operands[0]) == CONST_INT)
        return \"CB	%b0,@%1*2-31(R10)\";
      return \"CB	%0,@%1*2-31(R10)\";
    }
  if (GET_CODE (operands[1]) == CONST_INT)
    return \"CB	%0,%b1\";
  if (GET_CODE (operands[0]) == CONST_INT)
    return \"CB	%b0,%1\";
  return \"CB	%0,%1\";
}"
  [(set_attr "length" "1,2,2,3")])
			   

;; We have to have this because cse can optimize the previous pattern
;; into this one.

(define_insn "tstdf"
  [(set (cc0)
	(match_operand:DF 0 "float_register" ""))
  ]
  ""
  "MOV	%0,%0"
  [(set_attr "length" "1")])

(define_insn "tstsf"
  [(set (cc0)
	(match_operand:SF 0 "float_register" ""))
  ]
  ""
  "MOV	%0,%0"
  [(set_attr "length" "1")])

(define_insn "tstdi"
  [(set (cc0)
	(match_operand:DI 0 "general_operand" ""))]
  "TARGET_12"
  "*
{
   if (!ti990_emit_ckpt)
    {
       ti990_emit_ckpt = 1;
       return \"SETO	R12\;MOVS	%0,%0,8,R12\";
    }
   return \"MOVS	%0,%0,8,R12\";
}"
  [(set_attr "length" "5")])

(define_insn "tstsi"
  [(set (cc0)
	(match_operand:SI 0 "general_operand" ""))]
  "TARGET_12"
  "*
{
   if (!ti990_emit_ckpt)
    {
       ti990_emit_ckpt = 1;
       return \"SETO	R12\;MOVS	%0,%0,4,R12\";
    }
   return \"MOVS	%0,%0,4,R12\";
}"
  [(set_attr "length" "5")])

(define_insn "tsthi"
  [(set (cc0)
	(match_operand:HI 0 "general_operand" "rR,Q"))]
  ""
  "*
{
   ti990_emit_ckpt = 0;
   return \"MOV	%0,R12\";
}"
  [(set_attr "length" "1,2")])

(define_insn "tstqi"
  [(set (cc0)
	(match_operand:QI 0 "general_operand" "rR,Q"))]
  ""
  "*
{
  ti990_emit_ckpt = 0;
  if (REG_P (operands[0]))
    return \"MOVB	@%0*2-31(R10),R12\";
  return \"MOVB	%0,R12\";
}"
  [(set_attr "length" "2,2")])


;; These control RTL generation for conditional jump insns
;; and match them for register allocation.

(define_insn "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JEQ\", \"JNE\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])


(define_insn "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JNE\", \"JEQ\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JGT\", \"JGT\t$+4\;JMP\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JH\", \"JLE\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JLT\", \"JLT\t$+4\;JMP\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])


(define_insn "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JL\", \"JHE\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JLT\t$+4\;JMP\", \"JLT\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JHE\", \"JL\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JGT\t$+4\;JMP\", \"JGT\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "* return output_jump(\"JLE\", \"JH\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

;; These match inverted jump insns for register allocation.

(define_insn ""
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return output_jump(\"JNE\", \"JEQ\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return output_jump(\"JEQ\", \"JNE\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return output_jump(\"JGT\t$+4\;JMP\", \"JGT\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return output_jump(\"JLE\", \"JH\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return output_jump(\"JLT\t$+4\;JMP\", \"JLT\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return output_jump(\"JHE\", \"JL\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""  
  "* return output_jump(\"JLT\", \"JLT\t$+4\;JMP\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return output_jump(\"JL\", \"JHE\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return output_jump(\"JGT\", \"JGT\t$+4\;JMP\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "* return output_jump(\"JH\", \"JLE\", get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

;; Move instructions

(define_insn "movdf"
  [(set (match_operand:DF 0 "general_operand" "=g")
        (match_operand:DF 1 "general_operand" "g"))]
  "TARGET_12"
  "*
{
   if (!ti990_emit_ckpt)
    {
       ti990_emit_ckpt = 1;
       return \"SETO	R12\;MOVS	%1,%0,8,R12\";
    }
   return \"MOVS	%1,%0,8,R12\";
}"
  [(set_attr "length" "5")])


(define_insn "movsf"
  [(set (match_operand:SF 0 "general_operand" "=g")
        (match_operand:SF 1 "general_operand" "g"))]
  "TARGET_12"
  "*
{
   if (!ti990_emit_ckpt)
    {
       ti990_emit_ckpt = 1;
       return \"SETO	R12\;MOVS	%1,%0,4,R12\";
    }
   return \"MOVS	%1,%0,4,R12\";
}"
  [(set_attr "length" "5")])


(define_insn "movdi"
  [(set (match_operand:DI 0 "general_operand" "=g")
	(match_operand:DI 1 "general_operand" "g"))]
  "TARGET_12"
  "*
{
   static char inst[128];
   inst[0] = 0;
   if (!ti990_emit_ckpt)
     {
       ti990_emit_ckpt = 1;
       strcpy (inst, \"SETO	R12\;\");
     }
   if (GET_CODE (operands[1]) == CONST_INT)
     {
      strcat (inst, \"MOVS	%Q1,%0,8,R12\");
     }
   else
      strcat (inst, \"MOVS	%1,%0,8,R12\");
   return inst;
}"
  [(set_attr "length" "5")])

(define_insn "movsi"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(match_operand:SI 1 "general_operand" "g"))]
  "TARGET_12"
  "*
{
   static char inst[128];
   inst[0] = 0;
   if (!ti990_emit_ckpt)
     {
       ti990_emit_ckpt = 1;
       strcpy (inst, \"SETO	R12\;\");
     }
   if (GET_CODE (operands[1]) == CONST_INT)
     {
      strcat (inst, \"MOVS	%L1,%0,4,R12\");
     }
   else
      strcat (inst, \"MOVS	%1,%0,4,R12\");
   return inst;
}"
  [(set_attr "length" "5")])

(define_insn "movhi"
  [(set (match_operand:HI 0 "general_operand" "=rR,rR,Q,Q")
  	(match_operand:HI 1 "general_operand" "rRN,Qi,rRN,Qi"))]
  ""
  "*
{
  if (operands[1] == const0_rtx)
    return \"CLR	%0\";
  else if (operands[1] == constm1_rtx)
    return \"SETO	%0\";
  else if (GET_CODE (operands[1]) == CONST_INT)
    {
      if (REG_P (operands[0]))
       return \"LI	%0,%i1\";
      return \"MOV	%w1,%0\";
    }
  else if (GET_CODE (operands[1]) != MEM && GET_CODE(operands[1]) != REG)
    {
      if (REG_P (operands[0]))
       return \"LI	%0,%i1\";
    }
  return \"MOV	%1,%0\";
}"
  [(set_attr "length" "1,2,2,3")])

(define_insn "movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=g")
	(match_operand:QI 1 "general_operand" "g"))]
  ""
  "*
{
  if (REG_P (operands[0]))
    {
      if (operands[1] == const0_rtx)
        return \"CLR	%0\";
      if (GET_CODE (operands[1]) == CONST_INT)
        return \"MOVB	%b1,@%0*2-31(R10)\";
      if (REG_P (operands[1]))
        return \"MOVB	@%1*2-31(R10),@%0*2-31(R10)\";
      return \"MOVB	%1,@%0*2-31(R10)\";
    }
  if (GET_CODE (operands[1]) == CONST_INT)
    return \"MOVB	%b1,%0\";
  if (REG_P (operands[1]))
    return \"MOVB	@%1*2-31(R10),%0\";
  return \"MOVB	%1,%0\";
}"
  [(set_attr "length" "3")])

;; maybe fiddle a bit with move_ratio, then 
;; let constraints only accept a register ...

(define_expand "movstrhi"
  [(parallel [(set (match_operand:BLK 0 "general_operand" "=g,g")
		   (match_operand:BLK 1 "general_operand" "g,g"))
	      (use (match_operand:HI 2 "arith_operand" "n,&mr"))
	      (use (match_operand:HI 3 "immediate_operand" "i,i"))
	      (clobber (match_scratch:HI 4 "=&r,X"))
	      (clobber (match_dup 5))
	      (clobber (match_dup 6))
	      (clobber (match_dup 2))])]
  "(TARGET_BCOPY_BUILTIN)"
  "
{
  operands[0]
    = replace_equiv_address (operands[0],
			     copy_to_mode_reg (Pmode, XEXP (operands[0], 0)));
  operands[1]
    = replace_equiv_address (operands[1],
			     copy_to_mode_reg (Pmode, XEXP (operands[1], 0)));

  operands[5] = XEXP (operands[0], 0);
  operands[6] = XEXP (operands[1], 0);
}")


(define_insn "" ; "movstrhi"
  [(set (mem:BLK (match_operand:HI 0 "general_operand" "=r,r"))
	(mem:BLK (match_operand:HI 1 "general_operand" "r,r")))
   (use (match_operand:HI 2 "arith_operand" "n,&r"))
   (use (match_operand:HI 3 "immediate_operand" "i,i"))
   (clobber (match_scratch:HI 4 "=&r,X"))
   (clobber (match_dup 0))
   (clobber (match_dup 1))
   (clobber (match_dup 2))]
  "(TARGET_BCOPY_BUILTIN)"
  "* return output_block_move (operands);"
  [(set_attr "length" "40")])

;; Truncation instructions

(define_insn "truncsihi2"
  [(set (match_operand:HI 0 "general_operand" "")
	(truncate:HI (match_operand:SI 1 "general_operand" "")))]
  ""
  "*
{
  if (REG_P(operands[1]))
     return \"MOV	%1+1,%0\";
  return \"MOV	%1,%0\";
}"
  [(set_attr "length" "3")])

(define_insn "trunchiqi2"
  [(set (match_operand:QI 0 "general_operand" "")
	(truncate:QI (match_operand:HI 1 "general_operand" "")))]
  ""
  "*
{
   if (REG_P (operands[1]))
     {
       if (REG_P (operands[0]))
         return \"MOVB	@%1*2-31(R10),@%0*2-31(R10)	reg1\";
      return \"MOVB	@%1*2-31(R10),%0	reg2\";
     }
   if (REG_P (operands[0]))
     return \"MOVB	%1,@%0*2-31(R10)	notreg1\";
   return \"MOVB	%1,%0	notreg2\";
}"
  [(set_attr "length" "3")])

;; Zero extension instructions

(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(zero_extend:HI (match_operand:QI 1 "general_operand" "g")))]
  ""
  "*
{
  if (REG_P (operands[0]))
   {
     if (GET_CODE (operands[1]) == CONST_INT)
       return \"LI	%0,%i1\";
     if (REG_P (operands[1]))
       return \"MOVB	@%1*2-31(R10),%0\;SRL	%0,8\";
     return \"MOVB	%1,%0\;SRL	%0,8\";
   }
  ti990_emit_ckpt = 0;
  if (REG_P (operands[1]))
     return \"MOVB	@%1*2-31(R10),R12\;SRL	R12,8\;MOV	R12,%0\";
  return \"MOVB	%1,R12\;SRL	R12,8\;MOV	R12,%0\";
}"
  [(set_attr "length" "5")])
			 
(define_expand "zero_extendhisi2"
  [(set (subreg:HI 
          (match_dup 0)
          2)
        (match_operand:HI 1 "register_operand" "r"))
   (set (subreg:HI 
          (match_operand:SI 0 "register_operand" "=r")
          0)
        (const_int 0))]
  "TARGET_12"
  "/* operands[1] = make_safe_from (operands[1], operands[0]); */")

;; Sign extension instructions

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(sign_extend:HI (match_operand:QI 1 "general_operand" "rR,Q")))]
  ""
  "*
{
  if (REG_P (operands[0]))
    {
      if (GET_CODE (operands[1]) == CONST_INT)
        return \"MOVB	%b1,%0\;SRA	%0,8\";
      if (REG_P (operands[1]))
        return \"MOVB	@%1*2-31(R10),%0\;SRA	%0,8\";
      return \"MOVB	%1,%0\;SRA	%0,8\";
    }
  ti990_emit_ckpt = 0;
  if (REG_P (operands[1]))
    return \"MOVB	@%1*2-31(R10),R12\;SRA	R12,8\;MOV	R12,%0\";
  return \"MOVB	%1,R12\;SRA	R12,8\;MOV	R12,%0\";
}"
  [(set_attr "length" "5")])

(define_insn "extendqidi2"
  [(set (match_operand:DI 0 "general_operand" "")
	(sign_extend:DI (match_operand:QI 1 "general_operand" "")))]
  "TARGET_12"
  "EP	%1,%0,1,8"
  [(set_attr "length" "4")])

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "general_operand" "")
	(sign_extend:SI (match_operand:QI 1 "general_operand" "")))]
  "TARGET_12"
  "EP	%1,%0,1,4"
  [(set_attr "length" "4")])

(define_insn "extendhidi2"
  [(set (match_operand:DI 0 "general_operand" "")
	(sign_extend:DI (match_operand:HI 1 "general_operand" "")))]
  "TARGET_12"
  "EP	%1,%0,2,8"
  [(set_attr "length" "4")])
  
(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "general_operand" "")
	(sign_extend:SI (match_operand:HI 1 "general_operand" "")))]
  "TARGET_12"
  "EP	%1,%0,2,4"
  [(set_attr "length" "4")])

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI (match_operand:HI 1 "general_operand" "0")))]
  "(! TARGET_12)"
  "*
{
  static int count = 0;
  char buf[100];
  rtx lateoperands[2];

  lateoperands[0] = operands[0];
  operands[0] = gen_rtx_REG (HImode, REGNO (operands[0]) + 1);

  ti990_emit_ckpt = 0;
  output_asm_insn(\"MOV	%0,R12\", operands);
  sprintf(buf, \"JGT	extendhisi%d\", count);
  output_asm_insn(buf, NULL);
  sprintf(buf, \"JEQ	extendhisi%d\", count);
  output_asm_insn(buf, NULL);
  output_asm_insn(\"MOV	=W-1,%0\", lateoperands);
  sprintf(buf, \"JNE	extendhisi%d\", count+1);
  output_asm_insn(buf, NULL);
  sprintf(buf, \"\\nextendhisi%d\", count);
  output_asm_insn(buf, NULL);
  output_asm_insn(\"CLR	%0\", lateoperands);
  sprintf(buf, \"\\nextendhisi%d\", count+1);
  output_asm_insn(buf, NULL);

  count += 2;

  return \"\";
}"
  [(set_attr "length" "6")])

;; Add instructions

(define_insn "adddi3"
  [(set (match_operand:DI 0 "general_operand" "=g")
	(plus:DI (match_operand:DI 1 "general_operand" "0")
		 (match_operand:DI 2 "general_operand" "g")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"AM	%Q2,%0,8\";
   return \"AM	%2,%0,8\";
}"
  [(set_attr "length" "4")])

(define_insn "addsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(plus:SI (match_operand:SI 1 "general_operand" "0")
		 (match_operand:SI 2 "general_operand" "g")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"AM	%L2,%0,4\";
   return \"AM	%2,%0,4\";
}"
  [(set_attr "length" "4")])

(define_insn "addhi3"
  [(set (match_operand:HI 0 "general_operand" "=rR,rR,Q,Q")
	(plus:HI (match_operand:HI 1 "general_operand" "%0,0,0,0")
		 (match_operand:HI 2 "general_operand" "rRLM,Qi,rRLM,Qi")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      int i = INTVAL(operands[2]);

      if (i == 1)
	return \"INC	%0\";
      else if (i == 2)
        return \"INCT	%0\";
      else if (i == -1)
        return \"DEC	%0\";
      else if (i == -2)
        return \"DECT	%0\";
      else if (REG_P(operands[0]))
        return \"AI	%0,%i2\";
      return \"A	%w2,%0\";
    }
  else if (GET_CODE (operands[2]) == CONST && REG_P(operands[0]))
   {
     return \"AI	%0,%i2\";
   }
  else if (GET_CODE (operands[2]) != MEM && GET_CODE(operands[2]) != REG)
    {
      if (REG_P (operands[0]))
       return \"AI	%0,%i2\";
    }
  return \"A	%2,%0\";
}"
  [(set_attr "length" "1,2,2,3")])

(define_insn "addqi3"
  [(set (match_operand:QI 0 "general_operand" "=rR,rR,Q,Q")
	(plus:QI (match_operand:QI 1 "general_operand" "%0,0,0,0")
		 (match_operand:QI 2 "general_operand" "rRLM,Qi,rRLM,Qi")))]
  ""
  "*
{
  if (REG_P (operands[0]))
    {
      if (GET_CODE (operands[2]) == CONST_INT)
        return \"AB	%b2,@%0*2-31(R10)\";
      if (REG_P (operands[2]))
        return \"AB	@%2*2-31(R10),@%0*2-31(R10)\";
      return \"AB	%2,@%0*2-31(R10)\";
    }
  if (GET_CODE (operands[2]) == CONST_INT)
    return \"AB	%b2,%0\";
  if (REG_P (operands[2]))
      return \"AB	@%2*2-31(R10),%0\";
  return \"AB	%2,%0\";
}"
  [(set_attr "length" "1,2,2,3")])

;; Subtract instructions

(define_insn "subdi3"
  [(set (match_operand:DI 0 "general_operand" "=g")
	(minus:DI (match_operand:DI 1 "general_operand" "0")
		  (match_operand:DI 2 "general_operand" "g")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"SM	%Q2,%0,8\";
   return \"SM	%2,%0,8\";
}"
  [(set_attr "length" "4")])

(define_insn "subsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
        (minus:SI (match_operand:SI 1 "general_operand" "0")
                  (match_operand:SI 2 "general_operand" "g")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"SM	%L2,%0,4\";
   return \"SM	%2,%0,4\";
}"
  [(set_attr "length" "4")])

(define_insn "subhi3"
  [(set (match_operand:HI 0 "general_operand" "=rR,rR,Q,Q")
	(minus:HI (match_operand:HI 1 "general_operand" "0,0,0,0")
		  (match_operand:HI 2 "general_operand" "rR,Qi,rR,Qi")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      int i = INTVAL(operands[2]);
      if (i == 1)
	return \"DEC	%0\";
      else if (i == 2)
        return \"DECT	%0\";
      else if (i == -1)
        return \"INC	%0\";
      else if (i == -2)
        return \"INCT	%0\";
      else if (REG_P(operands[0]))
        {
	  if (i < 0)
	    return \"AI	%0,%i2\";
	  else
	    return \"AI	%0,-%i2\";
	}
    }

  return \"S	%2,%0\";
}"
  [(set_attr "length" "1,2,2,3")])

(define_insn "subqi3"
  [(set (match_operand:QI 0 "general_operand" "=rR,rR,Q,Q")
	(minus:QI (match_operand:QI 1 "general_operand" "0,0,0,0")
		  (match_operand:QI 2 "general_operand" "rR,Qi,rR,Qi")))]
  ""
  "*
{
  if (REG_P (operands[0]))
    {
      if (GET_CODE (operands[2]) == CONST_INT)
        return \"SB	%b2,@%0*2-31(R10)\";
      if (REG_P (operands[2]))
        return \"SB	@%2*2-31(R10),@%0*2-31(R10)\";
      return \"SB	%2,@%0*2-31(R10)\";
    }
  if (GET_CODE (operands[2]) == CONST_INT)
    return \"SB	%b2,%0\";
  if (REG_P (operands[2]))
      return \"SB	@%2*2-31(R10),%0\";
  return \"SB	%2,%0\";
}"
  [(set_attr "length" "1,2,2,3")])

;;  And instructions

(define_insn "anddi3"
  [(set (match_operand:DI 0 "general_operand" "=g")
	(and:DI (match_operand:DI 1 "general_operand" "0")
		(match_operand:DI 2 "general_operand" "g")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"ANDM	%Q2,%0,8\";
   return \"ANDM	%2,%0,8\";
}"
  [(set_attr "length" "4")])

(define_insn "andsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
	(and:SI (match_operand:SI 1 "general_operand" "0")
		(match_operand:SI 2 "general_operand" "g")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"ANDM	%L2,%0,4\";
   return \"ANDM	%2,%0,4\";
}"
  [(set_attr "length" "4")])

(define_insn "andhi3"
  [(set (match_operand:HI 0 "general_operand" "=rR,rR,Q,Q")
	(and:HI (match_operand:HI 1 "general_operand" "0,0,0,0")
		(match_operand:HI 2 "general_operand" "rR,Qi,rR,Qi")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      if (REG_P (operands[0]))
        {
          return \"ANDI	%0,%i2\";
        }
      operands[2] = GEN_INT(~INTVAL(operands[2]));
      return \"SZC	%2,%0\";
    }
  return \"MOV	%2,R12\;INV	R12\;SZC	R12,%0\";
}"
  [(set_attr "length" "1,2,2,3")])

(define_insn "andqi3"
  [(set (match_operand:QI 0 "general_operand" "=rR,rR,Q,Q")
	(and:QI (match_operand:QI 1 "general_operand" "0,0,0,0")
		(match_operand:QI 2 "general_operand" "rR,Qi,rR,Qi")))]
  ""
  "*
{
  if (REG_P (operands[0]))
    {
      if (GET_CODE (operands[2]) == CONST_INT)
        return \"ANDI	%0,%i2\";
      if (REG_P (operands[2]))
        return \"MOVB	@%2*2-31(R10),R12\;INV	R12\;SZCB	R12,@%0*2-31(R10)\";
      return \"MOVB	%2,R12\;INV	R12\;SZCB	R12,@%0*2-31(R10)\";
    }
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      operands[2] = GEN_INT(~INTVAL(operands[2]));
      return \"SZCB	%b2,%0\";
    }
  if (REG_P (operands[2]))
      return \"MOVB	@%2*2-31(R10),R12\;INV	R12\;SZCB	R12,%0\";
  return \"MOVB	%2,R12\;INV	R12\;SZCB	R12,%0\";
}"
  [(set_attr "length" "1,2,2,3")])

;; Bit set (inclusive or) instructions

(define_insn "iordi3"
  [(set (match_operand:DI 0 "general_operand" "=g")
        (ior:DI (match_operand:DI 1 "general_operand" "0")
                  (match_operand:DI 2 "general_operand" "g")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"ORM	%Q2,%0,8\";
   return \"ORM	%2,%0,8\";
}"
  [(set_attr "length" "4")])

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "general_operand" "=g")
        (ior:SI (match_operand:SI 1 "general_operand" "0")
                  (match_operand:SI 2 "general_operand" "g")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"ORM	%L2,%0,4\";
   return \"ORM	%2,%0,4\";
}"
  [(set_attr "length" "4")])

(define_insn "iorhi3"
  [(set (match_operand:HI 0 "general_operand" "=rR,rR,Q,Q")
	(ior:HI (match_operand:HI 1 "general_operand" "%0,0,0,0")
		(match_operand:HI 2 "general_operand" "rR,Qi,rR,Qi")))]
  ""
  "*
{
  if (REG_P (operands[0]) && GET_CODE (operands[2]) == CONST_INT)
    {
      return \"ORI	%0,%i2\";
    }
  return \"SOC	%2,%0\";
}"
  [(set_attr "length" "1,2,2,3")])

(define_insn "iorqi3"
  [(set (match_operand:QI 0 "general_operand" "=rR,rR,Q,Q")
	(ior:QI (match_operand:QI 1 "general_operand" "%0,0,0,0")
		(match_operand:QI 2 "general_operand" "rR,Qi,rR,Qi")))]
  ""
  "*
{
  if (REG_P (operands[0]))
    {
      if (GET_CODE (operands[2]) == CONST_INT)
        return \"ORI	%0,%i2\";
      if (REG_P (operands[2]))
        return \"SOC	@%2*2-31(R10),@%0*2-31(R10)\";
      return \"SOCB	%2,@%0*2-31(R10)\";
    }
  if (GET_CODE (operands[2]) == CONST_INT)
    return \"SOCB	%b2,%0\";
  if (REG_P (operands[2]))
      return \"SOCB	@%2*2-31(R10),%0\";
  return \"SOCB	%2,%0\";
}")

;; Xor instructions

(define_insn "xordi3"
  [(set (match_operand:DI 0 "general_operand" "")
        (xor:DI (match_operand:DI 1 "general_operand" "")
                  (match_operand:DI 2 "general_operand" "")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"XORM	%Q2,%0,8\";
   return \"XORM	%2,%0,8\";
}"
  [(set_attr "length" "4")])

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "general_operand" "")
        (xor:SI (match_operand:SI 1 "general_operand" "")
                  (match_operand:SI 2 "general_operand" "")))]
  "TARGET_12"
  "*
{
   if (GET_CODE (operands[2]) == CONST_INT)
      return \"XORM	%L2,%0,4\";
   return \"XORM	%2,%0,4\";
}"
  [(set_attr "length" "4")])

(define_insn "xorhi3"
  [(set (match_operand:HI 0 "general_operand" "=rR,Q")
	(xor:HI (match_operand:HI 1 "general_operand" "%0,0")
		(match_operand:HI 2 "register_operand" "r,r")))]
  ""
  "*
{
  if (REG_P(operands[0]))
    {
      return \"XOR	%2,%0\";
    }
  ti990_emit_ckpt = 0;
  return \"MOV	%0,R12\;XOR	%2,R12\;MOV	R12,%0\";
}"
  [(set_attr "length" "1,5")])

;; One complement instructions

(define_insn "one_cmplhi2"
  [(set (match_operand:HI 0 "general_operand" "=rR,Q")
        (not:HI (match_operand:HI 1 "general_operand" "0,0")))]
  ""
  "INV	%0"
  [(set_attr "length" "1,2")])

(define_insn "one_cmplqi2"
  [(set (match_operand:QI 0 "general_operand" "=rR,Q")
        (not:QI (match_operand:QI 1 "general_operand" "0,0")))]
  ""
  "*
{
  if (REG_P (operands[0]))
    return \"INV	%0\";
  ti990_emit_ckpt = 0;
  return \"MOVB	%1,R12\;INV	R12\;MOVB	R12,%0\";
}"
  [(set_attr "length" "1,5")])

;; Logical shift instructions

(define_insn "lshrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(lshiftrt:HI (match_operand:HI 1 "register_operand" "0,0")
		     (match_operand:HI 2 "general_operand" "rR,Qi")))]
  ""
  "*
{
  if (GET_CODE(operands[2]) == CONST_INT && INTVAL(operands[2]) < 16)
    return \"SRL	%0,%i2\";
  ti990_emit_ckpt = 0;
  return \"MOV	R0,R12\;MOV	%2,R0\;SRL	%0,0\;MOV	R12,R0\";
}"
  [(set_attr "length" "1,5")])

;; Arithmetic shift instructions

(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(ashift:SI (match_operand:SI 1 "register_operand" "0,0")
		   (match_operand:HI 2 "general_operand" "rR,Qi")))]
  "TARGET_12"
  "SLAM	%0,4,%i2"
  [(set_attr "length" "1,2")])

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(ashiftrt:SI (match_operand:SI 1 "register_operand" "0,0")
		     (match_operand:HI 2 "general_operand" "rR,Qi")))]
  "TARGET_12"
  "SRAM	%0,4,%i2"
  [(set_attr "length" "1,2")])

(define_insn "ashlhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(ashift:HI (match_operand:HI 1 "register_operand" "0,0")
		   (match_operand:HI 2 "general_operand" "rR,Qi")))]
  ""
  "*
{
  if (GET_CODE(operands[2]) == CONST_INT && INTVAL(operands[2]) < 16)
    return \"SLA	%0,%i2\";
  ti990_emit_ckpt = 0;
  return \"MOV	R0,R12\;MOV	%2,R0\;SLA	%0,0\;MOV	R12,R0\";
}"
  [(set_attr "length" "1,5")])

(define_insn "ashrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(ashiftrt:HI (match_operand:HI 1 "register_operand" "0,0")
		     (match_operand:HI 2 "general_operand" "rR,Qi")))]
  ""
  "*
{
  if (GET_CODE(operands[2]) == CONST_INT && INTVAL(operands[2]) < 16)
    return \"SRA	%0,%i2\";
  ti990_emit_ckpt = 0;
  return \"MOV	R0,R12\;MOV	%2,R0\;SRA	%0,0\;MOV	R12,R0\";
}"
  [(set_attr "length" "1,5")])

(define_insn "rotrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(rotatert:HI (match_operand:HI 1 "register_operand" "0,0")
		     (match_operand:HI 2 "general_operand" "rR,Qi")))]
  ""
  "*
{
  if (GET_CODE(operands[2]) == CONST_INT && INTVAL(operands[2]) < 16)
    return \"SRC	%0,%i2\";
  ti990_emit_ckpt = 0;
  return \"MOV	R0,R12\;MOV	%2,R0\;SRC	%0,0\;MOV	R12,R0\";
}"
  [(set_attr "length" "1,5")])

;; Absolute value instructions

(define_insn "absdf2"
  [(set (match_operand:DF 0 "float_register" "=f")
	(abs:DF (match_operand:DF 1 "float_register" "f")))]
  ""
  "ANDI	%0,>7FFF"
  [(set_attr "length" "2")])

(define_insn "abssf2"
  [(set (match_operand:SF 0 "float_register" "=f")
	(abs:SF (match_operand:SF 1 "float_register" "f")))]
  ""
  "ANDI	%0,>7FFF"
  [(set_attr "length" "2")])

(define_insn "abshi2"
  [(set (match_operand:HI 0 "general_operand" "=r,o")
	(abs:HI (match_operand:HI 1 "general_operand" "0,0")))]
  ""
  "ABS	%0"
  [(set_attr "length" "1,2")])


;; Negate value instructions

(define_insn "negdf2"
  [(set (match_operand:DF 0 "float_register" "=f")
	(neg:DF (match_operand:DF 1 "float_register" "f")))]
  ""
  "AI	%0,>8000"
  [(set_attr "length" "2")])

(define_insn "negsf2"
  [(set (match_operand:SF 0 "float_register" "=f")
	(neg:SF (match_operand:SF 1 "float_register" "f")))]
  ""
  "AI	%0,>8000"
  [(set_attr "length" "2")])

(define_insn "neghi2"
  [(set (match_operand:HI 0 "general_operand" "=rR,Q")
	(neg:HI (match_operand:HI 1 "general_operand" "0,0")))]
  ""
  "NEG	%0"
  [(set_attr "length" "1,2")])

;; Unconditional and other jump instructions

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "* return output_jump(\"JMP\", NULL, get_attr_length(insn));"
  [(set (attr "length") (if_then_else (ior (le (minus (match_dup 0)
						      (pc))
					       (const_int -128))
					   (ge (minus (match_dup 0)
						      (pc))
					       (const_int 128)))
				      (const_int 3)
				      (const_int 1)))])

(define_insn ""
  [(set (pc)
    (label_ref (match_operand 0 "" "")))
   (clobber (const_int 1))]
  ""
  "B	%0"
  [(set_attr "length" "2")])

(define_insn "tablejump"
  [(set (pc) (match_operand:HI 0 "general_operand" "rR,Q"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "*
{
   ti990_emit_ckpt = 0;
   return \"MOV	%0,R12\;B	*R12\";
}"
  [(set_attr "length" "2,4")])

;; indirect jump - let's be conservative!
;; allow only register_operand, even though we could also 
;; allow labels etc.

(define_insn "indirect_jump"
  [(set (pc) (match_operand:HI 0 "register_operand" "r"))]
  ""
  "B	*%0")

;; Jump to subroutine

(define_insn "call"
  [(call (match_operand:HI 0 "general_operand" "R,Q")
	 (match_operand:HI 1 "general_operand" "g,g"))]
  ""
  "*
{
  static char temp[128];
  int i = INTVAL(operands[1]);
  char *wpr = reg_names[STACK_POINTER_REGNUM];
  char *adr = reg_names[STACK_POINTER_REGNUM+1];

  ti990_emit_ckpt = 0;
  if (i == 0)
    {
     if (!REG_P(XEXP(operands[0], 0)))
       sprintf (temp,
	 \"LI	%s,%%i0\;BLWP	%s\",
	 adr, wpr);
     else
       sprintf (temp,
	 \"MOV	%%i0,%s\;BLWP	%s\",
	 adr, wpr);
    }
  else if (i == 2)
    {
     if (!REG_P(XEXP(operands[0], 0)))
       sprintf (temp,
#ifdef STACK_GROWS_DOWNWARD
	 \"MOV	%s,R1\;DECT	%s\;LI	%s,%%i0\;BLWP	%s\;INCT	%s\",
#else
	 \"MOV	%s,R1\;INCT	%s\;LI	%s,%%i0\;BLWP	%s\;DECT	%s\",
#endif
	 wpr, wpr, adr, wpr, wpr);
     else
       sprintf (temp,
#ifdef STACK_GROWS_DOWNWARD
	 \"MOV	%s,R1\;DECT	%s\;MOV	%%i0,%s\;BLWP	%s\;INCT	%s\",
#else
	 \"MOV	%s,R1\;INCT	%s\;MOV	%%i0,%s\;BLWP	%s\;DECT	%s\",
#endif
	 wpr, wpr, adr, wpr, wpr);
    }
  else
    {
     if (!REG_P(XEXP(operands[0], 0)))
       sprintf (temp,
#ifdef STACK_GROWS_DOWNWARD
	 \"MOV	%s,R1\;AI	%s,-%d\;LI	%s,%%i0\;BLWP	%s\;AI	%s,%d\",
#else
	 \"MOV	%s,R1\;AI	%s,%d\;LI	%s,%%i0\;BLWP	%s\;AI	%s,-%d\",
#endif
	 wpr, wpr, i, adr, wpr, wpr, i);
     else
       sprintf (temp,
#ifdef STACK_GROWS_DOWNWARD
	 \"MOV	%s,R1\;AI	%s,-%d\;MOV	%%i0,%s\;BLWP	%s\;AI	%s,%d\",
#else
	 \"MOV	%s,R1\;AI	%s,%d\;MOV	%%i0,%s\;BLWP	%s\;AI	%s,-%d\",
#endif
	 wpr, wpr, i, adr, wpr, wpr, i);
    }
  return temp;
}"
  [(set_attr "length" "16,16")])

(define_insn "call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:HI 1 "general_operand" "R,Q")
	      (match_operand:HI 2 "general_operand" "g,g")))]
  ""
  "*
{
  static char temp[128];
  int i = INTVAL(operands[2]);
  char *wpr = reg_names[STACK_POINTER_REGNUM];
  char *adr = reg_names[STACK_POINTER_REGNUM+1];


  ti990_emit_ckpt = 0;
  if (i == 0)
    {
     if (!REG_P(XEXP(operands[1], 0)))
       sprintf (temp,
	 \"LI	%s,%%i1\;BLWP	%s\",
	 adr, wpr);
     else
       sprintf (temp,
	 \"MOV	%%i1,%s\;BLWP	%s\",
	 adr, wpr);
    }
  else if (i == 2)
    {
     if (!REG_P(XEXP(operands[1], 0)))
       sprintf (temp,
#ifdef STACK_GROWS_DOWNWARD
	 \"MOV	%s,R1\;DECT	%s\;LI	%s,%%i1\;BLWP	%s\;INCT	%s\",
#else
	 \"MOV	%s,R1\;INCT	%s\;LI	%s,%%i1\;BLWP	%s\;DECT	%s\",
#endif
	 wpr, wpr, adr, wpr, wpr);
     else
       sprintf (temp,
#ifdef STACK_GROWS_DOWNWARD
	 \"MOV	%s,R1\;DECT	%s\;MOV	%%i1,%s\;BLWP	%s\;INCT	%s\",
#else
	 \"MOV	%s,R1\;INCT	%s\;MOV	%%i1,%s\;BLWP	%s\;DECT	%s\",
#endif
	 wpr, wpr, adr, wpr, wpr);
    }
  else
    {
     if (!REG_P(XEXP(operands[1], 0)))
       sprintf (temp,
#ifdef STACK_GROWS_DOWNWARD
	 \"MOV	%s,R1\;AI	%s,-%d\;LI	%s,%%i1\;BLWP	%s\;AI	%s,%d\",
#else
	 \"MOV	%s,R1\;AI	%s,%d\;LI	%s,%%i1\;BLWP	%s\;AI	%s,-%d\",
#endif
	 wpr, wpr, i, adr, wpr, wpr, i);
     else
       sprintf (temp,
#ifdef STACK_GROWS_DOWNWARD
	 \"MOV	%s,R1\;AI	%s,-%d\;MOV	%%i1,%s\;BLWP	%s\;AI	%s,%d\",
#else
	 \"MOV	%s,R1\;AI	%s,%d\;MOV	%%i1,%s\;BLWP	%s\;AI	%s,-%d\",
#endif
	 wpr, wpr, i, adr, wpr, wpr, i);
    }
  return temp;
}"
  [(set_attr "length" "16,16")])

;; Nop instruction

(define_insn "nop"
  [(const_int 0)]
  ""
  "NOP")

;; Multiply instructions

(define_insn "mulhi3"
  [(set (match_operand:HI 0 "register_operand" "=r") ; multiply regs
	(mult:HI (match_operand:HI 1 "general_operand" "0")
		 (match_operand:HI 2 "general_operand" "")))]
  ""
  "*
{
   ti990_emit_ckpt = 0;
   return \"MOV	%0+1,R12\;MPY	%2,%0\;MOV	%0+1,%0\;MOV	R12,%0+1\";
}"
  [(set_attr "length" "2")])

;; Divide instructions

(define_expand "divhi3"
  [(set (subreg:HI (match_dup 1) 0)
	(div:HI (match_operand:SI 1 "register_operand" "=r")
		(match_operand:HI 2 "general_operand" "g")))
   (set (match_operand:HI 0 "general_operand" "=r")
        (subreg:HI (match_dup 1) 0))]
  ""
  "")

(define_insn ""
  [(set (subreg:HI (match_operand:SI 0 "register_operand" "=r") 0)
	(div:HI (match_operand:SI 1 "register_operand" "0")
		(match_operand:HI 2 "general_operand" "")))]
  ""
  "DIV	%2,%0"
  [(set_attr "length" "2")])

(define_expand "modhi3"
  [(set (subreg:HI (match_dup 1) 2)
	(mod:HI (match_operand:SI 1 "register_operand" "0")
		(match_operand:HI 2 "general_operand" "g")))
   (set (match_operand:HI 0 "general_operand" "=r")
        (subreg:HI (match_dup 1) 2))]
  ""
  "")

(define_insn ""
  [(set (subreg:HI (match_operand:SI 0 "register_operand" "=r") 2)
	(mod:HI (match_operand:SI 1 "register_operand" "0")
		(match_operand:HI 2 "general_operand" "g")))]
  ""
  "DIV	%2,%0"
  [(set_attr "length" "2")])

