#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAXELEMENTS 500
#define MAXKEYSIZE 128
#define MAXRECSIZE 1024

#define TERMCHAR 034

typedef struct element
{
   char   key[MAXKEYSIZE];
   char   record[MAXRECSIZE];
} element_t;

static element_t elements[MAXELEMENTS];

static int
keycomp (const void *e1, const void *e2)
{
   return strcmp (((element_t *)e1)->key, ((element_t *)e2)->key);
}

int
main (int argc, char **argv)
{
   int count, j;

   for (count = 0; fgets (elements[count].record, MAXRECSIZE, stdin); count++)
   {
      char *bp;
      char *ep;

      if (count >= MAXELEMENTS)
      {
         fprintf (stderr, "Element overflow\n");
	 exit (1);
      }

      bp = elements[count].record;
      ep = strchr (bp, TERMCHAR);
      strncpy (elements[count].key, bp, ep-bp);
      elements[count].key[ep-bp] = 0;
   }

   qsort ((void *)&elements, count, sizeof(element_t), keycomp);

   for (j = 0; j < count; j++)
   {
      fputs (elements[j].record, stdout);
   }
}
