/************************************************************************
* close - Close a file.
************************************************************************/

#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <memory.h>
#include <fcntl.h>
#include <sys/svc.h>

int
close (int fd)
{
   FileTable *ft;
   int status;
   SVCIOBlk svc;

   /*
   ** If stdin, stderr, stdout return closed
   */

#ifdef DEBUGIO
   printf ("close: fd = %d\n", fd);
#endif

   _errno = 0;
   if (fd <= STDERR_FILENO)
      return (0);

   memset (&svc, 0, sizeof(SVCIOBlk));

   if (fd >= __MAXLUNO)
   {
      _errno = EBADF;
      return (-1);
   }
   ft = &_file_table[fd];
   if (!(ft->modes & FTINUSE))
   {
      _errno = EBADF;
      return (-1);
   }
   status = 0;

   /*
   ** Close file
   */

   svc.opcode = SVCIO;
   if (ft->modes & O_WRONLY)
      svc.subopcode = CLOSEEOF;
   else
      svc.subopcode = CLOSE;
   svc.luno = fd;
   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
      _errno = EIO;
      status = -1;
   }

   /*
   ** Release file luno
   */

   svc.subopcode = RELEASEFILE;
   _issue_svc ((SVCBlk *)&svc);

   ft->modes = 0;

   return (status);
}
