	IDT	'CRT0SCI'
	TITL	'CRT0SCI - C runtime entry'
***********************************************************************
*
*   CRT0 - Set up the C runtime environment and call the C main
*            routines. DX10 SCI version.
*
***********************************************************************
	OPTION	DUNLST,BUNLST,TUNLST
	LREF	_main
	LREF	__flushall
	REF	S$GTCA,S$RTCA,S$STOP,S$MAPS
	REF	S$PARM
*
	LDEF	__stkoverflow,__stkbottom,__stktop
	LDEF	__heapoverflow,__heapbottom,__heaptop
	LDEF	__printline,__readline
	LDEF	__issue_svc,__errno,__curluno
	LDEF	__file_table, __file_list
	LDEF	__mapsyn
	LDEF	_stdin,_stdout,_stderr
	LDEF	_abort,_exit,_atexit
	LDEF	__istxds,__termxflag,__termusrflag
	LDEF	__sighan
*
	DXOP	SVC,15
*
MAXMEM	EQU	60		Max memory to allocate in K.
STRTLUN	EQU	3		Starting luno.
MAXLUNO	EQU	10		Maximum luno.
BUFSIZ	EQU	288
EAGAIN	EQU	11
*
	DATA	MAINWS,MAINPC,ENDACT
MAINPC	EQU	$
*
	LI	R1,__file_table
	LI	R2,__file_table_end
CLRFDT	CLR	*R1+
	C	R1,R2
	JL	CLRFDT
*
	MOVB	@OPENOP,@TERMOPC
	SVC	@TERMSCB	Open the terminal for stdin/stdout/stderr.
	LI	R1,OPNMSG
	BL	@WRTMSG
	BL	@GETPARM	Get BID parms.
	MOV	@STKSIZ,R1	Get the stack and heap sizes.
	A	@HEPSIZ,R1
	SRL	R1,5
	MOV	R1,@GETSIZE
	SVC	@GETMAIN	Get the memory that will be the stack/heap.
	MOVB	@GETMAIN+1,R0
	JNE	NOMEM
	MOV	R9,@__stkbottom
	MOV	R9,R11
	A	@STKSIZ,R9
	MOV	R9,@__stktop
	MOV	R9,@__heapbottom
	MOV	R9,R10
	A	@HEPSIZ,R9
	MOV	R9,@__heaptop
	MOV	@HEPSIZ,*R10+	Set up heap for malloc.
	CLR	*R10+		   Flags.
	CLR	*R10+		   Back.
	CLR	*R10+		   Next.
*
	MOV	R11,R10		Set up call stack.
	MOV	R11,R12
	LI	R2,TASKID+1	Get address of program name.
	MOV	R2,*R12+	push argv[0]
	BL	@SETARGV	Push argv[n]
	MOV	R12,R1		End of argv list starts parms.
	MOV	R12,R11
	MOV	R2,*R11+	push argc
	MOV	R10,*R11+	push pointer to pointer argv[0]
	LI	R12,_main	Call the main program.
	BLWP	R11
*
_abort
EXITPC	EQU	$
	LI	R12,__flushall
	BLWP	R11
	LI	R1,PRESSE
*
EXIT	EQU	$
	BL	@WRTMSG
	LI	R1,READIT
	CLR	@TERMFLG
	BL	@READMSG
	MOVB	@CLOSEOP,@TERMOPC
	SVC	@TERMSCB	Close terminal
	CLR	R1
	CLR	R2
	BLWP	@S$STOP		End of task
*
NOMEM	LI	R1,NOMEMM	Can't allocate memory.
	JMP	EXIT
*
ENDACT	EQU	$
	LWPI	MAINWS
	LI	R3,>2F00	Get End action status.
	CLR	R4
	CLR	R5
	CLR	R6
	CLR	R7
	SVC	R3
	ANDI	R3,>00FF	Convert code to hex.
	MOV	@__sighan,R12
	JEQ	END003
	MOV	R11,R1
	MOV	R3,*R11+
	BLWP	R11
	JMP	EXITPC
END003  LI	R4,ENDCOD
	LI	R5,2
END005	EQU	$
	SLA	R3,4
	CB	R3,@TEN+1
	JLT	END010
	AI	R3,>700
END010	AB	@AZERO,R3
	MOVB	R3,*R4+
	DEC 	R5
	JGT	END005
	LI	R1,ENDER	And print it.
	JMP	EXIT
*
_exit
	MOV	@efunc,R12	If we have an atexit func.
	JEQ	EXITPC
	BLWP	R11		Do it.
	JMP	EXITPC
_atexit
	MOV	@2(R13),R1
	MOV	*R1,@efunc
	RTWP
*
efunc	DATA	0		atexit() function address.
__istxds
	DATA	0
__errno
	DATA	0		errno.
__stkoverflow
	LI	R1,STKOVER	Stack overflow.
	JMP	EXIT
__heapoverflow
	LI	R1,HEPOVER	Heap overflow.
	JMP	EXIT
*
WRTMSG	MOV	*R1,@TERMLRL	Put length into LRL & CHC
	MOV	*R1+,@TERMCHC
	MOV	R1,@TERMBUF	Set buffer address.
	MOVB	@WRITEOP,@TERMOPC
	SVC	@TERMSCB	Write it.
	RT
*
READMSG	MOV	@TERMFLG,R5	Check if busy (O_NONBLOCK I/O)
	JLT	REDBSY
	MOV	*R1,@TERMLRL	Put length into LRL & CHC
	MOV	*R1+,@TERMCHC
	MOV	R1,@TERMBUF	Set buffer address.
	MOVB	@READOP,@TERMOPC
	SVC	@TERMSCB	Read it.
	MOV	@TERMCHC,R0	How much did we read.
REDXIT	DECT	R1
	MOV	R0,*R1
	RT
REDBSY	LI	R5,EAGAIN
	MOV	R5,@__errno
	SETO	R0
	JMP	REDXIT
*
STKSIZ	DATA	0		Size of stack
HEPSIZ	DATA	0		Size of heap
*
__stkbottom
	DATA	0		Bottom of stack
__stktop
	DATA	0		Top of stack
__heapbottom
	DATA	0		Bottom of heap
__heaptop
	DATA	0		Top of heap
__file_list
	DATA	_stdin0		FILE list
_stdin
	DATA	_stdin0
_stdout
	DATA	_stdout0
_stderr
	DATA	_stderr0
*
GETMAIN	DATA	>1200		Get memory SVC
GETSIZE	DATA	$-$
*
TERMSCB BYTE	0		Terminal I/O operation
TERMERR BYTE	0		Terminal error code
TERMOPC	BYTE	0		Terminal operation code
TERMLUN BYTE	0		Terminal luno
__termusrflag
TERMFLG	DATA	0		Terminal flags
TERMBUF	DATA	$-$		Terminal buffer
TERMLRL	DATA	80		Terminal rec len
TERMCHC	DATA	80		Terminal char count
TERMRPY DATA	0 		Terminal reply address
__termxflag
TERMXFG DATA	0		Terminal extended flags
TERMFCH BYTE	0		Terminal fill char
TERMEVB BYTE	0		Terminal event byte
TERMCRW BYTE	0		Terminal cursor row
TERMCCL BYTE	0		Terminal cursor column
TERMFRW BYTE	0		Terminal field row
TERMFCL BYTE	0		Terminal field column
	EVEN
*
TEN	DATA	10
*
OPENOP	BYTE	0
CLOSEOP	BYTE	>1
WRITEOP	BYTE	>B
READOP	BYTE	>9
*
ABLNK	BYTE	' '
AZERO	BYTE	'0'
ANINE	BYTE	'9'
AA	BYTE	'A'
AZ	BYTE	'Z'
MSGMAX	BYTE	255
*
OPNMSG  DATA	2
CR	BYTE	>0D,>0A
LF	EQU	$-1
*
NOMEMM	DATA	NOMEML
	TEXT	'Unable to allocate memory:'
NOMEML	EQU	$-NOMEMM-2
	EVEN
*
STKOVER	DATA	STKOVL
	TEXT	'Stack overflow, terminating:'
STKOVL	EQU	$-STKOVER-2
__curluno
	BYTE	STRTLUN		Current luno for file alloc.
	EVEN
*
HEPOVER	DATA	HEPOVL
	TEXT	'Heap overflow, terminating:'
HEPOVL	EQU	$-HEPOVER-2
	EVEN
*
PRESSE	DATA	PRESSL
	TEXT	'Press enter to return to SCI:'
PRESSL	EQU	$-PRESSE-2
	EVEN
*
PARMER	DATA	PARMEL
	TEXT	'Parameter Error:'
PARMEL	EQU	$-PARMER-2
	EVEN
*
TCAER	DATA	TCAEL
	TEXT	'Can not get TCA:'
TCAEL	EQU	$-TCAER-2
	EVEN
*
ENDER	DATA	ENDEL
	TEXT	'End action taken-'
ENDCOD	TEXT	'XX:'
ENDEL	EQU	$-ENDER-2
	EVEN
*
MAINWS	BSS	32
*
* Issue SVC to the system.
*
__issue_svc
	STWP	R11		Get WS addressability.
	AI	R11,32
	MOV	@2(R13),R1	Get SVC block pointer.
	MOV	*R1,R1
	SVC	*R1
	RTWP
*
* Write string buffer to terminal
*
__printline
	STWP	R11		Get WS addressability.
	AI	R11,32
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get file descriptor.
	MOV	*R1+,R3		Get buffer address.
	MOV	*R1+,R5		Get buffer length.
	MOV	R11,R12		Buffer into the end of the frame.
	INCT	R12
	CLR	R4
PRT010	EQU	$		Copy buffer and convert NL -> CR/LF.
	MOVB	*R3+,R0
	JEQ	PRT020
	CB	R0,@LF
	JNE	PRT015
	MOVB	@CR,*R12+
	INC	R4
PRT015	EQU	$
	MOVB	R0,*R12+
	INC	R4
PRT020	EQU	$
	DEC	R5
	JGT	PRT010
	MOV	R4,*R11		Put converted size into frame.
	MOV	R11,R1
	BL	@WRTMSG		Go write.
	RTWP
*
* Read string buffer from terminal
*
__readline
	STWP	R10		Get WS addressability.
	AI	R10,32
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get file descriptor.
	MOV	*R1+,R3		Get buffer address.
	MOV	*R1,R4		Get buffer size.
	MOV	R10,R1		Buffer into the end of the frame.
	MOV	R4,*R10+	Put size into frame.
	BL	@READMSG	Go read.
	MOV	R0,R5
	JLT	READ30		Busy, O_NONBLOCK exit
	JEQ	READ20
READ10	EQU	$
	MOVB	*R10+,*R3+	Move char to user buffer.
	DEC	R5
	JGT	READ10
READ20	EQU	$
	MOVB	@LF,*R3+
	SB	*R3,*R3
	INC	R0
	LI	R1,OPNMSG
	BL	@WRTMSG
READ30	MOV	R0,*R13
	RTWP
*
* Set argv pointers into stack.
*
SETARGV	EQU	$
	LI	R2,1		Set start for argv[0].
	MOVB	@MSG,R4		Get argv parms length.
	SRL	R4,8
	JEQ	SETXIT		If zero, exit
	LI	R5,MSG+1
SET005	MOV	R5,*R12+	Push argv[n] pointer.
	INC	R2		Bump argc count.
SET010	MOVB	*R5,R13		Get char
	CB	@ABLNK,R13	BlanK?
	JEQ	SET020		Yes, end of arg.
	CB	R13,@AA		No, Convert to lower case.
	JLT	SET015
	CB	R13,@AZ
	JGT	SET015
	AB	@ABLNK,*R5
SET015	INC	R5		bump pointer.
	DEC	R4		At end?
	JEQ	SET030		Yes, exit
	JMP	SET010		No, check next.
SET020	SB	*R5,*R5		Blank, set null.
	INC	R5		Bump pointer.
	DEC	R4		At end?
	JEQ	SETXIT		Yes, exit.
	CB	@ABLNK,*R5	No, still blank?
	JEQ	SET020		Yes, set it null.
	JMP	SET005		No, start of new arg.
SET030	SB	*R5,*R5		Set trailing null.
SETXIT	SETO	*R12+
	RT
*
* Get ASCII number and convert
*
GETNUM	EQU	$
	MOVB	@MSGMAX,*R4
	BLWP	@S$PARM		Get the parm.
	BYTE	R3,R4
	MOV	R0,R0
	JNE	PRMERR
	MOV	R5,R6
	MOVB	*R4,R7		Get length.
	SRL	R7,8
GETN10	EQU	$		Convert it to decimal.
	MOVB	*R6+,R2
	SB	@AZERO,R2
	SRL	R2,8
	MPY	@TEN,R0
	MOV	R1,R0
	A	R2,R0
	DEC	R7
	JGT	GETN10
	RT
*
* Get TCA and program parms
*
GETPARM	EQU	$
	MOV	R11,R12
	BLWP	@S$GTCA		Get the TCA.
	MOV	R0,R0
	JNE	TCAERR
	LI	R5,MSG+1
	LI	R4,MSG
	LI	R3,1
	BL	@GETNUM		Get the stack size parm.
	MOV	R0,R14
	SLA	R0,10		Convert to K.
	JEQ	STKSHT		Can't be zero.
	MOV	R0,@STKSIZ
	INC	R3
	BL	@GETNUM		Get the heap size parm.
	A	R0,R14
	CI	R14,MAXMEM	Make sure stk/heap is not too big.
	JGT	TOOBIG
	SLA	R0,10		Convert to K.
	JEQ	HEPSHT		Can't be zero.
	MOV	R0,@HEPSIZ
	INC	R3
	LI	R4,TASKID
	BLWP	@S$PARM		Get the program name.
	BYTE	R3,R4
	MOV	R0,R0
	MOVB	*R4+,R13
	SRL	R13,8
	A	R13,R4
	SB	*R4,*R4
	INC	R3
	LI	R4,MSG
	MOVB	@MSGMAX,*R4
	BLWP	@S$PARM		Get the args parm.
	BYTE	R3,R4
	MOV	R0,R0
	JNE	PRMERR
GETEXIT	EQU	$
	BLWP	@S$RTCA		Return the TCA.
	B	*R12
*
* _mapsyn - Map synonyms
*
__mapsyn
	STWP	R10		Get WS addressability.
	AI	R10,32
	CLR	R0
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get out file descriptor.
	MOV	*R1+,R3		Get in file descriptor.
	BLWP	@S$GTCA		Get the TCA.
	MOV	R0,R0
	JNE	MAP030
	LI	R5,>FF00	Set max length
	MOVB	R5,*R2
	BLWP	@S$MAPS		Map the synonym.
	BYTE	R3,R2
	MOV	R0,R4
	BLWP	@S$RTCA		Return the TCA.
	MOV	R4,R4
	JNE	MAP030
	MOVB	*R2,R4		if returned length is zero
	JEQ	MAP005
	SRL	R4,8
	INC	R4
	A	R4,R2
	JMP	MAP015
MAP005	MOVB	*R3+,R4		   copy in to out, Get in length
	MOVB	R4,*R2+
	SRL	R4,8
	JEQ	MAP020
MAP010	MOVB	*R3+,*R2+	   Move it.
	DEC	R4
	JGT	MAP010
MAP015	SB	*R2,*R2		Null terminate.
MAP020	MOV	R0,*R13
	RTWP
MAP030	LI	R0,-22		EINVAL
	JMP	MAP020
*
STKSHT	B	@__stkoverflow
HEPSHT	B	@__heapoverflow
TOOBIG	B	@NOMEM
*
PRMERR	LI	R2,PARMER
	JMP	EXIT2
TCAERR	LI	R2,TCAER
EXIT2	B	@EXIT
*
__sighan
	DATA	0
*
_stdin0
	DATA	_stdout0
	DATA	0
	DATA	>0001
	DATA	0
	DATA	0
	DATA	_stdinbuf
_stdout0
	DATA	_stderr0
	DATA	1
	DATA	>0002
	DATA	0
	DATA	0
	DATA	_stdoutbuf
_stderr0
	DATA	0
	DATA	2
	DATA	>0002
	DATA	0
	DATA	0
	DATA	_stderrbuf
*
__file_table
	BSS	18*MAXLUNO
__file_table_end
*
_stdinbuf
MSG	BYTE	255,0
	BSS	BUFSIZ
_stdoutbuf
TASKID	BYTE	19,0
	BSS	BUFSIZ
READIT	DATA	1
_stderrbuf
	BSS	BUFSIZ+2
	END
