	IDT	'CRT0SRV'
	TITL	'CRT0SRV - C runtime entry'
***********************************************************************
*
*   CRT0 - Set up the C runtime environment and call the C main
*            routines. Server version. 
*
***********************************************************************
	OPTION	DUNLST,BUNLST,TUNLST
	LREF	_main
	LREF	__flushall
*
	LDEF	__stkoverflow,__stkbottom,__stktop
	LDEF	__heapoverflow,__heapbottom,__heaptop
	LDEF	__printline,__readline
	LDEF	__issue_svc,__errno,__curluno
	LDEF	__file_table, __file_list
	LDEF	__mapsyn
	LDEF	_stdin,_stdout,_stderr
	LDEF	_abort,_exit,_atexit
	LDEF	__istxds,__termxflag,__termusrflag
	LDEF	__sighan
*
	DXOP	SVC,15
*
STRTLUN	EQU	3		Starting luno.
MAXLUNO	EQU	10		Maximum luno.
NUMLUNO	EQU	MAXLUNO-STRTLUN
BUFSIZ	EQU	288
*
	DATA	MAINWS,MAINPC,ENDACT
MAINPC	EQU	$
*
	LI	R1,__file_table
	LI	R2,__file_table_end
CLRFDT	CLR	*R1+
	C	R1,R2
	JL	CLRFDT
*
	MOVB	@OPENOP,@TERMOPC
	SVC	@TERMSCB	Open the terminal for stdin/stdout/stderr.
	SVC	@BIDPARM	Get the task bid parms.
	MOV	@STKSIZ,R1
	JEQ	__stkoverflow
	MOV	@HEPSIZ,R0
	JEQ	__heapoverflow
	SLA	R0,10		Convert to K
	MOV	R0,@HEPSIZ
	SLA	R1,10
	MOV	R1,@STKSIZ
	A	R0,R1
	SRL	R1,5
	MOV	R1,@GETSIZE
	SVC	@GETMAIN	Get the memory that will be the stack/heap.
	MOVB	@GETMAIN+1,R0
	JNE	NOMEM
	MOV	R9,@__stkbottom
	MOV	R9,R10
	A	@STKSIZ,R9
	MOV	R9,@__stktop
	MOV	R9,@__heapbottom
	MOV	R9,R11
	MOV	@HEPSIZ,R12
	A	R12,R9
	MOV	R9,@__heaptop
	MOV	R12,*R11+	Set up heap for malloc.
	CLR	*R11+		   Flags.
	CLR	*R11+		   Back.
	CLR	*R11+		   Next.
*
	CLR	@ARGBUF
*
	MOV	R10,R11		Set up call stack.
	MOV	R10,R12
	LI	R2,DUMSTG	dummy program name.
	MOV	R2,*R12+	push
	BL	@SETARGV	Push argv[n]
	MOV	R12,R1		End of argv list starts parms.
	MOV	R12,R11
	MOV	R2,*R11+	push argc
	MOV	R10,*R11+	push pointer to pointer argv[0]
*
	LI	R12,_main	Call the main program.
	BLWP	R11
*
_abort
EXITPC	EQU	$
	LI	R12,__flushall
	BLWP	R11
*
EXIT	EQU	$
	MOVB	@CLOSEOP,@TERMOPC
	SVC	@TERMSCB	Close terminal
	SVC	@EOTSVC		End of task
*
NOMEM	LI	R1,NOMEMM
	BL	@WRTMSG		Can't allocate memory.
	JMP	EXIT
*
ENDACT	EQU	$
	LWPI	MAINWS
	LI	R3,>2F00	Get End action status.
	CLR	R4
	CLR	R5
	CLR	R6
	CLR	R7
	SVC	R3
	ANDI	R3,>00FF
	MOV	@__sighan,R12
	JEQ	END003
	MOV	R11,R1
	MOV	R3,*R11+
	BLWP	R11
	JMP	EXITPC
END003  LI	R4,ENDCOD
	LI	R5,2
END005	EQU	$
	SLA	R3,4
	CB	R3,@TEN+1
	JLT	END010
	AI	R3,>700
END010	AB	@AZERO,R3
	MOVB	R3,*R4+
	DEC 	R5
	JGT	END005
	LI	R1,ENDER
	JMP	EXIT
*
__stkoverflow
	LI	R1,STKOVER
	BL	@WRTMSG		Stack overflow.
	JMP	EXIT
__heapoverflow
	LI	R1,HEPOVER
	BL	@WRTMSG		Heap overflow.
	JMP	EXIT
*
_exit
	MOV	@efunc,R12	If we have an atexit func.
	JEQ	EXITPC
	BLWP	R11		Do it.
	JMP	EXITPC
_atexit
	MOV	@2(R13),R1
	MOV	*R1,@efunc
	RTWP
*
WRTMSG	MOV	*R1,@TERMLRL
	MOV	*R1+,@TERMCHC
	MOV	R1,@TERMBUF
	MOVB	@WRITEOP,@TERMOPC
	SVC	@TERMSCB
	RT
*
READMSG	MOV	@TERMFLG,R5	Check if busy (O_NONBLOCK I/O)
	JLT	REDBSY
	MOV	*R1,@TERMLRL
	MOV	*R1+,@TERMCHC
	MOV	R1,@TERMBUF
	MOVB	@READOP,@TERMOPC
	SVC	@TERMSCB
	MOV	@TERMCHC,R0
REDXIT	DECT	R1
	MOV	R0,*R1
	RT
REDBSY	LI	R5,EAGAIN
	MOV	R5,@__errno
	SETO	R0
	JMP	REDXIT
*
efunc	DATA	0		atexit() function address.
__istxds
	DATA	0
__errno
	DATA	0		errno.
__stkbottom
	DATA	0		Bottom of stack
__stktop
	DATA	0		Top of stack
__heapbottom
	DATA	0		Bottom of heap
__heaptop
	DATA	0		Top of heap
__file_list
	DATA	_stdin0		FILE list
_stdin
	DATA	_stdin0
_stdout
	DATA	_stdout0
_stderr
	DATA	_stderr0
*
EOTSVC	DATA	>0400		End of TASK SVC
GETMAIN	DATA	>1200		Get memory SVC
GETSIZE	DATA	$-$
*
TERMSCB BYTE	0		Terminal I/O operation
TERMERR BYTE	0		Terminal error code
TERMOPC	BYTE	0		Terminal operation code
TERMLUN BYTE	0		Terminal luno
__termusrflag
TERMFLG	DATA	0		Terminal flags
TERMBUF	DATA	$-$		Terminal buffer
TERMLRL	DATA	80		Terminal rec len
TERMCHC	DATA	80		Terminal char count
TERMRPY DATA	0 		Terminal reply address
__termxflag
TERMXFG DATA	0		Terminal extended flags
TERMFCH BYTE	0		Terminal fill char
TERMEVB BYTE	0		Terminal event byte
TERMCRW BYTE	0		Terminal cursor row
TERMCCL BYTE	0		Terminal cursor column
TERMFRW BYTE	0		Terminal field row
TERMFCL BYTE	0		Terminal field column
	EVEN
*
BIDPARM DATA	>1700		Get BID parms SVC.
STKSIZ	DATA	0
HEPSIZ	DATA	0
*
OPENOP	BYTE	0
CLOSEOP	BYTE	>1
WRITEOP	BYTE	>B
READOP	BYTE	>9
*
OPNMSG  DATA	2
CR	BYTE	>0D,>0A
LF	EQU	$-1
*
NOMEMM	DATA	NOMEML
	TEXT	'Unable to allocate memory'
	BYTE	>0D,>0A
NOMEML	EQU	$-NOMEMM-2
	EVEN
*
STKOVER	DATA	STKOVL
	TEXT	'Stack overflow, terminating'
	BYTE	>0D,>0A
STKOVL	EQU	$-STKOVER-2
__curluno
	BYTE	STRTLUN		Current luno for file alloc.
	EVEN
*
HEPOVER	DATA	HEPOVL
	TEXT	'Heap overflow, terminating'
	BYTE	>0D,>0A
HEPOVL	EQU	$-HEPOVER-2
	EVEN
*
ENDER	DATA	ENDEL
	TEXT	'End action taken-'
ENDCOD	TEXT	'XX '
ENDEL	EQU	$-ENDER-2
	EVEN
*
ABLNK	BYTE	' '
AA	BYTE	'A'
AZ	BYTE	'Z'
AZERO	BYTE	'0'
DUMSTG	TEXT	'osprog'
	BYTE	0
	EVEN
*
MAINWS	BSS	32
TEN	DATA	10
*
* Issue SVC to the system.
*
__issue_svc
	STWP	R11		Get WS addressability.
	AI	R11,32
	MOV	@2(R13),R1	Get SVC block pointer.
	MOV	*R1,R1
	SVC	*R1
	RTWP
*
* Write string buffer to terminal
*
__printline
	STWP	R11		Get WS addressability.
	AI	R11,32
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get file descriptor.
	MOV	*R1+,R3		Get buffer address.
	MOV	*R1+,R5		Get buffer length.
	MOV	R11,R12		Buffer into the end of the frame.
	INCT	R12
	CLR	R4		Clear count.
PRT010	EQU	$
	MOVB	*R3+,R0		Get char to print.
	JEQ	PRT020		Null char?
	CB	R0,@LF		No, Newline?
	JNE	PRT015
	MOVB	@CR,*R12+	Yes, make CR/LF.
	INC	R4
PRT015	EQU	$
	MOVB	R0,*R12+	Put char in to buffer.
	INC	R4
PRT020	EQU	$
	DEC	R5
	JGT	PRT010
	MOV	R4,*R11		Processed all chars.
	MOV	R11,R1
	BL	@WRTMSG		Write it out.
	RTWP
*
* Read string buffer from terminal
*
__readline
	STWP	R10		Get WS addressability.
	AI	R10,32
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get file descriptor.
	MOV	*R1+,R3		Get buffer address.
	MOV	*R1+,R4		Get buffer size.
	MOV	R10,R1		Buffer into the end of the frame.
	MOV	R4,*R10+	Put size into frame.
	BL	@READMSG	Go read.
	MOV	R0,R5
	JLT	READ30		Busy, O_NONBLOCK exit
	JEQ	READ20
READ10	EQU	$
	MOVB	*R10+,*R3+	Move char to user buffer.
	DEC	R5
	JGT	READ10
READ20	EQU	$
	MOVB	@LF,*R3+
	SB	*R3,*R3
	INC     R0
	LI	R1,OPNMSG
	BL	@WRTMSG
READ30	MOV	R0,*R13
	RTWP
*
* Set argv pointers into stack.
*
SETARGV	EQU	$
	LI	R2,1		Set start for argv[0].
	MOV	@ARGBUF,R4	Get argv parms length.
	JEQ	SETXIT		If zero, exit
	LI	R5,ARGMSG
SET005	MOV	R5,*R12+	Push argv[n] pointer.
	INC	R2		Bump argc count.
SET010	MOVB	*R5,R13		Get char
	CB	@ABLNK,R13	Blank?
	JEQ	SET020		Yes, end of arg.
	CB	R13,@AA		No, Convert to lower case.
	JLT	SET015
	CB	R13,@AZ
	JGT	SET015
	AB	@ABLNK,*R5
SET015	INC	R5		bump pointer.
	DEC	R4		At end?
	JEQ	SET030		Yes, exit
	JMP	SET010		No, check next.
SET020	SB	*R5,*R5		Blank, set null.
	INC	R5		Bump pointer.
	DEC	R4		At end?
	JEQ	SETXIT		Yes, exit.
	CB	@ABLNK,*R5	No, still blank?
	JEQ	SET020		Yes, set it null.
	JMP	SET005		No, start of new arg.
SET030	SB	*R5,*R5		Set trailing null.
SETXIT	SETO	*R12+
	RT
*
* _mapsyn - Map synonyms (no-op)
*
__mapsyn
	STWP	R10		Get WS addressability.
	AI	R10,32
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get out file descriptor.
	MOV	*R1+,R3		Get in file descriptor.
	MOVB	*R3+,R4		Get in length
	MOVB	R4,*R2+
	SRL	R4,8
	JEQ	MAP020
MAP010	MOVB	*R3+,*R2+	Move it.
	DEC	R4
	JGT	MAP010
	SB	*R2,*R2		Null terminate.
MAP020	CLR	*R13
	RTWP
*
__sighan
	DATA	0
*
_stdin0
	DATA	_stdout0
	DATA	0
	DATA	>0001
	DATA	0
	DATA	0
	DATA	_stdinbuf
_stdout0
	DATA	_stderr0
	DATA	1
	DATA	>0002
	DATA	0
	DATA	0
	DATA	_stdoutbuf
_stderr0
	DATA	0
	DATA	2
	DATA	>0002
	DATA	0
	DATA	0
	DATA	_stderrbuf
*
__file_table
	BSS	18*MAXLUNO
__file_table_end
*
ARGBUF	DATA	80
ARGMSG	EQU	$
_stdinbuf
	BSS	BUFSIZ+2
_stdoutbuf
	BSS	BUFSIZ+2
_stderrbuf
	BSS	BUFSIZ+2
	END
