	IDT	'CRT0TX'
	TITL	'CRT0TX - C runtime entry'
***********************************************************************
*
*   CRT0 - Set up the C runtime environment and call the C main
*            routines. TX990/TXDS version.
*
***********************************************************************
	OPTION	DUNLST,BUNLST,TUNLST
	LREF	_main
	LREF	__flushall
	REF	STKSIZ,HEPSIZ
*
	LDEF	__stkoverflow,__stkbottom,__stktop
	LDEF	__heapoverflow,__heapbottom,__heaptop
	LDEF	__printline,__readline
	LDEF	__issue_svc,__errno,__curluno
	LDEF	__file_table, __file_list
	LDEF	__mapsyn
	LDEF	_stdin,_stdout,_stderr
	LDEF	_abort,_exit,_atexit
	LDEF	__istxds,__termxflag,__termusrflag
	LDEF	__sighan
*
	DXOP	SVC,15
*
* COMMON AREA LAYOUT
*
        DORG    0
PRGNAM  BSS     16              FILE NAME OF PRGRAM TO LOAD
INFIL1  BSS     16              INPUT FILE NAME #1
INFIL2  BSS     16              INPUT FILE NAME #2
INFIL3  BSS     16              INPUT FILE NAME #3
OTFIL1  BSS     16              OUTPUT FILE NAME #1
OTFIL2  BSS     16              OUTPUT FILE NAME #2
OTFIL3  BSS     16              OUTPUT FILE NAME #3
OPTION  BSS     32              OPTIONS
CHNNAM  BSS     16              CHAINING FILE NAME
CHNFLG  BSS     1               CHAINING FLAG
BATFLG  BSS     1               BATCH FLAG
BATERR  BSS     1               BATCH ERROR CODE
CHNERR  BSS     1               CHAINING ERROR CODE
DFTPRT  BSS     4               DEFAULT PRINTER
RESERV  BSS     2               RESERVED
        RORG
*
STRTLUN	EQU	3		Starting luno.
MAXLUNO	EQU	10		Maximum luno.
BUFSIZ	EQU	288
*
DEVPOS  EQU     0               DISPLACEMENTS IN NAME FIELD
COLPOS  EQU     4
NAMPOS  EQU     5
SLHPOS  EQU     12
EXTPOS  EQU     13
*
DEVLEN  EQU     4               LEN OF EACH FILENAME FIELD
NAMLEN  EQU     7
EXTLEN  EQU     3
PTHLEN  EQU     16              LEN OF TOTAL PATHNAME
*
OPTLEN	EQU	32
*
	DATA	MAINWS,MAINPC,ENDACT
MAINPC	EQU	$
*
	LI	R1,__file_table
	LI	R2,__file_table_end
CLRFDT	CLR	*R1+
	C	R1,R2
	JL	CLRFDT
*
	MOVB	@OPENOP,@TERMOPC
	SVC	@TERMSCB	Open the terminal for stdin/stdout/stderr.
	LI	R1,OPNMSG
	BL	@WRTMSG
*
        SVC     @GETCMN         Get common address
        MOVB    @GETCMN+1,R0    If error then
        JEQ     GOTCMN
        LI      R1,CMNERR          Cant get common
        BL      @WRTMSG            Say it
	JMP	EXIT2
GOTCMN	EQU	$
        MOV     R8,@CMNSIZ      Save off common size
        MOV     R9,@CMNADR      and where it lives
*
	LI	R1,STKSIZ
	AI	R1,HEPSIZ
	SRL	R1,5
	MOV	R1,@GETSIZE
	SVC	@GETMAIN	Get the memory that will be the stack/heap.
	MOVB	@GETMAIN+1,R0
	JNE	NOMEM
	MOV	R9,@__stkbottom
	MOV	R9,R10
	AI	R9,STKSIZ
	MOV	R9,@__stktop
	MOV	R9,@__heapbottom
	MOV	R9,R11
	LI	R12,HEPSIZ
	A	R12,R9
	MOV	R9,@__heaptop
	MOV	R12,*R11+	Set up heap for malloc.
	CLR	*R11+		   Flags.
	CLR	*R11+		   Back.
	CLR	*R11+		   Next.
*
	MOV	R10,R11		Set up call stack.
	MOV	R10,R12
	LI	R4,PRGNAM	Program name.
	A	@CMNADR,R4
	CB	@GREAT,*R4
	JNE	PGM010
	MOVB	@ZERO,@3(R4)
	JMP	PGM015
PGM010	BL	@PRPPGM		Prepare name.
PGM015	MOV	R4,*R12+	push
	BL	@SETARGV	Push options argv[n]
	LI	R4,INFIL1
	BL	@PRPPTH
	LI	R4,INFIL2
	BL	@PRPPTH
	LI	R4,INFIL3
	BL	@PRPPTH
	LI	R4,OTFIL1
	BL	@PRPPTH
	LI	R4,OTFIL2
	BL	@PRPPTH
	LI	R4,OTFIL3
	BL	@PRPPTH
	MOV	R12,R1		End of argv list starts parms.
	MOV	R12,R11
	MOV	R2,*R11+	push argc
	MOV	R10,*R11+	push pointer to pointer argv[0]
*
	LI	R12,_main	Call the main program.
	BLWP	R11
*
_abort
EXITPC	EQU	$
	LI	R12,__flushall
	BLWP	R11
*
EXIT	EQU	$
	SVC	@PUTMAIN	Return memory
EXIT1	EQU	$
	SVC	@RETCMN		Return common
EXIT2	EQU	$
	MOVB	@CLOSEOP,@TERMOPC
	SVC	@TERMSCB	Close terminal
	SVC	@EOTSVC		End of task
*
NOMEM	LI	R1,NOMEMM
	BL	@WRTMSG		Can't allocate memory.
	JMP	EXIT1
*
ENDACT	EQU	$
	LWPI	MAINWS
	LI	R3,>2F00	Get End action status.
	CLR	R4
	CLR	R5
	CLR	R6
	CLR	R7
	SVC	R3
	ANDI	R3,>00FF
	MOV	@__sighan,R12
	JEQ	END003
	MOV	R11,R1
	MOV	R3,*R11+
	BLWP	R11
	JMP	EXITPC
END003  LI	R4,ENDCOD
	LI	R5,2
END005	EQU	$
	SLA	R3,4
	CB	R3,@TEN+1
	JLT	END010
	AI	R3,>700
END010	AB	@AZERO,R3
	MOVB	R3,*R4+
	DEC 	R5
	JGT	END005
	JMP	EXIT
*
__stkoverflow
	LI	R1,STKOVER
	BL	@WRTMSG		Stack overflow.
	JMP	EXIT
__heapoverflow
	LI	R1,HEPOVER
	BL	@WRTMSG		Heap overflow.
	JMP	EXIT
*
_exit
	MOV	@efunc,R12	If we have an atexit func.
	JEQ	EXITPC
	BLWP	R11		Do it.
	JMP	EXITPC
_atexit
	MOV	@2(R13),R1
	MOV	*R1,@efunc
	RTWP
*
WRTMSG	MOV	*R1,@TERMLRL
	MOV	*R1+,@TERMCHC
	MOV	R1,@TERMBUF
	MOVB	@WRITEOP,@TERMOPC
	SVC	@TERMSCB
	RT
*
READMSG	MOV	*R1,@TERMLRL
	MOV	*R1+,@TERMCHC
	MOV	R1,@TERMBUF
	MOVB	@READOP,@TERMOPC
	SVC	@TERMSCB
	MOV	@TERMCHC,R0
	DECT	R1
	MOV	R0,*R1
	RT
*
efunc	DATA	0		atexit() function address.
__istxds
	DATA	1
__errno
	DATA	0		errno.
__stkbottom
	DATA	0		Bottom of stack
__stktop
	DATA	0		Top of stack
__heapbottom
	DATA	0		Bottom of heap
__heaptop
	DATA	0		Top of heap
__file_list
	DATA	_stdin0		FILE list
_stdin
	DATA	_stdin0
_stdout
	DATA	_stdout0
_stderr
	DATA	_stderr0
*
CMNSIZ	DATA	0		Size of common
CMNADR	DATA	0		Address of common
GETCMN  DATA    >1000           Get common area address
RETCMN  DATA    >1B00           Return common area
EOTSVC	DATA	>1600		End of TASK SVC
PUTMAIN DATA	>1300		Put memory SVC
GETMAIN	DATA	>1200		Get memory SVC
GETSIZE	DATA	$-$
*
TERMSCB BYTE	0		Terminal I/O operation
TERMERR BYTE	0		Terminal error code
TERMOPC	BYTE	0		Terminal operation code
TERMLUN BYTE	0		Terminal luno
__termusrflag
TERMFLG	DATA	0		Terminal flags
TERMBUF	DATA	$-$		Terminal buffer
TERMLRL	DATA	80
TERMCHC	DATA	80
__termxflag
	DATA	0
*
OPENOP	BYTE	0
CLOSEOP	BYTE	>1
WRITEOP	BYTE	>B
READOP	BYTE	>9
*
OPNMSG  DATA	2
CR	BYTE	>0D,>0A
LF	EQU	$-1
*
CMNERR	DATA	CMNERRL
	TEXT	'Unable to aquire common'
	BYTE	>0D,>0A
CMNERRL	EQU	$-CMNERR-2
	EVEN
*
NOMEMM	DATA	NOMEML
	TEXT	'Unable to allocate memory'
	BYTE	>0D,>0A
NOMEML	EQU	$-NOMEMM-2
	EVEN
*
STKOVER	DATA	STKOVL
	TEXT	'Stack overflow, terminating'
	BYTE	>0D,>0A
STKOVL	EQU	$-STKOVER-2
__curluno
	BYTE	STRTLUN		Current luno for file alloc.
	EVEN
*
HEPOVER	DATA	HEPOVL
	TEXT	'Heap overflow, terminating'
	BYTE	>0D,>0A
HEPOVL	EQU	$-HEPOVER-2
	EVEN
*
ABLNK	BYTE	' '
AA	BYTE	'A'
AZ	BYTE	'Z'
SLASH	BYTE	'/'
PERIOD	BYTE	'.'
COMMA	BYTE	','
GREAT	BYTE	'>'
ZERO	BYTE	0
PRVSVC	BYTE	>23
	EVEN
*
MAINWS	BSS	32
*
* Issue SVC to the system.
*
__issue_svc
	STWP	R11		Get WS addressability.
	AI	R11,32
	MOV	@2(R13),R1	Get SVC block pointer.
	MOV	*R1,R1
	SVC	*R1
	CB	@PRVSVC,*R1
	JNE	SVCRET
	ANDI	R15,>FEFF
SVCRET	EQU	$
	RTWP
*
* Write string buffer to terminal
*
__printline
	STWP	R11		Get WS addressability.
	AI	R11,32
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get file descriptor.
	MOV	*R1+,R3		Get buffer address.
	MOV	*R1+,R5		Get buffer length.
	MOV	R11,R12		Buffer into the end of the frame.
	INCT	R12
	CLR	R4		Clear count.
PRT010	EQU	$
	MOVB	*R3+,R0		Get char to print.
	JEQ	PRT020		Null char?
	CB	R0,@LF		No, Newline?
	JNE	PRT015
	MOVB	@CR,*R12+	Yes, make CR/LF.
	INC	R4
PRT015	EQU	$
	MOVB	R0,*R12+	Put char in to buffer.
	INC	R4
PRT020	EQU	$
	DEC	R5
	JGT	PRT010
	MOV	R4,*R11		Processed all chars.
	MOV	R11,R1
	BL	@WRTMSG		Write it out.
	RTWP
*
* Read string buffer from terminal
*
__readline
	STWP	R10		Get WS addressability.
	AI	R10,32
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get file descriptor.
	MOV	*R1+,R3		Get buffer address.
	MOV	*R1+,R4		Get buffer size.
	MOV	R10,R1		Buffer into the end of the frame.
	MOV	R4,*R10+	Put size into frame.
	BL	@READMSG	Go read.
	MOV	R0,R5
	JEQ	READ20
READ10	EQU	$
	MOVB	*R10+,*R3+	Move char to user buffer.
	DEC	R5
	JGT	READ10
READ20	EQU	$
	MOVB	@LF,*R3+
	SB	*R3,*R3
	INC	R0
	MOV	R0,*R13
	RTWP
*
* Set argv pointers into stack.
*
SETARGV	EQU	$
	LI	R2,1		Set start for argv[0].
	LI	R4,OPTLEN	Get argv parms length.
	MOV	@CMNADR,R5
	AI	R5,OPTION
	MOVB	*R5,R13
	JEQ	SETXIT
	CB	@ABLNK,R13	Blank?
	JEQ	SET030		Yes, no args.
SET005	MOV	R5,*R12+	Push argv[n] pointer.
	INC	R2		Bump argc count.
SET010	MOVB	*R5,R13		Get char
	JEQ	SETXIT
	CB	@ABLNK,R13	Blank?
	JEQ	SET020		Yes, end of arg.
	CB	@COMMA,R13	Comma?
	JEQ	SET020		Yes, end of arg.
	CB	R13,@AA		No, Convert to lower case.
	JLT	SET015
	CB	R13,@AZ
	JGT	SET015
	AB	@ABLNK,*R5
SET015	INC	R5		bump pointer.
	DEC	R4		At end?
	JEQ	SET030		Yes, exit
	JMP	SET010		No, check next.
SET020	SB	*R5,*R5		Blank, set null.
	INC	R5		Bump pointer.
	DEC	R4		At end?
	JEQ	SETXIT		Yes, exit.
	CB	@ABLNK,*R5	No, still blank?
	JEQ	SET020		Yes, set it null.
	MOVB	*R5,*R5		No, NUL?
	JEQ	SETXIT		Yes, exit
	JMP	SET005		No, start of new arg.
SET030	SB	*R5,*R5		Set trailing null.
SETXIT	RT
*
* Prepare pathname.
*
PRPPTH	EQU	$
	MOV	R11,R15
	A	@CMNADR,R4
	CB	@ZERO,*R4
	JNE	PTH010
	CB	@ZERO,@NAMPOS(R4)
	JEQ	PTHXIT
PTH010	MOV	R4,*R12+
	INC	R2
	BL	@PRPPGM
PTHXIT	B	*R15
*
PRPPGM	EQU	$
	MOV	R4,R5
	MOV	R4,R6
	LI	R14,PTHLEN
PRP010	MOVB	*R5+,R13
	JEQ	PRP020
	CB	R13,@ABLNK
	JEQ	PRP020
	CB	R13,@SLASH
	JNE	PRP015
	MOVB	@PERIOD,R13
PRP015	MOVB	R13,*R6+
PRP020	DEC	R14
	JGT	PRP010
	SB	*R6,*R6
	RT
*
* _mapsyn - Map synonyms (no-op)
*
__mapsyn
	STWP	R10		Get WS addressability.
	AI	R10,32
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get out file descriptor.
	MOV	*R1+,R3		Get in file descriptor.
	MOVB	*R3+,R4		Get in length
	MOVB	R4,*R2+
	SRL	R4,8
	JEQ	MAP020
MAP010	MOVB	*R3+,*R2+	Move it.
	DEC	R4
	JGT	MAP010
	SB	*R2,*R2		Null terminate.
MAP020	CLR	*R13
	RTWP
*
__sighan
	DATA	0
*
_stdin0
	DATA	_stdout0
	DATA	0
	DATA	>0001
	DATA	0
	DATA	0
	DATA	_stdinbuf
_stdout0
	DATA	_stderr0
	DATA	1
	DATA	>0002
	DATA	0
	DATA	0
	DATA	_stdoutbuf
_stderr0
	DATA	0
	DATA	2
	DATA	>0002
	DATA	0
	DATA	0
	DATA	_stderrbuf
*
__file_table
	BSS	18*MAXLUNO
__file_table_end
*
_stdinbuf
	BSS	BUFSIZ+2
_stdoutbuf
	BSS	BUFSIZ+2
_stderrbuf
	BSS	BUFSIZ+2
	END
