	IDT	'CVTINT'
	TITL	'CVTINT - Convert integer numbers'
***********************************************************************
*
*   CVTINT - Converts integer numbers into strings.
*
***********************************************************************
	OPTION	DUNLST,BUNLST,TUNLST
*
	COPY	'config.cpy'
*
	LDEF	__cvtdec,__cvthexoct
	LDEF	__cvtdec32,__cvthexoct32
*
	LREF	___udivsi3,___umodsi3
	ASMIF	STKCHK=1
	LREF	__stkoverflow,__stktop
	ASMEND
*
* Convert decimal number.
*
* char *_cvtdec (int num, char *stg, int signed, int length, int filler)
*
__cvtdec
* function prologue 
	STWP	R10
	AI	R10,32
	MOV	R10,R11
	AI	R11,10
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	cvtdec010
	BL	@__stkoverflow
	TEXT	'__cvtdec'
	BYTE	0
	EVEN
	ASMEND
cvtdec010
	MOV	@2(R13),R9	Get arg pointer.
	MOV	*R9+,R7		Get number to convert.
	MOV	*R9+,R5		Get string pointer.
	MOV	*R9+,R6		Get signed/unsigned flag.
	MOV	R10,R8
	CLR	R3
	CLR	R12		Clear sign flag
	MOV	R6,R6		If signed
	JEQ	cvtdec020
	MOV	R7,R7		  then if negative
	JGT	cvtdec020
	JEQ	cvtdec020
	NEG	R7		    make number positive and
	SETO	R12		    set sign flag
cvtdec020
	CLR	R6
	DIV	@TEN,R6		Isolate digit
	SLA	R7,8
	AB	@AZERO,R7	Make ASCII
	MOVB	R7,*R8+
	INC	R3
	MOV	R6,R7
	JNE	cvtdec020
	BL	@FILLIT
	MOV	R5,*R13
	RTWP
*
* Convert long decimal number.
*
* char *_cvtdec32 (long *num, char *stg, int signed, int length, int filler)
*
__cvtdec32
* function prologue 
	STWP	R10
	AI	R10,32
	MOV	R10,R11
	AI	R11,10
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	cvtd32010
	BL	@__stkoverflow
	TEXT	'__cvtdec32'
	BYTE	0
	EVEN
	ASMEND
cvtd32010
	MOV	@2(R13),R9	Get arg pointer.
	MOV	*R9+,R1		Get number to convert.
	MOV	*R1+,R7		
	MOV	*R1,R8		
	MOV	*R9+,R5		Get string pointer.
	MOV	*R9+,R6		Get signed/unsigned flag.
	MOV	R10,R4
	CLR	R3
	CLR	R10		clear sign flag
	MOV	R6,R6		If signed 
	JEQ	cvtd32020
	MOV	R7,R7		  then check if negative
	JGT	cvtd32020
	JEQ	cvtd32020
	INV	R7		    make number positive and
	INV	R8
	INC	R8
	JNC	cvtd32015
	INC	R7
cvtd32015
	SETO	R10		    set sign flag
cvtd32020
	MOV	R11,R1
	MOV	R7,*R11+
	MOV	R8,*R11+
	MOV	@LTEN,*R11+
	MOV	@LTEN+2,*R11+
	MOV	=@___umodsi3,R12
	BLWP	R11
	AI	R11,-8
	SLA	R1,8
	AB	@AZERO,R1	Make ASCII
	MOVB	R1,*R4+
	MOV	R11,R1
	MOV	R7,*R11+
	MOV	R8,*R11+
	MOV	@LTEN,*R11+
	MOV	@LTEN+2,*R11+
	MOV	=@___udivsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R7
	MOV	R1,R8
	INC	R3
	MOV	R7,R7
	JNE	cvtd32020
	MOV	R8,R8
	JNE	cvtd32020
	MOV	R10,R12
	MOV	R4,R8
	BL	@FILLIT
	MOV	R5,*R13
	RTWP
*
* Convert HEX/Octal number.
*
* char *_cvthexoct (int num, char *stg, int bighex, int octflag,
*		    int length, int filler)
*
__cvthexoct
* function prologue 
	STWP	R10
	AI	R10,32
	MOV	R10,R11
	AI	R11,10
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	cvthex010
	BL	@__stkoverflow
	TEXT	'__cvthexoct'
	BYTE	0
	EVEN
	ASMEND
cvthex010
	MOV	@2(R13),R9	Get arg pointer.
	MOV	*R9+,R7		Get number to convert.
	MOV	*R9+,R5		Get string pointer.
	MOV	*R9+,R4		Get BIG hex.
	LI	R1,>FFF0	Set mask for HEX
	MOV	*R9+,R12	If octal flag
	JEQ	cvthex012
	LI	R1,>FFF8	then set octal mask.
cvthex012
	MOV	R10,R8
	CLR	R3
	MOV	R7,R7		If zero
	JNE	cvthex020
	MOVB	@AZERO,*R8+	  then put '0' in buffer.
	INC	R3
	JMP	cvthex027
cvthex020
	MOV	R7,R6
	JEQ	cvthex027
	SZC	R1,R6		Isolate digit.
	SLA	R6,8
	CB	R6,@TEN+1
	JLT	cvthex025
	MOV	R4,R4
	JNE	cvthex023
	AI	R6,>2000
cvthex023
	AI	R6,>700
cvthex025
	AB	@AZERO,R6	Make ASCII
	MOVB	R6,*R8+
	INC	R3
	MOV	R12,R12		Octal?
	JNE	cvthex026
	SRL	R7,4		No, Shift for hex.
	JMP	cvthex020
cvthex026
	SRL	R7,3		Yes, Shift for octal.
	JMP	cvthex020
cvthex027
	CLR	R12
	BL	@FILLIT
	MOV	R5,*R13
	RTWP
*
* Convert long HEX number.
*
* char *_cvthexoct32 (long *num, char *stg, int bighex, int octflag,
*		    int length, int filler)
*
__cvthexoct32
* function prologue 
	STWP	R10
	AI	R10,32
	MOV	R10,R11
	AI	R11,10
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	cvth32010
	BL	@__stkoverflow
	TEXT	'__cvthexoct32'
	BYTE	0
	EVEN
	ASMEND
cvth32010
	MOV	@2(R13),R9	Get arg pointer.
	MOV	*R9+,R1		Get number to convert.
	MOV	*R1+,R7
	MOV	*R1,R8
	MOV	*R9+,R5		Get string pointer.
	MOV	*R9+,R4		Get BIG hex.
	LI	R1,>FFF0	Set mask for HEX
	MOV	*R9+,R12	If octal flag
	JEQ	cvth32012
	LI	R1,>FFF8	then set octal mask.
cvth32012
	MOV	R10,R2
	CLR	R3
	MOV	R7,R7		If zero
	JNE	cvth32020
	MOV	R8,R8
	JNE	cvth32020
	MOVB	@AZERO,*R2+	  then put '0' in buffer.
	INC	R3
	JMP	cvth32027
cvth32020
	MOV	R8,R6
	MOV	R7,R7
	JNE	cvth32021
	MOV	R8,R8
	JEQ	cvth32027
cvth32021
	SZC	R1,R6		Isolate digit.
	SLA	R6,8
	CB	R6,@TEN+1
	JLT	cvth32025
	MOV	R4,R4
	JNE	cvth32023
	AI	R6,>2000
cvth32023
	AI	R6,>700
cvth32025
	AB	@AZERO,R6	Make ASCII
	MOVB	R6,*R2+
	INC	R3
	MOV	R7,R6
	MOV	R12,R12		Octal?
	JNE	cvth32026
	SLA	R6,12		No, shift for hex.
	SRL	R8,4
	SOC	R6,R8
	SRL	R7,4
	JMP	cvth32020
cvth32026
	SLA	R6,13		Yes, shift for octal.
	SRL	R8,3
	SOC	R6,R8
	SRL	R7,3
	JMP	cvth32020
cvth32027
	CLR	R12
	MOV	R2,R8
	BL	@FILLIT
	MOV	R5,*R13
	RTWP
*
FILLIT
	MOV	*R9+,R7		Pick up total length
	S	R3,R7		Minus digits used
	JLT	FILL15
	JEQ	FILL15
	MOV	*R9,R6		Pick up the fill char.
	SLA	R6,8
	MOV	R12,R12		If we were negative
	JEQ	FILL10
	DEC	R7		  account for sign in count
	CB	@AZERO,R6	If zero fill
	JNE	FILL10
	MOVB	@AMINUS,*R5+	 then  put '-' in buffer now.
	CLR	R12
FILL10
	MOV	R7,R7		Do we have a fill count?
	JLT	FILL15
	JEQ	FILL15
FILL13
	MOVB	R6,*R5+		Yes, Fill in using fill char.
	DEC	R7
	JGT	FILL13
FILL15
	MOV	R12,R12		If we are still signed
	JEQ	FILL20
	MOVB	@AMINUS,*R5+	then put '-' in buffer.
FILL20
	DEC	R8		Now copy the digits.
	MOVB	*R8,*R5+
	DEC	R3
	JGT	FILL20
	SB	*R5,*R5		null terminate.
	RT
*
LTEN	DATA	0
TEN	DATA	10
AZERO	BYTE	'0'
AMINUS	BYTE	'-'
	END
