#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/svc.h>

extern word_t _termxflag;
extern word_t _termusrflag;

int
fcntl (int fd, int cmd, int arg)
{
   FileTable *ft;
   int flags;

   if (fd >= __MAXLUNO)
   {
      _errno = EBADF;
      return (-1);
   }
   ft = &_file_table[fd];
   if (!(ft->modes & FTINUSE))
   {
      _errno = EBADF;
      return (-1);
   }

   flags = 0;
   switch (cmd)
   {
   case F_DUPFD:
   case F_GETFD:
   case F_SETFD:
      break;

   case F_GETFL:
      flags = ft->modes & ~FTINUSE;
      break;

   case F_SETFL:
      ft->modes = FTINUSE | arg;
      break;

   default:
      _errno = EINVAL;
      flags = -1;
   }
   return (flags);
}
