/************************************************************************
* ferror - Get file error code.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>

int
ferror (FILE *fd)
{

   if (fd == NULL)
   {
      _errno = EBADF;
      return (-1);
   }

   if (fd == stdin || fd == stdout || fd == stderr)
      return FALSE;
   
   return ((fd->file_flags & _FILE_ERROR) ? TRUE : FALSE);
}
