/************************************************************************
* fflush - Flush a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

int
fflush (FILE *fd)
{
   if (fd == NULL)
   {
      _errno = EBADF;
      return (-1);
   }

   if (fd->file_flags & _FILE_WRITE && fd->file_pos > 0)
      return (_writebuffer (fd));
   return (0);
}
