/************************************************************************
* fgetc - Get a char from a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>

int
fgetc (FILE *fd)
{
   int ch;

   if (fd == NULL)
   {
      _errno = EBADF;
      return (EOF);
   }
   
   if (fd->file_len == 0)
   {
      _readbuffer (fd);
   }
   if (fd->file_flags & (_FILE_ERROR | _FILE_EOF))
      return (EOF);

   ch = fd->file_buf[fd->file_pos];
   fd->file_len--;
   fd->file_pos++;
   return (ch);
}
