/************************************************************************
* fgets - Get a line from a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

char *
fgets (char *stg, int size, FILE *fd)
{
   char *up = stg;
   char *bp;

   if (fd == NULL)
   {
      _errno = EBADF;
      return (NULL);
   }
   
   if (fd->file_len == 0)
      _readbuffer (fd);
   if (fd->file_flags & (_FILE_ERROR | _FILE_EOF))
      return (NULL);

   size--;
   bp = &fd->file_buf[fd->file_pos];
   while (size > 0)
   {
      char ch;

      ch = *bp++;
      *up++ = ch;
      size--;
      fd->file_len--;
      fd->file_pos++;
      if (ch == '\n')
         break;
      if (fd->file_len == 0)
      {
         _readbuffer (fd);
	 if (fd->file_flags & (_FILE_ERROR | _FILE_EOF))
	    break;
         bp = fd->file_buf;
      }
   }

   *up = 0;
   return (stg);
}
