/************************************************************************
* fopen - Open a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <memory.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/svc.h>

FILE *
fopen (const char *path, const char *mode)
{
   FILE *ffd;
   int i;
   int fd;
   int oflag;
   int pos;
   char ch;

   if ((ffd = malloc (sizeof (FILE))) == NULL)
   {
      _errno = ENOMEM;
      return (NULL);
   }
   memset (ffd, 0, sizeof(FILE));

   if ((ffd->file_buf = malloc (BUFSIZ)) == NULL)
   {
      _errno = ENOMEM;
      free (ffd);
      return (NULL);
   }

   /*
   ** Parse mode
   */

#ifdef DEBUGIO
   printf ("fopen: path = %s, mode = %s\n", path, mode);
#endif

   oflag = 0;
   pos = SEEK_SET;
   i = 0;
   ch = mode[i];
   if (ch == 'a')
   {
      ffd->file_flags |= _FILE_WRITE;
      oflag = O_WRONLY;
      for (i++; mode[i]; i++)
      {
         ch = mode[i];
	 pos = SEEK_END;
	 if (ch == '+')
	 {
	    oflag = O_RDWR;
	    ffd->file_flags |= _FILE_READ;
	 }
	 else if (ch == 'b')
	 {
	    ffd->file_flags |= _FILE_BINARY;
	 }
	 else
	 {
	    _errno = EINVAL;
	    goto CLEAN_UP;
	 }
      }
   }
   else if (ch == 'r')
   {
      oflag = O_RDONLY;
      ffd->file_flags |= _FILE_READ;
      for (i++; mode[i]; i++)
      {
         ch = mode[i];
	 if (ch == '+')
	 {
	    oflag = O_RDWR;
	    ffd->file_flags |= _FILE_WRITE;
	 }
	 else if (ch == 'b')
	 {
	    ffd->file_flags |= _FILE_BINARY;
	 }
	 else
	 {
	    _errno = EINVAL;
	    goto CLEAN_UP;
	 }
      }
   }
   else if (ch == 'w')
   {
      oflag = O_CREAT | O_WRONLY;
      ffd->file_flags |= _FILE_WRITE;
      for (i++; mode[i]; i++)
      {
         ch = mode[i];
	 if (ch == '+')
	 {
	    oflag = O_CREAT | O_RDWR;
	    ffd->file_flags |= _FILE_READ;
	 }
	 else if (ch == 'b')
	 {
	    ffd->file_flags |= _FILE_BINARY;
	 }
	 else
	 {
	    _errno = EINVAL;
	    goto CLEAN_UP;
	 }
      }
   }
   else 
   {
      _errno = EINVAL;
      goto CLEAN_UP;
   }

   /*
   ** go open the file.
   */

   if ((fd = open (path, oflag)) < 0)
   {
      goto CLEAN_UP;
   }

   ffd->file_num = fd;
   ffd->file_next = _file_list;
   _file_list = ffd;
   return (ffd);

CLEAN_UP:
   free (ffd->file_buf);
   free (ffd);
   return (NULL);
}
