/************************************************************************
* fprintf - Print a formatted line on a file.
************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>

int
fprintf (FILE *fd, const char *fmt, ...)
{
   int i;
   va_list ap;
   char obuf[BUFSIZ];

   if (fd == NULL)
   {
      _errno = EBADF;
      return (-1);
   }
   va_start (ap, fmt);
   i = vsprintf (obuf, fmt, ap);
   va_end (ap);

   if (fputs (obuf, fd) < 0)
      return (-1);
   return (i);
}
