/************************************************************************
* free - Free an allocated block of storage.
************************************************************************/

#include <stddef.h>
#include <stdlib.h>

void
free (void *up)
{
   Malloc_blk *cp, *bp;
   char *umem;
   
   /*
   ** Make sure we have something to free
   */

   if (!up) return;

   /*
   ** Mark it free.
   */

   umem = (char *)up - sizeof(Malloc_blk);
   cp = (Malloc_blk *)umem;
   cp->flags = 0;

   /*
   ** Collapse adjacent free blocks
   */

   bp = cp;
   if (cp->back && !cp->back->flags)
   {
      bp = cp->back;
      bp->size += cp->size;
      bp->next = cp->next;
      if (cp->next)
	 cp->next->back = bp;
   }

   while (cp->next) 
   {
      if (cp->next->flags)
      {
	 cp->next->back = bp;
	 break;
      }
      cp = cp->next;
      bp->size += cp->size;
      bp->next = cp->next;
      cp->back = bp;
   }

}
