/************************************************************************
* fseek - Seek to a location in file. 
*         Only supported on relative record (random) files. 
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stddef.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/svc.h>

int
fseek (FILE *fp, off_t offset, int whence)
{
   FileTable *ft;

   /*
   ** Ensure that FILE ptr is good.
   */

   if (fp == NULL)
   {
      _errno = EBADF;
      return (-1);
   }

   ft = &_file_table[fp->file_num];

#ifdef DEBUGIO
   printf ("fseek: file_num = %d, attrflags = %X, lrl = %d\n",
          fp->file_num, ft->attrflags, ft->logicalrecordlength);
   printf ("   offset = %d, whence = %d\n", offset, whence);
#endif

   if ((ft->attrflags & ATTRTYPEMASK) != ATTRRELRECORD)
   {
      _errno = EPERM;
      return (-1);
   }

   if (whence == SEEK_SET)
      ft->recnum = offset / ft->logicalrecordlength;
   else if (whence == SEEK_CUR)
      ft->recnum += offset / ft->logicalrecordlength;
   else if (whence == SEEK_END)
      ft->recnum = ft->numberofrecords + (offset / ft->logicalrecordlength);
   else
   {
      _errno = EINVAL;
      return (-1);
   }

   _readbuffer (fp);

   fp->file_pos = offset % ft->logicalrecordlength;


#ifdef DEBUGIO
   printf ("   new recnum = %d, file_pos = %d\n",
	   ft->recnum - 1, fp->file_pos);
#endif

   return (0);
}
