/************************************************************************
* fputs - Print a line on the file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

size_t
fwrite (const void *stg, size_t size, size_t num, FILE *fd)
{
   char *up = (char *)stg;
   char *bp;
   int cnt, len;

   if (fd == NULL)
   {
      _errno = EBADF;
      return (0);
   }
   bp = &fd->file_buf[fd->file_pos];

   len = 0;
   while (len < num)
   {
      cnt = size;
      while (cnt > 0)
      {
	 *bp++ = *up++;
	 fd->file_pos++;
	 if (fd->file_pos >= BUFSIZ)
	 {
	    if (_writebuffer (fd) < 0)
	       return (len);
	    bp = fd->file_buf;
	 }
	 cnt--;
      }
      len++;
   }

   return (len);
}
