#ifndef __CTYPE_H__
#define __CTYPE_H__

extern char __ctype[];      /* property array defined in chartab.c */
 
#define _U	0x01    /* this bit is for upper-case letters [A-Z] */
#define _L	0x02    /* this bit is for lower-case letters [a-z] */
#define _N	0x04    /* this bit is for numbers [0-9] */
#define _S	0x08    /* this bit is for white space \t \n \f etc */
#define _P	0x10    /* this bit is for punctuation characters */
#define _C	0x20    /* this bit is for control characters */
#define _X	0x40    /* this bit is for hex digits [a-f] and [A-F]*/

extern int isalnum (int);
extern int isalpha (int);
extern int isascii (int);
extern int isblank (int);
extern int iscntrl (int);
extern int isdigit (int);
extern int isgraph (int);
extern int islower (int);
extern int isprint (int);
extern int ispunct (int);
extern int isspace (int);
extern int isupper (int);
extern int isxdigit (int);

extern int tolower (int);
extern int toupper (int);

#define isalnum(c)  ((__ctype+1)[c]&(_U|_L|_N))
#define isalpha(c)  ((__ctype+1)[c]&(_U|_L))
#define iscntrl(c)  ((__ctype+1)[c]&_C)
#define isgraph(c)  ((__ctype+1)[c]&(_P|_U|_L|_N))
#define ispunct(c)  ((__ctype+1)[c]&_P)
#define isspace(c)  ((__ctype+1)[c]&_S)
#define isxdigit(c) ((__ctype+1)[c]&(_N|_X))

#define isdigit(c)  ((__ctype+1)[c]&(_N))
#define islower(c)  ((__ctype+1)[c]&(_L))
#define isupper(c)  ((__ctype+1)[c]&(_U))
#define isprint(c)  ((unsigned) ((c)-' ') < 95)
#define isascii(c)  ((unsigned) (c) < 128)
#define isblank(c)  ((c) == ' ' || (c) == '\t')

#endif
