#ifndef __STDIO_H__
#define __STDIO_H__

#include <stddef.h>
#include <stdarg.h>

#define SEEK_SET       0       /* Seek from beginning of file.  */
#define SEEK_CUR       1       /* Seek from current position.  */
#define SEEK_END       2       /* Seek from end of file.  */

#define BUFSIZ 288

#ifndef EOF
#define EOF (-1)
#endif

#include <sys/stdio.h>

extern FILE *stdin;
extern FILE *stdout;
extern FILE *stderr;

extern FILE *fopen (const char *, const char *);
extern FILE *freopen (const char *, const char *, FILE *);
extern FILE *fdopen (int, const char *);
extern FILE *tmpfile (void);
extern int fclose (FILE *);
extern int fflush (FILE *);

extern int fseek (FILE *, unsigned int, int);
extern unsigned int ftell (FILE *);

extern int rename (const char *, const char *);

extern int printf (const char *, ...);
extern int fprintf (FILE *, const char *, ...);

extern int puts (const char *);
extern int fputs (const char *, FILE *);

extern int fputc (int, FILE *);
extern int putc (int, FILE *);
extern int putchar(int);
#define putc(c,s) fputc (c, s)
#define putchar(c) fputc (c, stdout)

extern char *gets (char *);
extern char *fgets (char *, int, FILE *);
extern int getc (FILE *);
extern int getchar (void);
extern int fgetc (FILE *);
#define getc(s) fgetc (s)
#define getchar() fgetc (stdin)

extern int sprintf (char *, const char *, ...);

extern int vsprintf (char *, const char *, va_list *);

extern size_t fread (void *, size_t, size_t, FILE *);
extern size_t fwrite (const void *, size_t, size_t, FILE *);

extern void clearerr (FILE *);
extern int feof (FILE *);
extern int ferror (FILE *);
extern int fileno (FILE *);

extern void perror (const char *);

extern int sys_nerr;
extern char *sys_errlist[];

#endif
