#ifndef __STDLIB_H__
#define __STDLIB_H__

#include <stddef.h>

#define RAND_MAX       32767    /* largest value generated by rand() */

extern int atoi (const char *);
extern int rand (void);
extern void srand (unsigned int);

extern void exit (int);

extern void *calloc (size_t, size_t);
extern void *malloc (size_t);
extern void free (void *);

extern char *getenv (const char *);

extern void abort (void);
extern void exit (int);
extern int atexit (void (*)(void));

extern char *mktemp (char *);

typedef struct _Malloc_blk
{
   size_t size;
   word_t flags;
   struct _Malloc_blk *back;
   struct _Malloc_blk *next;
} Malloc_blk;

#endif
