/***********************************************************************
*
* txdir.h - Definition for TX990 disk directory formats.
*
* Changes:
*   12/17/08   DGP   Original.
*
***********************************************************************/

#ifndef __TXDIR_H__
#define __TXDIR_H__

#include <stddef.h>

/*
** Location of things
*/

#define TXLABELAU 4		/* Disk label AU */
#define TXDIRAU 5		/* Disk directory AU start */

#define TXLABELLEN 32		/* Length of volume label */
#define TXEYELEN 2		/* Length of volume eye catcher */
#define TXVOLNAMLEN 4		/* Length of volume namne */

#define TXDIRPSEC 8		/* Directory entries per sector */
#define TXSECAU 6		/* Sectors per AU */
#define TXFILELEN 7		/* Length of the file name */
#define TXEXTLEN 3		/* Length of the file name extension */

#define TXFCBEYELEN 4		/* Length of FCB eye catcher */
#define TXMAXEXT 10		/* Maximum extents for file */

#define TXSECLEN 128		/* Length of sector */

/*
** Standard File control codes
*/

#define ENDOFRECORD 0xFF
#define COMPBLANKS 0xFE
#define ENDOFFILE 0xFB
#define BINARYESCAPE 0xFA

typedef struct
{
   char label[TXLABELLEN];	/* Volume label */
   word_t bootfcb;		/* Location of file to boot */
   char txeye[TXEYELEN];	/* TX Eye catcher 'TX' */
   char filler1[2];
   char volname[TXVOLNAMLEN];	/* Volume name */
   char filler2[86];
} disklabel_t;

typedef struct
{
   char filename[TXFILELEN];	/* File name */
   char fileext[TXEXTLEN];	/* File name extension */
   word_t filefcb;		/* Location of file fcb */
   char fileprot;		/* File protection */
   char filler1[3];
} txdir_t;

typedef struct
{
   word_t startau;		/* Starting AU location of block */
   word_t numaus;		/* Number of AUs in block */
} txextent_t;

typedef struct
{
   word_t fil1;
   char fcbeye[TXFCBEYELEN];	/* FCB eye catcher */
   word_t fil2;
   word_t fil3;
   word_t fil4;
   word_t fil5;
   word_t fil6;
   word_t fil7;
   word_t fil8;
   txextent_t extents[TXMAXEXT];
} txfcb_t;

#endif
