#ifndef __TYPES_H__
#define __TYPES_H__

#ifndef __SIZE_T__
#define __SIZE_T__
typedef unsigned int size_t;
#endif

#ifndef __SSIZE_T__
#define __SSIZE_T__
typedef int ssize_t;
#endif

#ifndef __TIME_T__
#define __TIME_T__
typedef unsigned long time_t;	   /* time in sec since 1 Jan 1970 0000 GMT */
#endif

#ifndef __CLOCK_T__
#define __CLOCK_T__
typedef long clock_t;		   /* unit for system accounting */
#endif

#ifndef __SIGSET_T__
#define __SIGSET_T__
typedef unsigned long sigset_t;
#endif

typedef long useconds_t;	/* Time in microseconds */

/* Types used in disk, inode, etc. data structures. */

typedef int            dev_t;	   /* holds (major|minor) device pair */
typedef char           gid_t;	   /* group id */
typedef unsigned int   ino_t; 	   /* i-node number (V3 filesystem) */
typedef unsigned int   mode_t;	   /* file type and permissions bits */
typedef int          nlink_t;	   /* number of links to a file */
typedef unsigned int   off_t;	   /* offset within a file */
typedef int            pid_t;	   /* process id (must be signed) */
typedef int            uid_t;	   /* user id */
typedef unsigned int  zone_t;	   /* zone number */
typedef unsigned int  block_t;	   /* block number */
typedef unsigned int   bit_t;	   /* bit number in a bit map */
typedef unsigned int   zone1_t;	   /* zone number for V1 file systems */
typedef unsigned int   bitchunk_t; /* collection of bits in a bitmap */

typedef unsigned char   u8_t;	   /* 8 bit type */
typedef unsigned int   u16_t;	   /* 16 bit type */
typedef unsigned long  u32_t;	   /* 32 bit type */

typedef char            i8_t;      /* 8 bit signed type */
typedef int            i16_t;      /* 16 bit signed type */
typedef long           i32_t;      /* 32 bit signed type */

/* Signal handler type, e.g. SIG_IGN */

typedef void (*sighandler_t)(int);

/* Compatibility with other systems */

typedef unsigned char	u_char;
typedef unsigned int  	u_short;
typedef unsigned int	u_int;
typedef unsigned long	u_long;
typedef char		*caddr_t;

#endif
