/************************************************************************
* isatty - If file a tty.
************************************************************************/

#include <unistd.h>
#include <errno.h>

int
isatty (int fd)
{
   FileTable *ft;

   _errno = 0;

   /*
   ** If stdin, stderr, stdout return tty
   */

   if (fd <= STDERR_FILENO)
      return (1);

   if (fd >= __MAXLUNO)
   {
      _errno = EBADF;
      return (-1);
   }
   ft = &_file_table[fd];
   if (!(ft->modes & FTINUSE))
   {
      _errno = EBADF;
      return (-1);
   }
   return (0);
}
