	IDT	'LCLTIME'
	TITL	'LOCALTIME - System time routines'
***********************************************************************
*
*   LOCALTIME - System time routines.
*
***********************************************************************
	OPTION	DUNLST,BUNLST,TUNLST
*
	COPY	'config.cpy'
*
	LDEF	_localtime
*
	LREF	___addsi3,___subsi3,___mulsi3,___udivsi3,___umodsi3
	LREF	__year2day
	ASMIF	STKCHK=1
	LREF	__stkoverflow,__stktop
	ASMEND
*
* struct tm {
tm	DORG
tm_sec  BSS	2
tm_min  BSS	2
tm_hour BSS	2
tm_mday BSS	2
tm_mon  BSS	2
tm_year BSS	2
tm_wday BSS	2
tm_yday BSS	2
tm_isds BSS	2
* };
	RORG
*
mon2day
	STWP	R10
	AI	R10,32
	MOV	R10,R11
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	mon010
	BL	@__stkoverflow
	TEXT	'mon2day'
	BYTE	0
	EVEN
	ASMEND
mon010
	MOV	*R13,R5		Get the months.
	MOV	@2(R13),R6
	MOV	R11,R1		temp1 = months * 3057;
	MOV	R5,*R11+
	MOV	R6,*R11+
	MOV	@D3057,*R11+
	MOV	@D3057+2,*R11+
	MOV	=@___mulsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R5		temp1
	MOV	R1,R6
	MOV	R11,R1		temp1 -= 3007;
	MOV	R5,*R11+
	MOV	R6,*R11+
	MOV	@D3007,*R11+
	MOV	@D3007+2,*R11+
	MOV	=@___subsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R5		temp1
	MOV	R1,R6
	MOV	R11,R1		temp1 /= 100;
	MOV	R5,*R11+
	MOV	R6,*R11+
	MOV	@D100,*R11+
	MOV	@D100+2,*R11+
	MOV	=@___udivsi3,R12
	BLWP	R11
	MOV	R0,*R13
	MOV	R1,@2(R13)
	RTWP
*
isleap
	CLR	R0
	MOV	*R13,R1		Get year
	CLR	R2
	MOV	R1,R3
	DIV	@D400+2,R2	if (year % 400 == 0) return 1
	MOV	R3,R3
	JEQ	isl080
	CLR	R2
	MOV	R1,R3
	DIV	@D4+2,R2	if ((year % 4 == 0) &&
	MOV	R3,R3
	JNE	isl090
	CLR	R2
	MOV	R1,R3
	DIV	@D100+2,R2	    (year % 100 != 0)) return 1
	MOV	R3,R3
	JEQ	isl090
isl080
	INC	R0
isl090
	MOV	R0,*R13
	RTWP
*
ymd2day
	STWP	R10
	AI	R10,32
	MOV	R10,R11
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	ymd010
	BL	@__stkoverflow
	TEXT	'ymd2day'
	BYTE	0
	EVEN
	ASMEND
ymd010
	MOV	@2(R13),R9
	CLR	R2
	MOV	*R9+,R3		Get the year.
	CLR	R4
	MOV	*R9+,R5		Get the month.
	CLR	R6
	MOV	*R9,R7		Get the day.
	MOV	R4,R0
	MOV	R5,R1
	LI	R12,mon2day	temp1 = mon2day (month)
	BLWP	R11
	MOV	R0,R8		temp1
	MOV	R1,R9
	MOV	R11,R1		temp1 += day
	MOV	R6,*R11+
	MOV	R7,*R11+
	MOV	R8,*R11+
	MOV	R9,*R11+
	MOV	=@___addsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R8		temp1
	MOV	R1,R9
	CI	R5,2		if (month > 2)
	JLT	ymd040
	JEQ	ymd040
	MOV	R3,R0		   temp1 -= isleap (year) ? 1 : 2
	LI	R12,isleap
	BLWP	R11
	MOV	R0,R0
	JNE	ymd035
	DEC	R9
ymd035
	DEC	R9
ymd040
	MOV	R2,R0
	MOV	R3,R1
	DEC	R1		year--
	LI	R12,__year2day	year2day(year)
	BLWP	R11
	MOV	R0,R2		year(now days)
	MOV	R1,R3
	MOV	R11,R1		temp1 += days
	MOV	R2,*R11+
	MOV	R3,*R11+
	MOV	R8,*R11+
	MOV	R9,*R11+
	MOV	=@___addsi3,R12
	BLWP	R11
	MOV	R0,*R13		return temp1
	MOV	R1,@2(R13)
	RTWP
*
dow
	STWP	R10
	AI	R10,32
	MOV	R10,R11
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	dow010
	BL	@__stkoverflow
	TEXT	'dow'
	BYTE	0
	EVEN
	ASMEND
dow010
	MOV	*R13,R2		Get yr
	MOV	@2(R13),R3	Get mon
	MOV	@4(R13),R4	Get day
	CLR	R5		n = (((mon + 9) % 12 + 1) << 4) % 27 + day + 1
	MOV	R3,R6
	A	=W9,R6
	DIV	=W12,R5
	INC	R6
	SLA	R6,4
	CLR	R5
	DIV	=W27,R5
	A	R4,R6
	INC	R6		n
	CLR	R7
	MOV	R2,R8		ty = yr % 400 + 400
	DIV	@D400+2,R7
	A	@D400+2,R8
	A	R8,R6		n += ty
	CLR	R9
	MOV	R8,R10
	DIV	@D4+2,R9
	A	R9,R6		n += ty / 4
	CLR	R9
	MOV	R8,R10
	DIV	@D100+2,R9
	S	R9,R6		n -= ty / 100
	CI	R3,2		if (mon <= 2)
	JGT	dow030
	MOV	R2,R0
	LI	R12,isleap	   n += isleap (yr) ? 5 : 6
	BLWP	R11
	MOV	R0,R0
	JNE	dow020
	INC	R6
dow020
	AI	R6,5
dow030
	CLR	R5		n %= 7
	DIV	=W7,R5
	MOV	R6,*R13		return n
	RTWP
*
day2ymd
	STWP	R10
	AI	R10,32
	MOV	R10,R11
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	day010
	BL	@__stkoverflow
	TEXT	'day2ymd'
	BYTE	0
	EVEN
	ASMEND
day010
	MOV	@2(R13),R9	Get the days.
	MOV	*R9+,R8
	MOV	*R8+,R2
	MOV	*R8,R3
	MOV	R11,R1		temp1 = days * 400;
	MOV	R2,*R11+
	MOV	R3,*R11+
	MOV	@D400,*R11+
	MOV	@D400+2,*R11+
	MOV	=@___mulsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R5		temp1
	MOV	R1,R6
	MOV	R11,R1		temp1 /= 146097;
	MOV	R5,*R11+
	MOV	R6,*R11+
	MOV	@D146097,*R11+
	MOV	@D146097+2,*R11+
	MOV	=@___udivsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R5		temp1
	MOV	R1,R6
day015
	LI	R12,__year2day	year2day(temp1)
	BLWP	R11
	C	R0,R2		while (temp1 < days)
	JLT	day020
	C	R1,R3
	JLT	day020
	JMP	day030
day020
	INC	R6		   temp1++
	JNC	day025
	INC	R5
day025
	MOV	R5,R0
	MOV	R6,R1
	JMP	day015
day030
	MOV	*R9+,R8		*yr = temp1
	MOV	R6,*R8
	DEC	R6
	MOV	R5,R0
	MOV	R6,R1
	LI	R12,__year2day	year2day(temp1)
	BLWP	R11
	MOV	R0,R5		temp1
	MOV	R1,R6
	MOV	R11,R1		temp1 = days - temp1
	MOV	R2,*R11+
	MOV	R3,*R11+
	MOV	R5,*R11+
	MOV	R6,*R11+
	MOV	=@___subsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R5		temp1
	MOV	R1,R6
	CI	R6,59
	JLT	day040
	JEQ	day040
	INCT	R6
	MOV	*R8,R0
	LI	R12,isleap
	BLWP	R11
	MOV	R0,R0
	JEQ	day040
	CI	R6,62
	JGT	day035
	DEC	R6
day035
	DEC	R6
day040
	MOV	R11,R1		temp2 = temp1 * 100;
	MOV	R5,*R11+
	MOV	R6,*R11+
	MOV	@D100,*R11+
	MOV	@D100+2,*R11+
	MOV	=@___mulsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R2		temp2
	MOV	R1,R3
	MOV	R11,R1		temp2 += 3007;
	MOV	R2,*R11+
	MOV	R3,*R11+
	MOV	@D3007,*R11+
	MOV	@D3007+2,*R11+
	MOV	=@___addsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R2		temp2
	MOV	R1,R3
	MOV	R11,R1		temp2 /= 3057;
	MOV	R2,*R11+
	MOV	R3,*R11+
	MOV	@D3057,*R11+
	MOV	@D3057+2,*R11+
	MOV	=@___udivsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R2		temp2
	MOV	R1,R3
	MOV	*R9+,R8		*mo = temp2
	MOV	R3,*R8
	LI	R12,mon2day
	BLWP	R11
	MOV	R0,R2
	MOV	R1,R3
	MOV	R11,R1		temp1 -= temp2	
	MOV	R5,*R11+
	MOV	R6,*R11+
	MOV	R2,*R11+
	MOV	R3,*R11+
	MOV	=@___subsi3,R12
	BLWP	R11
	MOV	*R9,R8		*da = temp1
	MOV	R1,*R8
	RTWP
*
* Convert system in seconds into a tm structure.
*
* struct *tm localtime (time_t *t);
*
_localtime
	STWP	R10
	AI	R10,32
	MOV	R10,R11
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	loct010
	BL	@__stkoverflow
	TEXT	'localtime'
	BYTE	0
	EVEN
	ASMEND
loct010
	MOV	@2(R13),R9
	MOV	*R9,R12
	MOV	*R12+,R2	Get timer value.
	MOV	*R12,R3
	MOV	R2,R4
	MOV	R3,R5
	MOV	R11,R1		temp = timer / daysec;
	MOV	R4,*R11+
	MOV	R5,*R11+
	MOV	@DAYSEC,*R11+
	MOV	@DAYSEC+2,*R11+
	MOV	=@___udivsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R6		days in R6/R7
	MOV	R1,R7
	MOV	R11,R1		temp = timer / daysec;
	MOV	R4,*R11+
	MOV	R5,*R11+
	MOV	@DAYSEC,*R11+
	MOV	@DAYSEC+2,*R11+
	MOV	=@___umodsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R4		secs in R4/R5
	MOV	R1,R5
	MOV	R11,R1		days + epoc
	MOV	R6,*R11+
	MOV	R7,*R11+
	MOV	@EPOC,*R11+
	MOV	@EPOC+2,*R11+
	MOV	=@___addsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R6
	MOV	R1,R7
	MOV	R11,R1
	STWP	R12
	AI	R12,R6*2	day2ymd (day, *yr, *mo, *da)
	MOV	R12,*R11+
	LI	R10,TMS
	MOV	R10,R12
	AI	R12,tm_year
	MOV	R12,*R11+
	MOV	R10,R12
	AI	R12,tm_mon
	MOV	R12,*R11+
	MOV	R10,R12
	AI	R12,tm_mday
	MOV	R12,*R11+
	LI	R12,day2ymd
	BLWP	R11
	AI	R11,-8
	S	=W1900,@tm_year(R10)
	DEC	@tm_mon(R10)
	MOV	R11,R1		tm_sec = secs % 60
	MOV	R4,*R11+
	MOV	R5,*R11+
	MOV	@D60,*R11+
	MOV	@D60+2,*R11+
	MOV	=@___umodsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R1,*R10		tm_sec
	MOV	R11,R1		secs / 60
	MOV	R4,*R11+
	MOV	R5,*R11+
	MOV	@D60,*R11+
	MOV	@D60+2,*R11+
	MOV	=@___udivsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R0,R4		secs /= 60
	MOV	R1,R5
	MOV	R11,R1		tm_min = secs % 60
	MOV	R4,*R11+
	MOV	R5,*R11+
	MOV	@D60,*R11+
	MOV	@D60+2,*R11+
	MOV	=@___umodsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R1,@tm_min(R10)
	MOV	R11,R1		tm_hour = secs / 60
	MOV	R4,*R11+
	MOV	R5,*R11+
	MOV	@D60,*R11+
	MOV	@D60+2,*R11+
	MOV	=@___udivsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R1,@tm_hour(R10)
	MOV	R11,R1
	MOV	@tm_year(R10),R6
	A	=W1900,R6
	MOV	R6,*R11+
	MOV	@tm_mon(R10),R7
	INC	R7
	MOV	R7,*R11+
	MOV	@tm_mday(R10),*R11+
	LI	R12,ymd2day	ymd2day (tm_year + 1900, tm_mon + 1, tm_day)
	BLWP	R11
	AI	R11,-6
	MOV	R0,R2		temp1
	MOV	R1,R3
	MOV	R11,R1
	MOV	R6,*R11+
	MOV	=W1,*R11+
	MOV	=W1,*R11+
	LI	R12,ymd2day	ymd2day (tm_year + 1900, 1, 1)
	BLWP	R11
	AI	R11,-6
	MOV	R0,R4		temp2
	MOV	R1,R5
	MOV	R11,R1 		tm_yday = temp1 - temp2
	MOV	R2,*R11+
	MOV	R3,*R11+
	MOV	R4,*R11+
	MOV	R5,*R11+
	MOV	=@___subsi3,R12
	BLWP	R11
	AI	R11,-8
	MOV	R1,@tm_yday(R10)
	MOV	R6,R0
	MOV	R7,R1
	MOV	@tm_mday(R10),R2
	LI	R12,dow		dow (yr, mon, day)
	BLWP	R11
	MOV	R0,@tm_wday(R10)
	MOV	=W-1,@tm_isds(R10)
	MOV	R10,*R13
	RTWP
*
D4	LONG	4
D60	LONG	60
D100	LONG	100
D400	LONG	400
D3007	LONG	3007
D3057	LONG	3057
DAYSEC	LONG	86400		Seconds per day
D146097	LONG	146097
EPOC	LONG	719163		1970
*
TMS	BSS	18		static struct tm tms;
	END
